/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2017-07-28 12:29:20 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_content_status` (
  `rid` bigint(20) NOT NULL,
  `nid` bigint(20) NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_core_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `module` varchar(16) NOT NULL,
  `origin` varchar(64) NOT NULL,
  `target` varchar(64) NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(10) NOT NULL,
  `flag` varchar(32) NOT NULL,
  `from_template` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(7) NOT NULL,
  `english_name` varchar(128) NOT NULL,
  `major` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL,
  `default_locale` varchar(8) DEFAULT NULL,
  `tag` varchar(8) DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `english_name` (`english_name`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_languages_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) NOT NULL,
  `display_language_code` varchar(7) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_code` (`language_code`,`display_language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4097 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_locale_map` (
  `code` varchar(7) NOT NULL,
  `locale` varchar(8) NOT NULL,
  UNIQUE KEY `code` (`code`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `from_language` varchar(10) NOT NULL,
  `to_language` varchar(10) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) NOT NULL,
  `object_type` varchar(64) NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rid` (`rid`),
  KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_node` (
  `nid` bigint(20) NOT NULL,
  `md5` varchar(32) NOT NULL,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_reminders` (
  `id` bigint(20) NOT NULL,
  `message` text NOT NULL,
  `url` text NOT NULL,
  `can_delete` tinyint(4) NOT NULL,
  `show` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_string_positions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `kind` tinyint(4) DEFAULT NULL,
  `position_in_page` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_string_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `string_translation_id` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_translation_id` (`string_translation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_string_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `language` varchar(10) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `value` text,
  `translator_id` bigint(20) unsigned DEFAULT NULL,
  `translation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_language` (`string_id`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_strings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) NOT NULL,
  `context` varchar(160) NOT NULL,
  `name` varchar(160) NOT NULL,
  `value` text NOT NULL,
  `status` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `context_name` (`context`,`name`),
  KEY `language_context` (`language`,`context`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_translate` (
  `tid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `field_type` varchar(128) NOT NULL,
  `field_format` varchar(16) NOT NULL,
  `field_translate` tinyint(4) NOT NULL,
  `field_data` longtext NOT NULL,
  `field_data_translated` longtext NOT NULL,
  `field_finished` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM AUTO_INCREMENT=353 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_translate_job` (
  `job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `translator_id` int(10) unsigned NOT NULL,
  `translated` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `manager_id` int(10) unsigned NOT NULL,
  `revision` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `rid` (`rid`,`translator_id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_translation_status` (
  `rid` bigint(20) NOT NULL AUTO_INCREMENT,
  `translation_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `translator_id` bigint(20) NOT NULL,
  `needs_update` tinyint(4) NOT NULL,
  `md5` varchar(32) NOT NULL,
  `translation_service` varchar(16) NOT NULL,
  `translation_package` text NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  `_prevstate` longtext,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `translation_id` (`translation_id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_icl_translations` (
  `translation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_type` varchar(36) NOT NULL DEFAULT 'post_post',
  `element_id` bigint(20) DEFAULT NULL,
  `trid` bigint(20) NOT NULL,
  `language_code` varchar(7) NOT NULL,
  `source_language_code` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  KEY `trid` (`trid`),
  KEY `id_type_language` (`element_id`,`element_type`,`language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=1622 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) DEFAULT NULL,
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=75809 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=12167 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=14096 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=267 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=261 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yith_wcwl` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `prod_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `dateadded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  KEY `product` (`prod_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("5", "4", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("6", "5", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("7", "6", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("8", "7", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("9", "8", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("14", "12", "rating", "5");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("4", "9693", "Swift Ideas", "ed@swiftideas.net", "", "86.132.24.123", "2013-11-13 01:41:17", "2013-11-13 01:41:17", "estibulum ante ipsum primis.", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("5", "9693", "Swift Ideas", "ed@swiftideas.net", "", "86.132.24.123", "2013-11-13 01:41:37", "2013-11-13 01:41:37", "estibulum ante ipsum primis in fauc ibus orci luctus et ultrices posuere cubilia Curae; Integer in enim dui. Suspendisse potenti.", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("6", "9700", "Swift Ideas", "ed@swiftideas.net", "", "86.132.24.123", "2013-11-13 01:39:52", "2013-11-13 01:39:52", "estibulum ante ipsum primis in fauc ibus orci luctus et ultrices posuere cubilia Curae; Integer in enim dui. Suspendisse potenti.", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("7", "9700", "Swift Ideas", "ed@swiftideas.net", "", "86.132.24.123", "2013-11-13 01:40:12", "2013-11-13 01:40:12", "estibulum ante ipsum primis in fauc ibus orci luctus et ultrices posuere cubilia Curae; Integer in enim dui.", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("8", "9700", "Swift Ideas", "ed@swiftideas.net", "", "86.132.24.123", "2013-11-13 01:40:39", "2013-11-13 01:40:39", "estibulum ante ipsum primis in fauc ibus orci luctus et ultrices posuere cubilia Curae; Integer in enim dui. Suspendisse potenti. Sed placerat pellentesque nibh ut varius. Morbi aliquet nulla at sem consequat eleifend.", "0", "1", "", "", "0", "1");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("2", "20170726_ganneavocats_duplicator", "925ad5fec450a5263716170728122741", "20", "2017-07-28 12:29:20", "Julien", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-07-28 12:27:41\";s:7:\"Version\";s:6:\"1.2.14\";s:9:\"VersionWP\";s:5:\"4.6.6\";s:9:\"VersionDB\";s:6:\"5.5.55\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:32:\"20170726_ganneavocats_duplicator\";s:4:\"Hash\";s:32:\"925ad5fec450a5263716170728122741\";s:8:\"NameHash\";s:65:\"20170726_ganneavocats_duplicator_925ad5fec450a5263716170728122741\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:35:\"/home/ganneavo/www/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://www.ganne-avocats.com/wp-snapshots/\";s:8:\"ScanFile\";s:75:\"20170726_ganneavocats_duplicator_925ad5fec450a5263716170728122741_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Julien\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:77:\"20170726_ganneavocats_duplicator_925ad5fec450a5263716170728122741_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:18:\"/home/ganneavo/www\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-07-28 12:27:41\";s:7:\"Version\";s:6:\"1.2.14\";s:9:\"VersionWP\";s:5:\"4.6.6\";s:9:\"VersionDB\";s:6:\"5.5.55\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20170726_ganneavocats_duplicator\";s:4:\"Hash\";s:32:\"925ad5fec450a5263716170728122741\";s:8:\"NameHash\";s:65:\"20170726_ganneavocats_duplicator_925ad5fec450a5263716170728122741\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:35:\"/home/ganneavo/www/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://www.ganne-avocats.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:79:\"20170726_ganneavocats_duplicator_925ad5fec450a5263716170728122741_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:57;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:78:\"20170726_ganneavocats_duplicator_925ad5fec450a5263716170728122741_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:8:\"(Debian)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:27:\"/home/ganneavo/www/wp-admin\";i:1;s:37:\"/home/ganneavo/www/wp-content/uploads\";i:2;s:39:\"/home/ganneavo/www/wp-content/languages\";i:3;s:37:\"/home/ganneavo/www/wp-content/plugins\";i:4;s:36:\"/home/ganneavo/www/wp-content/themes\";i:5;s:30:\"/home/ganneavo/www/wp-includes\";}}s:9:\"Installer\";r:79;s:8:\"Database\";r:92;}");

/* INSERT TABLE DATA: wp_icl_flags */
INSERT INTO `wp_icl_flags` VALUES("1", "ar", "ar.png", "0");
INSERT INTO `wp_icl_flags` VALUES("2", "bg", "bg.png", "0");
INSERT INTO `wp_icl_flags` VALUES("3", "bs", "bs.png", "0");
INSERT INTO `wp_icl_flags` VALUES("4", "ca", "ca.png", "0");
INSERT INTO `wp_icl_flags` VALUES("5", "cs", "cs.png", "0");
INSERT INTO `wp_icl_flags` VALUES("6", "cy", "cy.png", "0");
INSERT INTO `wp_icl_flags` VALUES("7", "da", "da.png", "0");
INSERT INTO `wp_icl_flags` VALUES("8", "de", "de.png", "0");
INSERT INTO `wp_icl_flags` VALUES("9", "el", "el.png", "0");
INSERT INTO `wp_icl_flags` VALUES("10", "en", "en.png", "0");
INSERT INTO `wp_icl_flags` VALUES("11", "eo", "eo.png", "0");
INSERT INTO `wp_icl_flags` VALUES("12", "es", "es.png", "0");
INSERT INTO `wp_icl_flags` VALUES("13", "et", "et.png", "0");
INSERT INTO `wp_icl_flags` VALUES("14", "eu", "eu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("15", "fa", "fa.png", "0");
INSERT INTO `wp_icl_flags` VALUES("16", "fi", "fi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("17", "fr", "fr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("18", "ga", "ga.png", "0");
INSERT INTO `wp_icl_flags` VALUES("19", "he", "he.png", "0");
INSERT INTO `wp_icl_flags` VALUES("20", "hi", "hi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("21", "hr", "hr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("22", "hu", "hu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("23", "hy", "hy.png", "0");
INSERT INTO `wp_icl_flags` VALUES("24", "id", "id.png", "0");
INSERT INTO `wp_icl_flags` VALUES("25", "is", "is.png", "0");
INSERT INTO `wp_icl_flags` VALUES("26", "it", "it.png", "0");
INSERT INTO `wp_icl_flags` VALUES("27", "ja", "ja.png", "0");
INSERT INTO `wp_icl_flags` VALUES("28", "ko", "ko.png", "0");
INSERT INTO `wp_icl_flags` VALUES("29", "ku", "ku.png", "0");
INSERT INTO `wp_icl_flags` VALUES("30", "la", "la.png", "0");
INSERT INTO `wp_icl_flags` VALUES("31", "lt", "lt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("32", "lv", "lv.png", "0");
INSERT INTO `wp_icl_flags` VALUES("33", "mk", "mk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("34", "mn", "mn.png", "0");
INSERT INTO `wp_icl_flags` VALUES("35", "mo", "mo.png", "0");
INSERT INTO `wp_icl_flags` VALUES("36", "ms", "ms.png", "0");
INSERT INTO `wp_icl_flags` VALUES("37", "mt", "mt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("38", "nb", "nb.png", "0");
INSERT INTO `wp_icl_flags` VALUES("39", "ne", "ne.png", "0");
INSERT INTO `wp_icl_flags` VALUES("40", "nl", "nl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("41", "pa", "pa.png", "0");
INSERT INTO `wp_icl_flags` VALUES("42", "pl", "pl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("43", "pt-br", "pt-br.png", "0");
INSERT INTO `wp_icl_flags` VALUES("44", "pt-pt", "pt-pt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("45", "qu", "qu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("46", "ro", "ro.png", "0");
INSERT INTO `wp_icl_flags` VALUES("47", "ru", "ru.png", "0");
INSERT INTO `wp_icl_flags` VALUES("48", "sk", "sk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("49", "sl", "sl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("50", "so", "so.png", "0");
INSERT INTO `wp_icl_flags` VALUES("51", "sq", "sq.png", "0");
INSERT INTO `wp_icl_flags` VALUES("52", "sr", "sr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("53", "sv", "sv.png", "0");
INSERT INTO `wp_icl_flags` VALUES("54", "ta", "ta.png", "0");
INSERT INTO `wp_icl_flags` VALUES("55", "th", "th.png", "0");
INSERT INTO `wp_icl_flags` VALUES("56", "tr", "tr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("57", "uk", "uk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("58", "ur", "ur.png", "0");
INSERT INTO `wp_icl_flags` VALUES("59", "uz", "uz.png", "0");
INSERT INTO `wp_icl_flags` VALUES("60", "vi", "vi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("61", "yi", "yi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("62", "zh-hans", "zh-hans.png", "0");
INSERT INTO `wp_icl_flags` VALUES("63", "zh-hant", "zh-hant.png", "0");
INSERT INTO `wp_icl_flags` VALUES("64", "zu", "zu.png", "0");

/* INSERT TABLE DATA: wp_icl_languages */
INSERT INTO `wp_icl_languages` VALUES("1", "en", "English", "1", "1", "en_US", "en-US", "0");
INSERT INTO `wp_icl_languages` VALUES("2", "es", "Spanish", "1", "0", "es_ES", "es-ES", "0");
INSERT INTO `wp_icl_languages` VALUES("3", "de", "German", "1", "0", "de_DE", "de-DE", "0");
INSERT INTO `wp_icl_languages` VALUES("4", "fr", "French", "1", "1", "fr_FR", "fr-FR", "0");
INSERT INTO `wp_icl_languages` VALUES("5", "ar", "Arabic", "0", "0", "ar", "ar", "0");
INSERT INTO `wp_icl_languages` VALUES("6", "bs", "Bosnian", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("7", "bg", "Bulgarian", "0", "0", "bg_BG", "bg-BG", "0");
INSERT INTO `wp_icl_languages` VALUES("8", "ca", "Catalan", "0", "0", "ca", "ca", "0");
INSERT INTO `wp_icl_languages` VALUES("9", "cs", "Czech", "0", "0", "cs_CZ", "cs-CZ", "0");
INSERT INTO `wp_icl_languages` VALUES("10", "sk", "Slovak", "0", "0", "sk_SK", "sk-SK", "0");
INSERT INTO `wp_icl_languages` VALUES("11", "cy", "Welsh", "0", "0", "cy", "cy", "0");
INSERT INTO `wp_icl_languages` VALUES("12", "da", "Danish", "1", "0", "da_DK", "da-DK", "0");
INSERT INTO `wp_icl_languages` VALUES("13", "el", "Greek", "0", "0", "el", "el", "0");
INSERT INTO `wp_icl_languages` VALUES("14", "eo", "Esperanto", "0", "0", "eo", "eo", "0");
INSERT INTO `wp_icl_languages` VALUES("15", "et", "Estonian", "0", "0", "et", "et", "0");
INSERT INTO `wp_icl_languages` VALUES("16", "eu", "Basque", "0", "0", "eu", "eu", "0");
INSERT INTO `wp_icl_languages` VALUES("17", "fa", "Persian", "0", "0", "fa_IR", "fa-IR", "0");
INSERT INTO `wp_icl_languages` VALUES("18", "fi", "Finnish", "0", "0", "fi", "fi", "0");
INSERT INTO `wp_icl_languages` VALUES("19", "ga", "Irish", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("20", "he", "Hebrew", "0", "0", "he_IL", "he-IL", "0");
INSERT INTO `wp_icl_languages` VALUES("21", "hi", "Hindi", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("22", "hr", "Croatian", "0", "0", "hr", "hr", "0");
INSERT INTO `wp_icl_languages` VALUES("23", "hu", "Hungarian", "0", "0", "hu_HU", "hu-HU", "0");
INSERT INTO `wp_icl_languages` VALUES("24", "hy", "Armenian", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("25", "id", "Indonesian", "0", "0", "id_ID", "id-ID", "0");
INSERT INTO `wp_icl_languages` VALUES("26", "is", "Icelandic", "0", "0", "is_IS", "is-IS", "0");
INSERT INTO `wp_icl_languages` VALUES("27", "it", "Italian", "1", "0", "it_IT", "it-IT", "0");
INSERT INTO `wp_icl_languages` VALUES("28", "ja", "Japanese", "1", "0", "ja", "ja", "0");
INSERT INTO `wp_icl_languages` VALUES("29", "ko", "Korean", "0", "0", "ko_KR", "ko-KR", "0");
INSERT INTO `wp_icl_languages` VALUES("30", "ku", "Kurdish", "0", "0", "ku", "ku", "0");
INSERT INTO `wp_icl_languages` VALUES("31", "la", "Latin", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("32", "lv", "Latvian", "0", "0", "lv", "lv", "0");
INSERT INTO `wp_icl_languages` VALUES("33", "lt", "Lithuanian", "0", "0", "lt", "lt", "0");
INSERT INTO `wp_icl_languages` VALUES("34", "mk", "Macedonian", "0", "0", "mk_MK", "mk-MK", "0");
INSERT INTO `wp_icl_languages` VALUES("35", "mt", "Maltese", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("36", "mo", "Moldavian", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("37", "mn", "Mongolian", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("38", "ne", "Nepali", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("39", "nl", "Dutch", "1", "0", "nl_NL", "nl-NL", "0");
INSERT INTO `wp_icl_languages` VALUES("40", "nb", "Norwegian Bokmål", "0", "0", "nb_NO", "nb-NO", "0");
INSERT INTO `wp_icl_languages` VALUES("41", "pa", "Punjabi", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("42", "pl", "Polish", "0", "0", "pl_PL", "pl-PL", "0");
INSERT INTO `wp_icl_languages` VALUES("43", "pt-pt", "Portuguese, Portugal", "0", "0", "pt_PT", "pt-PT", "0");
INSERT INTO `wp_icl_languages` VALUES("44", "pt-br", "Portuguese, Brazil", "0", "0", "pt_BR", "pt-BR", "0");
INSERT INTO `wp_icl_languages` VALUES("45", "qu", "Quechua", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("46", "ro", "Romanian", "0", "0", "ro_RO", "ro-RO", "0");
INSERT INTO `wp_icl_languages` VALUES("47", "ru", "Russian", "1", "0", "ru_RU", "ru-RU", "0");
INSERT INTO `wp_icl_languages` VALUES("48", "sl", "Slovenian", "0", "0", "sl_SI", "sl-SI", "0");
INSERT INTO `wp_icl_languages` VALUES("49", "so", "Somali", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("50", "sq", "Albanian", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("51", "sr", "Serbian", "0", "0", "sr_RS", "sr-RS", "0");
INSERT INTO `wp_icl_languages` VALUES("52", "sv", "Swedish", "0", "0", "sv_SE", "sv-SE", "0");
INSERT INTO `wp_icl_languages` VALUES("53", "ta", "Tamil", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("54", "th", "Thai", "0", "0", "th", "th", "0");
INSERT INTO `wp_icl_languages` VALUES("55", "tr", "Turkish", "0", "0", "tr", "tr", "0");
INSERT INTO `wp_icl_languages` VALUES("56", "uk", "Ukrainian", "0", "0", "uk_UA", "uk-UA", "0");
INSERT INTO `wp_icl_languages` VALUES("57", "ur", "Urdu", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("58", "uz", "Uzbek", "0", "0", "uz_UZ", "uz-UZ", "0");
INSERT INTO `wp_icl_languages` VALUES("59", "vi", "Vietnamese", "0", "0", "vi", "vi", "0");
INSERT INTO `wp_icl_languages` VALUES("60", "yi", "Yiddish", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("61", "zh-hans", "Chinese (Simplified)", "1", "1", "zh_CN", "zh-CN", "0");
INSERT INTO `wp_icl_languages` VALUES("62", "zu", "Zulu", "0", "0", "", "", "0");
INSERT INTO `wp_icl_languages` VALUES("63", "zh-hant", "Chinese (Traditional)", "1", "0", "zh_TW", "zh-TW", "0");
INSERT INTO `wp_icl_languages` VALUES("64", "ms", "Malay", "0", "0", "ms_MY", "ms-MY", "0");

/* INSERT TABLE DATA: wp_icl_languages_translations */
INSERT INTO `wp_icl_languages_translations` VALUES("1", "en", "en", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("2", "en", "es", "Inglés");
INSERT INTO `wp_icl_languages_translations` VALUES("3", "en", "de", "Englisch");
INSERT INTO `wp_icl_languages_translations` VALUES("4", "en", "fr", "Anglais");
INSERT INTO `wp_icl_languages_translations` VALUES("5", "en", "ar", "الإنجليزية");
INSERT INTO `wp_icl_languages_translations` VALUES("6", "en", "bs", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("7", "en", "bg", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("8", "en", "ca", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("9", "en", "cs", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("10", "en", "sk", "Angličtina");
INSERT INTO `wp_icl_languages_translations` VALUES("11", "en", "cy", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("12", "en", "da", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("13", "en", "el", "Αγγλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("14", "en", "eo", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("15", "en", "et", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("16", "en", "eu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("17", "en", "fa", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("18", "en", "fi", "englanti");
INSERT INTO `wp_icl_languages_translations` VALUES("19", "en", "ga", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("20", "en", "he", "אנגלית");
INSERT INTO `wp_icl_languages_translations` VALUES("21", "en", "hi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("22", "en", "hr", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("23", "en", "hu", "angol");
INSERT INTO `wp_icl_languages_translations` VALUES("24", "en", "hy", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("25", "en", "id", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("26", "en", "is", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("27", "en", "it", "Inglese");
INSERT INTO `wp_icl_languages_translations` VALUES("28", "en", "ja", "英語");
INSERT INTO `wp_icl_languages_translations` VALUES("29", "en", "ko", "영어");
INSERT INTO `wp_icl_languages_translations` VALUES("30", "en", "ku", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("31", "en", "la", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("32", "en", "lv", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("33", "en", "lt", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("34", "en", "mk", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("35", "en", "mt", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("36", "en", "mo", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("37", "en", "mn", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("38", "en", "ne", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("39", "en", "nl", "Engels");
INSERT INTO `wp_icl_languages_translations` VALUES("40", "en", "nb", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("41", "en", "pa", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("42", "en", "pl", "angielski");
INSERT INTO `wp_icl_languages_translations` VALUES("43", "en", "pt-pt", "Inglês");
INSERT INTO `wp_icl_languages_translations` VALUES("44", "en", "pt-br", "Inglês");
INSERT INTO `wp_icl_languages_translations` VALUES("45", "en", "qu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("46", "en", "ro", "Engleză");
INSERT INTO `wp_icl_languages_translations` VALUES("47", "en", "ru", "Английский");
INSERT INTO `wp_icl_languages_translations` VALUES("48", "en", "sl", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("49", "en", "so", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("50", "en", "sq", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("51", "en", "sr", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("52", "en", "sv", "Engelska");
INSERT INTO `wp_icl_languages_translations` VALUES("53", "en", "ta", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("54", "en", "th", "อังกฤษ");
INSERT INTO `wp_icl_languages_translations` VALUES("55", "en", "tr", "İngilizce");
INSERT INTO `wp_icl_languages_translations` VALUES("56", "en", "uk", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("57", "en", "ur", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("58", "en", "uz", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("59", "en", "vi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("60", "en", "yi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("61", "en", "zh-hans", "英语");
INSERT INTO `wp_icl_languages_translations` VALUES("62", "en", "zu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("63", "en", "zh-hant", "英語");
INSERT INTO `wp_icl_languages_translations` VALUES("64", "en", "ms", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("65", "es", "en", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("66", "es", "es", "Español");
INSERT INTO `wp_icl_languages_translations` VALUES("67", "es", "de", "Spanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("68", "es", "fr", "Espagnol");
INSERT INTO `wp_icl_languages_translations` VALUES("69", "es", "ar", "الأسبانية");
INSERT INTO `wp_icl_languages_translations` VALUES("70", "es", "bs", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("71", "es", "bg", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("72", "es", "ca", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("73", "es", "cs", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("74", "es", "sk", "Španielčina");
INSERT INTO `wp_icl_languages_translations` VALUES("75", "es", "cy", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("76", "es", "da", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("77", "es", "el", "Ισπανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("78", "es", "eo", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("79", "es", "et", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("80", "es", "eu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("81", "es", "fa", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("82", "es", "fi", "espanja");
INSERT INTO `wp_icl_languages_translations` VALUES("83", "es", "ga", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("84", "es", "he", "ספרדית");
INSERT INTO `wp_icl_languages_translations` VALUES("85", "es", "hi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("86", "es", "hr", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("87", "es", "hu", "spanyol");
INSERT INTO `wp_icl_languages_translations` VALUES("88", "es", "hy", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("89", "es", "id", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("90", "es", "is", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("91", "es", "it", "Spagnolo");
INSERT INTO `wp_icl_languages_translations` VALUES("92", "es", "ja", "スペイン語");
INSERT INTO `wp_icl_languages_translations` VALUES("93", "es", "ko", "스페인어");
INSERT INTO `wp_icl_languages_translations` VALUES("94", "es", "ku", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("95", "es", "la", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("96", "es", "lv", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("97", "es", "lt", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("98", "es", "mk", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("99", "es", "mt", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("100", "es", "mo", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("101", "es", "mn", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("102", "es", "ne", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("103", "es", "nl", "Spaans");
INSERT INTO `wp_icl_languages_translations` VALUES("104", "es", "nb", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("105", "es", "pa", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("106", "es", "pl", "hiszpański");
INSERT INTO `wp_icl_languages_translations` VALUES("107", "es", "pt-pt", "Espanhol");
INSERT INTO `wp_icl_languages_translations` VALUES("108", "es", "pt-br", "Espanhol");
INSERT INTO `wp_icl_languages_translations` VALUES("109", "es", "qu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("110", "es", "ro", "Spaniolă");
INSERT INTO `wp_icl_languages_translations` VALUES("111", "es", "ru", "Испанский");
INSERT INTO `wp_icl_languages_translations` VALUES("112", "es", "sl", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("113", "es", "so", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("114", "es", "sq", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("115", "es", "sr", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("116", "es", "sv", "Spanska");
INSERT INTO `wp_icl_languages_translations` VALUES("117", "es", "ta", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("118", "es", "th", "สเปน");
INSERT INTO `wp_icl_languages_translations` VALUES("119", "es", "tr", "İspanyolca");
INSERT INTO `wp_icl_languages_translations` VALUES("120", "es", "uk", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("121", "es", "ur", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("122", "es", "uz", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("123", "es", "vi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("124", "es", "yi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("125", "es", "zh-hans", "西班牙语");
INSERT INTO `wp_icl_languages_translations` VALUES("126", "es", "zu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("127", "es", "zh-hant", "西班牙語");
INSERT INTO `wp_icl_languages_translations` VALUES("128", "es", "ms", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("129", "de", "en", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("130", "de", "es", "Alemán");
INSERT INTO `wp_icl_languages_translations` VALUES("131", "de", "de", "Deutsch");
INSERT INTO `wp_icl_languages_translations` VALUES("132", "de", "fr", "Allemand");
INSERT INTO `wp_icl_languages_translations` VALUES("133", "de", "ar", "الألمانية");
INSERT INTO `wp_icl_languages_translations` VALUES("134", "de", "bs", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("135", "de", "bg", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("136", "de", "ca", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("137", "de", "cs", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("138", "de", "sk", "Nemčina");
INSERT INTO `wp_icl_languages_translations` VALUES("139", "de", "cy", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("140", "de", "da", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("141", "de", "el", "Γερμανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("142", "de", "eo", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("143", "de", "et", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("144", "de", "eu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("145", "de", "fa", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("146", "de", "fi", "saksa");
INSERT INTO `wp_icl_languages_translations` VALUES("147", "de", "ga", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("148", "de", "he", "גרמנית");
INSERT INTO `wp_icl_languages_translations` VALUES("149", "de", "hi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("150", "de", "hr", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("151", "de", "hu", "német");
INSERT INTO `wp_icl_languages_translations` VALUES("152", "de", "hy", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("153", "de", "id", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("154", "de", "is", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("155", "de", "it", "Tedesco");
INSERT INTO `wp_icl_languages_translations` VALUES("156", "de", "ja", "ドイツ語");
INSERT INTO `wp_icl_languages_translations` VALUES("157", "de", "ko", "독어");
INSERT INTO `wp_icl_languages_translations` VALUES("158", "de", "ku", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("159", "de", "la", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("160", "de", "lv", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("161", "de", "lt", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("162", "de", "mk", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("163", "de", "mt", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("164", "de", "mo", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("165", "de", "mn", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("166", "de", "ne", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("167", "de", "nl", "Duits");
INSERT INTO `wp_icl_languages_translations` VALUES("168", "de", "nb", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("169", "de", "pa", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("170", "de", "pl", "niemiecki");
INSERT INTO `wp_icl_languages_translations` VALUES("171", "de", "pt-pt", "Alemão");
INSERT INTO `wp_icl_languages_translations` VALUES("172", "de", "pt-br", "Alemão");
INSERT INTO `wp_icl_languages_translations` VALUES("173", "de", "qu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("174", "de", "ro", "Germană");
INSERT INTO `wp_icl_languages_translations` VALUES("175", "de", "ru", "Немецкий");
INSERT INTO `wp_icl_languages_translations` VALUES("176", "de", "sl", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("177", "de", "so", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("178", "de", "sq", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("179", "de", "sr", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("180", "de", "sv", "Tyska");
INSERT INTO `wp_icl_languages_translations` VALUES("181", "de", "ta", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("182", "de", "th", "เยอรมัน");
INSERT INTO `wp_icl_languages_translations` VALUES("183", "de", "tr", "Almanca");
INSERT INTO `wp_icl_languages_translations` VALUES("184", "de", "uk", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("185", "de", "ur", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("186", "de", "uz", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("187", "de", "vi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("188", "de", "yi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("189", "de", "zh-hans", "德语");
INSERT INTO `wp_icl_languages_translations` VALUES("190", "de", "zu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("191", "de", "zh-hant", "德語");
INSERT INTO `wp_icl_languages_translations` VALUES("192", "de", "ms", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("193", "fr", "en", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("194", "fr", "es", "Francés");
INSERT INTO `wp_icl_languages_translations` VALUES("195", "fr", "de", "Französisch");
INSERT INTO `wp_icl_languages_translations` VALUES("196", "fr", "fr", "Français");
INSERT INTO `wp_icl_languages_translations` VALUES("197", "fr", "ar", "الفرنسية");
INSERT INTO `wp_icl_languages_translations` VALUES("198", "fr", "bs", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("199", "fr", "bg", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("200", "fr", "ca", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("201", "fr", "cs", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("202", "fr", "sk", "Francúzština");
INSERT INTO `wp_icl_languages_translations` VALUES("203", "fr", "cy", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("204", "fr", "da", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("205", "fr", "el", "Γαλλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("206", "fr", "eo", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("207", "fr", "et", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("208", "fr", "eu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("209", "fr", "fa", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("210", "fr", "fi", "ranska");
INSERT INTO `wp_icl_languages_translations` VALUES("211", "fr", "ga", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("212", "fr", "he", "צרפתית");
INSERT INTO `wp_icl_languages_translations` VALUES("213", "fr", "hi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("214", "fr", "hr", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("215", "fr", "hu", "francia");
INSERT INTO `wp_icl_languages_translations` VALUES("216", "fr", "hy", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("217", "fr", "id", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("218", "fr", "is", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("219", "fr", "it", "Francese");
INSERT INTO `wp_icl_languages_translations` VALUES("220", "fr", "ja", "フランス語");
INSERT INTO `wp_icl_languages_translations` VALUES("221", "fr", "ko", "불어");
INSERT INTO `wp_icl_languages_translations` VALUES("222", "fr", "ku", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("223", "fr", "la", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("224", "fr", "lv", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("225", "fr", "lt", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("226", "fr", "mk", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("227", "fr", "mt", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("228", "fr", "mo", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("229", "fr", "mn", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("230", "fr", "ne", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("231", "fr", "nl", "Frans");
INSERT INTO `wp_icl_languages_translations` VALUES("232", "fr", "nb", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("233", "fr", "pa", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("234", "fr", "pl", "francuski");
INSERT INTO `wp_icl_languages_translations` VALUES("235", "fr", "pt-pt", "Francês");
INSERT INTO `wp_icl_languages_translations` VALUES("236", "fr", "pt-br", "Francês");
INSERT INTO `wp_icl_languages_translations` VALUES("237", "fr", "qu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("238", "fr", "ro", "Franceză");
INSERT INTO `wp_icl_languages_translations` VALUES("239", "fr", "ru", "Французский");
INSERT INTO `wp_icl_languages_translations` VALUES("240", "fr", "sl", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("241", "fr", "so", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("242", "fr", "sq", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("243", "fr", "sr", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("244", "fr", "sv", "Franska");
INSERT INTO `wp_icl_languages_translations` VALUES("245", "fr", "ta", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("246", "fr", "th", "ฝรั่งเศส");
INSERT INTO `wp_icl_languages_translations` VALUES("247", "fr", "tr", "Fransızca");
INSERT INTO `wp_icl_languages_translations` VALUES("248", "fr", "uk", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("249", "fr", "ur", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("250", "fr", "uz", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("251", "fr", "vi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("252", "fr", "yi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("253", "fr", "zh-hans", "法语");
INSERT INTO `wp_icl_languages_translations` VALUES("254", "fr", "zu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("255", "fr", "zh-hant", "法語");
INSERT INTO `wp_icl_languages_translations` VALUES("256", "fr", "ms", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("257", "ar", "en", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("258", "ar", "es", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("259", "ar", "de", "Arabisch");
INSERT INTO `wp_icl_languages_translations` VALUES("260", "ar", "fr", "Arabe");
INSERT INTO `wp_icl_languages_translations` VALUES("261", "ar", "ar", "العربية");
INSERT INTO `wp_icl_languages_translations` VALUES("262", "ar", "bs", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("263", "ar", "bg", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("264", "ar", "ca", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("265", "ar", "cs", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("266", "ar", "sk", "Arabčina");
INSERT INTO `wp_icl_languages_translations` VALUES("267", "ar", "cy", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("268", "ar", "da", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("269", "ar", "el", "Αραβικα");
INSERT INTO `wp_icl_languages_translations` VALUES("270", "ar", "eo", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("271", "ar", "et", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("272", "ar", "eu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("273", "ar", "fa", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("274", "ar", "fi", "arabia");
INSERT INTO `wp_icl_languages_translations` VALUES("275", "ar", "ga", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("276", "ar", "he", "ערבית");
INSERT INTO `wp_icl_languages_translations` VALUES("277", "ar", "hi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("278", "ar", "hr", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("279", "ar", "hu", "arab");
INSERT INTO `wp_icl_languages_translations` VALUES("280", "ar", "hy", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("281", "ar", "id", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("282", "ar", "is", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("283", "ar", "it", "Arabo");
INSERT INTO `wp_icl_languages_translations` VALUES("284", "ar", "ja", "アラビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("285", "ar", "ko", "아랍어");
INSERT INTO `wp_icl_languages_translations` VALUES("286", "ar", "ku", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("287", "ar", "la", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("288", "ar", "lv", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("289", "ar", "lt", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("290", "ar", "mk", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("291", "ar", "mt", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("292", "ar", "mo", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("293", "ar", "mn", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("294", "ar", "ne", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("295", "ar", "nl", "Arabisch");
INSERT INTO `wp_icl_languages_translations` VALUES("296", "ar", "nb", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("297", "ar", "pa", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("298", "ar", "pl", "arabski");
INSERT INTO `wp_icl_languages_translations` VALUES("299", "ar", "pt-pt", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("300", "ar", "pt-br", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("301", "ar", "qu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("302", "ar", "ro", "Arabică");
INSERT INTO `wp_icl_languages_translations` VALUES("303", "ar", "ru", "Арабский");
INSERT INTO `wp_icl_languages_translations` VALUES("304", "ar", "sl", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("305", "ar", "so", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("306", "ar", "sq", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("307", "ar", "sr", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("308", "ar", "sv", "Arabiska");
INSERT INTO `wp_icl_languages_translations` VALUES("309", "ar", "ta", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("310", "ar", "th", "อารบิก");
INSERT INTO `wp_icl_languages_translations` VALUES("311", "ar", "tr", "Arapça");
INSERT INTO `wp_icl_languages_translations` VALUES("312", "ar", "uk", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("313", "ar", "ur", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("314", "ar", "uz", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("315", "ar", "vi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("316", "ar", "yi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("317", "ar", "zh-hans", "阿拉伯语");
INSERT INTO `wp_icl_languages_translations` VALUES("318", "ar", "zu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("319", "ar", "zh-hant", "阿拉伯語");
INSERT INTO `wp_icl_languages_translations` VALUES("320", "ar", "ms", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("321", "bs", "en", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("322", "bs", "es", "Bosnio");
INSERT INTO `wp_icl_languages_translations` VALUES("323", "bs", "de", "Bosnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("324", "bs", "fr", "Bosnien");
INSERT INTO `wp_icl_languages_translations` VALUES("325", "bs", "ar", "البوسنية");
INSERT INTO `wp_icl_languages_translations` VALUES("326", "bs", "bs", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("327", "bs", "bg", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("328", "bs", "ca", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("329", "bs", "cs", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("330", "bs", "sk", "Bosniačtina");
INSERT INTO `wp_icl_languages_translations` VALUES("331", "bs", "cy", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("332", "bs", "da", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("333", "bs", "el", "Βοσνιακα");
INSERT INTO `wp_icl_languages_translations` VALUES("334", "bs", "eo", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("335", "bs", "et", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("336", "bs", "eu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("337", "bs", "fa", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("338", "bs", "fi", "bosnia");
INSERT INTO `wp_icl_languages_translations` VALUES("339", "bs", "ga", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("340", "bs", "he", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("341", "bs", "hi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("342", "bs", "hr", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("343", "bs", "hu", "bosnyák");
INSERT INTO `wp_icl_languages_translations` VALUES("344", "bs", "hy", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("345", "bs", "id", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("346", "bs", "is", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("347", "bs", "it", "Bosniaco");
INSERT INTO `wp_icl_languages_translations` VALUES("348", "bs", "ja", "ボスニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("349", "bs", "ko", "보즈니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("350", "bs", "ku", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("351", "bs", "la", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("352", "bs", "lv", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("353", "bs", "lt", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("354", "bs", "mk", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("355", "bs", "mt", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("356", "bs", "mo", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("357", "bs", "mn", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("358", "bs", "ne", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("359", "bs", "nl", "Bosnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("360", "bs", "nb", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("361", "bs", "pa", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("362", "bs", "pl", "bośniacki");
INSERT INTO `wp_icl_languages_translations` VALUES("363", "bs", "pt-pt", "Bósnio");
INSERT INTO `wp_icl_languages_translations` VALUES("364", "bs", "pt-br", "Bósnio");
INSERT INTO `wp_icl_languages_translations` VALUES("365", "bs", "qu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("366", "bs", "ro", "Bosniacă");
INSERT INTO `wp_icl_languages_translations` VALUES("367", "bs", "ru", "Боснийский");
INSERT INTO `wp_icl_languages_translations` VALUES("368", "bs", "sl", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("369", "bs", "so", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("370", "bs", "sq", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("371", "bs", "sr", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("372", "bs", "sv", "Bosniska");
INSERT INTO `wp_icl_languages_translations` VALUES("373", "bs", "ta", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("374", "bs", "th", "บอสเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("375", "bs", "tr", "Boşnakça");
INSERT INTO `wp_icl_languages_translations` VALUES("376", "bs", "uk", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("377", "bs", "ur", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("378", "bs", "uz", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("379", "bs", "vi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("380", "bs", "yi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("381", "bs", "zh-hans", "波斯尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("382", "bs", "zu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("383", "bs", "zh-hant", "波士尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("384", "bs", "ms", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("385", "bg", "en", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("386", "bg", "es", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("387", "bg", "de", "Bulgarisch");
INSERT INTO `wp_icl_languages_translations` VALUES("388", "bg", "fr", "Bulgare");
INSERT INTO `wp_icl_languages_translations` VALUES("389", "bg", "ar", "البلغارية");
INSERT INTO `wp_icl_languages_translations` VALUES("390", "bg", "bs", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("391", "bg", "bg", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("392", "bg", "ca", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("393", "bg", "cs", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("394", "bg", "sk", "Bulharčina");
INSERT INTO `wp_icl_languages_translations` VALUES("395", "bg", "cy", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("396", "bg", "da", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("397", "bg", "el", "Βουλγαρικα");
INSERT INTO `wp_icl_languages_translations` VALUES("398", "bg", "eo", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("399", "bg", "et", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("400", "bg", "eu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("401", "bg", "fa", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("402", "bg", "fi", "bulgaria");
INSERT INTO `wp_icl_languages_translations` VALUES("403", "bg", "ga", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("404", "bg", "he", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("405", "bg", "hi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("406", "bg", "hr", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("407", "bg", "hu", "bolgár");
INSERT INTO `wp_icl_languages_translations` VALUES("408", "bg", "hy", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("409", "bg", "id", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("410", "bg", "is", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("411", "bg", "it", "Bulgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("412", "bg", "ja", "ブルガリア語");
INSERT INTO `wp_icl_languages_translations` VALUES("413", "bg", "ko", "불가리아어");
INSERT INTO `wp_icl_languages_translations` VALUES("414", "bg", "ku", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("415", "bg", "la", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("416", "bg", "lv", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("417", "bg", "lt", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("418", "bg", "mk", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("419", "bg", "mt", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("420", "bg", "mo", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("421", "bg", "mn", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("422", "bg", "ne", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("423", "bg", "nl", "Bulgaars");
INSERT INTO `wp_icl_languages_translations` VALUES("424", "bg", "nb", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("425", "bg", "pa", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("426", "bg", "pl", "bułgarski");
INSERT INTO `wp_icl_languages_translations` VALUES("427", "bg", "pt-pt", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("428", "bg", "pt-br", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("429", "bg", "qu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("430", "bg", "ro", "Bulgară");
INSERT INTO `wp_icl_languages_translations` VALUES("431", "bg", "ru", "Болгарский");
INSERT INTO `wp_icl_languages_translations` VALUES("432", "bg", "sl", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("433", "bg", "so", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("434", "bg", "sq", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("435", "bg", "sr", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("436", "bg", "sv", "Bulgariska");
INSERT INTO `wp_icl_languages_translations` VALUES("437", "bg", "ta", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("438", "bg", "th", "บัลแกเรียน");
INSERT INTO `wp_icl_languages_translations` VALUES("439", "bg", "tr", "Bulgarca");
INSERT INTO `wp_icl_languages_translations` VALUES("440", "bg", "uk", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("441", "bg", "ur", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("442", "bg", "uz", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("443", "bg", "vi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("444", "bg", "yi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("445", "bg", "zh-hans", "保加利亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("446", "bg", "zu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("447", "bg", "zh-hant", "保加利亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("448", "bg", "ms", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("449", "ca", "en", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("450", "ca", "es", "Catalán");
INSERT INTO `wp_icl_languages_translations` VALUES("451", "ca", "de", "Katalanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("452", "ca", "fr", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("453", "ca", "ar", "الكاتالوينية");
INSERT INTO `wp_icl_languages_translations` VALUES("454", "ca", "bs", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("455", "ca", "bg", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("456", "ca", "ca", "Català");
INSERT INTO `wp_icl_languages_translations` VALUES("457", "ca", "cs", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("458", "ca", "sk", "Katalánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("459", "ca", "cy", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("460", "ca", "da", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("461", "ca", "el", "Καταλανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("462", "ca", "eo", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("463", "ca", "et", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("464", "ca", "eu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("465", "ca", "fa", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("466", "ca", "fi", "katalaani");
INSERT INTO `wp_icl_languages_translations` VALUES("467", "ca", "ga", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("468", "ca", "he", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("469", "ca", "hi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("470", "ca", "hr", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("471", "ca", "hu", "katalán");
INSERT INTO `wp_icl_languages_translations` VALUES("472", "ca", "hy", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("473", "ca", "id", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("474", "ca", "is", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("475", "ca", "it", "Catalano");
INSERT INTO `wp_icl_languages_translations` VALUES("476", "ca", "ja", "カタルーニャ語");
INSERT INTO `wp_icl_languages_translations` VALUES("477", "ca", "ko", "카탈로니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("478", "ca", "ku", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("479", "ca", "la", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("480", "ca", "lv", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("481", "ca", "lt", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("482", "ca", "mk", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("483", "ca", "mt", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("484", "ca", "mo", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("485", "ca", "mn", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("486", "ca", "ne", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("487", "ca", "nl", "Catalaans");
INSERT INTO `wp_icl_languages_translations` VALUES("488", "ca", "nb", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("489", "ca", "pa", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("490", "ca", "pl", "kataloński");
INSERT INTO `wp_icl_languages_translations` VALUES("491", "ca", "pt-pt", "Catalão");
INSERT INTO `wp_icl_languages_translations` VALUES("492", "ca", "pt-br", "Catalão");
INSERT INTO `wp_icl_languages_translations` VALUES("493", "ca", "qu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("494", "ca", "ro", "Catalană");
INSERT INTO `wp_icl_languages_translations` VALUES("495", "ca", "ru", "Каталанский");
INSERT INTO `wp_icl_languages_translations` VALUES("496", "ca", "sl", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("497", "ca", "so", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("498", "ca", "sq", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("499", "ca", "sr", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("500", "ca", "sv", "Katalanska");
INSERT INTO `wp_icl_languages_translations` VALUES("501", "ca", "ta", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("502", "ca", "th", "คะตะลาน");
INSERT INTO `wp_icl_languages_translations` VALUES("503", "ca", "tr", "Katalan dili");
INSERT INTO `wp_icl_languages_translations` VALUES("504", "ca", "uk", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("505", "ca", "ur", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("506", "ca", "uz", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("507", "ca", "vi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("508", "ca", "yi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("509", "ca", "zh-hans", "加泰罗尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("510", "ca", "zu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("511", "ca", "zh-hant", "加泰羅尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("512", "ca", "ms", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("513", "cs", "en", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("514", "cs", "es", "Checo");
INSERT INTO `wp_icl_languages_translations` VALUES("515", "cs", "de", "Tschechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("516", "cs", "fr", "Tchèque");
INSERT INTO `wp_icl_languages_translations` VALUES("517", "cs", "ar", "التشيكية");
INSERT INTO `wp_icl_languages_translations` VALUES("518", "cs", "bs", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("519", "cs", "bg", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("520", "cs", "ca", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("521", "cs", "cs", "Čeština");
INSERT INTO `wp_icl_languages_translations` VALUES("522", "cs", "sk", "Čeština");
INSERT INTO `wp_icl_languages_translations` VALUES("523", "cs", "cy", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("524", "cs", "da", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("525", "cs", "el", "Τσεχικη");
INSERT INTO `wp_icl_languages_translations` VALUES("526", "cs", "eo", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("527", "cs", "et", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("528", "cs", "eu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("529", "cs", "fa", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("530", "cs", "fi", "tsekki");
INSERT INTO `wp_icl_languages_translations` VALUES("531", "cs", "ga", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("532", "cs", "he", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("533", "cs", "hi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("534", "cs", "hr", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("535", "cs", "hu", "cseh");
INSERT INTO `wp_icl_languages_translations` VALUES("536", "cs", "hy", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("537", "cs", "id", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("538", "cs", "is", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("539", "cs", "it", "Ceco");
INSERT INTO `wp_icl_languages_translations` VALUES("540", "cs", "ja", "チェコ語");
INSERT INTO `wp_icl_languages_translations` VALUES("541", "cs", "ko", "체코슬로바키아어");
INSERT INTO `wp_icl_languages_translations` VALUES("542", "cs", "ku", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("543", "cs", "la", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("544", "cs", "lv", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("545", "cs", "lt", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("546", "cs", "mk", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("547", "cs", "mt", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("548", "cs", "mo", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("549", "cs", "mn", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("550", "cs", "ne", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("551", "cs", "nl", "Tsjechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("552", "cs", "nb", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("553", "cs", "pa", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("554", "cs", "pl", "czeski");
INSERT INTO `wp_icl_languages_translations` VALUES("555", "cs", "pt-pt", "Checa");
INSERT INTO `wp_icl_languages_translations` VALUES("556", "cs", "pt-br", "Checa");
INSERT INTO `wp_icl_languages_translations` VALUES("557", "cs", "qu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("558", "cs", "ro", "Cehă");
INSERT INTO `wp_icl_languages_translations` VALUES("559", "cs", "ru", "Чешский");
INSERT INTO `wp_icl_languages_translations` VALUES("560", "cs", "sl", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("561", "cs", "so", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("562", "cs", "sq", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("563", "cs", "sr", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("564", "cs", "sv", "Tjeckiska");
INSERT INTO `wp_icl_languages_translations` VALUES("565", "cs", "ta", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("566", "cs", "th", "เช็ก");
INSERT INTO `wp_icl_languages_translations` VALUES("567", "cs", "tr", "Çekçe");
INSERT INTO `wp_icl_languages_translations` VALUES("568", "cs", "uk", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("569", "cs", "ur", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("570", "cs", "uz", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("571", "cs", "vi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("572", "cs", "yi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("573", "cs", "zh-hans", "捷克语");
INSERT INTO `wp_icl_languages_translations` VALUES("574", "cs", "zu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("575", "cs", "zh-hant", "捷克語");
INSERT INTO `wp_icl_languages_translations` VALUES("576", "cs", "ms", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("577", "sk", "en", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("578", "sk", "es", "Eslavo");
INSERT INTO `wp_icl_languages_translations` VALUES("579", "sk", "de", "Slawisch");
INSERT INTO `wp_icl_languages_translations` VALUES("580", "sk", "fr", "Slave");
INSERT INTO `wp_icl_languages_translations` VALUES("581", "sk", "ar", "السلافية");
INSERT INTO `wp_icl_languages_translations` VALUES("582", "sk", "bs", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("583", "sk", "bg", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("584", "sk", "ca", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("585", "sk", "cs", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("586", "sk", "sk", "Slovenčina");
INSERT INTO `wp_icl_languages_translations` VALUES("587", "sk", "cy", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("588", "sk", "da", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("589", "sk", "el", "Σλαβικη");
INSERT INTO `wp_icl_languages_translations` VALUES("590", "sk", "eo", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("591", "sk", "et", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("592", "sk", "eu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("593", "sk", "fa", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("594", "sk", "fi", "slaavi");
INSERT INTO `wp_icl_languages_translations` VALUES("595", "sk", "ga", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("596", "sk", "he", "Slavic");
INSERT INTO `wp_icl_languages_translations` VALUES("597", "sk", "hi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("598", "sk", "hr", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("599", "sk", "hu", "szláv");
INSERT INTO `wp_icl_languages_translations` VALUES("600", "sk", "hy", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("601", "sk", "id", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("602", "sk", "is", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("603", "sk", "it", "Slavo");
INSERT INTO `wp_icl_languages_translations` VALUES("604", "sk", "ja", "スラヴ語派");
INSERT INTO `wp_icl_languages_translations` VALUES("605", "sk", "ko", "슬라브어");
INSERT INTO `wp_icl_languages_translations` VALUES("606", "sk", "ku", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("607", "sk", "la", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("608", "sk", "lv", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("609", "sk", "lt", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("610", "sk", "mk", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("611", "sk", "mt", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("612", "sk", "mo", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("613", "sk", "mn", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("614", "sk", "ne", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("615", "sk", "nl", "Slavisch");
INSERT INTO `wp_icl_languages_translations` VALUES("616", "sk", "nb", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("617", "sk", "pa", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("618", "sk", "pl", "słowiański");
INSERT INTO `wp_icl_languages_translations` VALUES("619", "sk", "pt-pt", "Eslava");
INSERT INTO `wp_icl_languages_translations` VALUES("620", "sk", "pt-br", "Eslava");
INSERT INTO `wp_icl_languages_translations` VALUES("621", "sk", "qu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("622", "sk", "ro", "Slavă");
INSERT INTO `wp_icl_languages_translations` VALUES("623", "sk", "ru", "Славянский");
INSERT INTO `wp_icl_languages_translations` VALUES("624", "sk", "sl", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("625", "sk", "so", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("626", "sk", "sq", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("627", "sk", "sr", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("628", "sk", "sv", "Slavisk");
INSERT INTO `wp_icl_languages_translations` VALUES("629", "sk", "ta", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("630", "sk", "th", "สลาวิก");
INSERT INTO `wp_icl_languages_translations` VALUES("631", "sk", "tr", "Slav dili");
INSERT INTO `wp_icl_languages_translations` VALUES("632", "sk", "uk", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("633", "sk", "ur", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("634", "sk", "uz", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("635", "sk", "vi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("636", "sk", "yi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("637", "sk", "zh-hans", "斯拉夫语");
INSERT INTO `wp_icl_languages_translations` VALUES("638", "sk", "zu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("639", "sk", "zh-hant", "斯拉夫語");
INSERT INTO `wp_icl_languages_translations` VALUES("640", "sk", "ms", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("641", "cy", "en", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("642", "cy", "es", "Galés");
INSERT INTO `wp_icl_languages_translations` VALUES("643", "cy", "de", "Walisisch");
INSERT INTO `wp_icl_languages_translations` VALUES("644", "cy", "fr", "Gallois");
INSERT INTO `wp_icl_languages_translations` VALUES("645", "cy", "ar", "الولزية");
INSERT INTO `wp_icl_languages_translations` VALUES("646", "cy", "bs", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("647", "cy", "bg", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("648", "cy", "ca", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("649", "cy", "cs", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("650", "cy", "sk", "Welština");
INSERT INTO `wp_icl_languages_translations` VALUES("651", "cy", "cy", "Cymraeg");
INSERT INTO `wp_icl_languages_translations` VALUES("652", "cy", "da", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("653", "cy", "el", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("654", "cy", "eo", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("655", "cy", "et", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("656", "cy", "eu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("657", "cy", "fa", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("658", "cy", "fi", "kymri");
INSERT INTO `wp_icl_languages_translations` VALUES("659", "cy", "ga", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("660", "cy", "he", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("661", "cy", "hi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("662", "cy", "hr", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("663", "cy", "hu", "vels");
INSERT INTO `wp_icl_languages_translations` VALUES("664", "cy", "hy", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("665", "cy", "id", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("666", "cy", "is", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("667", "cy", "it", "Gallese");
INSERT INTO `wp_icl_languages_translations` VALUES("668", "cy", "ja", "ウェールズ語");
INSERT INTO `wp_icl_languages_translations` VALUES("669", "cy", "ko", "웨일즈어");
INSERT INTO `wp_icl_languages_translations` VALUES("670", "cy", "ku", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("671", "cy", "la", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("672", "cy", "lv", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("673", "cy", "lt", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("674", "cy", "mk", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("675", "cy", "mt", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("676", "cy", "mo", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("677", "cy", "mn", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("678", "cy", "ne", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("679", "cy", "nl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("680", "cy", "nb", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("681", "cy", "pa", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("682", "cy", "pl", "walijski");
INSERT INTO `wp_icl_languages_translations` VALUES("683", "cy", "pt-pt", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("684", "cy", "pt-br", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("685", "cy", "qu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("686", "cy", "ro", "Galeză");
INSERT INTO `wp_icl_languages_translations` VALUES("687", "cy", "ru", "Валлийский");
INSERT INTO `wp_icl_languages_translations` VALUES("688", "cy", "sl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("689", "cy", "so", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("690", "cy", "sq", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("691", "cy", "sr", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("692", "cy", "sv", "Walesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("693", "cy", "ta", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("694", "cy", "th", "เวลช์");
INSERT INTO `wp_icl_languages_translations` VALUES("695", "cy", "tr", "Galce");
INSERT INTO `wp_icl_languages_translations` VALUES("696", "cy", "uk", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("697", "cy", "ur", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("698", "cy", "uz", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("699", "cy", "vi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("700", "cy", "yi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("701", "cy", "zh-hans", "威尔士语");
INSERT INTO `wp_icl_languages_translations` VALUES("702", "cy", "zu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("703", "cy", "zh-hant", "威爾士語");
INSERT INTO `wp_icl_languages_translations` VALUES("704", "cy", "ms", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("705", "da", "en", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("706", "da", "es", "Danés");
INSERT INTO `wp_icl_languages_translations` VALUES("707", "da", "de", "Dänisch");
INSERT INTO `wp_icl_languages_translations` VALUES("708", "da", "fr", "Danois");
INSERT INTO `wp_icl_languages_translations` VALUES("709", "da", "ar", "الدانماركية");
INSERT INTO `wp_icl_languages_translations` VALUES("710", "da", "bs", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("711", "da", "bg", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("712", "da", "ca", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("713", "da", "cs", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("714", "da", "sk", "Dánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("715", "da", "cy", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("716", "da", "da", "Dansk");
INSERT INTO `wp_icl_languages_translations` VALUES("717", "da", "el", "Δανεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("718", "da", "eo", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("719", "da", "et", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("720", "da", "eu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("721", "da", "fa", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("722", "da", "fi", "tanska");
INSERT INTO `wp_icl_languages_translations` VALUES("723", "da", "ga", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("724", "da", "he", "דנית");
INSERT INTO `wp_icl_languages_translations` VALUES("725", "da", "hi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("726", "da", "hr", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("727", "da", "hu", "dán");
INSERT INTO `wp_icl_languages_translations` VALUES("728", "da", "hy", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("729", "da", "id", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("730", "da", "is", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("731", "da", "it", "Danese");
INSERT INTO `wp_icl_languages_translations` VALUES("732", "da", "ja", "デンマーク語");
INSERT INTO `wp_icl_languages_translations` VALUES("733", "da", "ko", "덴마크어");
INSERT INTO `wp_icl_languages_translations` VALUES("734", "da", "ku", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("735", "da", "la", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("736", "da", "lv", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("737", "da", "lt", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("738", "da", "mk", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("739", "da", "mt", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("740", "da", "mo", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("741", "da", "mn", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("742", "da", "ne", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("743", "da", "nl", "Deens");
INSERT INTO `wp_icl_languages_translations` VALUES("744", "da", "nb", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("745", "da", "pa", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("746", "da", "pl", "duński");
INSERT INTO `wp_icl_languages_translations` VALUES("747", "da", "pt-pt", "Dinamarquês");
INSERT INTO `wp_icl_languages_translations` VALUES("748", "da", "pt-br", "Dinamarquês");
INSERT INTO `wp_icl_languages_translations` VALUES("749", "da", "qu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("750", "da", "ro", "Daneză");
INSERT INTO `wp_icl_languages_translations` VALUES("751", "da", "ru", "Датский");
INSERT INTO `wp_icl_languages_translations` VALUES("752", "da", "sl", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("753", "da", "so", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("754", "da", "sq", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("755", "da", "sr", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("756", "da", "sv", "Danska");
INSERT INTO `wp_icl_languages_translations` VALUES("757", "da", "ta", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("758", "da", "th", "เดนมาร์ก");
INSERT INTO `wp_icl_languages_translations` VALUES("759", "da", "tr", "Danca");
INSERT INTO `wp_icl_languages_translations` VALUES("760", "da", "uk", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("761", "da", "ur", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("762", "da", "uz", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("763", "da", "vi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("764", "da", "yi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("765", "da", "zh-hans", "丹麦语");
INSERT INTO `wp_icl_languages_translations` VALUES("766", "da", "zu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("767", "da", "zh-hant", "丹麥語");
INSERT INTO `wp_icl_languages_translations` VALUES("768", "da", "ms", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("769", "el", "en", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("770", "el", "es", "Griego");
INSERT INTO `wp_icl_languages_translations` VALUES("771", "el", "de", "Griechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("772", "el", "fr", "Grec moderne");
INSERT INTO `wp_icl_languages_translations` VALUES("773", "el", "ar", "اليونانية");
INSERT INTO `wp_icl_languages_translations` VALUES("774", "el", "bs", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("775", "el", "bg", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("776", "el", "ca", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("777", "el", "cs", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("778", "el", "sk", "Gréčtina");
INSERT INTO `wp_icl_languages_translations` VALUES("779", "el", "cy", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("780", "el", "da", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("781", "el", "el", "Ελληνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("782", "el", "eo", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("783", "el", "et", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("784", "el", "eu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("785", "el", "fa", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("786", "el", "fi", "kreikka");
INSERT INTO `wp_icl_languages_translations` VALUES("787", "el", "ga", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("788", "el", "he", "יוונית");
INSERT INTO `wp_icl_languages_translations` VALUES("789", "el", "hi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("790", "el", "hr", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("791", "el", "hu", "görög");
INSERT INTO `wp_icl_languages_translations` VALUES("792", "el", "hy", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("793", "el", "id", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("794", "el", "is", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("795", "el", "it", "Greco");
INSERT INTO `wp_icl_languages_translations` VALUES("796", "el", "ja", "ギリシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("797", "el", "ko", "그리스어");
INSERT INTO `wp_icl_languages_translations` VALUES("798", "el", "ku", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("799", "el", "la", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("800", "el", "lv", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("801", "el", "lt", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("802", "el", "mk", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("803", "el", "mt", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("804", "el", "mo", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("805", "el", "mn", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("806", "el", "ne", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("807", "el", "nl", "Grieks");
INSERT INTO `wp_icl_languages_translations` VALUES("808", "el", "nb", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("809", "el", "pa", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("810", "el", "pl", "grecki");
INSERT INTO `wp_icl_languages_translations` VALUES("811", "el", "pt-pt", "Grego");
INSERT INTO `wp_icl_languages_translations` VALUES("812", "el", "pt-br", "Grego");
INSERT INTO `wp_icl_languages_translations` VALUES("813", "el", "qu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("814", "el", "ro", "Greacă");
INSERT INTO `wp_icl_languages_translations` VALUES("815", "el", "ru", "Греческий");
INSERT INTO `wp_icl_languages_translations` VALUES("816", "el", "sl", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("817", "el", "so", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("818", "el", "sq", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("819", "el", "sr", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("820", "el", "sv", "Grekiska");
INSERT INTO `wp_icl_languages_translations` VALUES("821", "el", "ta", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("822", "el", "th", "กรีก");
INSERT INTO `wp_icl_languages_translations` VALUES("823", "el", "tr", "Yunanca");
INSERT INTO `wp_icl_languages_translations` VALUES("824", "el", "uk", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("825", "el", "ur", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("826", "el", "uz", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("827", "el", "vi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("828", "el", "yi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("829", "el", "zh-hans", "希腊语");
INSERT INTO `wp_icl_languages_translations` VALUES("830", "el", "zu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("831", "el", "zh-hant", "希臘語");
INSERT INTO `wp_icl_languages_translations` VALUES("832", "el", "ms", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("833", "eo", "en", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("834", "eo", "es", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("835", "eo", "de", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("836", "eo", "fr", "Espéranto");
INSERT INTO `wp_icl_languages_translations` VALUES("837", "eo", "ar", "الاسبرانتو");
INSERT INTO `wp_icl_languages_translations` VALUES("838", "eo", "bs", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("839", "eo", "bg", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("840", "eo", "ca", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("841", "eo", "cs", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("842", "eo", "sk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("843", "eo", "cy", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("844", "eo", "da", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("845", "eo", "el", "Εσπεραντο");
INSERT INTO `wp_icl_languages_translations` VALUES("846", "eo", "eo", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("847", "eo", "et", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("848", "eo", "eu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("849", "eo", "fa", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("850", "eo", "fi", "esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("851", "eo", "ga", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("852", "eo", "he", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("853", "eo", "hi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("854", "eo", "hr", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("855", "eo", "hu", "eszperantó");
INSERT INTO `wp_icl_languages_translations` VALUES("856", "eo", "hy", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("857", "eo", "id", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("858", "eo", "is", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("859", "eo", "it", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("860", "eo", "ja", "エスペラント語");
INSERT INTO `wp_icl_languages_translations` VALUES("861", "eo", "ko", "에스페란토어");
INSERT INTO `wp_icl_languages_translations` VALUES("862", "eo", "ku", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("863", "eo", "la", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("864", "eo", "lv", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("865", "eo", "lt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("866", "eo", "mk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("867", "eo", "mt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("868", "eo", "mo", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("869", "eo", "mn", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("870", "eo", "ne", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("871", "eo", "nl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("872", "eo", "nb", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("873", "eo", "pa", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("874", "eo", "pl", "esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("875", "eo", "pt-pt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("876", "eo", "pt-br", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("877", "eo", "qu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("878", "eo", "ro", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("879", "eo", "ru", "Эсперанто");
INSERT INTO `wp_icl_languages_translations` VALUES("880", "eo", "sl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("881", "eo", "so", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("882", "eo", "sq", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("883", "eo", "sr", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("884", "eo", "sv", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("885", "eo", "ta", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("886", "eo", "th", "เอสเปอรันโต");
INSERT INTO `wp_icl_languages_translations` VALUES("887", "eo", "tr", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("888", "eo", "uk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("889", "eo", "ur", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("890", "eo", "uz", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("891", "eo", "vi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("892", "eo", "yi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("893", "eo", "zh-hans", "世界语");
INSERT INTO `wp_icl_languages_translations` VALUES("894", "eo", "zu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("895", "eo", "zh-hant", "世界語");
INSERT INTO `wp_icl_languages_translations` VALUES("896", "eo", "ms", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("897", "et", "en", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("898", "et", "es", "Estonio");
INSERT INTO `wp_icl_languages_translations` VALUES("899", "et", "de", "Estnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("900", "et", "fr", "Estonien");
INSERT INTO `wp_icl_languages_translations` VALUES("901", "et", "ar", "الأستونية");
INSERT INTO `wp_icl_languages_translations` VALUES("902", "et", "bs", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("903", "et", "bg", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("904", "et", "ca", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("905", "et", "cs", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("906", "et", "sk", "Estónčina");
INSERT INTO `wp_icl_languages_translations` VALUES("907", "et", "cy", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("908", "et", "da", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("909", "et", "el", "Εσθονικα");
INSERT INTO `wp_icl_languages_translations` VALUES("910", "et", "eo", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("911", "et", "et", "Eesti");
INSERT INTO `wp_icl_languages_translations` VALUES("912", "et", "eu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("913", "et", "fa", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("914", "et", "fi", "eesti");
INSERT INTO `wp_icl_languages_translations` VALUES("915", "et", "ga", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("916", "et", "he", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("917", "et", "hi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("918", "et", "hr", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("919", "et", "hu", "észt");
INSERT INTO `wp_icl_languages_translations` VALUES("920", "et", "hy", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("921", "et", "id", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("922", "et", "is", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("923", "et", "it", "Estone");
INSERT INTO `wp_icl_languages_translations` VALUES("924", "et", "ja", "エストニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("925", "et", "ko", "에스토니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("926", "et", "ku", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("927", "et", "la", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("928", "et", "lv", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("929", "et", "lt", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("930", "et", "mk", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("931", "et", "mt", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("932", "et", "mo", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("933", "et", "mn", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("934", "et", "ne", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("935", "et", "nl", "Ests");
INSERT INTO `wp_icl_languages_translations` VALUES("936", "et", "nb", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("937", "et", "pa", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("938", "et", "pl", "estoński");
INSERT INTO `wp_icl_languages_translations` VALUES("939", "et", "pt-pt", "Estoniano");
INSERT INTO `wp_icl_languages_translations` VALUES("940", "et", "pt-br", "Estoniano");
INSERT INTO `wp_icl_languages_translations` VALUES("941", "et", "qu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("942", "et", "ro", "Estoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("943", "et", "ru", "Эстонский");
INSERT INTO `wp_icl_languages_translations` VALUES("944", "et", "sl", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("945", "et", "so", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("946", "et", "sq", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("947", "et", "sr", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("948", "et", "sv", "Estniska");
INSERT INTO `wp_icl_languages_translations` VALUES("949", "et", "ta", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("950", "et", "th", "เอสโตเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("951", "et", "tr", "Estonya dili");
INSERT INTO `wp_icl_languages_translations` VALUES("952", "et", "uk", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("953", "et", "ur", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("954", "et", "uz", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("955", "et", "vi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("956", "et", "yi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("957", "et", "zh-hans", "爱沙尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("958", "et", "zu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("959", "et", "zh-hant", "愛沙尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("960", "et", "ms", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("961", "eu", "en", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("962", "eu", "es", "Euskera");
INSERT INTO `wp_icl_languages_translations` VALUES("963", "eu", "de", "Baskisch");
INSERT INTO `wp_icl_languages_translations` VALUES("964", "eu", "fr", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("965", "eu", "ar", "لغة الباسك");
INSERT INTO `wp_icl_languages_translations` VALUES("966", "eu", "bs", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("967", "eu", "bg", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("968", "eu", "ca", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("969", "eu", "cs", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("970", "eu", "sk", "Baskičtina");
INSERT INTO `wp_icl_languages_translations` VALUES("971", "eu", "cy", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("972", "eu", "da", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("973", "eu", "el", "Βασκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("974", "eu", "eo", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("975", "eu", "et", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("976", "eu", "eu", "Euskara");
INSERT INTO `wp_icl_languages_translations` VALUES("977", "eu", "fa", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("978", "eu", "fi", "baski");
INSERT INTO `wp_icl_languages_translations` VALUES("979", "eu", "ga", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("980", "eu", "he", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("981", "eu", "hi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("982", "eu", "hr", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("983", "eu", "hu", "baszk");
INSERT INTO `wp_icl_languages_translations` VALUES("984", "eu", "hy", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("985", "eu", "id", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("986", "eu", "is", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("987", "eu", "it", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("988", "eu", "ja", "バスク語");
INSERT INTO `wp_icl_languages_translations` VALUES("989", "eu", "ko", "바스크어");
INSERT INTO `wp_icl_languages_translations` VALUES("990", "eu", "ku", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("991", "eu", "la", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("992", "eu", "lv", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("993", "eu", "lt", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("994", "eu", "mk", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("995", "eu", "mt", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("996", "eu", "mo", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("997", "eu", "mn", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("998", "eu", "ne", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("999", "eu", "nl", "Baskisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1000", "eu", "nb", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1001", "eu", "pa", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1002", "eu", "pl", "baskijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1003", "eu", "pt-pt", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("1004", "eu", "pt-br", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("1005", "eu", "qu", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1006", "eu", "ro", "Bască");
INSERT INTO `wp_icl_languages_translations` VALUES("1007", "eu", "ru", "Баскский");
INSERT INTO `wp_icl_languages_translations` VALUES("1008", "eu", "sl", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1009", "eu", "so", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1010", "eu", "sq", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1011", "eu", "sr", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1012", "eu", "sv", "Baskiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1013", "eu", "ta", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1014", "eu", "th", "บาสค์");
INSERT INTO `wp_icl_languages_translations` VALUES("1015", "eu", "tr", "Bask dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1016", "eu", "uk", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1017", "eu", "ur", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1018", "eu", "uz", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1019", "eu", "vi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1020", "eu", "yi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1021", "eu", "zh-hans", "巴斯克语");
INSERT INTO `wp_icl_languages_translations` VALUES("1022", "eu", "zu", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1023", "eu", "zh-hant", "巴斯克語");
INSERT INTO `wp_icl_languages_translations` VALUES("1024", "eu", "ms", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1025", "fa", "en", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1026", "fa", "es", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1027", "fa", "de", "Persisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1028", "fa", "fr", "Perse");
INSERT INTO `wp_icl_languages_translations` VALUES("1029", "fa", "ar", "الفارسية");
INSERT INTO `wp_icl_languages_translations` VALUES("1030", "fa", "bs", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1031", "fa", "bg", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1032", "fa", "ca", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1033", "fa", "cs", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1034", "fa", "sk", "Perzština");
INSERT INTO `wp_icl_languages_translations` VALUES("1035", "fa", "cy", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1036", "fa", "da", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1037", "fa", "el", "Περσικος");
INSERT INTO `wp_icl_languages_translations` VALUES("1038", "fa", "eo", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1039", "fa", "et", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1040", "fa", "eu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1041", "fa", "fa", "پارسی");
INSERT INTO `wp_icl_languages_translations` VALUES("1042", "fa", "fi", "persia");
INSERT INTO `wp_icl_languages_translations` VALUES("1043", "fa", "ga", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1044", "fa", "he", "פרסית");
INSERT INTO `wp_icl_languages_translations` VALUES("1045", "fa", "hi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1046", "fa", "hr", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1047", "fa", "hu", "perzsa");
INSERT INTO `wp_icl_languages_translations` VALUES("1048", "fa", "hy", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1049", "fa", "id", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1050", "fa", "is", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1051", "fa", "it", "Persiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1052", "fa", "ja", "ペルシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1053", "fa", "ko", "페르시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1054", "fa", "ku", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1055", "fa", "la", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1056", "fa", "lv", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1057", "fa", "lt", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1058", "fa", "mk", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1059", "fa", "mt", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1060", "fa", "mo", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1061", "fa", "mn", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1062", "fa", "ne", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1063", "fa", "nl", "Perzisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1064", "fa", "nb", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1065", "fa", "pa", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1066", "fa", "pl", "perski");
INSERT INTO `wp_icl_languages_translations` VALUES("1067", "fa", "pt-pt", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1068", "fa", "pt-br", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1069", "fa", "qu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1070", "fa", "ro", "Persană");
INSERT INTO `wp_icl_languages_translations` VALUES("1071", "fa", "ru", "Персидский");
INSERT INTO `wp_icl_languages_translations` VALUES("1072", "fa", "sl", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1073", "fa", "so", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1074", "fa", "sq", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1075", "fa", "sr", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1076", "fa", "sv", "Persiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1077", "fa", "ta", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1078", "fa", "th", "เปอร์เซียน");
INSERT INTO `wp_icl_languages_translations` VALUES("1079", "fa", "tr", "Farsça");
INSERT INTO `wp_icl_languages_translations` VALUES("1080", "fa", "uk", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1081", "fa", "ur", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1082", "fa", "uz", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1083", "fa", "vi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1084", "fa", "yi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1085", "fa", "zh-hans", "波斯语");
INSERT INTO `wp_icl_languages_translations` VALUES("1086", "fa", "zu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1087", "fa", "zh-hant", "波斯語");
INSERT INTO `wp_icl_languages_translations` VALUES("1088", "fa", "ms", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1089", "fi", "en", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1090", "fi", "es", "Finlandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1091", "fi", "de", "Finnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1092", "fi", "fr", "Finnois");
INSERT INTO `wp_icl_languages_translations` VALUES("1093", "fi", "ar", "الفنلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1094", "fi", "bs", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1095", "fi", "bg", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1096", "fi", "ca", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1097", "fi", "cs", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1098", "fi", "sk", "Fínština");
INSERT INTO `wp_icl_languages_translations` VALUES("1099", "fi", "cy", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1100", "fi", "da", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1101", "fi", "el", "Φινλανδικη");
INSERT INTO `wp_icl_languages_translations` VALUES("1102", "fi", "eo", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1103", "fi", "et", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1104", "fi", "eu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1105", "fi", "fa", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1106", "fi", "fi", "Suomi");
INSERT INTO `wp_icl_languages_translations` VALUES("1107", "fi", "ga", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1108", "fi", "he", "פינית");
INSERT INTO `wp_icl_languages_translations` VALUES("1109", "fi", "hi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1110", "fi", "hr", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1111", "fi", "hu", "finn");
INSERT INTO `wp_icl_languages_translations` VALUES("1112", "fi", "hy", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1113", "fi", "id", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1114", "fi", "is", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1115", "fi", "it", "Finlandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1116", "fi", "ja", "フィンランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1117", "fi", "ko", "핀란드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1118", "fi", "ku", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1119", "fi", "la", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1120", "fi", "lv", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1121", "fi", "lt", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1122", "fi", "mk", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1123", "fi", "mt", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1124", "fi", "mo", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1125", "fi", "mn", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1126", "fi", "ne", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1127", "fi", "nl", "Fins");
INSERT INTO `wp_icl_languages_translations` VALUES("1128", "fi", "nb", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1129", "fi", "pa", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1130", "fi", "pl", "fiński");
INSERT INTO `wp_icl_languages_translations` VALUES("1131", "fi", "pt-pt", "Finlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1132", "fi", "pt-br", "Finlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1133", "fi", "qu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1134", "fi", "ro", "Finlandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1135", "fi", "ru", "Финский");
INSERT INTO `wp_icl_languages_translations` VALUES("1136", "fi", "sl", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1137", "fi", "so", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1138", "fi", "sq", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1139", "fi", "sr", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1140", "fi", "sv", "Finska");
INSERT INTO `wp_icl_languages_translations` VALUES("1141", "fi", "ta", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1142", "fi", "th", "ฟินนิช");
INSERT INTO `wp_icl_languages_translations` VALUES("1143", "fi", "tr", "Fince");
INSERT INTO `wp_icl_languages_translations` VALUES("1144", "fi", "uk", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1145", "fi", "ur", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1146", "fi", "uz", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1147", "fi", "vi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1148", "fi", "yi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1149", "fi", "zh-hans", "芬兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("1150", "fi", "zu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1151", "fi", "zh-hant", "芬蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("1152", "fi", "ms", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1153", "ga", "en", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1154", "ga", "es", "Irlandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1155", "ga", "de", "Irisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1156", "ga", "fr", "Irlandais");
INSERT INTO `wp_icl_languages_translations` VALUES("1157", "ga", "ar", "الأيرلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1158", "ga", "bs", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1159", "ga", "bg", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1160", "ga", "ca", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1161", "ga", "cs", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1162", "ga", "sk", "Írština");
INSERT INTO `wp_icl_languages_translations` VALUES("1163", "ga", "cy", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1164", "ga", "da", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1165", "ga", "el", "Ιρλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1166", "ga", "eo", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1167", "ga", "et", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1168", "ga", "eu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1169", "ga", "fa", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1170", "ga", "fi", "iiri");
INSERT INTO `wp_icl_languages_translations` VALUES("1171", "ga", "ga", "Gaeilge");
INSERT INTO `wp_icl_languages_translations` VALUES("1172", "ga", "he", "אירית");
INSERT INTO `wp_icl_languages_translations` VALUES("1173", "ga", "hi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1174", "ga", "hr", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1175", "ga", "hu", "ír");
INSERT INTO `wp_icl_languages_translations` VALUES("1176", "ga", "hy", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1177", "ga", "id", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1178", "ga", "is", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1179", "ga", "it", "Irlandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1180", "ga", "ja", "アイルランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1181", "ga", "ko", "아일랜드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1182", "ga", "ku", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1183", "ga", "la", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1184", "ga", "lv", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1185", "ga", "lt", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1186", "ga", "mk", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1187", "ga", "mt", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1188", "ga", "mo", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1189", "ga", "mn", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1190", "ga", "ne", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1191", "ga", "nl", "Iers");
INSERT INTO `wp_icl_languages_translations` VALUES("1192", "ga", "nb", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1193", "ga", "pa", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1194", "ga", "pl", "irlandzki");
INSERT INTO `wp_icl_languages_translations` VALUES("1195", "ga", "pt-pt", "Irlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1196", "ga", "pt-br", "Irlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1197", "ga", "qu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1198", "ga", "ro", "Irlandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1199", "ga", "ru", "Ирландский");
INSERT INTO `wp_icl_languages_translations` VALUES("1200", "ga", "sl", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1201", "ga", "so", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1202", "ga", "sq", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1203", "ga", "sr", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1204", "ga", "sv", "Irländska");
INSERT INTO `wp_icl_languages_translations` VALUES("1205", "ga", "ta", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1206", "ga", "th", "ไอริช");
INSERT INTO `wp_icl_languages_translations` VALUES("1207", "ga", "tr", "İrlanda dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1208", "ga", "uk", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1209", "ga", "ur", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1210", "ga", "uz", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1211", "ga", "vi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1212", "ga", "yi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1213", "ga", "zh-hans", "爱尔兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("1214", "ga", "zu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1215", "ga", "zh-hant", "愛爾蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("1216", "ga", "ms", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1217", "he", "en", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1218", "he", "es", "Hebreo");
INSERT INTO `wp_icl_languages_translations` VALUES("1219", "he", "de", "Hebräisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1220", "he", "fr", "Hébreu");
INSERT INTO `wp_icl_languages_translations` VALUES("1221", "he", "ar", "العبرية");
INSERT INTO `wp_icl_languages_translations` VALUES("1222", "he", "bs", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1223", "he", "bg", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1224", "he", "ca", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1225", "he", "cs", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1226", "he", "sk", "Hebrejčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1227", "he", "cy", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1228", "he", "da", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1229", "he", "el", "Εβραικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1230", "he", "eo", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1231", "he", "et", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1232", "he", "eu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1233", "he", "fa", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1234", "he", "fi", "heprea");
INSERT INTO `wp_icl_languages_translations` VALUES("1235", "he", "ga", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1236", "he", "he", "עברית");
INSERT INTO `wp_icl_languages_translations` VALUES("1237", "he", "hi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1238", "he", "hr", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1239", "he", "hu", "héber");
INSERT INTO `wp_icl_languages_translations` VALUES("1240", "he", "hy", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1241", "he", "id", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1242", "he", "is", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1243", "he", "it", "Ebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1244", "he", "ja", "ヘブライ語");
INSERT INTO `wp_icl_languages_translations` VALUES("1245", "he", "ko", "히브리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1246", "he", "ku", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1247", "he", "la", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1248", "he", "lv", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1249", "he", "lt", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1250", "he", "mk", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1251", "he", "mt", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1252", "he", "mo", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1253", "he", "mn", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1254", "he", "ne", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1255", "he", "nl", "Hebreeuws");
INSERT INTO `wp_icl_languages_translations` VALUES("1256", "he", "nb", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1257", "he", "pa", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1258", "he", "pl", "hebrajski");
INSERT INTO `wp_icl_languages_translations` VALUES("1259", "he", "pt-pt", "Hebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1260", "he", "pt-br", "Hebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1261", "he", "qu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1262", "he", "ro", "Ebraică");
INSERT INTO `wp_icl_languages_translations` VALUES("1263", "he", "ru", "Иврит");
INSERT INTO `wp_icl_languages_translations` VALUES("1264", "he", "sl", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1265", "he", "so", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1266", "he", "sq", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1267", "he", "sr", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1268", "he", "sv", "Hebreiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1269", "he", "ta", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1270", "he", "th", "ฮิบรู");
INSERT INTO `wp_icl_languages_translations` VALUES("1271", "he", "tr", "İbranice");
INSERT INTO `wp_icl_languages_translations` VALUES("1272", "he", "uk", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1273", "he", "ur", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1274", "he", "uz", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1275", "he", "vi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1276", "he", "yi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1277", "he", "zh-hans", "希伯来语");
INSERT INTO `wp_icl_languages_translations` VALUES("1278", "he", "zu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1279", "he", "zh-hant", "希伯來語");
INSERT INTO `wp_icl_languages_translations` VALUES("1280", "he", "ms", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1281", "hi", "en", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1282", "hi", "es", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1283", "hi", "de", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1284", "hi", "fr", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1285", "hi", "ar", "الهندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1286", "hi", "bs", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1287", "hi", "bg", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1288", "hi", "ca", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1289", "hi", "cs", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1290", "hi", "sk", "Hindčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1291", "hi", "cy", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1292", "hi", "da", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1293", "hi", "el", "Ινδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1294", "hi", "eo", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1295", "hi", "et", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1296", "hi", "eu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1297", "hi", "fa", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1298", "hi", "fi", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1299", "hi", "ga", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1300", "hi", "he", "הודית");
INSERT INTO `wp_icl_languages_translations` VALUES("1301", "hi", "hi", "हिन्दी");
INSERT INTO `wp_icl_languages_translations` VALUES("1302", "hi", "hr", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1303", "hi", "hu", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1304", "hi", "hy", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1305", "hi", "id", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1306", "hi", "is", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1307", "hi", "it", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1308", "hi", "ja", "ヒンディー語");
INSERT INTO `wp_icl_languages_translations` VALUES("1309", "hi", "ko", "힌두어");
INSERT INTO `wp_icl_languages_translations` VALUES("1310", "hi", "ku", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1311", "hi", "la", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1312", "hi", "lv", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1313", "hi", "lt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1314", "hi", "mk", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1315", "hi", "mt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1316", "hi", "mo", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1317", "hi", "mn", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1318", "hi", "ne", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1319", "hi", "nl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1320", "hi", "nb", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1321", "hi", "pa", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1322", "hi", "pl", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1323", "hi", "pt-pt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1324", "hi", "pt-br", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1325", "hi", "qu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1326", "hi", "ro", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1327", "hi", "ru", "Хинди");
INSERT INTO `wp_icl_languages_translations` VALUES("1328", "hi", "sl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1329", "hi", "so", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1330", "hi", "sq", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1331", "hi", "sr", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1332", "hi", "sv", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1333", "hi", "ta", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1334", "hi", "th", "ฮินดิ");
INSERT INTO `wp_icl_languages_translations` VALUES("1335", "hi", "tr", "Hintçe");
INSERT INTO `wp_icl_languages_translations` VALUES("1336", "hi", "uk", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1337", "hi", "ur", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1338", "hi", "uz", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1339", "hi", "vi", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1340", "hi", "yi", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1341", "hi", "zh-hans", "印地语");
INSERT INTO `wp_icl_languages_translations` VALUES("1342", "hi", "zu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1343", "hi", "zh-hant", "印地語");
INSERT INTO `wp_icl_languages_translations` VALUES("1344", "hi", "ms", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1345", "hr", "en", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1346", "hr", "es", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1347", "hr", "de", "Kroatisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1348", "hr", "fr", "Croate");
INSERT INTO `wp_icl_languages_translations` VALUES("1349", "hr", "ar", "الكرواتية");
INSERT INTO `wp_icl_languages_translations` VALUES("1350", "hr", "bs", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1351", "hr", "bg", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1352", "hr", "ca", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1353", "hr", "cs", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1354", "hr", "sk", "Chorvátština");
INSERT INTO `wp_icl_languages_translations` VALUES("1355", "hr", "cy", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1356", "hr", "da", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1357", "hr", "el", "Κροατικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1358", "hr", "eo", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1359", "hr", "et", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1360", "hr", "eu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1361", "hr", "fa", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1362", "hr", "fi", "kroatia");
INSERT INTO `wp_icl_languages_translations` VALUES("1363", "hr", "ga", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1364", "hr", "he", "קרוטאית");
INSERT INTO `wp_icl_languages_translations` VALUES("1365", "hr", "hi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1366", "hr", "hr", "Hrvatski");
INSERT INTO `wp_icl_languages_translations` VALUES("1367", "hr", "hu", "horvát");
INSERT INTO `wp_icl_languages_translations` VALUES("1368", "hr", "hy", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1369", "hr", "id", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1370", "hr", "is", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1371", "hr", "it", "Croato");
INSERT INTO `wp_icl_languages_translations` VALUES("1372", "hr", "ja", "クロアチア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1373", "hr", "ko", "크로아시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1374", "hr", "ku", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1375", "hr", "la", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1376", "hr", "lv", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1377", "hr", "lt", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1378", "hr", "mk", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1379", "hr", "mt", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1380", "hr", "mo", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1381", "hr", "mn", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1382", "hr", "ne", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1383", "hr", "nl", "Kroatisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1384", "hr", "nb", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1385", "hr", "pa", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1386", "hr", "pl", "chorwacki");
INSERT INTO `wp_icl_languages_translations` VALUES("1387", "hr", "pt-pt", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1388", "hr", "pt-br", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1389", "hr", "qu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1390", "hr", "ro", "Croată");
INSERT INTO `wp_icl_languages_translations` VALUES("1391", "hr", "ru", "Хорватский");
INSERT INTO `wp_icl_languages_translations` VALUES("1392", "hr", "sl", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1393", "hr", "so", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1394", "hr", "sq", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1395", "hr", "sr", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1396", "hr", "sv", "Kroatiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1397", "hr", "ta", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1398", "hr", "th", "โครเอเชีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1399", "hr", "tr", "Hırvatça");
INSERT INTO `wp_icl_languages_translations` VALUES("1400", "hr", "uk", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1401", "hr", "ur", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1402", "hr", "uz", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1403", "hr", "vi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1404", "hr", "yi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1405", "hr", "zh-hans", "克罗地亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1406", "hr", "zu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1407", "hr", "zh-hant", "克羅地亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1408", "hr", "ms", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1409", "hu", "en", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1410", "hu", "es", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1411", "hu", "de", "Ungarisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1412", "hu", "fr", "Hongrois");
INSERT INTO `wp_icl_languages_translations` VALUES("1413", "hu", "ar", "الهنغارية");
INSERT INTO `wp_icl_languages_translations` VALUES("1414", "hu", "bs", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1415", "hu", "bg", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1416", "hu", "ca", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1417", "hu", "cs", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1418", "hu", "sk", "Maďarčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1419", "hu", "cy", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1420", "hu", "da", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1421", "hu", "el", "Ουγγρικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1422", "hu", "eo", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1423", "hu", "et", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1424", "hu", "eu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1425", "hu", "fa", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1426", "hu", "fi", "unkari");
INSERT INTO `wp_icl_languages_translations` VALUES("1427", "hu", "ga", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1428", "hu", "he", "הונגרית");
INSERT INTO `wp_icl_languages_translations` VALUES("1429", "hu", "hi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1430", "hu", "hr", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1431", "hu", "hu", "Magyar");
INSERT INTO `wp_icl_languages_translations` VALUES("1432", "hu", "hy", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1433", "hu", "id", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1434", "hu", "is", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1435", "hu", "it", "Ungherese");
INSERT INTO `wp_icl_languages_translations` VALUES("1436", "hu", "ja", "ハンガリー語");
INSERT INTO `wp_icl_languages_translations` VALUES("1437", "hu", "ko", "헝가리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1438", "hu", "ku", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1439", "hu", "la", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1440", "hu", "lv", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1441", "hu", "lt", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1442", "hu", "mk", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1443", "hu", "mt", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1444", "hu", "mo", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1445", "hu", "mn", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1446", "hu", "ne", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1447", "hu", "nl", "Hongaars");
INSERT INTO `wp_icl_languages_translations` VALUES("1448", "hu", "nb", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1449", "hu", "pa", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1450", "hu", "pl", "węgierski");
INSERT INTO `wp_icl_languages_translations` VALUES("1451", "hu", "pt-pt", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1452", "hu", "pt-br", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1453", "hu", "qu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1454", "hu", "ro", "Ungară");
INSERT INTO `wp_icl_languages_translations` VALUES("1455", "hu", "ru", "Венгерский");
INSERT INTO `wp_icl_languages_translations` VALUES("1456", "hu", "sl", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1457", "hu", "so", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1458", "hu", "sq", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1459", "hu", "sr", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1460", "hu", "sv", "Ungerska");
INSERT INTO `wp_icl_languages_translations` VALUES("1461", "hu", "ta", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1462", "hu", "th", "ฮังการี");
INSERT INTO `wp_icl_languages_translations` VALUES("1463", "hu", "tr", "Macarca");
INSERT INTO `wp_icl_languages_translations` VALUES("1464", "hu", "uk", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1465", "hu", "ur", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1466", "hu", "uz", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1467", "hu", "vi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1468", "hu", "yi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1469", "hu", "zh-hans", "匈牙利语");
INSERT INTO `wp_icl_languages_translations` VALUES("1470", "hu", "zu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1471", "hu", "zh-hant", "匈牙利語");
INSERT INTO `wp_icl_languages_translations` VALUES("1472", "hu", "ms", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1473", "hy", "en", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1474", "hy", "es", "Armenio");
INSERT INTO `wp_icl_languages_translations` VALUES("1475", "hy", "de", "Armenisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1476", "hy", "fr", "Arménien");
INSERT INTO `wp_icl_languages_translations` VALUES("1477", "hy", "ar", "الأرمينية");
INSERT INTO `wp_icl_languages_translations` VALUES("1478", "hy", "bs", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1479", "hy", "bg", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1480", "hy", "ca", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1481", "hy", "cs", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1482", "hy", "sk", "Arménčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1483", "hy", "cy", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1484", "hy", "da", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1485", "hy", "el", "Αρμενικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1486", "hy", "eo", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1487", "hy", "et", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1488", "hy", "eu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1489", "hy", "fa", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1490", "hy", "fi", "armenia");
INSERT INTO `wp_icl_languages_translations` VALUES("1491", "hy", "ga", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1492", "hy", "he", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1493", "hy", "hi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1494", "hy", "hr", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1495", "hy", "hu", "örmény");
INSERT INTO `wp_icl_languages_translations` VALUES("1496", "hy", "hy", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1497", "hy", "id", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1498", "hy", "is", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1499", "hy", "it", "Armeno");
INSERT INTO `wp_icl_languages_translations` VALUES("1500", "hy", "ja", "アルメニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1501", "hy", "ko", "아르메니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1502", "hy", "ku", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1503", "hy", "la", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1504", "hy", "lv", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1505", "hy", "lt", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1506", "hy", "mk", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1507", "hy", "mt", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1508", "hy", "mo", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1509", "hy", "mn", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1510", "hy", "ne", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1511", "hy", "nl", "Armeens");
INSERT INTO `wp_icl_languages_translations` VALUES("1512", "hy", "nb", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1513", "hy", "pa", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1514", "hy", "pl", "ormiański");
INSERT INTO `wp_icl_languages_translations` VALUES("1515", "hy", "pt-pt", "Arménio");
INSERT INTO `wp_icl_languages_translations` VALUES("1516", "hy", "pt-br", "Arménio");
INSERT INTO `wp_icl_languages_translations` VALUES("1517", "hy", "qu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1518", "hy", "ro", "Armeană");
INSERT INTO `wp_icl_languages_translations` VALUES("1519", "hy", "ru", "Армянский");
INSERT INTO `wp_icl_languages_translations` VALUES("1520", "hy", "sl", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1521", "hy", "so", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1522", "hy", "sq", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1523", "hy", "sr", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1524", "hy", "sv", "Armeniska");
INSERT INTO `wp_icl_languages_translations` VALUES("1525", "hy", "ta", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1526", "hy", "th", "อาร์เมเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1527", "hy", "tr", "Ermenice");
INSERT INTO `wp_icl_languages_translations` VALUES("1528", "hy", "uk", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1529", "hy", "ur", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1530", "hy", "uz", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1531", "hy", "vi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1532", "hy", "yi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1533", "hy", "zh-hans", "亚美尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1534", "hy", "zu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1535", "hy", "zh-hant", "亞美尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1536", "hy", "ms", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1537", "id", "en", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1538", "id", "es", "Indonesio");
INSERT INTO `wp_icl_languages_translations` VALUES("1539", "id", "de", "Indonesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1540", "id", "fr", "Indonésien");
INSERT INTO `wp_icl_languages_translations` VALUES("1541", "id", "ar", "الأندونيسية");
INSERT INTO `wp_icl_languages_translations` VALUES("1542", "id", "bs", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1543", "id", "bg", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1544", "id", "ca", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1545", "id", "cs", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1546", "id", "sk", "Indonézčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1547", "id", "cy", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1548", "id", "da", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1549", "id", "el", "Ινδονησιακα");
INSERT INTO `wp_icl_languages_translations` VALUES("1550", "id", "eo", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1551", "id", "et", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1552", "id", "eu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1553", "id", "fa", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1554", "id", "fi", "indonesia");
INSERT INTO `wp_icl_languages_translations` VALUES("1555", "id", "ga", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1556", "id", "he", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1557", "id", "hi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1558", "id", "hr", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1559", "id", "hu", "indonéz");
INSERT INTO `wp_icl_languages_translations` VALUES("1560", "id", "hy", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1561", "id", "id", "Indonesia");
INSERT INTO `wp_icl_languages_translations` VALUES("1562", "id", "is", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1563", "id", "it", "Indonesiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1564", "id", "ja", "インドネシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1565", "id", "ko", "인도네시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1566", "id", "ku", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1567", "id", "la", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1568", "id", "lv", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1569", "id", "lt", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1570", "id", "mk", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1571", "id", "mt", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1572", "id", "mo", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1573", "id", "mn", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1574", "id", "ne", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1575", "id", "nl", "Indonesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1576", "id", "nb", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1577", "id", "pa", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1578", "id", "pl", "indonezyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("1579", "id", "pt-pt", "Indonésio");
INSERT INTO `wp_icl_languages_translations` VALUES("1580", "id", "pt-br", "Indonésio");
INSERT INTO `wp_icl_languages_translations` VALUES("1581", "id", "qu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1582", "id", "ro", "Indoneziană");
INSERT INTO `wp_icl_languages_translations` VALUES("1583", "id", "ru", "Индонезийский");
INSERT INTO `wp_icl_languages_translations` VALUES("1584", "id", "sl", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1585", "id", "so", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1586", "id", "sq", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1587", "id", "sr", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1588", "id", "sv", "Indonesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1589", "id", "ta", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1590", "id", "th", "อินโดนีเซีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1591", "id", "tr", "Endonezya dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1592", "id", "uk", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1593", "id", "ur", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1594", "id", "uz", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1595", "id", "vi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1596", "id", "yi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1597", "id", "zh-hans", "印度尼西亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1598", "id", "zu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1599", "id", "zh-hant", "印尼語");
INSERT INTO `wp_icl_languages_translations` VALUES("1600", "id", "ms", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1601", "is", "en", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1602", "is", "es", "Islandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1603", "is", "de", "Isländisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1604", "is", "fr", "Islandais");
INSERT INTO `wp_icl_languages_translations` VALUES("1605", "is", "ar", "الأيسلاندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1606", "is", "bs", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1607", "is", "bg", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1608", "is", "ca", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1609", "is", "cs", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1610", "is", "sk", "Islančina");
INSERT INTO `wp_icl_languages_translations` VALUES("1611", "is", "cy", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1612", "is", "da", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1613", "is", "el", "Ισλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1614", "is", "eo", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1615", "is", "et", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1616", "is", "eu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1617", "is", "fa", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1618", "is", "fi", "islanti");
INSERT INTO `wp_icl_languages_translations` VALUES("1619", "is", "ga", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1620", "is", "he", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1621", "is", "hi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1622", "is", "hr", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1623", "is", "hu", "izlandi");
INSERT INTO `wp_icl_languages_translations` VALUES("1624", "is", "hy", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1625", "is", "id", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1626", "is", "is", "Íslenska");
INSERT INTO `wp_icl_languages_translations` VALUES("1627", "is", "it", "Islandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1628", "is", "ja", "アイスランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1629", "is", "ko", "아이슬랜드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1630", "is", "ku", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1631", "is", "la", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1632", "is", "lv", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1633", "is", "lt", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1634", "is", "mk", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1635", "is", "mt", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1636", "is", "mo", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1637", "is", "mn", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1638", "is", "ne", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1639", "is", "nl", "Ijslands");
INSERT INTO `wp_icl_languages_translations` VALUES("1640", "is", "nb", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1641", "is", "pa", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1642", "is", "pl", "islandzki");
INSERT INTO `wp_icl_languages_translations` VALUES("1643", "is", "pt-pt", "Islandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1644", "is", "pt-br", "Islandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1645", "is", "qu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1646", "is", "ro", "Islandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1647", "is", "ru", "Исландский");
INSERT INTO `wp_icl_languages_translations` VALUES("1648", "is", "sl", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1649", "is", "so", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1650", "is", "sq", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1651", "is", "sr", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1652", "is", "sv", "Isländska");
INSERT INTO `wp_icl_languages_translations` VALUES("1653", "is", "ta", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1654", "is", "th", "ไอซ์แลนด์");
INSERT INTO `wp_icl_languages_translations` VALUES("1655", "is", "tr", "İzlandaca");
INSERT INTO `wp_icl_languages_translations` VALUES("1656", "is", "uk", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1657", "is", "ur", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1658", "is", "uz", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1659", "is", "vi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1660", "is", "yi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1661", "is", "zh-hans", "冰岛语");
INSERT INTO `wp_icl_languages_translations` VALUES("1662", "is", "zu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1663", "is", "zh-hant", "冰島語");
INSERT INTO `wp_icl_languages_translations` VALUES("1664", "is", "ms", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1665", "it", "en", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1666", "it", "es", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1667", "it", "de", "Italienisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1668", "it", "fr", "Italien");
INSERT INTO `wp_icl_languages_translations` VALUES("1669", "it", "ar", "الإيطالية");
INSERT INTO `wp_icl_languages_translations` VALUES("1670", "it", "bs", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1671", "it", "bg", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1672", "it", "ca", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1673", "it", "cs", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1674", "it", "sk", "Taliančina");
INSERT INTO `wp_icl_languages_translations` VALUES("1675", "it", "cy", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1676", "it", "da", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1677", "it", "el", "Ιταλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1678", "it", "eo", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1679", "it", "et", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1680", "it", "eu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1681", "it", "fa", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1682", "it", "fi", "italia");
INSERT INTO `wp_icl_languages_translations` VALUES("1683", "it", "ga", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1684", "it", "he", "איטלקית");
INSERT INTO `wp_icl_languages_translations` VALUES("1685", "it", "hi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1686", "it", "hr", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1687", "it", "hu", "olasz");
INSERT INTO `wp_icl_languages_translations` VALUES("1688", "it", "hy", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1689", "it", "id", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1690", "it", "is", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1691", "it", "it", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1692", "it", "ja", "イタリア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1693", "it", "ko", "이태리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1694", "it", "ku", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1695", "it", "la", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1696", "it", "lv", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1697", "it", "lt", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1698", "it", "mk", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1699", "it", "mt", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1700", "it", "mo", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1701", "it", "mn", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1702", "it", "ne", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1703", "it", "nl", "Italiaans");
INSERT INTO `wp_icl_languages_translations` VALUES("1704", "it", "nb", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1705", "it", "pa", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1706", "it", "pl", "włoski");
INSERT INTO `wp_icl_languages_translations` VALUES("1707", "it", "pt-pt", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1708", "it", "pt-br", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1709", "it", "qu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1710", "it", "ro", "Italiană");
INSERT INTO `wp_icl_languages_translations` VALUES("1711", "it", "ru", "Итальянский");
INSERT INTO `wp_icl_languages_translations` VALUES("1712", "it", "sl", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1713", "it", "so", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1714", "it", "sq", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1715", "it", "sr", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1716", "it", "sv", "Italienska");
INSERT INTO `wp_icl_languages_translations` VALUES("1717", "it", "ta", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1718", "it", "th", "อิตาลี");
INSERT INTO `wp_icl_languages_translations` VALUES("1719", "it", "tr", "İtalyanca");
INSERT INTO `wp_icl_languages_translations` VALUES("1720", "it", "uk", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1721", "it", "ur", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1722", "it", "uz", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1723", "it", "vi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1724", "it", "yi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1725", "it", "zh-hans", "意大利语");
INSERT INTO `wp_icl_languages_translations` VALUES("1726", "it", "zu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1727", "it", "zh-hant", "義大利語");
INSERT INTO `wp_icl_languages_translations` VALUES("1728", "it", "ms", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1729", "ja", "en", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1730", "ja", "es", "Japonés");
INSERT INTO `wp_icl_languages_translations` VALUES("1731", "ja", "de", "Japanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1732", "ja", "fr", "Japonais");
INSERT INTO `wp_icl_languages_translations` VALUES("1733", "ja", "ar", "اليابانية");
INSERT INTO `wp_icl_languages_translations` VALUES("1734", "ja", "bs", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1735", "ja", "bg", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1736", "ja", "ca", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1737", "ja", "cs", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1738", "ja", "sk", "Japonština");
INSERT INTO `wp_icl_languages_translations` VALUES("1739", "ja", "cy", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1740", "ja", "da", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1741", "ja", "el", "Ιαπωνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1742", "ja", "eo", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1743", "ja", "et", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1744", "ja", "eu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1745", "ja", "fa", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1746", "ja", "fi", "japani");
INSERT INTO `wp_icl_languages_translations` VALUES("1747", "ja", "ga", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1748", "ja", "he", "יפנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1749", "ja", "hi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1750", "ja", "hr", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1751", "ja", "hu", "japán");
INSERT INTO `wp_icl_languages_translations` VALUES("1752", "ja", "hy", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1753", "ja", "id", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1754", "ja", "is", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1755", "ja", "it", "Giapponese");
INSERT INTO `wp_icl_languages_translations` VALUES("1756", "ja", "ja", "日本語");
INSERT INTO `wp_icl_languages_translations` VALUES("1757", "ja", "ko", "일어");
INSERT INTO `wp_icl_languages_translations` VALUES("1758", "ja", "ku", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1759", "ja", "la", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1760", "ja", "lv", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1761", "ja", "lt", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1762", "ja", "mk", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1763", "ja", "mt", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1764", "ja", "mo", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1765", "ja", "mn", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1766", "ja", "ne", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1767", "ja", "nl", "Japans");
INSERT INTO `wp_icl_languages_translations` VALUES("1768", "ja", "nb", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1769", "ja", "pa", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1770", "ja", "pl", "japoński");
INSERT INTO `wp_icl_languages_translations` VALUES("1771", "ja", "pt-pt", "Japonês");
INSERT INTO `wp_icl_languages_translations` VALUES("1772", "ja", "pt-br", "Japonês");
INSERT INTO `wp_icl_languages_translations` VALUES("1773", "ja", "qu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1774", "ja", "ro", "Japoneză");
INSERT INTO `wp_icl_languages_translations` VALUES("1775", "ja", "ru", "Японский");
INSERT INTO `wp_icl_languages_translations` VALUES("1776", "ja", "sl", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1777", "ja", "so", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1778", "ja", "sq", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1779", "ja", "sr", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1780", "ja", "sv", "Japanska");
INSERT INTO `wp_icl_languages_translations` VALUES("1781", "ja", "ta", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1782", "ja", "th", "ญี่ปุ่น");
INSERT INTO `wp_icl_languages_translations` VALUES("1783", "ja", "tr", "Japonca");
INSERT INTO `wp_icl_languages_translations` VALUES("1784", "ja", "uk", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1785", "ja", "ur", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1786", "ja", "uz", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1787", "ja", "vi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1788", "ja", "yi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1789", "ja", "zh-hans", "日语");
INSERT INTO `wp_icl_languages_translations` VALUES("1790", "ja", "zu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1791", "ja", "zh-hant", "日語");
INSERT INTO `wp_icl_languages_translations` VALUES("1792", "ja", "ms", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1793", "ko", "en", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1794", "ko", "es", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1795", "ko", "de", "Koreanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1796", "ko", "fr", "Coréen");
INSERT INTO `wp_icl_languages_translations` VALUES("1797", "ko", "ar", "الكورية");
INSERT INTO `wp_icl_languages_translations` VALUES("1798", "ko", "bs", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1799", "ko", "bg", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1800", "ko", "ca", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1801", "ko", "cs", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1802", "ko", "sk", "Kórejčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1803", "ko", "cy", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1804", "ko", "da", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1805", "ko", "el", "Κορεατικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1806", "ko", "eo", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1807", "ko", "et", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1808", "ko", "eu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1809", "ko", "fa", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1810", "ko", "fi", "korea");
INSERT INTO `wp_icl_languages_translations` VALUES("1811", "ko", "ga", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1812", "ko", "he", "קוראנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1813", "ko", "hi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1814", "ko", "hr", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1815", "ko", "hu", "koreai");
INSERT INTO `wp_icl_languages_translations` VALUES("1816", "ko", "hy", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1817", "ko", "id", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1818", "ko", "is", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1819", "ko", "it", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1820", "ko", "ja", "韓国語");
INSERT INTO `wp_icl_languages_translations` VALUES("1821", "ko", "ko", "한국어");
INSERT INTO `wp_icl_languages_translations` VALUES("1822", "ko", "ku", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1823", "ko", "la", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1824", "ko", "lv", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1825", "ko", "lt", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1826", "ko", "mk", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1827", "ko", "mt", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1828", "ko", "mo", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1829", "ko", "mn", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1830", "ko", "ne", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1831", "ko", "nl", "Koreaans");
INSERT INTO `wp_icl_languages_translations` VALUES("1832", "ko", "nb", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1833", "ko", "pa", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1834", "ko", "pl", "koreański");
INSERT INTO `wp_icl_languages_translations` VALUES("1835", "ko", "pt-pt", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1836", "ko", "pt-br", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1837", "ko", "qu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1838", "ko", "ro", "Coreană");
INSERT INTO `wp_icl_languages_translations` VALUES("1839", "ko", "ru", "Корейский");
INSERT INTO `wp_icl_languages_translations` VALUES("1840", "ko", "sl", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1841", "ko", "so", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1842", "ko", "sq", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1843", "ko", "sr", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1844", "ko", "sv", "Koreanska");
INSERT INTO `wp_icl_languages_translations` VALUES("1845", "ko", "ta", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1846", "ko", "th", "เกาหลี");
INSERT INTO `wp_icl_languages_translations` VALUES("1847", "ko", "tr", "Kore dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1848", "ko", "uk", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1849", "ko", "ur", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1850", "ko", "uz", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1851", "ko", "vi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1852", "ko", "yi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1853", "ko", "zh-hans", "韩语");
INSERT INTO `wp_icl_languages_translations` VALUES("1854", "ko", "zu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1855", "ko", "zh-hant", "韓語");
INSERT INTO `wp_icl_languages_translations` VALUES("1856", "ko", "ms", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1857", "ku", "en", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1858", "ku", "es", "Kurdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1859", "ku", "de", "Kurdisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1860", "ku", "fr", "Kurde");
INSERT INTO `wp_icl_languages_translations` VALUES("1861", "ku", "ar", "الكردية");
INSERT INTO `wp_icl_languages_translations` VALUES("1862", "ku", "bs", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1863", "ku", "bg", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1864", "ku", "ca", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1865", "ku", "cs", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1866", "ku", "sk", "Kurdština");
INSERT INTO `wp_icl_languages_translations` VALUES("1867", "ku", "cy", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1868", "ku", "da", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1869", "ku", "el", "Κουρδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1870", "ku", "eo", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1871", "ku", "et", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1872", "ku", "eu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1873", "ku", "fa", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1874", "ku", "fi", "kurdi");
INSERT INTO `wp_icl_languages_translations` VALUES("1875", "ku", "ga", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1876", "ku", "he", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1877", "ku", "hi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1878", "ku", "hr", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1879", "ku", "hu", "kurd");
INSERT INTO `wp_icl_languages_translations` VALUES("1880", "ku", "hy", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1881", "ku", "id", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1882", "ku", "is", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1883", "ku", "it", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1884", "ku", "ja", "クルド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1885", "ku", "ko", "쿠르드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1886", "ku", "ku", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1887", "ku", "la", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1888", "ku", "lv", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1889", "ku", "lt", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1890", "ku", "mk", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1891", "ku", "mt", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1892", "ku", "mo", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1893", "ku", "mn", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1894", "ku", "ne", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1895", "ku", "nl", "Koerdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1896", "ku", "nb", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1897", "ku", "pa", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1898", "ku", "pl", "kurdyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("1899", "ku", "pt-pt", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1900", "ku", "pt-br", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1901", "ku", "qu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1902", "ku", "ro", "Kurdă");
INSERT INTO `wp_icl_languages_translations` VALUES("1903", "ku", "ru", "Курдский");
INSERT INTO `wp_icl_languages_translations` VALUES("1904", "ku", "sl", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1905", "ku", "so", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1906", "ku", "sq", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1907", "ku", "sr", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1908", "ku", "sv", "Kurdiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1909", "ku", "ta", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1910", "ku", "th", "เคอร์ดิช");
INSERT INTO `wp_icl_languages_translations` VALUES("1911", "ku", "tr", "Kürtçe");
INSERT INTO `wp_icl_languages_translations` VALUES("1912", "ku", "uk", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1913", "ku", "ur", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1914", "ku", "uz", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1915", "ku", "vi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1916", "ku", "yi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1917", "ku", "zh-hans", "库尔德语");
INSERT INTO `wp_icl_languages_translations` VALUES("1918", "ku", "zu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1919", "ku", "zh-hant", "庫爾德語");
INSERT INTO `wp_icl_languages_translations` VALUES("1920", "ku", "ms", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1921", "la", "en", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1922", "la", "es", "Latín");
INSERT INTO `wp_icl_languages_translations` VALUES("1923", "la", "de", "Latein");
INSERT INTO `wp_icl_languages_translations` VALUES("1924", "la", "fr", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1925", "la", "ar", "اللاتينية");
INSERT INTO `wp_icl_languages_translations` VALUES("1926", "la", "bs", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1927", "la", "bg", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1928", "la", "ca", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1929", "la", "cs", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1930", "la", "sk", "Latinčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1931", "la", "cy", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1932", "la", "da", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1933", "la", "el", "Λατινικη");
INSERT INTO `wp_icl_languages_translations` VALUES("1934", "la", "eo", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1935", "la", "et", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1936", "la", "eu", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1937", "la", "fa", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1938", "la", "fi", "latina");
INSERT INTO `wp_icl_languages_translations` VALUES("1939", "la", "ga", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1940", "la", "he", "לטינית");
INSERT INTO `wp_icl_languages_translations` VALUES("1941", "la", "hi", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1942", "la", "hr", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1943", "la", "hu", "latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1944", "la", "hy", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1945", "la", "id", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1946", "la", "is", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1947", "la", "it", "Latino");
INSERT INTO `wp_icl_languages_translations` VALUES("1948", "la", "ja", "ラテン語");
INSERT INTO `wp_icl_languages_translations` VALUES("1949", "la", "ko", "라틴어");
INSERT INTO `wp_icl_languages_translations` VALUES("1950", "la", "ku", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1951", "la", "la", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1952", "la", "lv", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1953", "la", "lt", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1954", "la", "mk", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1955", "la", "mt", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1956", "la", "mo", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1957", "la", "mn", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1958", "la", "ne", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1959", "la", "nl", "Latijn");
INSERT INTO `wp_icl_languages_translations` VALUES("1960", "la", "nb", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1961", "la", "pa", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1962", "la", "pl", "łaciński");
INSERT INTO `wp_icl_languages_translations` VALUES("1963", "la", "pt-pt", "Latina");
INSERT INTO `wp_icl_languages_translations` VALUES("1964", "la", "pt-br", "Latina");
INSERT INTO `wp_icl_languages_translations` VALUES("1965", "la", "qu", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1966", "la", "ro", "Latină");
INSERT INTO `wp_icl_languages_translations` VALUES("1967", "la", "ru", "Латинский");
INSERT INTO `wp_icl_languages_translations` VALUES("1968", "la", "sl", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1969", "la", "so", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1970", "la", "sq", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1971", "la", "sr", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1972", "la", "sv", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1973", "la", "ta", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1974", "la", "th", "ละติน");
INSERT INTO `wp_icl_languages_translations` VALUES("1975", "la", "tr", "Latince");
INSERT INTO `wp_icl_languages_translations` VALUES("1976", "la", "uk", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1977", "la", "ur", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1978", "la", "uz", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1979", "la", "vi", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1980", "la", "yi", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1981", "la", "zh-hans", "拉丁语");
INSERT INTO `wp_icl_languages_translations` VALUES("1982", "la", "zu", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1983", "la", "zh-hant", "拉丁語");
INSERT INTO `wp_icl_languages_translations` VALUES("1984", "la", "ms", "Latin");
INSERT INTO `wp_icl_languages_translations` VALUES("1985", "lv", "en", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1986", "lv", "es", "Letón");
INSERT INTO `wp_icl_languages_translations` VALUES("1987", "lv", "de", "Lettisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1988", "lv", "fr", "Letton");
INSERT INTO `wp_icl_languages_translations` VALUES("1989", "lv", "ar", "اللاتفية");
INSERT INTO `wp_icl_languages_translations` VALUES("1990", "lv", "bs", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1991", "lv", "bg", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1992", "lv", "ca", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1993", "lv", "cs", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1994", "lv", "sk", "Lotyština");
INSERT INTO `wp_icl_languages_translations` VALUES("1995", "lv", "cy", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1996", "lv", "da", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1997", "lv", "el", "Λετονικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1998", "lv", "eo", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1999", "lv", "et", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2000", "lv", "eu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2001", "lv", "fa", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2002", "lv", "fi", "latvia");
INSERT INTO `wp_icl_languages_translations` VALUES("2003", "lv", "ga", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2004", "lv", "he", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2005", "lv", "hi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2006", "lv", "hr", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2007", "lv", "hu", "lett");
INSERT INTO `wp_icl_languages_translations` VALUES("2008", "lv", "hy", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2009", "lv", "id", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2010", "lv", "is", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2011", "lv", "it", "Lettone");
INSERT INTO `wp_icl_languages_translations` VALUES("2012", "lv", "ja", "ラトビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2013", "lv", "ko", "라트비아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2014", "lv", "ku", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2015", "lv", "la", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2016", "lv", "lv", "Latviešu");
INSERT INTO `wp_icl_languages_translations` VALUES("2017", "lv", "lt", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2018", "lv", "mk", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2019", "lv", "mt", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2020", "lv", "mo", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2021", "lv", "mn", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2022", "lv", "ne", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2023", "lv", "nl", "Lets");
INSERT INTO `wp_icl_languages_translations` VALUES("2024", "lv", "nb", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2025", "lv", "pa", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2026", "lv", "pl", "łotewski");
INSERT INTO `wp_icl_languages_translations` VALUES("2027", "lv", "pt-pt", "Letão");
INSERT INTO `wp_icl_languages_translations` VALUES("2028", "lv", "pt-br", "Letão");
INSERT INTO `wp_icl_languages_translations` VALUES("2029", "lv", "qu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2030", "lv", "ro", "Letoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("2031", "lv", "ru", "латышский");
INSERT INTO `wp_icl_languages_translations` VALUES("2032", "lv", "sl", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2033", "lv", "so", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2034", "lv", "sq", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2035", "lv", "sr", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2036", "lv", "sv", "Lettiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2037", "lv", "ta", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2038", "lv", "th", "ลัตเวีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2039", "lv", "tr", "Letonca");
INSERT INTO `wp_icl_languages_translations` VALUES("2040", "lv", "uk", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2041", "lv", "ur", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2042", "lv", "uz", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2043", "lv", "vi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2044", "lv", "yi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2045", "lv", "zh-hans", "拉脱维亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2046", "lv", "zu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2047", "lv", "zh-hant", "拉脫維亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2048", "lv", "ms", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("2049", "lt", "en", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2050", "lt", "es", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2051", "lt", "de", "Litauisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2052", "lt", "fr", "Lituanien");
INSERT INTO `wp_icl_languages_translations` VALUES("2053", "lt", "ar", "اللتوانية");
INSERT INTO `wp_icl_languages_translations` VALUES("2054", "lt", "bs", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2055", "lt", "bg", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2056", "lt", "ca", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2057", "lt", "cs", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2058", "lt", "sk", "Litovčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2059", "lt", "cy", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2060", "lt", "da", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2061", "lt", "el", "Λιθουανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2062", "lt", "eo", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2063", "lt", "et", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2064", "lt", "eu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2065", "lt", "fa", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2066", "lt", "fi", "liettua");
INSERT INTO `wp_icl_languages_translations` VALUES("2067", "lt", "ga", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2068", "lt", "he", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2069", "lt", "hi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2070", "lt", "hr", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2071", "lt", "hu", "litván");
INSERT INTO `wp_icl_languages_translations` VALUES("2072", "lt", "hy", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2073", "lt", "id", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2074", "lt", "is", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2075", "lt", "it", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2076", "lt", "ja", "リトアニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2077", "lt", "ko", "리투아니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2078", "lt", "ku", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2079", "lt", "la", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2080", "lt", "lv", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2081", "lt", "lt", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2082", "lt", "mk", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2083", "lt", "mt", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2084", "lt", "mo", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2085", "lt", "mn", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2086", "lt", "ne", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2087", "lt", "nl", "Litouws");
INSERT INTO `wp_icl_languages_translations` VALUES("2088", "lt", "nb", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2089", "lt", "pa", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2090", "lt", "pl", "litewski");
INSERT INTO `wp_icl_languages_translations` VALUES("2091", "lt", "pt-pt", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2092", "lt", "pt-br", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2093", "lt", "qu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2094", "lt", "ro", "Lituaniană");
INSERT INTO `wp_icl_languages_translations` VALUES("2095", "lt", "ru", "Литовский");
INSERT INTO `wp_icl_languages_translations` VALUES("2096", "lt", "sl", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2097", "lt", "so", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2098", "lt", "sq", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2099", "lt", "sr", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2100", "lt", "sv", "Litauiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2101", "lt", "ta", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2102", "lt", "th", "ลิธัวเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2103", "lt", "tr", "Litvanyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2104", "lt", "uk", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2105", "lt", "ur", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2106", "lt", "uz", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2107", "lt", "vi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2108", "lt", "yi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2109", "lt", "zh-hans", "立陶宛语");
INSERT INTO `wp_icl_languages_translations` VALUES("2110", "lt", "zu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2111", "lt", "zh-hant", "立陶宛語");
INSERT INTO `wp_icl_languages_translations` VALUES("2112", "lt", "ms", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2113", "mk", "en", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2114", "mk", "es", "Macedonio");
INSERT INTO `wp_icl_languages_translations` VALUES("2115", "mk", "de", "Mazedonisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2116", "mk", "fr", "Macédonien");
INSERT INTO `wp_icl_languages_translations` VALUES("2117", "mk", "ar", "المقدونية");
INSERT INTO `wp_icl_languages_translations` VALUES("2118", "mk", "bs", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2119", "mk", "bg", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2120", "mk", "ca", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2121", "mk", "cs", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2122", "mk", "sk", "Macedónština");
INSERT INTO `wp_icl_languages_translations` VALUES("2123", "mk", "cy", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2124", "mk", "da", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2125", "mk", "el", "Μακεδονικο");
INSERT INTO `wp_icl_languages_translations` VALUES("2126", "mk", "eo", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2127", "mk", "et", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2128", "mk", "eu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2129", "mk", "fa", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2130", "mk", "fi", "makedonia");
INSERT INTO `wp_icl_languages_translations` VALUES("2131", "mk", "ga", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2132", "mk", "he", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2133", "mk", "hi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2134", "mk", "hr", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2135", "mk", "hu", "macedón");
INSERT INTO `wp_icl_languages_translations` VALUES("2136", "mk", "hy", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2137", "mk", "id", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2138", "mk", "is", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2139", "mk", "it", "Macedone");
INSERT INTO `wp_icl_languages_translations` VALUES("2140", "mk", "ja", "マケドニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2141", "mk", "ko", "마케도니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2142", "mk", "ku", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2143", "mk", "la", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2144", "mk", "lv", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2145", "mk", "lt", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2146", "mk", "mk", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2147", "mk", "mt", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2148", "mk", "mo", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2149", "mk", "mn", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2150", "mk", "ne", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2151", "mk", "nl", "Macedonisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2152", "mk", "nb", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2153", "mk", "pa", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2154", "mk", "pl", "macedoński");
INSERT INTO `wp_icl_languages_translations` VALUES("2155", "mk", "pt-pt", "Macedônio");
INSERT INTO `wp_icl_languages_translations` VALUES("2156", "mk", "pt-br", "Macedônio");
INSERT INTO `wp_icl_languages_translations` VALUES("2157", "mk", "qu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2158", "mk", "ro", "Macedoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("2159", "mk", "ru", "Македонский");
INSERT INTO `wp_icl_languages_translations` VALUES("2160", "mk", "sl", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2161", "mk", "so", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2162", "mk", "sq", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2163", "mk", "sr", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2164", "mk", "sv", "Makedonska");
INSERT INTO `wp_icl_languages_translations` VALUES("2165", "mk", "ta", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2166", "mk", "th", "มาซิโดเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2167", "mk", "tr", "Makedonyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2168", "mk", "uk", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2169", "mk", "ur", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2170", "mk", "uz", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2171", "mk", "vi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2172", "mk", "yi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2173", "mk", "zh-hans", "马其顿语");
INSERT INTO `wp_icl_languages_translations` VALUES("2174", "mk", "zu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2175", "mk", "zh-hant", "馬其頓語");
INSERT INTO `wp_icl_languages_translations` VALUES("2176", "mk", "ms", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2177", "mt", "en", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2178", "mt", "es", "Maltés");
INSERT INTO `wp_icl_languages_translations` VALUES("2179", "mt", "de", "Maltesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2180", "mt", "fr", "Maltais");
INSERT INTO `wp_icl_languages_translations` VALUES("2181", "mt", "ar", "المالطية");
INSERT INTO `wp_icl_languages_translations` VALUES("2182", "mt", "bs", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2183", "mt", "bg", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2184", "mt", "ca", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2185", "mt", "cs", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2186", "mt", "sk", "Maltézština");
INSERT INTO `wp_icl_languages_translations` VALUES("2187", "mt", "cy", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2188", "mt", "da", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2189", "mt", "el", "Μαλτεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2190", "mt", "eo", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2191", "mt", "et", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2192", "mt", "eu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2193", "mt", "fa", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2194", "mt", "fi", "malta");
INSERT INTO `wp_icl_languages_translations` VALUES("2195", "mt", "ga", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2196", "mt", "he", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2197", "mt", "hi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2198", "mt", "hr", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2199", "mt", "hu", "máltai");
INSERT INTO `wp_icl_languages_translations` VALUES("2200", "mt", "hy", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2201", "mt", "id", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2202", "mt", "is", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2203", "mt", "it", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2204", "mt", "ja", "マルタ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2205", "mt", "ko", "몰타어");
INSERT INTO `wp_icl_languages_translations` VALUES("2206", "mt", "ku", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2207", "mt", "la", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2208", "mt", "lv", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2209", "mt", "lt", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2210", "mt", "mk", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2211", "mt", "mt", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2212", "mt", "mo", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2213", "mt", "mn", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2214", "mt", "ne", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2215", "mt", "nl", "Maltees");
INSERT INTO `wp_icl_languages_translations` VALUES("2216", "mt", "nb", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2217", "mt", "pa", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2218", "mt", "pl", "maltański");
INSERT INTO `wp_icl_languages_translations` VALUES("2219", "mt", "pt-pt", "Maltês");
INSERT INTO `wp_icl_languages_translations` VALUES("2220", "mt", "pt-br", "Maltês");
INSERT INTO `wp_icl_languages_translations` VALUES("2221", "mt", "qu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2222", "mt", "ro", "Malteză");
INSERT INTO `wp_icl_languages_translations` VALUES("2223", "mt", "ru", "Мальтийский");
INSERT INTO `wp_icl_languages_translations` VALUES("2224", "mt", "sl", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2225", "mt", "so", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2226", "mt", "sq", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2227", "mt", "sr", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2228", "mt", "sv", "Maltesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2229", "mt", "ta", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2230", "mt", "th", "มอลทีส");
INSERT INTO `wp_icl_languages_translations` VALUES("2231", "mt", "tr", "Malta dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2232", "mt", "uk", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2233", "mt", "ur", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2234", "mt", "uz", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2235", "mt", "vi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2236", "mt", "yi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2237", "mt", "zh-hans", "马耳他语");
INSERT INTO `wp_icl_languages_translations` VALUES("2238", "mt", "zu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2239", "mt", "zh-hant", "馬爾他語");
INSERT INTO `wp_icl_languages_translations` VALUES("2240", "mt", "ms", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2241", "mo", "en", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2242", "mo", "es", "Moldavo");
INSERT INTO `wp_icl_languages_translations` VALUES("2243", "mo", "de", "Moldavisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2244", "mo", "fr", "Moldave");
INSERT INTO `wp_icl_languages_translations` VALUES("2245", "mo", "ar", "المولدوفية");
INSERT INTO `wp_icl_languages_translations` VALUES("2246", "mo", "bs", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2247", "mo", "bg", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2248", "mo", "ca", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2249", "mo", "cs", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2250", "mo", "sk", "Moldavčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2251", "mo", "cy", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2252", "mo", "da", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2253", "mo", "el", "Μολδαβικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2254", "mo", "eo", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2255", "mo", "et", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2256", "mo", "eu", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2257", "mo", "fa", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2258", "mo", "fi", "moldavia");
INSERT INTO `wp_icl_languages_translations` VALUES("2259", "mo", "ga", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2260", "mo", "he", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2261", "mo", "hi", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2262", "mo", "hr", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2263", "mo", "hu", "moldovai");
INSERT INTO `wp_icl_languages_translations` VALUES("2264", "mo", "hy", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2265", "mo", "id", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2266", "mo", "is", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2267", "mo", "it", "Moldavo");
INSERT INTO `wp_icl_languages_translations` VALUES("2268", "mo", "ja", "モルダビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2269", "mo", "ko", "몰다비아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2270", "mo", "ku", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2271", "mo", "la", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2272", "mo", "lv", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2273", "mo", "lt", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2274", "mo", "mk", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2275", "mo", "mt", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2276", "mo", "mo", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2277", "mo", "mn", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2278", "mo", "ne", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2279", "mo", "nl", "Moldavisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2280", "mo", "nb", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2281", "mo", "pa", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2282", "mo", "pl", "mołdawski");
INSERT INTO `wp_icl_languages_translations` VALUES("2283", "mo", "pt-pt", "Moldavo");
INSERT INTO `wp_icl_languages_translations` VALUES("2284", "mo", "pt-br", "Moldavo");
INSERT INTO `wp_icl_languages_translations` VALUES("2285", "mo", "qu", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2286", "mo", "ro", "Moldoveană");
INSERT INTO `wp_icl_languages_translations` VALUES("2287", "mo", "ru", "Молдавский");
INSERT INTO `wp_icl_languages_translations` VALUES("2288", "mo", "sl", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2289", "mo", "so", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2290", "mo", "sq", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2291", "mo", "sr", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2292", "mo", "sv", "Moldaviska");
INSERT INTO `wp_icl_languages_translations` VALUES("2293", "mo", "ta", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2294", "mo", "th", "มอลดาเวียน");
INSERT INTO `wp_icl_languages_translations` VALUES("2295", "mo", "tr", "Moldovyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2296", "mo", "uk", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2297", "mo", "ur", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2298", "mo", "uz", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2299", "mo", "vi", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2300", "mo", "yi", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2301", "mo", "zh-hans", "摩尔达维亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2302", "mo", "zu", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2303", "mo", "zh-hant", "摩爾達維亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2304", "mo", "ms", "Moldavian");
INSERT INTO `wp_icl_languages_translations` VALUES("2305", "mn", "en", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2306", "mn", "es", "Mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2307", "mn", "de", "Mongolisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2308", "mn", "fr", "Mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2309", "mn", "ar", "المنغولية");
INSERT INTO `wp_icl_languages_translations` VALUES("2310", "mn", "bs", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2311", "mn", "bg", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2312", "mn", "ca", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2313", "mn", "cs", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2314", "mn", "sk", "Mongolština");
INSERT INTO `wp_icl_languages_translations` VALUES("2315", "mn", "cy", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2316", "mn", "da", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2317", "mn", "el", "Μογγολικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2318", "mn", "eo", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2319", "mn", "et", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2320", "mn", "eu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2321", "mn", "fa", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2322", "mn", "fi", "mongoli");
INSERT INTO `wp_icl_languages_translations` VALUES("2323", "mn", "ga", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2324", "mn", "he", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2325", "mn", "hi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2326", "mn", "hr", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2327", "mn", "hu", "mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2328", "mn", "hy", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2329", "mn", "id", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2330", "mn", "is", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2331", "mn", "it", "Mongolo");
INSERT INTO `wp_icl_languages_translations` VALUES("2332", "mn", "ja", "モンゴル語");
INSERT INTO `wp_icl_languages_translations` VALUES("2333", "mn", "ko", "몽골어");
INSERT INTO `wp_icl_languages_translations` VALUES("2334", "mn", "ku", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2335", "mn", "la", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2336", "mn", "lv", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2337", "mn", "lt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2338", "mn", "mk", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2339", "mn", "mt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2340", "mn", "mo", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2341", "mn", "mn", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2342", "mn", "ne", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2343", "mn", "nl", "Mongools");
INSERT INTO `wp_icl_languages_translations` VALUES("2344", "mn", "nb", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2345", "mn", "pa", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2346", "mn", "pl", "mongolski");
INSERT INTO `wp_icl_languages_translations` VALUES("2347", "mn", "pt-pt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2348", "mn", "pt-br", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2349", "mn", "qu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2350", "mn", "ro", "Mongoleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2351", "mn", "ru", "Монгольский");
INSERT INTO `wp_icl_languages_translations` VALUES("2352", "mn", "sl", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2353", "mn", "so", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2354", "mn", "sq", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2355", "mn", "sr", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2356", "mn", "sv", "Mongoliska");
INSERT INTO `wp_icl_languages_translations` VALUES("2357", "mn", "ta", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2358", "mn", "th", "มองโกเลีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2359", "mn", "tr", "Mongolca");
INSERT INTO `wp_icl_languages_translations` VALUES("2360", "mn", "uk", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2361", "mn", "ur", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2362", "mn", "uz", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2363", "mn", "vi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2364", "mn", "yi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2365", "mn", "zh-hans", "蒙古语");
INSERT INTO `wp_icl_languages_translations` VALUES("2366", "mn", "zu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2367", "mn", "zh-hant", "蒙古語");
INSERT INTO `wp_icl_languages_translations` VALUES("2368", "mn", "ms", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2369", "ne", "en", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2370", "ne", "es", "Nepalí");
INSERT INTO `wp_icl_languages_translations` VALUES("2371", "ne", "de", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2372", "ne", "fr", "Népalais");
INSERT INTO `wp_icl_languages_translations` VALUES("2373", "ne", "ar", "النيبالية");
INSERT INTO `wp_icl_languages_translations` VALUES("2374", "ne", "bs", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2375", "ne", "bg", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2376", "ne", "ca", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2377", "ne", "cs", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2378", "ne", "sk", "Nepálčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2379", "ne", "cy", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2380", "ne", "da", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2381", "ne", "el", "Νεπαλι");
INSERT INTO `wp_icl_languages_translations` VALUES("2382", "ne", "eo", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2383", "ne", "et", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2384", "ne", "eu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2385", "ne", "fa", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2386", "ne", "fi", "nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2387", "ne", "ga", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2388", "ne", "he", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2389", "ne", "hi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2390", "ne", "hr", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2391", "ne", "hu", "nepáli");
INSERT INTO `wp_icl_languages_translations` VALUES("2392", "ne", "hy", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2393", "ne", "id", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2394", "ne", "is", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2395", "ne", "it", "Nepalese");
INSERT INTO `wp_icl_languages_translations` VALUES("2396", "ne", "ja", "ネパール語");
INSERT INTO `wp_icl_languages_translations` VALUES("2397", "ne", "ko", "네팔어");
INSERT INTO `wp_icl_languages_translations` VALUES("2398", "ne", "ku", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2399", "ne", "la", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2400", "ne", "lv", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2401", "ne", "lt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2402", "ne", "mk", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2403", "ne", "mt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2404", "ne", "mo", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2405", "ne", "mn", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2406", "ne", "ne", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2407", "ne", "nl", "Nepalees");
INSERT INTO `wp_icl_languages_translations` VALUES("2408", "ne", "nb", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2409", "ne", "pa", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2410", "ne", "pl", "nepalski");
INSERT INTO `wp_icl_languages_translations` VALUES("2411", "ne", "pt-pt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2412", "ne", "pt-br", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2413", "ne", "qu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2414", "ne", "ro", "Nepaleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2415", "ne", "ru", "Непальский");
INSERT INTO `wp_icl_languages_translations` VALUES("2416", "ne", "sl", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2417", "ne", "so", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2418", "ne", "sq", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2419", "ne", "sr", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2420", "ne", "sv", "Nepalesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2421", "ne", "ta", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2422", "ne", "th", "เนปาล");
INSERT INTO `wp_icl_languages_translations` VALUES("2423", "ne", "tr", "Nepal dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2424", "ne", "uk", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2425", "ne", "ur", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2426", "ne", "uz", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2427", "ne", "vi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2428", "ne", "yi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2429", "ne", "zh-hans", "尼泊尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("2430", "ne", "zu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2431", "ne", "zh-hant", "尼泊爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("2432", "ne", "ms", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2433", "nl", "en", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2434", "nl", "es", "Holandés");
INSERT INTO `wp_icl_languages_translations` VALUES("2435", "nl", "de", "Holländisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2436", "nl", "fr", "Néerlandais");
INSERT INTO `wp_icl_languages_translations` VALUES("2437", "nl", "ar", "الهولندية");
INSERT INTO `wp_icl_languages_translations` VALUES("2438", "nl", "bs", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2439", "nl", "bg", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2440", "nl", "ca", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2441", "nl", "cs", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2442", "nl", "sk", "Holandčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2443", "nl", "cy", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2444", "nl", "da", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2445", "nl", "el", "Ολλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2446", "nl", "eo", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2447", "nl", "et", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2448", "nl", "eu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2449", "nl", "fa", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2450", "nl", "fi", "hollanti");
INSERT INTO `wp_icl_languages_translations` VALUES("2451", "nl", "ga", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2452", "nl", "he", "הולנדית");
INSERT INTO `wp_icl_languages_translations` VALUES("2453", "nl", "hi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2454", "nl", "hr", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2455", "nl", "hu", "holland");
INSERT INTO `wp_icl_languages_translations` VALUES("2456", "nl", "hy", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2457", "nl", "id", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2458", "nl", "is", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2459", "nl", "it", "Neerlandese");
INSERT INTO `wp_icl_languages_translations` VALUES("2460", "nl", "ja", "オランダ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2461", "nl", "ko", "화란어");
INSERT INTO `wp_icl_languages_translations` VALUES("2462", "nl", "ku", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2463", "nl", "la", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2464", "nl", "lv", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2465", "nl", "lt", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2466", "nl", "mk", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2467", "nl", "mt", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2468", "nl", "mo", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2469", "nl", "mn", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2470", "nl", "ne", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2471", "nl", "nl", "Nederlands");
INSERT INTO `wp_icl_languages_translations` VALUES("2472", "nl", "nb", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2473", "nl", "pa", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2474", "nl", "pl", "holenderski");
INSERT INTO `wp_icl_languages_translations` VALUES("2475", "nl", "pt-pt", "Holandês");
INSERT INTO `wp_icl_languages_translations` VALUES("2476", "nl", "pt-br", "Holandês");
INSERT INTO `wp_icl_languages_translations` VALUES("2477", "nl", "qu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2478", "nl", "ro", "Olaneză");
INSERT INTO `wp_icl_languages_translations` VALUES("2479", "nl", "ru", "Голландский");
INSERT INTO `wp_icl_languages_translations` VALUES("2480", "nl", "sl", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2481", "nl", "so", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2482", "nl", "sq", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2483", "nl", "sr", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2484", "nl", "sv", "Nederländska");
INSERT INTO `wp_icl_languages_translations` VALUES("2485", "nl", "ta", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2486", "nl", "th", "ดัตช์");
INSERT INTO `wp_icl_languages_translations` VALUES("2487", "nl", "tr", "Hollandaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2488", "nl", "uk", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2489", "nl", "ur", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2490", "nl", "uz", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2491", "nl", "vi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2492", "nl", "yi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2493", "nl", "zh-hans", "荷兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("2494", "nl", "zu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2495", "nl", "zh-hant", "荷蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("2496", "nl", "ms", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2497", "nb", "en", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2498", "nb", "es", "Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2499", "nb", "de", "Norwegisch (Buchsprache)");
INSERT INTO `wp_icl_languages_translations` VALUES("2500", "nb", "fr", "Norvégien Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2501", "nb", "ar", "البوكمالية النرويجية");
INSERT INTO `wp_icl_languages_translations` VALUES("2502", "nb", "bs", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2503", "nb", "bg", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2504", "nb", "ca", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2505", "nb", "cs", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2506", "nb", "sk", "Nórsky jazyk Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2507", "nb", "cy", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2508", "nb", "da", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2509", "nb", "el", "Νορβηγικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2510", "nb", "eo", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2511", "nb", "et", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2512", "nb", "eu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2513", "nb", "fa", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2514", "nb", "fi", "kirjanorja");
INSERT INTO `wp_icl_languages_translations` VALUES("2515", "nb", "ga", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2516", "nb", "he", "נורווגית");
INSERT INTO `wp_icl_languages_translations` VALUES("2517", "nb", "hi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2518", "nb", "hr", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2519", "nb", "hu", "norvég bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2520", "nb", "hy", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2521", "nb", "id", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2522", "nb", "is", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2523", "nb", "it", "Norvegese Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2524", "nb", "ja", "ノルウェー・ブークモール");
INSERT INTO `wp_icl_languages_translations` VALUES("2525", "nb", "ko", "노르웨이 보크말어");
INSERT INTO `wp_icl_languages_translations` VALUES("2526", "nb", "ku", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2527", "nb", "la", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2528", "nb", "lv", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2529", "nb", "lt", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2530", "nb", "mk", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2531", "nb", "mt", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2532", "nb", "mo", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2533", "nb", "mn", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2534", "nb", "ne", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2535", "nb", "nl", "Noors Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2536", "nb", "nb", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2537", "nb", "pa", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2538", "nb", "pl", "norweski bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2539", "nb", "pt-pt", "Norueguês");
INSERT INTO `wp_icl_languages_translations` VALUES("2540", "nb", "pt-br", "Norueguês");
INSERT INTO `wp_icl_languages_translations` VALUES("2541", "nb", "qu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2542", "nb", "ro", "Bokmål (norvegiană)");
INSERT INTO `wp_icl_languages_translations` VALUES("2543", "nb", "ru", "Норвежский букмол");
INSERT INTO `wp_icl_languages_translations` VALUES("2544", "nb", "sl", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2545", "nb", "so", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2546", "nb", "sq", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2547", "nb", "sr", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2548", "nb", "sv", "Norskt Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2549", "nb", "ta", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2550", "nb", "th", "นอร์วิเจียนบอกมาล");
INSERT INTO `wp_icl_languages_translations` VALUES("2551", "nb", "tr", "Bokmal Norveç dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2552", "nb", "uk", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2553", "nb", "ur", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2554", "nb", "uz", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2555", "nb", "vi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2556", "nb", "yi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2557", "nb", "zh-hans", "挪威布克莫尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("2558", "nb", "zu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2559", "nb", "zh-hant", "挪威布克莫爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("2560", "nb", "ms", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2561", "pa", "en", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2562", "pa", "es", "Panyabí");
INSERT INTO `wp_icl_languages_translations` VALUES("2563", "pa", "de", "Pandschabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2564", "pa", "fr", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2565", "pa", "ar", "البنجابية");
INSERT INTO `wp_icl_languages_translations` VALUES("2566", "pa", "bs", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2567", "pa", "bg", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2568", "pa", "ca", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2569", "pa", "cs", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2570", "pa", "sk", "Pandžábčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2571", "pa", "cy", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2572", "pa", "da", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2573", "pa", "el", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2574", "pa", "eo", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2575", "pa", "et", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2576", "pa", "eu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2577", "pa", "fa", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2578", "pa", "fi", "pandzabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2579", "pa", "ga", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2580", "pa", "he", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2581", "pa", "hi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2582", "pa", "hr", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2583", "pa", "hu", "pandzsábi");
INSERT INTO `wp_icl_languages_translations` VALUES("2584", "pa", "hy", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2585", "pa", "id", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2586", "pa", "is", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2587", "pa", "it", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2588", "pa", "ja", "パンジャーブ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2589", "pa", "ko", "펀자브어");
INSERT INTO `wp_icl_languages_translations` VALUES("2590", "pa", "ku", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2591", "pa", "la", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2592", "pa", "lv", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2593", "pa", "lt", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2594", "pa", "mk", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2595", "pa", "mt", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2596", "pa", "mo", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2597", "pa", "mn", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2598", "pa", "ne", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2599", "pa", "nl", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2600", "pa", "nb", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2601", "pa", "pa", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2602", "pa", "pl", "pendżabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2603", "pa", "pt-pt", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2604", "pa", "pt-br", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2605", "pa", "qu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2606", "pa", "ro", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2607", "pa", "ru", "Панджаби");
INSERT INTO `wp_icl_languages_translations` VALUES("2608", "pa", "sl", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2609", "pa", "so", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2610", "pa", "sq", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2611", "pa", "sr", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2612", "pa", "sv", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2613", "pa", "ta", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2614", "pa", "th", "ปัญจาบ");
INSERT INTO `wp_icl_languages_translations` VALUES("2615", "pa", "tr", "Pencapça");
INSERT INTO `wp_icl_languages_translations` VALUES("2616", "pa", "uk", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2617", "pa", "ur", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2618", "pa", "uz", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2619", "pa", "vi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2620", "pa", "yi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2621", "pa", "zh-hans", "旁遮普语");
INSERT INTO `wp_icl_languages_translations` VALUES("2622", "pa", "zu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2623", "pa", "zh-hant", "旁遮普語");
INSERT INTO `wp_icl_languages_translations` VALUES("2624", "pa", "ms", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2625", "pl", "en", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2626", "pl", "es", "Polaco");
INSERT INTO `wp_icl_languages_translations` VALUES("2627", "pl", "de", "Polnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2628", "pl", "fr", "Polonais");
INSERT INTO `wp_icl_languages_translations` VALUES("2629", "pl", "ar", "البولندية");
INSERT INTO `wp_icl_languages_translations` VALUES("2630", "pl", "bs", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2631", "pl", "bg", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2632", "pl", "ca", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2633", "pl", "cs", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2634", "pl", "sk", "Polština");
INSERT INTO `wp_icl_languages_translations` VALUES("2635", "pl", "cy", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2636", "pl", "da", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2637", "pl", "el", "Πολωνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2638", "pl", "eo", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2639", "pl", "et", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2640", "pl", "eu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2641", "pl", "fa", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2642", "pl", "fi", "puola");
INSERT INTO `wp_icl_languages_translations` VALUES("2643", "pl", "ga", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2644", "pl", "he", "פולנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2645", "pl", "hi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2646", "pl", "hr", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2647", "pl", "hu", "lengyel");
INSERT INTO `wp_icl_languages_translations` VALUES("2648", "pl", "hy", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2649", "pl", "id", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2650", "pl", "is", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2651", "pl", "it", "Polacco");
INSERT INTO `wp_icl_languages_translations` VALUES("2652", "pl", "ja", "ポーランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("2653", "pl", "ko", "폴란드어");
INSERT INTO `wp_icl_languages_translations` VALUES("2654", "pl", "ku", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2655", "pl", "la", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2656", "pl", "lv", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2657", "pl", "lt", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2658", "pl", "mk", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2659", "pl", "mt", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2660", "pl", "mo", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2661", "pl", "mn", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2662", "pl", "ne", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2663", "pl", "nl", "Pools");
INSERT INTO `wp_icl_languages_translations` VALUES("2664", "pl", "nb", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2665", "pl", "pa", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2666", "pl", "pl", "polski");
INSERT INTO `wp_icl_languages_translations` VALUES("2667", "pl", "pt-pt", "Polonês");
INSERT INTO `wp_icl_languages_translations` VALUES("2668", "pl", "pt-br", "Polonês");
INSERT INTO `wp_icl_languages_translations` VALUES("2669", "pl", "qu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2670", "pl", "ro", "Poloneză");
INSERT INTO `wp_icl_languages_translations` VALUES("2671", "pl", "ru", "Польский");
INSERT INTO `wp_icl_languages_translations` VALUES("2672", "pl", "sl", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2673", "pl", "so", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2674", "pl", "sq", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2675", "pl", "sr", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2676", "pl", "sv", "Polska");
INSERT INTO `wp_icl_languages_translations` VALUES("2677", "pl", "ta", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2678", "pl", "th", "โปแลนด์");
INSERT INTO `wp_icl_languages_translations` VALUES("2679", "pl", "tr", "Polonyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2680", "pl", "uk", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2681", "pl", "ur", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2682", "pl", "uz", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2683", "pl", "vi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2684", "pl", "yi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2685", "pl", "zh-hans", "波兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("2686", "pl", "zu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2687", "pl", "zh-hant", "波蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("2688", "pl", "ms", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2689", "pt-pt", "en", "Portuguese (Portugal)");
INSERT INTO `wp_icl_languages_translations` VALUES("2690", "pt-pt", "es", "Portugués, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2691", "pt-pt", "de", "Portugiesisch, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2692", "pt-pt", "fr", "Portugais - du Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2693", "pt-pt", "ar", "البرتغالية ، البرتغال");
INSERT INTO `wp_icl_languages_translations` VALUES("2694", "pt-pt", "bs", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2695", "pt-pt", "bg", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2696", "pt-pt", "ca", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2697", "pt-pt", "cs", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2698", "pt-pt", "sk", "Portugalština");
INSERT INTO `wp_icl_languages_translations` VALUES("2699", "pt-pt", "cy", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2700", "pt-pt", "da", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2701", "pt-pt", "el", "Πορτογαλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2702", "pt-pt", "eo", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2703", "pt-pt", "et", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2704", "pt-pt", "eu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2705", "pt-pt", "fa", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2706", "pt-pt", "fi", "portugali");
INSERT INTO `wp_icl_languages_translations` VALUES("2707", "pt-pt", "ga", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2708", "pt-pt", "he", "פורטוגזית");
INSERT INTO `wp_icl_languages_translations` VALUES("2709", "pt-pt", "hi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2710", "pt-pt", "hr", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2711", "pt-pt", "hu", "portugál");
INSERT INTO `wp_icl_languages_translations` VALUES("2712", "pt-pt", "hy", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2713", "pt-pt", "id", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2714", "pt-pt", "is", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2715", "pt-pt", "it", "Portoghese, Portogallo");
INSERT INTO `wp_icl_languages_translations` VALUES("2716", "pt-pt", "ja", "ポルトガル語");
INSERT INTO `wp_icl_languages_translations` VALUES("2717", "pt-pt", "ko", "포르투갈 포르투갈어");
INSERT INTO `wp_icl_languages_translations` VALUES("2718", "pt-pt", "ku", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2719", "pt-pt", "la", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2720", "pt-pt", "lv", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2721", "pt-pt", "lt", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2722", "pt-pt", "mk", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2723", "pt-pt", "mt", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2724", "pt-pt", "mo", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2725", "pt-pt", "mn", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2726", "pt-pt", "ne", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2727", "pt-pt", "nl", "Portugees, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2728", "pt-pt", "nb", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2729", "pt-pt", "pa", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2730", "pt-pt", "pl", "portugalski, Portugalia");
INSERT INTO `wp_icl_languages_translations` VALUES("2731", "pt-pt", "pt-pt", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2732", "pt-pt", "pt-br", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2733", "pt-pt", "qu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2734", "pt-pt", "ro", "Portugheză (Portugalia)");
INSERT INTO `wp_icl_languages_translations` VALUES("2735", "pt-pt", "ru", "Португальский, Португалия");
INSERT INTO `wp_icl_languages_translations` VALUES("2736", "pt-pt", "sl", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2737", "pt-pt", "so", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2738", "pt-pt", "sq", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2739", "pt-pt", "sr", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2740", "pt-pt", "sv", "Portugisiska, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2741", "pt-pt", "ta", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2742", "pt-pt", "th", "โปรตุเกส");
INSERT INTO `wp_icl_languages_translations` VALUES("2743", "pt-pt", "tr", "Portekizce, Portekiz");
INSERT INTO `wp_icl_languages_translations` VALUES("2744", "pt-pt", "uk", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2745", "pt-pt", "ur", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2746", "pt-pt", "uz", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2747", "pt-pt", "vi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2748", "pt-pt", "yi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2749", "pt-pt", "zh-hans", "葡萄牙语（葡萄牙）");
INSERT INTO `wp_icl_languages_translations` VALUES("2750", "pt-pt", "zu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2751", "pt-pt", "zh-hant", "葡萄牙語（葡萄牙）");
INSERT INTO `wp_icl_languages_translations` VALUES("2752", "pt-pt", "ms", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2753", "pt-br", "en", "Portuguese (Brazil)");
INSERT INTO `wp_icl_languages_translations` VALUES("2754", "pt-br", "es", "Portugués, Brasil");
INSERT INTO `wp_icl_languages_translations` VALUES("2755", "pt-br", "de", "Portugiesisch, Brasilien");
INSERT INTO `wp_icl_languages_translations` VALUES("2756", "pt-br", "fr", "Portugais - du Brésil");
INSERT INTO `wp_icl_languages_translations` VALUES("2757", "pt-br", "ar", "البرتغالية ،البرازيل");
INSERT INTO `wp_icl_languages_translations` VALUES("2758", "pt-br", "bs", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2759", "pt-br", "bg", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2760", "pt-br", "ca", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2761", "pt-br", "cs", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2762", "pt-br", "sk", "Brazílska Portugalština");
INSERT INTO `wp_icl_languages_translations` VALUES("2763", "pt-br", "cy", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2764", "pt-br", "da", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2765", "pt-br", "el", "Πορτογαλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2766", "pt-br", "eo", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2767", "pt-br", "et", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2768", "pt-br", "eu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2769", "pt-br", "fa", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2770", "pt-br", "fi", "Brasilian portugali");
INSERT INTO `wp_icl_languages_translations` VALUES("2771", "pt-br", "ga", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2772", "pt-br", "he", "פורטוגזית");
INSERT INTO `wp_icl_languages_translations` VALUES("2773", "pt-br", "hi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2774", "pt-br", "hr", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2775", "pt-br", "hu", "brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2776", "pt-br", "hy", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2777", "pt-br", "id", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2778", "pt-br", "is", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2779", "pt-br", "it", "Portoghese, Brasile");
INSERT INTO `wp_icl_languages_translations` VALUES("2780", "pt-br", "ja", "ポルトガル語（ブラジル）");
INSERT INTO `wp_icl_languages_translations` VALUES("2781", "pt-br", "ko", "브라질 포르투갈어");
INSERT INTO `wp_icl_languages_translations` VALUES("2782", "pt-br", "ku", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2783", "pt-br", "la", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2784", "pt-br", "lv", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2785", "pt-br", "lt", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2786", "pt-br", "mk", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2787", "pt-br", "mt", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2788", "pt-br", "mo", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2789", "pt-br", "mn", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2790", "pt-br", "ne", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2791", "pt-br", "nl", "Portugees, Brazilië");
INSERT INTO `wp_icl_languages_translations` VALUES("2792", "pt-br", "nb", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2793", "pt-br", "pa", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2794", "pt-br", "pl", "portugalski, Brazylia");
INSERT INTO `wp_icl_languages_translations` VALUES("2795", "pt-br", "pt-pt", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2796", "pt-br", "pt-br", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2797", "pt-br", "qu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2798", "pt-br", "ro", "Portugheză (Brazilia)");
INSERT INTO `wp_icl_languages_translations` VALUES("2799", "pt-br", "ru", "Португальский, Бразилия");
INSERT INTO `wp_icl_languages_translations` VALUES("2800", "pt-br", "sl", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2801", "pt-br", "so", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2802", "pt-br", "sq", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2803", "pt-br", "sr", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2804", "pt-br", "sv", "Portugisiska, Brasilien");
INSERT INTO `wp_icl_languages_translations` VALUES("2805", "pt-br", "ta", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2806", "pt-br", "th", "โปรตุเกสบราซิล");
INSERT INTO `wp_icl_languages_translations` VALUES("2807", "pt-br", "tr", "Portekizce, Brezilya");
INSERT INTO `wp_icl_languages_translations` VALUES("2808", "pt-br", "uk", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2809", "pt-br", "ur", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2810", "pt-br", "uz", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2811", "pt-br", "vi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2812", "pt-br", "yi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2813", "pt-br", "zh-hans", "葡萄牙语（巴西）");
INSERT INTO `wp_icl_languages_translations` VALUES("2814", "pt-br", "zu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2815", "pt-br", "zh-hant", "葡萄牙語（巴西）");
INSERT INTO `wp_icl_languages_translations` VALUES("2816", "pt-br", "ms", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2817", "qu", "en", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2818", "qu", "es", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2819", "qu", "de", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2820", "qu", "fr", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2821", "qu", "ar", "الكويتشوا");
INSERT INTO `wp_icl_languages_translations` VALUES("2822", "qu", "bs", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2823", "qu", "bg", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2824", "qu", "ca", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2825", "qu", "cs", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2826", "qu", "sk", "Jazyk Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2827", "qu", "cy", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2828", "qu", "da", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2829", "qu", "el", "Κετσουα");
INSERT INTO `wp_icl_languages_translations` VALUES("2830", "qu", "eo", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2831", "qu", "et", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2832", "qu", "eu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2833", "qu", "fa", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2834", "qu", "fi", "ketsua");
INSERT INTO `wp_icl_languages_translations` VALUES("2835", "qu", "ga", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2836", "qu", "he", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2837", "qu", "hi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2838", "qu", "hr", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2839", "qu", "hu", "quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2840", "qu", "hy", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2841", "qu", "id", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2842", "qu", "is", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2843", "qu", "it", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2844", "qu", "ja", "ケチュア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2845", "qu", "ko", "케추아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2846", "qu", "ku", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2847", "qu", "la", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2848", "qu", "lv", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2849", "qu", "lt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2850", "qu", "mk", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2851", "qu", "mt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2852", "qu", "mo", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2853", "qu", "mn", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2854", "qu", "ne", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2855", "qu", "nl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2856", "qu", "nb", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2857", "qu", "pa", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2858", "qu", "pl", "keczua");
INSERT INTO `wp_icl_languages_translations` VALUES("2859", "qu", "pt-pt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2860", "qu", "pt-br", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2861", "qu", "qu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2862", "qu", "ro", "Quechuană");
INSERT INTO `wp_icl_languages_translations` VALUES("2863", "qu", "ru", "Кечуа");
INSERT INTO `wp_icl_languages_translations` VALUES("2864", "qu", "sl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2865", "qu", "so", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2866", "qu", "sq", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2867", "qu", "sr", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2868", "qu", "sv", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2869", "qu", "ta", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2870", "qu", "th", "คิวชัว");
INSERT INTO `wp_icl_languages_translations` VALUES("2871", "qu", "tr", "Quechua dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2872", "qu", "uk", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2873", "qu", "ur", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2874", "qu", "uz", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2875", "qu", "vi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2876", "qu", "yi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2877", "qu", "zh-hans", "盖丘亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2878", "qu", "zu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2879", "qu", "zh-hant", "蓋丘亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2880", "qu", "ms", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2881", "ro", "en", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2882", "ro", "es", "Rumano");
INSERT INTO `wp_icl_languages_translations` VALUES("2883", "ro", "de", "Rumänisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2884", "ro", "fr", "Roumain");
INSERT INTO `wp_icl_languages_translations` VALUES("2885", "ro", "ar", "الرومانية");
INSERT INTO `wp_icl_languages_translations` VALUES("2886", "ro", "bs", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2887", "ro", "bg", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2888", "ro", "ca", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2889", "ro", "cs", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2890", "ro", "sk", "Rumunčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2891", "ro", "cy", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2892", "ro", "da", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2893", "ro", "el", "Ρουμανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2894", "ro", "eo", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2895", "ro", "et", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2896", "ro", "eu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2897", "ro", "fa", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2898", "ro", "fi", "romania");
INSERT INTO `wp_icl_languages_translations` VALUES("2899", "ro", "ga", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2900", "ro", "he", "רומנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2901", "ro", "hi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2902", "ro", "hr", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2903", "ro", "hu", "román");
INSERT INTO `wp_icl_languages_translations` VALUES("2904", "ro", "hy", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2905", "ro", "id", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2906", "ro", "is", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2907", "ro", "it", "Rumeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2908", "ro", "ja", "ルーマニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2909", "ro", "ko", "로마니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2910", "ro", "ku", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2911", "ro", "la", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2912", "ro", "lv", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2913", "ro", "lt", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2914", "ro", "mk", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2915", "ro", "mt", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2916", "ro", "mo", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2917", "ro", "mn", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2918", "ro", "ne", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2919", "ro", "nl", "Roemeens");
INSERT INTO `wp_icl_languages_translations` VALUES("2920", "ro", "nb", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2921", "ro", "pa", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2922", "ro", "pl", "rumuński");
INSERT INTO `wp_icl_languages_translations` VALUES("2923", "ro", "pt-pt", "Romeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2924", "ro", "pt-br", "Romeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2925", "ro", "qu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2926", "ro", "ro", "Română");
INSERT INTO `wp_icl_languages_translations` VALUES("2927", "ro", "ru", "Румынский");
INSERT INTO `wp_icl_languages_translations` VALUES("2928", "ro", "sl", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2929", "ro", "so", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2930", "ro", "sq", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2931", "ro", "sr", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2932", "ro", "sv", "Rumänska");
INSERT INTO `wp_icl_languages_translations` VALUES("2933", "ro", "ta", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2934", "ro", "th", "โรมาเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2935", "ro", "tr", "Rumence");
INSERT INTO `wp_icl_languages_translations` VALUES("2936", "ro", "uk", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2937", "ro", "ur", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2938", "ro", "uz", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2939", "ro", "vi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2940", "ro", "yi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2941", "ro", "zh-hans", "罗马尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2942", "ro", "zu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2943", "ro", "zh-hant", "羅馬尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2944", "ro", "ms", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2945", "ru", "en", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2946", "ru", "es", "Ruso");
INSERT INTO `wp_icl_languages_translations` VALUES("2947", "ru", "de", "Russisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2948", "ru", "fr", "Russe");
INSERT INTO `wp_icl_languages_translations` VALUES("2949", "ru", "ar", "الروسية");
INSERT INTO `wp_icl_languages_translations` VALUES("2950", "ru", "bs", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2951", "ru", "bg", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2952", "ru", "ca", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2953", "ru", "cs", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2954", "ru", "sk", "Ruština");
INSERT INTO `wp_icl_languages_translations` VALUES("2955", "ru", "cy", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2956", "ru", "da", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2957", "ru", "el", "Ρωσικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2958", "ru", "eo", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2959", "ru", "et", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2960", "ru", "eu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2961", "ru", "fa", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2962", "ru", "fi", "venäjä");
INSERT INTO `wp_icl_languages_translations` VALUES("2963", "ru", "ga", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2964", "ru", "he", "רוסית");
INSERT INTO `wp_icl_languages_translations` VALUES("2965", "ru", "hi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2966", "ru", "hr", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2967", "ru", "hu", "orosz");
INSERT INTO `wp_icl_languages_translations` VALUES("2968", "ru", "hy", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2969", "ru", "id", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2970", "ru", "is", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2971", "ru", "it", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2972", "ru", "ja", "ロシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2973", "ru", "ko", "러시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2974", "ru", "ku", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2975", "ru", "la", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2976", "ru", "lv", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2977", "ru", "lt", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2978", "ru", "mk", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2979", "ru", "mt", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2980", "ru", "mo", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2981", "ru", "mn", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2982", "ru", "ne", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2983", "ru", "nl", "Russisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2984", "ru", "nb", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2985", "ru", "pa", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2986", "ru", "pl", "rosyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("2987", "ru", "pt-pt", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2988", "ru", "pt-br", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2989", "ru", "qu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2990", "ru", "ro", "Rusă");
INSERT INTO `wp_icl_languages_translations` VALUES("2991", "ru", "ru", "Русский");
INSERT INTO `wp_icl_languages_translations` VALUES("2992", "ru", "sl", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2993", "ru", "so", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2994", "ru", "sq", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2995", "ru", "sr", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2996", "ru", "sv", "Ryska");
INSERT INTO `wp_icl_languages_translations` VALUES("2997", "ru", "ta", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2998", "ru", "th", "รัสเซีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2999", "ru", "tr", "Rusça");
INSERT INTO `wp_icl_languages_translations` VALUES("3000", "ru", "uk", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("3001", "ru", "ur", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("3002", "ru", "uz", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("3003", "ru", "vi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("3004", "ru", "yi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("3005", "ru", "zh-hans", "俄语");
INSERT INTO `wp_icl_languages_translations` VALUES("3006", "ru", "zu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("3007", "ru", "zh-hant", "俄語");
INSERT INTO `wp_icl_languages_translations` VALUES("3008", "ru", "ms", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("3009", "sl", "en", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3010", "sl", "es", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("3011", "sl", "de", "Slowenisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3012", "sl", "fr", "Slovène");
INSERT INTO `wp_icl_languages_translations` VALUES("3013", "sl", "ar", "السلوفانية");
INSERT INTO `wp_icl_languages_translations` VALUES("3014", "sl", "bs", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3015", "sl", "bg", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3016", "sl", "ca", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3017", "sl", "cs", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3018", "sl", "sk", "Slovinčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3019", "sl", "cy", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3020", "sl", "da", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3021", "sl", "el", "Σλοβενικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3022", "sl", "eo", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3023", "sl", "et", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3024", "sl", "eu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3025", "sl", "fa", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3026", "sl", "fi", "sloveeni");
INSERT INTO `wp_icl_languages_translations` VALUES("3027", "sl", "ga", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3028", "sl", "he", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3029", "sl", "hi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3030", "sl", "hr", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3031", "sl", "hu", "szlovén");
INSERT INTO `wp_icl_languages_translations` VALUES("3032", "sl", "hy", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3033", "sl", "id", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3034", "sl", "is", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3035", "sl", "it", "Sloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("3036", "sl", "ja", "スロベニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("3037", "sl", "ko", "슬로베니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3038", "sl", "ku", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3039", "sl", "la", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3040", "sl", "lv", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3041", "sl", "lt", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3042", "sl", "mk", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3043", "sl", "mt", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3044", "sl", "mo", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3045", "sl", "mn", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3046", "sl", "ne", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3047", "sl", "nl", "Sloveens");
INSERT INTO `wp_icl_languages_translations` VALUES("3048", "sl", "nb", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3049", "sl", "pa", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3050", "sl", "pl", "słoweński");
INSERT INTO `wp_icl_languages_translations` VALUES("3051", "sl", "pt-pt", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("3052", "sl", "pt-br", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("3053", "sl", "qu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3054", "sl", "ro", "Slovenă");
INSERT INTO `wp_icl_languages_translations` VALUES("3055", "sl", "ru", "Словенский");
INSERT INTO `wp_icl_languages_translations` VALUES("3056", "sl", "sl", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3057", "sl", "so", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3058", "sl", "sq", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3059", "sl", "sr", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3060", "sl", "sv", "Slovenska");
INSERT INTO `wp_icl_languages_translations` VALUES("3061", "sl", "ta", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3062", "sl", "th", "สโลวีเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("3063", "sl", "tr", "Sloven dili");
INSERT INTO `wp_icl_languages_translations` VALUES("3064", "sl", "uk", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3065", "sl", "ur", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3066", "sl", "uz", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3067", "sl", "vi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3068", "sl", "yi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3069", "sl", "zh-hans", "斯洛文尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("3070", "sl", "zu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3071", "sl", "zh-hant", "斯洛文尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("3072", "sl", "ms", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("3073", "so", "en", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3074", "so", "es", "Somalí");
INSERT INTO `wp_icl_languages_translations` VALUES("3075", "so", "de", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3076", "so", "fr", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3077", "so", "ar", "الصومالية");
INSERT INTO `wp_icl_languages_translations` VALUES("3078", "so", "bs", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3079", "so", "bg", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3080", "so", "ca", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3081", "so", "cs", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3082", "so", "sk", "Somálčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3083", "so", "cy", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3084", "so", "da", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3085", "so", "el", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3086", "so", "eo", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3087", "so", "et", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3088", "so", "eu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3089", "so", "fa", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3090", "so", "fi", "somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3091", "so", "ga", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3092", "so", "he", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3093", "so", "hi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3094", "so", "hr", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3095", "so", "hu", "szomáli");
INSERT INTO `wp_icl_languages_translations` VALUES("3096", "so", "hy", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3097", "so", "id", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3098", "so", "is", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3099", "so", "it", "Somalo");
INSERT INTO `wp_icl_languages_translations` VALUES("3100", "so", "ja", "ソマリ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3101", "so", "ko", "소말리아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3102", "so", "ku", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3103", "so", "la", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3104", "so", "lv", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3105", "so", "lt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3106", "so", "mk", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3107", "so", "mt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3108", "so", "mo", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3109", "so", "mn", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3110", "so", "ne", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3111", "so", "nl", "Somalisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3112", "so", "nb", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3113", "so", "pa", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3114", "so", "pl", "somalijski");
INSERT INTO `wp_icl_languages_translations` VALUES("3115", "so", "pt-pt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3116", "so", "pt-br", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3117", "so", "qu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3118", "so", "ro", "Somaleză");
INSERT INTO `wp_icl_languages_translations` VALUES("3119", "so", "ru", "Сомалийский");
INSERT INTO `wp_icl_languages_translations` VALUES("3120", "so", "sl", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3121", "so", "so", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3122", "so", "sq", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3123", "so", "sr", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3124", "so", "sv", "Somaliska");
INSERT INTO `wp_icl_languages_translations` VALUES("3125", "so", "ta", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3126", "so", "th", "โซมาลี");
INSERT INTO `wp_icl_languages_translations` VALUES("3127", "so", "tr", "Somalice");
INSERT INTO `wp_icl_languages_translations` VALUES("3128", "so", "uk", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3129", "so", "ur", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3130", "so", "uz", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3131", "so", "vi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3132", "so", "yi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3133", "so", "zh-hans", "索马里语");
INSERT INTO `wp_icl_languages_translations` VALUES("3134", "so", "zu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3135", "so", "zh-hant", "索馬里語");
INSERT INTO `wp_icl_languages_translations` VALUES("3136", "so", "ms", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3137", "sq", "en", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3138", "sq", "es", "Albanés");
INSERT INTO `wp_icl_languages_translations` VALUES("3139", "sq", "de", "Albanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3140", "sq", "fr", "Albanais");
INSERT INTO `wp_icl_languages_translations` VALUES("3141", "sq", "ar", "الألبانية");
INSERT INTO `wp_icl_languages_translations` VALUES("3142", "sq", "bs", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3143", "sq", "bg", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3144", "sq", "ca", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3145", "sq", "cs", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3146", "sq", "sk", "Albánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3147", "sq", "cy", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3148", "sq", "da", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3149", "sq", "el", "Αλβανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3150", "sq", "eo", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3151", "sq", "et", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3152", "sq", "eu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3153", "sq", "fa", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3154", "sq", "fi", "albania");
INSERT INTO `wp_icl_languages_translations` VALUES("3155", "sq", "ga", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3156", "sq", "he", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3157", "sq", "hi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3158", "sq", "hr", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3159", "sq", "hu", "albán");
INSERT INTO `wp_icl_languages_translations` VALUES("3160", "sq", "hy", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3161", "sq", "id", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3162", "sq", "is", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3163", "sq", "it", "Albanese");
INSERT INTO `wp_icl_languages_translations` VALUES("3164", "sq", "ja", "アルバニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("3165", "sq", "ko", "알바니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3166", "sq", "ku", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3167", "sq", "la", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3168", "sq", "lv", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3169", "sq", "lt", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3170", "sq", "mk", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3171", "sq", "mt", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3172", "sq", "mo", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3173", "sq", "mn", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3174", "sq", "ne", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3175", "sq", "nl", "Albaans");
INSERT INTO `wp_icl_languages_translations` VALUES("3176", "sq", "nb", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3177", "sq", "pa", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3178", "sq", "pl", "albański");
INSERT INTO `wp_icl_languages_translations` VALUES("3179", "sq", "pt-pt", "Albanês");
INSERT INTO `wp_icl_languages_translations` VALUES("3180", "sq", "pt-br", "Albanês");
INSERT INTO `wp_icl_languages_translations` VALUES("3181", "sq", "qu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3182", "sq", "ro", "Albaneză");
INSERT INTO `wp_icl_languages_translations` VALUES("3183", "sq", "ru", "Албанский");
INSERT INTO `wp_icl_languages_translations` VALUES("3184", "sq", "sl", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3185", "sq", "so", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3186", "sq", "sq", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3187", "sq", "sr", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3188", "sq", "sv", "Albanska");
INSERT INTO `wp_icl_languages_translations` VALUES("3189", "sq", "ta", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3190", "sq", "th", "อัลเบเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("3191", "sq", "tr", "Arnavutça");
INSERT INTO `wp_icl_languages_translations` VALUES("3192", "sq", "uk", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3193", "sq", "ur", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3194", "sq", "uz", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3195", "sq", "vi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3196", "sq", "yi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3197", "sq", "zh-hans", "阿尔巴尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("3198", "sq", "zu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3199", "sq", "zh-hant", "阿爾巴尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("3200", "sq", "ms", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3201", "sr", "en", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3202", "sr", "es", "Serbio");
INSERT INTO `wp_icl_languages_translations` VALUES("3203", "sr", "de", "Serbisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3204", "sr", "fr", "Serbe");
INSERT INTO `wp_icl_languages_translations` VALUES("3205", "sr", "ar", "الصربية");
INSERT INTO `wp_icl_languages_translations` VALUES("3206", "sr", "bs", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3207", "sr", "bg", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3208", "sr", "ca", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3209", "sr", "cs", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3210", "sr", "sk", "Srbština");
INSERT INTO `wp_icl_languages_translations` VALUES("3211", "sr", "cy", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3212", "sr", "da", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3213", "sr", "el", "Σερβικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3214", "sr", "eo", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3215", "sr", "et", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3216", "sr", "eu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3217", "sr", "fa", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3218", "sr", "fi", "serbia");
INSERT INTO `wp_icl_languages_translations` VALUES("3219", "sr", "ga", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3220", "sr", "he", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3221", "sr", "hi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3222", "sr", "hr", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3223", "sr", "hu", "szerb");
INSERT INTO `wp_icl_languages_translations` VALUES("3224", "sr", "hy", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3225", "sr", "id", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3226", "sr", "is", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3227", "sr", "it", "Serbo");
INSERT INTO `wp_icl_languages_translations` VALUES("3228", "sr", "ja", "セルビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("3229", "sr", "ko", "세르비아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3230", "sr", "ku", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3231", "sr", "la", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3232", "sr", "lv", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3233", "sr", "lt", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3234", "sr", "mk", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3235", "sr", "mt", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3236", "sr", "mo", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3237", "sr", "mn", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3238", "sr", "ne", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3239", "sr", "nl", "Servisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3240", "sr", "nb", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3241", "sr", "pa", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3242", "sr", "pl", "serbski");
INSERT INTO `wp_icl_languages_translations` VALUES("3243", "sr", "pt-pt", "Sérvio");
INSERT INTO `wp_icl_languages_translations` VALUES("3244", "sr", "pt-br", "Sérvio");
INSERT INTO `wp_icl_languages_translations` VALUES("3245", "sr", "qu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3246", "sr", "ro", "Sârbă");
INSERT INTO `wp_icl_languages_translations` VALUES("3247", "sr", "ru", "Сербский");
INSERT INTO `wp_icl_languages_translations` VALUES("3248", "sr", "sl", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3249", "sr", "so", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3250", "sr", "sq", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3251", "sr", "sr", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3252", "sr", "sv", "Serbiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3253", "sr", "ta", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3254", "sr", "th", "เซอร์เบีย");
INSERT INTO `wp_icl_languages_translations` VALUES("3255", "sr", "tr", "Sırpça");
INSERT INTO `wp_icl_languages_translations` VALUES("3256", "sr", "uk", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3257", "sr", "ur", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3258", "sr", "uz", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3259", "sr", "vi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3260", "sr", "yi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3261", "sr", "zh-hans", "赛尔维亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("3262", "sr", "zu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3263", "sr", "zh-hant", "賽爾維亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("3264", "sr", "ms", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3265", "sv", "en", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3266", "sv", "es", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3267", "sv", "de", "Schwedisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3268", "sv", "fr", "Suédois");
INSERT INTO `wp_icl_languages_translations` VALUES("3269", "sv", "ar", "السويدية");
INSERT INTO `wp_icl_languages_translations` VALUES("3270", "sv", "bs", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3271", "sv", "bg", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3272", "sv", "ca", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3273", "sv", "cs", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3274", "sv", "sk", "Švédština");
INSERT INTO `wp_icl_languages_translations` VALUES("3275", "sv", "cy", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3276", "sv", "da", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3277", "sv", "el", "Σουηδικη");
INSERT INTO `wp_icl_languages_translations` VALUES("3278", "sv", "eo", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3279", "sv", "et", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3280", "sv", "eu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3281", "sv", "fa", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3282", "sv", "fi", "ruotsi");
INSERT INTO `wp_icl_languages_translations` VALUES("3283", "sv", "ga", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3284", "sv", "he", "שוודית");
INSERT INTO `wp_icl_languages_translations` VALUES("3285", "sv", "hi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3286", "sv", "hr", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3287", "sv", "hu", "svéd");
INSERT INTO `wp_icl_languages_translations` VALUES("3288", "sv", "hy", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3289", "sv", "id", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3290", "sv", "is", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3291", "sv", "it", "Svedese");
INSERT INTO `wp_icl_languages_translations` VALUES("3292", "sv", "ja", "スウェーデン語");
INSERT INTO `wp_icl_languages_translations` VALUES("3293", "sv", "ko", "스웨덴어");
INSERT INTO `wp_icl_languages_translations` VALUES("3294", "sv", "ku", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3295", "sv", "la", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3296", "sv", "lv", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3297", "sv", "lt", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3298", "sv", "mk", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3299", "sv", "mt", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3300", "sv", "mo", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3301", "sv", "mn", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3302", "sv", "ne", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3303", "sv", "nl", "Zweeds");
INSERT INTO `wp_icl_languages_translations` VALUES("3304", "sv", "nb", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3305", "sv", "pa", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3306", "sv", "pl", "szwedzki");
INSERT INTO `wp_icl_languages_translations` VALUES("3307", "sv", "pt-pt", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3308", "sv", "pt-br", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3309", "sv", "qu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3310", "sv", "ro", "Suedeză");
INSERT INTO `wp_icl_languages_translations` VALUES("3311", "sv", "ru", "Шведский");
INSERT INTO `wp_icl_languages_translations` VALUES("3312", "sv", "sl", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3313", "sv", "so", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3314", "sv", "sq", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3315", "sv", "sr", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3316", "sv", "sv", "Svenska");
INSERT INTO `wp_icl_languages_translations` VALUES("3317", "sv", "ta", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3318", "sv", "th", "สวีเดน");
INSERT INTO `wp_icl_languages_translations` VALUES("3319", "sv", "tr", "İsveççe");
INSERT INTO `wp_icl_languages_translations` VALUES("3320", "sv", "uk", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3321", "sv", "ur", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3322", "sv", "uz", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3323", "sv", "vi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3324", "sv", "yi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3325", "sv", "zh-hans", "瑞典语");
INSERT INTO `wp_icl_languages_translations` VALUES("3326", "sv", "zu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3327", "sv", "zh-hant", "瑞典語");
INSERT INTO `wp_icl_languages_translations` VALUES("3328", "sv", "ms", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3329", "ta", "en", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3330", "ta", "es", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3331", "ta", "de", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3332", "ta", "fr", "Tamoul");
INSERT INTO `wp_icl_languages_translations` VALUES("3333", "ta", "ar", "التاميلية");
INSERT INTO `wp_icl_languages_translations` VALUES("3334", "ta", "bs", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3335", "ta", "bg", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3336", "ta", "ca", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3337", "ta", "cs", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3338", "ta", "sk", "Tamilčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3339", "ta", "cy", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3340", "ta", "da", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3341", "ta", "el", "Ταμιλ");
INSERT INTO `wp_icl_languages_translations` VALUES("3342", "ta", "eo", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3343", "ta", "et", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3344", "ta", "eu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3345", "ta", "fa", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3346", "ta", "fi", "tamili");
INSERT INTO `wp_icl_languages_translations` VALUES("3347", "ta", "ga", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3348", "ta", "he", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3349", "ta", "hi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3350", "ta", "hr", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3351", "ta", "hu", "tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3352", "ta", "hy", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3353", "ta", "id", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3354", "ta", "is", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3355", "ta", "it", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3356", "ta", "ja", "タミル語");
INSERT INTO `wp_icl_languages_translations` VALUES("3357", "ta", "ko", "타밀어");
INSERT INTO `wp_icl_languages_translations` VALUES("3358", "ta", "ku", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3359", "ta", "la", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3360", "ta", "lv", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3361", "ta", "lt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3362", "ta", "mk", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3363", "ta", "mt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3364", "ta", "mo", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3365", "ta", "mn", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3366", "ta", "ne", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3367", "ta", "nl", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3368", "ta", "nb", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3369", "ta", "pa", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3370", "ta", "pl", "tamilski");
INSERT INTO `wp_icl_languages_translations` VALUES("3371", "ta", "pt-pt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3372", "ta", "pt-br", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3373", "ta", "qu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3374", "ta", "ro", "Tamilă");
INSERT INTO `wp_icl_languages_translations` VALUES("3375", "ta", "ru", "Тамильский");
INSERT INTO `wp_icl_languages_translations` VALUES("3376", "ta", "sl", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3377", "ta", "so", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3378", "ta", "sq", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3379", "ta", "sr", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3380", "ta", "sv", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3381", "ta", "ta", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3382", "ta", "th", "ทมิฬ");
INSERT INTO `wp_icl_languages_translations` VALUES("3383", "ta", "tr", "Tamil dili");
INSERT INTO `wp_icl_languages_translations` VALUES("3384", "ta", "uk", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3385", "ta", "ur", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3386", "ta", "uz", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3387", "ta", "vi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3388", "ta", "yi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3389", "ta", "zh-hans", "泰米尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("3390", "ta", "zu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3391", "ta", "zh-hant", "泰米爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("3392", "ta", "ms", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3393", "th", "en", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3394", "th", "es", "Tailandés");
INSERT INTO `wp_icl_languages_translations` VALUES("3395", "th", "de", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3396", "th", "fr", "Thaï");
INSERT INTO `wp_icl_languages_translations` VALUES("3397", "th", "ar", "التايلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("3398", "th", "bs", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3399", "th", "bg", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3400", "th", "ca", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3401", "th", "cs", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3402", "th", "sk", "Thajština");
INSERT INTO `wp_icl_languages_translations` VALUES("3403", "th", "cy", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3404", "th", "da", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3405", "th", "el", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3406", "th", "eo", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3407", "th", "et", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3408", "th", "eu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3409", "th", "fa", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3410", "th", "fi", "thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3411", "th", "ga", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3412", "th", "he", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3413", "th", "hi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3414", "th", "hr", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3415", "th", "hu", "tájföldi");
INSERT INTO `wp_icl_languages_translations` VALUES("3416", "th", "hy", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3417", "th", "id", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3418", "th", "is", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3419", "th", "it", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3420", "th", "ja", "タイ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3421", "th", "ko", "태국어");
INSERT INTO `wp_icl_languages_translations` VALUES("3422", "th", "ku", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3423", "th", "la", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3424", "th", "lv", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3425", "th", "lt", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3426", "th", "mk", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3427", "th", "mt", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3428", "th", "mo", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3429", "th", "mn", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3430", "th", "ne", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3431", "th", "nl", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3432", "th", "nb", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3433", "th", "pa", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3434", "th", "pl", "tajski");
INSERT INTO `wp_icl_languages_translations` VALUES("3435", "th", "pt-pt", "Tailandês");
INSERT INTO `wp_icl_languages_translations` VALUES("3436", "th", "pt-br", "Tailandês");
INSERT INTO `wp_icl_languages_translations` VALUES("3437", "th", "qu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3438", "th", "ro", "Tailandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("3439", "th", "ru", "Тайский");
INSERT INTO `wp_icl_languages_translations` VALUES("3440", "th", "sl", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3441", "th", "so", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3442", "th", "sq", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3443", "th", "sr", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3444", "th", "sv", "Thailändska");
INSERT INTO `wp_icl_languages_translations` VALUES("3445", "th", "ta", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3446", "th", "th", "ไทย");
INSERT INTO `wp_icl_languages_translations` VALUES("3447", "th", "tr", "Tayca");
INSERT INTO `wp_icl_languages_translations` VALUES("3448", "th", "uk", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3449", "th", "ur", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3450", "th", "uz", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3451", "th", "vi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3452", "th", "yi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3453", "th", "zh-hans", "泰语");
INSERT INTO `wp_icl_languages_translations` VALUES("3454", "th", "zu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3455", "th", "zh-hant", "泰語");
INSERT INTO `wp_icl_languages_translations` VALUES("3456", "th", "ms", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3457", "tr", "en", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3458", "tr", "es", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3459", "tr", "de", "Türkisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3460", "tr", "fr", "Turc");
INSERT INTO `wp_icl_languages_translations` VALUES("3461", "tr", "ar", "التركية");
INSERT INTO `wp_icl_languages_translations` VALUES("3462", "tr", "bs", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3463", "tr", "bg", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3464", "tr", "ca", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3465", "tr", "cs", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3466", "tr", "sk", "Turečtina");
INSERT INTO `wp_icl_languages_translations` VALUES("3467", "tr", "cy", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3468", "tr", "da", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3469", "tr", "el", "Τουρκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3470", "tr", "eo", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3471", "tr", "et", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3472", "tr", "eu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3473", "tr", "fa", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3474", "tr", "fi", "turkki");
INSERT INTO `wp_icl_languages_translations` VALUES("3475", "tr", "ga", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3476", "tr", "he", "תורכית");
INSERT INTO `wp_icl_languages_translations` VALUES("3477", "tr", "hi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3478", "tr", "hr", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3479", "tr", "hu", "török");
INSERT INTO `wp_icl_languages_translations` VALUES("3480", "tr", "hy", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3481", "tr", "id", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3482", "tr", "is", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3483", "tr", "it", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3484", "tr", "ja", "トルコ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3485", "tr", "ko", "터어키어");
INSERT INTO `wp_icl_languages_translations` VALUES("3486", "tr", "ku", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3487", "tr", "la", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3488", "tr", "lv", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3489", "tr", "lt", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3490", "tr", "mk", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3491", "tr", "mt", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3492", "tr", "mo", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3493", "tr", "mn", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3494", "tr", "ne", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3495", "tr", "nl", "Turks");
INSERT INTO `wp_icl_languages_translations` VALUES("3496", "tr", "nb", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3497", "tr", "pa", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3498", "tr", "pl", "turecki");
INSERT INTO `wp_icl_languages_translations` VALUES("3499", "tr", "pt-pt", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3500", "tr", "pt-br", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3501", "tr", "qu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3502", "tr", "ro", "Turcă");
INSERT INTO `wp_icl_languages_translations` VALUES("3503", "tr", "ru", "Турецкий");
INSERT INTO `wp_icl_languages_translations` VALUES("3504", "tr", "sl", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3505", "tr", "so", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3506", "tr", "sq", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3507", "tr", "sr", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3508", "tr", "sv", "Turkiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3509", "tr", "ta", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3510", "tr", "th", "ตุรกี");
INSERT INTO `wp_icl_languages_translations` VALUES("3511", "tr", "tr", "Türkçe");
INSERT INTO `wp_icl_languages_translations` VALUES("3512", "tr", "uk", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3513", "tr", "ur", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3514", "tr", "uz", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3515", "tr", "vi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3516", "tr", "yi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3517", "tr", "zh-hans", "土耳其语");
INSERT INTO `wp_icl_languages_translations` VALUES("3518", "tr", "zu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3519", "tr", "zh-hant", "土耳其語");
INSERT INTO `wp_icl_languages_translations` VALUES("3520", "tr", "ms", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3521", "uk", "en", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3522", "uk", "es", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3523", "uk", "de", "Ukrainisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3524", "uk", "fr", "Ukrainien");
INSERT INTO `wp_icl_languages_translations` VALUES("3525", "uk", "ar", "الأوكرانية");
INSERT INTO `wp_icl_languages_translations` VALUES("3526", "uk", "bs", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3527", "uk", "bg", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3528", "uk", "ca", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3529", "uk", "cs", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3530", "uk", "sk", "Ukrajinčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3531", "uk", "cy", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3532", "uk", "da", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3533", "uk", "el", "Ουκρανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3534", "uk", "eo", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3535", "uk", "et", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3536", "uk", "eu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3537", "uk", "fa", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3538", "uk", "fi", "ukraina");
INSERT INTO `wp_icl_languages_translations` VALUES("3539", "uk", "ga", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3540", "uk", "he", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3541", "uk", "hi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3542", "uk", "hr", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3543", "uk", "hu", "ukrán");
INSERT INTO `wp_icl_languages_translations` VALUES("3544", "uk", "hy", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3545", "uk", "id", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3546", "uk", "is", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3547", "uk", "it", "Ucraino");
INSERT INTO `wp_icl_languages_translations` VALUES("3548", "uk", "ja", "ウクライナ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3549", "uk", "ko", "우크라이나어");
INSERT INTO `wp_icl_languages_translations` VALUES("3550", "uk", "ku", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3551", "uk", "la", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3552", "uk", "lv", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3553", "uk", "lt", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3554", "uk", "mk", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3555", "uk", "mt", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3556", "uk", "mo", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3557", "uk", "mn", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3558", "uk", "ne", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3559", "uk", "nl", "Oekraïens");
INSERT INTO `wp_icl_languages_translations` VALUES("3560", "uk", "nb", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3561", "uk", "pa", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3562", "uk", "pl", "ukraiński");
INSERT INTO `wp_icl_languages_translations` VALUES("3563", "uk", "pt-pt", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3564", "uk", "pt-br", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3565", "uk", "qu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3566", "uk", "ro", "Ucrainiană");
INSERT INTO `wp_icl_languages_translations` VALUES("3567", "uk", "ru", "Украинский");
INSERT INTO `wp_icl_languages_translations` VALUES("3568", "uk", "sl", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3569", "uk", "so", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3570", "uk", "sq", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3571", "uk", "sr", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3572", "uk", "sv", "Ukrainska");
INSERT INTO `wp_icl_languages_translations` VALUES("3573", "uk", "ta", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3574", "uk", "th", "ยูเครน");
INSERT INTO `wp_icl_languages_translations` VALUES("3575", "uk", "tr", "Ukraynaca");
INSERT INTO `wp_icl_languages_translations` VALUES("3576", "uk", "uk", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3577", "uk", "ur", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3578", "uk", "uz", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3579", "uk", "vi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3580", "uk", "yi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3581", "uk", "zh-hans", "乌克兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("3582", "uk", "zu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3583", "uk", "zh-hant", "烏克蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("3584", "uk", "ms", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3585", "ur", "en", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3586", "ur", "es", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3587", "ur", "de", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3588", "ur", "fr", "Ourdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3589", "ur", "ar", "الأردية");
INSERT INTO `wp_icl_languages_translations` VALUES("3590", "ur", "bs", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3591", "ur", "bg", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3592", "ur", "ca", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3593", "ur", "cs", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3594", "ur", "sk", "Urdština");
INSERT INTO `wp_icl_languages_translations` VALUES("3595", "ur", "cy", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3596", "ur", "da", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3597", "ur", "el", "Ουρντου");
INSERT INTO `wp_icl_languages_translations` VALUES("3598", "ur", "eo", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3599", "ur", "et", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3600", "ur", "eu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3601", "ur", "fa", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3602", "ur", "fi", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3603", "ur", "ga", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3604", "ur", "he", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3605", "ur", "hi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3606", "ur", "hr", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3607", "ur", "hu", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3608", "ur", "hy", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3609", "ur", "id", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3610", "ur", "is", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3611", "ur", "it", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3612", "ur", "ja", "ウルドゥー語");
INSERT INTO `wp_icl_languages_translations` VALUES("3613", "ur", "ko", "우르두어");
INSERT INTO `wp_icl_languages_translations` VALUES("3614", "ur", "ku", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3615", "ur", "la", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3616", "ur", "lv", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3617", "ur", "lt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3618", "ur", "mk", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3619", "ur", "mt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3620", "ur", "mo", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3621", "ur", "mn", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3622", "ur", "ne", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3623", "ur", "nl", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3624", "ur", "nb", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3625", "ur", "pa", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3626", "ur", "pl", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3627", "ur", "pt-pt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3628", "ur", "pt-br", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3629", "ur", "qu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3630", "ur", "ro", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3631", "ur", "ru", "Урду");
INSERT INTO `wp_icl_languages_translations` VALUES("3632", "ur", "sl", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3633", "ur", "so", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3634", "ur", "sq", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3635", "ur", "sr", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3636", "ur", "sv", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3637", "ur", "ta", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3638", "ur", "th", "อุรดู");
INSERT INTO `wp_icl_languages_translations` VALUES("3639", "ur", "tr", "Urduca");
INSERT INTO `wp_icl_languages_translations` VALUES("3640", "ur", "uk", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3641", "ur", "ur", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3642", "ur", "uz", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3643", "ur", "vi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3644", "ur", "yi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3645", "ur", "zh-hans", "乌尔都语");
INSERT INTO `wp_icl_languages_translations` VALUES("3646", "ur", "zu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3647", "ur", "zh-hant", "烏爾都語");
INSERT INTO `wp_icl_languages_translations` VALUES("3648", "ur", "ms", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3649", "uz", "en", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3650", "uz", "es", "Uzbeko");
INSERT INTO `wp_icl_languages_translations` VALUES("3651", "uz", "de", "Usbekisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3652", "uz", "fr", "Ouzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3653", "uz", "ar", "الاوزباكية");
INSERT INTO `wp_icl_languages_translations` VALUES("3654", "uz", "bs", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3655", "uz", "bg", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3656", "uz", "ca", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3657", "uz", "cs", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3658", "uz", "sk", "Uzbekčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3659", "uz", "cy", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3660", "uz", "da", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3661", "uz", "el", "Ουζμπεκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3662", "uz", "eo", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3663", "uz", "et", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3664", "uz", "eu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3665", "uz", "fa", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3666", "uz", "fi", "uzbekki");
INSERT INTO `wp_icl_languages_translations` VALUES("3667", "uz", "ga", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3668", "uz", "he", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3669", "uz", "hi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3670", "uz", "hr", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3671", "uz", "hu", "üzbég");
INSERT INTO `wp_icl_languages_translations` VALUES("3672", "uz", "hy", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3673", "uz", "id", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3674", "uz", "is", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3675", "uz", "it", "Uzbeco");
INSERT INTO `wp_icl_languages_translations` VALUES("3676", "uz", "ja", "ウズベク語");
INSERT INTO `wp_icl_languages_translations` VALUES("3677", "uz", "ko", "우즈베크어");
INSERT INTO `wp_icl_languages_translations` VALUES("3678", "uz", "ku", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3679", "uz", "la", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3680", "uz", "lv", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3681", "uz", "lt", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3682", "uz", "mk", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3683", "uz", "mt", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3684", "uz", "mo", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3685", "uz", "mn", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3686", "uz", "ne", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3687", "uz", "nl", "Oezbeeks");
INSERT INTO `wp_icl_languages_translations` VALUES("3688", "uz", "nb", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3689", "uz", "pa", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3690", "uz", "pl", "uzbecki");
INSERT INTO `wp_icl_languages_translations` VALUES("3691", "uz", "pt-pt", "Uzbeque");
INSERT INTO `wp_icl_languages_translations` VALUES("3692", "uz", "pt-br", "Uzbeque");
INSERT INTO `wp_icl_languages_translations` VALUES("3693", "uz", "qu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3694", "uz", "ro", "Uzbecă");
INSERT INTO `wp_icl_languages_translations` VALUES("3695", "uz", "ru", "Узбекский");
INSERT INTO `wp_icl_languages_translations` VALUES("3696", "uz", "sl", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3697", "uz", "so", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3698", "uz", "sq", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3699", "uz", "sr", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3700", "uz", "sv", "Uzbekiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3701", "uz", "ta", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3702", "uz", "th", "อุซเบก");
INSERT INTO `wp_icl_languages_translations` VALUES("3703", "uz", "tr", "Özbekçe");
INSERT INTO `wp_icl_languages_translations` VALUES("3704", "uz", "uk", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3705", "uz", "ur", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3706", "uz", "uz", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3707", "uz", "vi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3708", "uz", "yi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3709", "uz", "zh-hans", "乌兹别克语");
INSERT INTO `wp_icl_languages_translations` VALUES("3710", "uz", "zu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3711", "uz", "zh-hant", "烏茲別克語");
INSERT INTO `wp_icl_languages_translations` VALUES("3712", "uz", "ms", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3713", "vi", "en", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3714", "vi", "es", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3715", "vi", "de", "Vietnamesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3716", "vi", "fr", "Vietnamien");
INSERT INTO `wp_icl_languages_translations` VALUES("3717", "vi", "ar", "الفيتنامية");
INSERT INTO `wp_icl_languages_translations` VALUES("3718", "vi", "bs", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3719", "vi", "bg", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3720", "vi", "ca", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3721", "vi", "cs", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3722", "vi", "sk", "Vietnamčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3723", "vi", "cy", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3724", "vi", "da", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3725", "vi", "el", "Βιετναμεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3726", "vi", "eo", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3727", "vi", "et", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3728", "vi", "eu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3729", "vi", "fa", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3730", "vi", "fi", "vietnam");
INSERT INTO `wp_icl_languages_translations` VALUES("3731", "vi", "ga", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3732", "vi", "he", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3733", "vi", "hi", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3734", "vi", "hr", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3735", "vi", "hu", "vietnámi");
INSERT INTO `wp_icl_languages_translations` VALUES("3736", "vi", "hy", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3737", "vi", "id", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3738", "vi", "is", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3739", "vi", "it", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3740", "vi", "ja", "ベトナム語");
INSERT INTO `wp_icl_languages_translations` VALUES("3741", "vi", "ko", "베트남어");
INSERT INTO `wp_icl_languages_translations` VALUES("3742", "vi", "ku", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3743", "vi", "la", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3744", "vi", "lv", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3745", "vi", "lt", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3746", "vi", "mk", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3747", "vi", "mt", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3748", "vi", "mo", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3749", "vi", "mn", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3750", "vi", "ne", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3751", "vi", "nl", "Vietnamees");
INSERT INTO `wp_icl_languages_translations` VALUES("3752", "vi", "nb", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3753", "vi", "pa", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3754", "vi", "pl", "wietnamski");
INSERT INTO `wp_icl_languages_translations` VALUES("3755", "vi", "pt-pt", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3756", "vi", "pt-br", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3757", "vi", "qu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3758", "vi", "ro", "Vietnameză");
INSERT INTO `wp_icl_languages_translations` VALUES("3759", "vi", "ru", "Вьетнамский");
INSERT INTO `wp_icl_languages_translations` VALUES("3760", "vi", "sl", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3761", "vi", "so", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3762", "vi", "sq", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3763", "vi", "sr", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3764", "vi", "sv", "Vietnamesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3765", "vi", "ta", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3766", "vi", "th", "เวียดนาม");
INSERT INTO `wp_icl_languages_translations` VALUES("3767", "vi", "tr", "Vietnamca");
INSERT INTO `wp_icl_languages_translations` VALUES("3768", "vi", "uk", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3769", "vi", "ur", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3770", "vi", "uz", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3771", "vi", "vi", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3772", "vi", "yi", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3773", "vi", "zh-hans", "越南语");
INSERT INTO `wp_icl_languages_translations` VALUES("3774", "vi", "zu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3775", "vi", "zh-hant", "越南語");
INSERT INTO `wp_icl_languages_translations` VALUES("3776", "vi", "ms", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3777", "yi", "en", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3778", "yi", "es", "Yidis");
INSERT INTO `wp_icl_languages_translations` VALUES("3779", "yi", "de", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3780", "yi", "fr", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3781", "yi", "ar", "اليديشية");
INSERT INTO `wp_icl_languages_translations` VALUES("3782", "yi", "bs", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3783", "yi", "bg", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3784", "yi", "ca", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3785", "yi", "cs", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3786", "yi", "sk", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3787", "yi", "cy", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3788", "yi", "da", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3789", "yi", "el", "Γιντις");
INSERT INTO `wp_icl_languages_translations` VALUES("3790", "yi", "eo", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3791", "yi", "et", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3792", "yi", "eu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3793", "yi", "fa", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3794", "yi", "fi", "jiddi");
INSERT INTO `wp_icl_languages_translations` VALUES("3795", "yi", "ga", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3796", "yi", "he", "יידיש");
INSERT INTO `wp_icl_languages_translations` VALUES("3797", "yi", "hi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3798", "yi", "hr", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3799", "yi", "hu", "jiddis");
INSERT INTO `wp_icl_languages_translations` VALUES("3800", "yi", "hy", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3801", "yi", "id", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3802", "yi", "is", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3803", "yi", "it", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3804", "yi", "ja", "イディッシュ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3805", "yi", "ko", "이디시어");
INSERT INTO `wp_icl_languages_translations` VALUES("3806", "yi", "ku", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3807", "yi", "la", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3808", "yi", "lv", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3809", "yi", "lt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3810", "yi", "mk", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3811", "yi", "mt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3812", "yi", "mo", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3813", "yi", "mn", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3814", "yi", "ne", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3815", "yi", "nl", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3816", "yi", "nb", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3817", "yi", "pa", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3818", "yi", "pl", "jidysz");
INSERT INTO `wp_icl_languages_translations` VALUES("3819", "yi", "pt-pt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3820", "yi", "pt-br", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3821", "yi", "qu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3822", "yi", "ro", "Idiş");
INSERT INTO `wp_icl_languages_translations` VALUES("3823", "yi", "ru", "Идиш");
INSERT INTO `wp_icl_languages_translations` VALUES("3824", "yi", "sl", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3825", "yi", "so", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3826", "yi", "sq", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3827", "yi", "sr", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3828", "yi", "sv", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3829", "yi", "ta", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3830", "yi", "th", "ยิชดิช");
INSERT INTO `wp_icl_languages_translations` VALUES("3831", "yi", "tr", "Eski İbranice");
INSERT INTO `wp_icl_languages_translations` VALUES("3832", "yi", "uk", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3833", "yi", "ur", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3834", "yi", "uz", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3835", "yi", "vi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3836", "yi", "yi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3837", "yi", "zh-hans", "依地语");
INSERT INTO `wp_icl_languages_translations` VALUES("3838", "yi", "zu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3839", "yi", "zh-hant", "依地語");
INSERT INTO `wp_icl_languages_translations` VALUES("3840", "yi", "ms", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3841", "zh-hans", "en", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3842", "zh-hans", "es", "Chino simplificado");
INSERT INTO `wp_icl_languages_translations` VALUES("3843", "zh-hans", "de", "Vereinfachtes Chinesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3844", "zh-hans", "fr", "Chinois simplifié");
INSERT INTO `wp_icl_languages_translations` VALUES("3845", "zh-hans", "ar", "الصينية المبسطة");
INSERT INTO `wp_icl_languages_translations` VALUES("3846", "zh-hans", "bs", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3847", "zh-hans", "bg", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3848", "zh-hans", "ca", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3849", "zh-hans", "cs", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3850", "zh-hans", "sk", "Zjednodušená Čínština");
INSERT INTO `wp_icl_languages_translations` VALUES("3851", "zh-hans", "cy", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3852", "zh-hans", "da", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3853", "zh-hans", "el", "Κινεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3854", "zh-hans", "eo", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3855", "zh-hans", "et", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3856", "zh-hans", "eu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3857", "zh-hans", "fa", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3858", "zh-hans", "fi", "kiina");
INSERT INTO `wp_icl_languages_translations` VALUES("3859", "zh-hans", "ga", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3860", "zh-hans", "he", "סינית");
INSERT INTO `wp_icl_languages_translations` VALUES("3861", "zh-hans", "hi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3862", "zh-hans", "hr", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3863", "zh-hans", "hu", "egyszerűsített kínai");
INSERT INTO `wp_icl_languages_translations` VALUES("3864", "zh-hans", "hy", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3865", "zh-hans", "id", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3866", "zh-hans", "is", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3867", "zh-hans", "it", "Cinese semplificato");
INSERT INTO `wp_icl_languages_translations` VALUES("3868", "zh-hans", "ja", "簡体中国語");
INSERT INTO `wp_icl_languages_translations` VALUES("3869", "zh-hans", "ko", "중국어 간체");
INSERT INTO `wp_icl_languages_translations` VALUES("3870", "zh-hans", "ku", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3871", "zh-hans", "la", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3872", "zh-hans", "lv", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3873", "zh-hans", "lt", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3874", "zh-hans", "mk", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3875", "zh-hans", "mt", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3876", "zh-hans", "mo", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3877", "zh-hans", "mn", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3878", "zh-hans", "ne", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3879", "zh-hans", "nl", "Vereenvoudigd Chinees");
INSERT INTO `wp_icl_languages_translations` VALUES("3880", "zh-hans", "nb", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3881", "zh-hans", "pa", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3882", "zh-hans", "pl", "chiński uproszczony");
INSERT INTO `wp_icl_languages_translations` VALUES("3883", "zh-hans", "pt-pt", "Chinês");
INSERT INTO `wp_icl_languages_translations` VALUES("3884", "zh-hans", "pt-br", "Chinês");
INSERT INTO `wp_icl_languages_translations` VALUES("3885", "zh-hans", "qu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3886", "zh-hans", "ro", "Chineza simplificată");
INSERT INTO `wp_icl_languages_translations` VALUES("3887", "zh-hans", "ru", "Упрощенный китайский");
INSERT INTO `wp_icl_languages_translations` VALUES("3888", "zh-hans", "sl", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3889", "zh-hans", "so", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3890", "zh-hans", "sq", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3891", "zh-hans", "sr", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3892", "zh-hans", "sv", "Förenklad kinesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3893", "zh-hans", "ta", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3894", "zh-hans", "th", "จีนประยุกต์");
INSERT INTO `wp_icl_languages_translations` VALUES("3895", "zh-hans", "tr", "Modern Çince");
INSERT INTO `wp_icl_languages_translations` VALUES("3896", "zh-hans", "uk", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3897", "zh-hans", "ur", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3898", "zh-hans", "uz", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3899", "zh-hans", "vi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3900", "zh-hans", "yi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3901", "zh-hans", "zh-hans", "简体中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3902", "zh-hans", "zu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3903", "zh-hans", "zh-hant", "簡體中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3904", "zh-hans", "ms", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3905", "zu", "en", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3906", "zu", "es", "Zulú");
INSERT INTO `wp_icl_languages_translations` VALUES("3907", "zu", "de", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3908", "zu", "fr", "Zoulou");
INSERT INTO `wp_icl_languages_translations` VALUES("3909", "zu", "ar", "الزولو");
INSERT INTO `wp_icl_languages_translations` VALUES("3910", "zu", "bs", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3911", "zu", "bg", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3912", "zu", "ca", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3913", "zu", "cs", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3914", "zu", "sk", "Jazyk Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3915", "zu", "cy", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3916", "zu", "da", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3917", "zu", "el", "Ζουλου");
INSERT INTO `wp_icl_languages_translations` VALUES("3918", "zu", "eo", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3919", "zu", "et", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3920", "zu", "eu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3921", "zu", "fa", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3922", "zu", "fi", "zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3923", "zu", "ga", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3924", "zu", "he", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3925", "zu", "hi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3926", "zu", "hr", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3927", "zu", "hu", "zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3928", "zu", "hy", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3929", "zu", "id", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3930", "zu", "is", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3931", "zu", "it", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3932", "zu", "ja", "ズールー語");
INSERT INTO `wp_icl_languages_translations` VALUES("3933", "zu", "ko", "줄루어");
INSERT INTO `wp_icl_languages_translations` VALUES("3934", "zu", "ku", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3935", "zu", "la", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3936", "zu", "lv", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3937", "zu", "lt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3938", "zu", "mk", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3939", "zu", "mt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3940", "zu", "mo", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3941", "zu", "mn", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3942", "zu", "ne", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3943", "zu", "nl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3944", "zu", "nb", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3945", "zu", "pa", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3946", "zu", "pl", "zuluski");
INSERT INTO `wp_icl_languages_translations` VALUES("3947", "zu", "pt-pt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3948", "zu", "pt-br", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3949", "zu", "qu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3950", "zu", "ro", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3951", "zu", "ru", "Зулу");
INSERT INTO `wp_icl_languages_translations` VALUES("3952", "zu", "sl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3953", "zu", "so", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3954", "zu", "sq", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3955", "zu", "sr", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3956", "zu", "sv", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3957", "zu", "ta", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3958", "zu", "th", "ซูลู");
INSERT INTO `wp_icl_languages_translations` VALUES("3959", "zu", "tr", "Zulu dili");
INSERT INTO `wp_icl_languages_translations` VALUES("3960", "zu", "uk", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3961", "zu", "ur", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3962", "zu", "uz", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3963", "zu", "vi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3964", "zu", "yi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3965", "zu", "zh-hans", "祖鲁语");
INSERT INTO `wp_icl_languages_translations` VALUES("3966", "zu", "zu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3967", "zu", "zh-hant", "祖魯語");
INSERT INTO `wp_icl_languages_translations` VALUES("3968", "zu", "ms", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3969", "zh-hant", "en", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3970", "zh-hant", "es", "Chino tradicional");
INSERT INTO `wp_icl_languages_translations` VALUES("3971", "zh-hant", "de", "Traditionelles Chinesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3972", "zh-hant", "fr", "Chinois traditionnel");
INSERT INTO `wp_icl_languages_translations` VALUES("3973", "zh-hant", "ar", "الصينية التقليدية");
INSERT INTO `wp_icl_languages_translations` VALUES("3974", "zh-hant", "bs", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3975", "zh-hant", "bg", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3976", "zh-hant", "ca", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3977", "zh-hant", "cs", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3978", "zh-hant", "sk", "Tradičná Čínština");
INSERT INTO `wp_icl_languages_translations` VALUES("3979", "zh-hant", "cy", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3980", "zh-hant", "da", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3981", "zh-hant", "el", "Κινεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3982", "zh-hant", "eo", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3983", "zh-hant", "et", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3984", "zh-hant", "eu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3985", "zh-hant", "fa", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3986", "zh-hant", "fi", "perinteinen kiina");
INSERT INTO `wp_icl_languages_translations` VALUES("3987", "zh-hant", "ga", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3988", "zh-hant", "he", "סינית מסורתית");
INSERT INTO `wp_icl_languages_translations` VALUES("3989", "zh-hant", "hi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3990", "zh-hant", "hr", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3991", "zh-hant", "hu", "hagyományos kínai");
INSERT INTO `wp_icl_languages_translations` VALUES("3992", "zh-hant", "hy", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3993", "zh-hant", "id", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3994", "zh-hant", "is", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3995", "zh-hant", "it", "Cinese tradizionale");
INSERT INTO `wp_icl_languages_translations` VALUES("3996", "zh-hant", "ja", "繁体中国語");
INSERT INTO `wp_icl_languages_translations` VALUES("3997", "zh-hant", "ko", "중국어 번체");
INSERT INTO `wp_icl_languages_translations` VALUES("3998", "zh-hant", "ku", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3999", "zh-hant", "la", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4000", "zh-hant", "lv", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4001", "zh-hant", "lt", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4002", "zh-hant", "mk", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4003", "zh-hant", "mt", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4004", "zh-hant", "mo", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4005", "zh-hant", "mn", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4006", "zh-hant", "ne", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4007", "zh-hant", "nl", "Traditioneel Chinees");
INSERT INTO `wp_icl_languages_translations` VALUES("4008", "zh-hant", "nb", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4009", "zh-hant", "pa", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4010", "zh-hant", "pl", "chiński tradycyjny");
INSERT INTO `wp_icl_languages_translations` VALUES("4011", "zh-hant", "pt-pt", "Chinês");
INSERT INTO `wp_icl_languages_translations` VALUES("4012", "zh-hant", "pt-br", "Chinês");
INSERT INTO `wp_icl_languages_translations` VALUES("4013", "zh-hant", "qu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4014", "zh-hant", "ro", "Chineza tradiţională");
INSERT INTO `wp_icl_languages_translations` VALUES("4015", "zh-hant", "ru", "Традиционный китайский");
INSERT INTO `wp_icl_languages_translations` VALUES("4016", "zh-hant", "sl", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4017", "zh-hant", "so", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4018", "zh-hant", "sq", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4019", "zh-hant", "sr", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4020", "zh-hant", "sv", "Traditionell kinesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("4021", "zh-hant", "ta", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4022", "zh-hant", "th", "จีนดั้งเดิม");
INSERT INTO `wp_icl_languages_translations` VALUES("4023", "zh-hant", "tr", "Klasik Çince");
INSERT INTO `wp_icl_languages_translations` VALUES("4024", "zh-hant", "uk", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4025", "zh-hant", "ur", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4026", "zh-hant", "uz", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4027", "zh-hant", "vi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4028", "zh-hant", "yi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4029", "zh-hant", "zh-hans", "繁体中文");
INSERT INTO `wp_icl_languages_translations` VALUES("4030", "zh-hant", "zu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4031", "zh-hant", "zh-hant", "繁體中文");
INSERT INTO `wp_icl_languages_translations` VALUES("4032", "zh-hant", "ms", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("4033", "ms", "en", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4034", "ms", "es", "Malayo");
INSERT INTO `wp_icl_languages_translations` VALUES("4035", "ms", "de", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4036", "ms", "fr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4037", "ms", "ar", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4038", "ms", "bs", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4039", "ms", "bg", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4040", "ms", "ca", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4041", "ms", "cs", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4042", "ms", "sk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4043", "ms", "cy", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4044", "ms", "da", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4045", "ms", "el", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4046", "ms", "eo", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4047", "ms", "et", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4048", "ms", "eu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4049", "ms", "fa", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4050", "ms", "fi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4051", "ms", "ga", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4052", "ms", "he", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4053", "ms", "hi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4054", "ms", "hr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4055", "ms", "hu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4056", "ms", "hy", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4057", "ms", "id", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4058", "ms", "is", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4059", "ms", "it", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4060", "ms", "ja", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4061", "ms", "ko", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4062", "ms", "ku", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4063", "ms", "la", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4064", "ms", "lv", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4065", "ms", "lt", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4066", "ms", "mk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4067", "ms", "mt", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4068", "ms", "mo", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4069", "ms", "mn", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4070", "ms", "ne", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4071", "ms", "nl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4072", "ms", "nb", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4073", "ms", "pa", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4074", "ms", "pl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4075", "ms", "pt-pt", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4076", "ms", "pt-br", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4077", "ms", "qu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4078", "ms", "ro", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4079", "ms", "ru", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4080", "ms", "sl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4081", "ms", "so", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4082", "ms", "sq", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4083", "ms", "sr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4084", "ms", "sv", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4085", "ms", "ta", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4086", "ms", "th", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4087", "ms", "tr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4088", "ms", "uk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4089", "ms", "ur", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4090", "ms", "uz", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4091", "ms", "vi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4092", "ms", "yi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4093", "ms", "zh-hans", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4094", "ms", "zu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4095", "ms", "zh-hant", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("4096", "ms", "ms", "Melayu");

/* INSERT TABLE DATA: wp_icl_locale_map */
INSERT INTO `wp_icl_locale_map` VALUES("en", "en_US");
INSERT INTO `wp_icl_locale_map` VALUES("fr", "fr_FR");
INSERT INTO `wp_icl_locale_map` VALUES("zh-hans", "zh_CN");

/* INSERT TABLE DATA: wp_icl_translate */
INSERT INTO `wp_icl_translate` VALUES("1", "1", "0", "2014-10-29 14:57:28", "title", "base64", "1", "Q2FiaW5ldCBkJ2F2b2NhdHMgZW4gZHJvaXQgZGVzIGFmZmFpcmVzIMOgIFRvdWxvdXNl", "TGVnYWwgZmlybSBzcGVjaWFsaXppbmcgaW4gYnVzaW5lc3MgbGF3IGluIFRvdWxvdXNl", "1");
INSERT INTO `wp_icl_translate` VALUES("2", "1", "0", "2014-10-29 14:57:28", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("3", "1", "0", "2014-10-29 14:57:28", "original_id", "", "0", "6575", "", "1");
INSERT INTO `wp_icl_translate` VALUES("4", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_title", "base64", "1", "Q2FiaW5ldCBkJ2F2b2NhdHMgZW4gZHJvaXQgZGVzIGFmZmFpcmVzIMOgIFRvdWxvdXNl", "", "1");
INSERT INTO `wp_icl_translate` VALUES("5", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("6", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("7", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_metadesc", "base64", "1", "U3DDqWNpYWxpc8OpIGVuIGRyb2l0IGRlcyBhZmZhaXJlcywgbGUgY2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgaW50ZXJ2aWVudCB0YW50IGVuIG1hdGnDqHJlIGRlIGNvbnNlaWwgcXVlIGRlIGNvbnRlbnRpZXV4IGF1cHLDqHMgZGVzIGVudHJlcHJpc2VzIMOgIFRvdWxvdXNlLg==", "TGVnYWwgZmlybSBzcGVjaWFsaXppbmcgaW4gYnVzaW5lc3MgbGF3IGluIFRvdWxvdXNl", "1");
INSERT INTO `wp_icl_translate` VALUES("8", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("9", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("10", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_focuskw", "base64", "1", "ZHJvaXQgZGVzIGFmZmFpcmVz", "YnVzaW5lc3MgTGF3", "1");
INSERT INTO `wp_icl_translate` VALUES("11", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("12", "1", "0", "2014-10-29 14:57:28", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("13", "2", "0", "2014-10-29 16:36:48", "title", "base64", "1", "QWNjb21wYWduZW1lbnQ=", "QXNzaXN0YW5jZQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("14", "2", "0", "2014-10-29 16:36:48", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("15", "2", "0", "2014-10-29 16:36:48", "original_id", "", "0", "13188", "", "1");
INSERT INTO `wp_icl_translate` VALUES("16", "2", "0", "2014-10-29 16:36:48", "field-_yoast_wpseo_metadesc", "base64", "1", "TCdhY2NvbXBhZ25lbWVudCBkZXMgZW50cmVwcmVuZXVycyBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgZXN0IGxlIGZvbmRlbWVudCBwcmluY2lwYWwgZGUgbCdhY3Rpdml0w6kgZHUgQ2FiaW5ldCAtIG5vcyBkb21haW5lcyBkZSBjb21ww6l0ZW5jZXMgOiBmaXNjYWxpdMOpLCBkcm9pdCBkZXMgc29jacOpdMOpcywgZHJvaXQgY29tbWVyY2lhbCwgdHJhbnNtaXNzaW9uIGQnZW50cmVwcmlzZXMu", "", "1");
INSERT INTO `wp_icl_translate` VALUES("17", "2", "0", "2014-10-29 16:36:48", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("18", "2", "0", "2014-10-29 16:36:48", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("19", "2", "0", "2014-10-29 16:36:48", "field-_yoast_wpseo_focuskw", "base64", "1", "YWNjb21wYWduZW1lbnQ=", "YnVzaW5lc3MgbGF3", "1");
INSERT INTO `wp_icl_translate` VALUES("20", "2", "0", "2014-10-29 16:36:48", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("21", "2", "0", "2014-10-29 16:36:48", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("22", "3", "0", "2014-10-29 17:02:48", "title", "base64", "1", "RXhwZXJ0aXNlcyAtIGF2b2NhdHMgw6AgVG91bG91c2U=", "RXhwZXJ0aXNlIGluIGJ1c2luZXNzIGxhdw==", "1");
INSERT INTO `wp_icl_translate` VALUES("23", "3", "0", "2014-10-29 17:02:48", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("24", "3", "0", "2014-10-29 17:02:48", "original_id", "", "0", "1195", "", "1");
INSERT INTO `wp_icl_translate` VALUES("25", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_title", "base64", "1", "QXZvY2F0cyDDoCBUb3Vsb3VzZSAtIEV4cGVydGlzZXMgZW4gZHJvaXQgZGVzIGFmZmFpcmVz", "", "1");
INSERT INTO `wp_icl_translate` VALUES("26", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("27", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("28", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_metadesc", "base64", "1", "QSB0cmF2ZXJzIHNlcyBkaWZmw6lyZW50cyBkw6lwYXJ0ZW1lbnRzLCBsZSBjYWJpbmV0IGQnYXZvY2F0cyDDoCBUb3Vsb3VzZSBpbnRlcnZpZW50IHRhbnQgZW4gbWF0acOocmUgZGUgY29uc2VpbCBxdWUgZGUgY29udGVudGlldXggYXVwcsOocyBkZSBzYSBjbGllbnTDqGxlIHByby4=", "", "1");
INSERT INTO `wp_icl_translate` VALUES("29", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("30", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("31", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_focuskw", "base64", "1", "QXZvY2F0cyDDoCBUb3Vsb3VzZQ==", "", "1");
INSERT INTO `wp_icl_translate` VALUES("32", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("33", "3", "0", "2014-10-29 17:02:48", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("34", "4", "0", "2014-10-29 19:32:24", "title", "base64", "1", "RMOpcGFydGVtZW50IGNvbnRlbnRpZXV4IGV0IGRyb2l0IGludGVybmF0aW9uYWw=", "TGl0aWdhdGlvbuKAk0ludGVybmF0aW9uYWwgTGF3IERlcGFydG1lbnQ=", "1");
INSERT INTO `wp_icl_translate` VALUES("35", "4", "0", "2014-10-29 19:32:24", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("36", "4", "0", "2014-10-29 19:32:24", "original_id", "", "0", "12199", "", "1");
INSERT INTO `wp_icl_translate` VALUES("37", "4", "0", "2014-10-29 19:32:24", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgQ2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgcmVwcsOpc2VudGUgc2VzIGNsaWVudHMgcG91ciB0b3V0IGNvbnRlbnRpZXV4IGRldmFudCBsZXMganVyaWRpY3Rpb25zIGNpdmlsZXMsIHDDqW5hbGVzIGV0IGNvbW1lcmNpYWxlcyBuYXRpb25hbGVzIGV0IGV1cm9ww6llbm5lcy4=", "", "1");
INSERT INTO `wp_icl_translate` VALUES("38", "4", "0", "2014-10-29 19:32:24", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("39", "4", "0", "2014-10-29 19:32:24", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("40", "4", "0", "2014-10-29 19:32:24", "field-_yoast_wpseo_focuskw", "base64", "1", "Y29udGVudGlldXg=", "TGl0aWdhdGlvbiBMYXc=", "1");
INSERT INTO `wp_icl_translate` VALUES("41", "4", "0", "2014-10-29 19:32:24", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("42", "4", "0", "2014-10-29 19:32:24", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("43", "5", "0", "2014-10-30 09:38:22", "title", "base64", "1", "RMOpcGFydGVtZW50IENvcnBvcmF0ZSAtIEZpbmFuY2U=", "Q29ycG9yYXRlIC0gRmluYW5jZSBEZXBhcnRtZW50", "1");
INSERT INTO `wp_icl_translate` VALUES("44", "5", "0", "2014-10-30 09:38:22", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("45", "5", "0", "2014-10-30 09:38:22", "original_id", "", "0", "12207", "", "1");
INSERT INTO `wp_icl_translate` VALUES("46", "5", "0", "2014-10-30 09:38:22", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgQ2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgaW50ZXJ2aWVudCBzdXIgZGVzIG9ww6lyYXRpb25zIGRlIGZpbmFuY2VtZW50LCBkZSBjb3Jwb3JhdGUgZmluYW5jZSwgTEJPLCBwcml2YXRlIGVxdWl0eSwgZnVzaW9uLWFjcXVpc2l0aW9uLg==", "", "1");
INSERT INTO `wp_icl_translate` VALUES("47", "5", "0", "2014-10-30 09:38:22", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("48", "5", "0", "2014-10-30 09:38:22", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("49", "5", "0", "2014-10-30 09:38:22", "field-_yoast_wpseo_focuskw", "base64", "1", "Y29ycG9yYXRl", "Y29ycG9yYXRlIGZpbmFuY2U=", "1");
INSERT INTO `wp_icl_translate` VALUES("50", "5", "0", "2014-10-30 09:38:22", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("51", "5", "0", "2014-10-30 09:38:22", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("52", "6", "0", "2014-10-30 09:53:16", "title", "base64", "1", "RHJvaXQgZmlzY2FsICYgR2VzdGlvbiBkZSBQYXRyaW1vaW5l", "VGF4IExhdyAtIFdlYWx0aCBNYW5hZ2VtZW50IERlcGFydG1lbnQ=", "1");
INSERT INTO `wp_icl_translate` VALUES("53", "6", "0", "2014-10-30 09:53:16", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("54", "6", "0", "2014-10-30 09:53:16", "original_id", "", "0", "12205", "", "1");
INSERT INTO `wp_icl_translate` VALUES("55", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_title", "base64", "1", "QXZvY2F0IMOgIFRvdWxvdXNlIC0gRHJvaXQgZmlzY2FsIC0gR0FOTkUgJiBBVk9DQVRT", "TGVnYWwgZmlybSBzcGVjaWFsaXppbmcgaW4gYnVzaW5lc3MgbGF3IGluIFRvdWxvdXNlIC0gVGF4IGxhdyAtIEdBTk5FICYgQVZPQ0FUUw==", "1");
INSERT INTO `wp_icl_translate` VALUES("56", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("57", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("58", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBhc3Npc3RlIGxlcyBlbnRyZXByaXNlcyBlbiBkcm9pdCBmaXNjYWwgbG9ycyBkZSB0cmFuc2FjdGlvbnMgY29ycG9yYXRlLCBpbW1vYmlsacOocmVzIGV0IGZpbmFuY2nDqHJlcy4=", "VGhlIGZpcm0gb2ZmZXJzIGNvbXBhbmllcyB0YXggbGF3IGFzc2lzdGFuY2UgZm9yIGNvcnBvcmF0ZSwgcHJvcGVydHkgYW5kIGZpbmFuY2lhbCB0cmFuc2FjdGlvbnMu", "1");
INSERT INTO `wp_icl_translate` VALUES("59", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("60", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("61", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_focuskw", "base64", "1", "ZHJvaXQgZmlzY2Fs", "VGF4IGxhdw==", "1");
INSERT INTO `wp_icl_translate` VALUES("62", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("63", "6", "0", "2014-10-30 09:53:16", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("64", "7", "0", "2014-10-30 10:04:05", "title", "base64", "1", "UmVzdHJ1Y3R1cmluZyBldCBlbnRyZXByaXNlIGVuIGRpZmZpY3VsdMOp", "UmVzdHJ1Y3R1cmluZyDigJMgSW5zb2x2ZW5jeSBEZXBhcnRtZW50", "1");
INSERT INTO `wp_icl_translate` VALUES("65", "7", "0", "2014-10-30 10:04:05", "body", "base64", "1", "W2JveGVkX2NvbnRlbnQgdHlwZT0id2hpdGVzdHJva2UiIGN1c3RvbV9iZ19jb2xvdXI9IiNmZmZmZmYiIHBiX21hcmdpbl9ib3R0b209Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdDQoNCltvbmVfdGhpcmRdDQoNCjxhIHRpdGxlPSJWb2lyIGxhIGZpY2hlIGRlIEx1Y2lsZSBDQUxNRVRURSIgaHJlZj0iLi4vLi4vP3RlYW09bHVjaWxlLWNhbG1ldHRlIj48aW1nIHNyYz0iLi4vLi4vd3AtY29udGVudC91cGxvYWRzLzIwMTQvMDEvQ2FiaW5ldF9HYW5uZS1Bdm9jYXRzX0x1Y2llLUNhbG1ldHRlX2NhcnJlLWNvdWxldXItMTUweDE1MC5qcGciIGFsdD0iQ2FiaW5ldCBHYW5uZSAmYW1wOyBBdm9jYXRzIC0gTHVjaWUtQ2FsbWV0dGUiIHdpZHRoPSIxNTAiIGhlaWdodD0iMTUwIiAvPjwvYT4NCg0KWy9vbmVfdGhpcmRdDQpbdHdvX3RoaXJkX2xhc3RdDQo8aDQ+UmVzcG9uc2FibGUgZHUgRMOpcGFydGVtZW50IFJlc3RydWN0dXJpbmcgLSBFbnRyZXByaXNlcyBlbiBkaWZmaWN1bHTDqTwvaDQ+DQpNYcOudHJlIEx1Y2lsZSBDQUxNRVRURQ0KDQo8YSB0aXRsZT0iUmV0cm91dmV6IGxhIGZpY2hlIGRlIEx1Y2lsZSBDYWxtZXR0ZSIgaHJlZj0iLi4vLi4vP3RlYW09bHVjaWxlLWNhbG1ldHRlIj48aSBjbGFzcz0iZmEtYW5nbGUtcmlnaHQiPjwvaT4gVm9pciBlbiBkw6l0YWlsPC9hPg0KDQpbL3R3b190aGlyZF9sYXN0XQ0KDQpbL2JveGVkX2NvbnRlbnRdIFtibGFua19zcGFjZXIgaGVpZ2h0PSIzMHB4IiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdIFtib3hlZF9jb250ZW50IHR5cGU9IndoaXRlc3Ryb2tlIiBjdXN0b21fYmdfY29sb3VyPSIjZjJmMmYyIiBwYl9tYXJnaW5fYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPGg0IHN0eWxlPSJ0ZXh0LWFsaWduOiBsZWZ0OyI+TOKAmWFjdGl2aXTDqSBkdSBjYWJpbmV0IEdBTk5FICZhbXA7IEFWT0NBVFMgY291dnJlIGzigJllbnNlbWJsZSBkZXMgbWlzc2lvbnMgZOKAmWFzc2lzdGFuY2UgZXQgZGUgY29uc2VpbCBkYW5zIGxlIGNhZHJlIGRlIGxhIHByw6l2ZW50aW9uIGV0IGR1IHRyYWl0ZW1lbnQgZGVzIGRpZmZpY3VsdMOpcyBkZXMgZW50cmVwcmlzZXMuPC9oND4NClsvYm94ZWRfY29udGVudF0gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjMwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9hY2NvcmRpb24gd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXSBbc3BiX2FjY29yZGlvbl90YWIgdGl0bGU9IlJlc3RydWN0dXJpbmciXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbc3BiX2FjY29yZGlvbl90YWIgdGl0bGU9IlByw6l2ZW50aW9uIl0gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPHVsPg0KCTxsaT5BaWRlIGF1IGRpYWdub3N0aWPCoDogw6l0YXQgZGUgY2Vzc2F0aW9uIGRlcyBwYWllbWVudHMsIHJlc3BvbnNhYmlsaXTDqSwgYmlsYW4gZGVzIHPDu3JldMOpcyBldCBkZSBsZXVyIGVmZmljYWNpdMOpPC9saT4NCgk8bGk+QXNzaXN0YW5jZSBldCByZXByw6lzZW50YXRpb24gZGVzIGNyw6lhbmNpZXJzIGJhbmNhaXJlcywgb2JsaWdhdGFpcmVzLCBhc3N1cmV1cnMgY3LDqWRpdHMsIGZvdXJuaXNzZXVycywgZGFucyBsZSBjYWRyZSBkZSBuw6lnb2NpYXRpb25zIGFtaWFibGVzIGRlIHJlc3RydWN0dXJhdGlvbiwgZGUgbWFuZGF0IGFkIGhvYyBldCBkZSBjb25jaWxpYXRpb25zPC9saT4NCgk8bGk+UsOpZGFjdGlvbiBkZSBsYSBkb2N1bWVudGF0aW9uIGp1cmlkaXF1ZcKgOiBwcm90b2NvbGUgZGUgY29uY2lsaWF0aW9uLCBkb2N1bWVudGF0aW9uIGRlIGxhIGRldHRlIHJlc3RydWN0dXLDqWUgZXQgZG9jdW1lbnRhdGlvbiBkZSBjcsOpZGl0LCBjZXNzaW9uIGRlIGNyw6lhbmNlcywgZGUgcGFydGljaXBhdGlvbiwgY29uc3RpdHV0aW9uIGRlIHPDu3JldMOpcywgZXRj4oCmPC9saT4NCjwvdWw+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbc3BiX2FjY29yZGlvbl90YWIgdGl0bGU9IlByb2PDqWR1cmVzIGNvbGxlY3RpdmVzIl0gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPHVsPg0KCTxsaT5Bc3Npc3RhbmNlIGRlcyBjcsOpYW5jaWVycywgZMOpY2xhcmF0aW9uIGRlIGNyw6lhbmNlcywgZMOpc2lnbmF0aW9uIGR1IGNvbnRyw7RsZXVyPC9saT4NCgk8bGk+UmVwcsOpc2VudGF0aW9uIGRlIGTDqWJpdGV1cnMsIGRlIGxldXJzIGRpcmlnZWFudHMgb3UgZGUgbGV1cnMgYWN0aW9ubmFpcmVzPC9saT4NCgk8bGk+QW5hbHlzZSBvdSBwcsOpcGFyYXRpb24gZGVzIHBsYW5zIGRlIHNhdXZlZ2FyZGUsIGRlIGNvbnRpbnVhdGlvbiBvdSBkZSBjZXNzaW9uPC9saT4NCgk8bGk+U3VpdmkgZGVzIHBvdXJzdWl0ZXMgZW4gY2FzIGRlIGxpcXVpZGF0aW9uPC9saT4NCgk8bGk+QXNzaXN0YW5jZSBkYW5zIGxlIGNhZHJlIGRlIHJhY2hhdCDDoCBsYcKgYmFycmUgZHUgVHJpYnVuYWzCoChyw6lkYWN0aW9uIGRlIGzigJlvZmZyZSwgYXNzaXN0YW5jZSBqdWRpY2lhaXJlKTwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJDb250ZW50aWV1eCJdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjx1bD4NCgk8bGk+UHJvY8OpZHVyZXMgZGV2YW50IGxlIGp1Z2UgY29tbWlzc2FpcmUsIGxlIFRyaWJ1bmFsIGRlIGNvbW1lcmNlIGV0IGxhIENvdXIgZOKAmUFwcGVsIChyZXZlbmRpY2F0aW9uLCBjb250ZXN0YXRpb24gZGUgY3LDqWFuY2VzLCByw6lzaWxpYXRpb24gZGUgY29udHJhdHMsIGNlc3Npb24gZOKAmWFjdGlmcywgZXRjLik8L2xpPg0KCTxsaT5Db250ZW50aWV1eCBkZSBsYSByZXNwb25zYWJpbGl0w6kgZGVzIGNyw6lhbmNpZXJzIGV0IGRlcyBkaXJpZ2VhbnRzPC9saT4NCjwvdWw+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbL3NwYl9hY2NvcmRpb25dIFtibGFua19zcGFjZXIgaGVpZ2h0PSIxMnB4IiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJd", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("66", "7", "0", "2014-10-30 10:04:05", "original_id", "", "0", "12202", "", "1");
INSERT INTO `wp_icl_translate` VALUES("67", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_title", "base64", "1", "QXZvY2F0cyDDoCBUb3Vsb3VzZSBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgLSBSZXN0cnVjdHVyaW5nIC0gR2FubmUgJiBBdm9jYXRz", "TGVnYWwgZmlybSBzcGVjaWFsaXppbmcgaW4gYnVzaW5lc3MgbGF3IGluIFRvdWxvdXNlIC0gUmVzdHJ1Y3R1cmluZyAtIEdBTk5FICYgQVZPQ0FUUw==", "1");
INSERT INTO `wp_icl_translate` VALUES("68", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("69", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("70", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_metadesc", "base64", "1", "TWlzc2lvbnMgZOKAmWFzc2lzdGFuY2UgZXQgZGUgY29uc2VpbCBkYW5zIGxlIGNhZHJlIGRlIGxhIHByw6l2ZW50aW9uIGV0IGR1IHRyYWl0ZW1lbnQgZGVzIGRpZmZpY3VsdMOpcyBkZXMgZW50cmVwcmlzZXMgOiByZXN0cnVjdHVyaW5nLg==", "QXNzaXN0YW5jZSBhbmQgYWR2aXNvcnkgbWlzc2lvbnMgaW4gdGhlIHByZXZlbnRpb24gYW5kIHRyZWF0bWVudCBvZiBpbnNvbHZlbmN5OiByZXN0cnVjdHVyaW5nLg==", "1");
INSERT INTO `wp_icl_translate` VALUES("71", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("72", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("73", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_focuskw", "base64", "1", "cmVzdHJ1Y3R1cmluZw==", "bGVnYWwgZmlybQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("74", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("75", "7", "0", "2014-10-30 10:04:05", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("76", "8", "0", "2014-10-30 10:05:26", "title", "base64", "1", "UmVjcnV0ZW1lbnQgZW4gZHJvaXQgZGVzIGFmZmFpcmVz", "UmVjcnVpdGluZyBpbiBidXNpbmVzcyBsYXc=", "1");
INSERT INTO `wp_icl_translate` VALUES("77", "8", "0", "2014-10-30 10:05:26", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("78", "8", "0", "2014-10-30 10:05:26", "original_id", "", "0", "11634", "", "1");
INSERT INTO `wp_icl_translate` VALUES("79", "8", "0", "2014-10-30 10:05:26", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgb2ZmcmUgZGVzIHBvc3NpYmlsaXTDqXMgZGUgY2FycmnDqHJlIGV0IGTigJnDqXZvbHV0aW9uIGZvbmTDqWVzIHN1ciBsZSBtw6lyaXRlLCBsYSByZXNwb25zYWJpbGl0w6kgZXQgbGEgcGVyc29ubmFsaXTDqS4=", "T3VyIGJ1c2luZXNzIGxhdyBmaXJtIG9mZmVycyBjYXJlZXIgYW5kIGFkdmFuY2VtZW50IG9wcG9ydHVuaXRpZXMgYmFzZWQgb24gbWVyaXQsIHJlc3BvbnNpYmlsaXR5IGFuZCBwZXJzb25hbGl0eS4=", "1");
INSERT INTO `wp_icl_translate` VALUES("80", "8", "0", "2014-10-30 10:05:26", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("81", "8", "0", "2014-10-30 10:05:26", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("82", "8", "0", "2014-10-30 10:05:26", "field-_yoast_wpseo_focuskw", "base64", "1", "ZHJvaXQgZGVzIGFmZmFpcmVz", "YnVzaW5lc3MgbGF3", "1");
INSERT INTO `wp_icl_translate` VALUES("83", "8", "0", "2014-10-30 10:05:26", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("84", "8", "0", "2014-10-30 10:05:26", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("85", "9", "0", "2014-10-30 10:23:41", "title", "base64", "1", "VHJhbnNhY3Rpb25z", "VHJhbnNhY3Rpb25z", "1");
INSERT INTO `wp_icl_translate` VALUES("86", "9", "0", "2014-10-30 10:23:41", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("87", "9", "0", "2014-10-30 10:23:41", "original_id", "", "0", "2", "", "1");
INSERT INTO `wp_icl_translate` VALUES("88", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_title", "base64", "1", "QXZvY2F0cyDDoCBUb3Vsb3VzZSAtIFRyYW5zYWN0aW9ucyAtIEdhbm5lICYgQXZvY2F0cw==", "TGF3IGZpcm0gaW4gVG91bG91c2UgLSB0cmFuc2FjdGlvbiAtIEdhbm5lICYgQXZvY2F0cw==", "1");
INSERT INTO `wp_icl_translate` VALUES("89", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("90", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("91", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_metadesc", "base64", "1", "U3DDqWNpYWxpc8OpIGVuIG1hdGnDqHJlIGRlIHRyYW5zYWN0aW9ucyBldCBkZSB0cmFuc21pc3Npb25zIGTigJllbnRyZXByaXNlcyBldCBkZSBmb25kcyBkZSBjb21tZXJjZSwgbGUgY2FiaW5ldCBlc3Qgw6Agdm90cmUgZGlzcG9zaXRpb24gcG91ciB2b3VzIGFjY29tcGFnbmVyLg==", "U3BlY2lhbGl6aW5nIGluIHRyYW5zYWN0aW9ucyBhbmQgaW4gdHJhbnNtaXNzaW9ucyBvZiBidXNpbmVzcyBvd25lcnNoaXAgYW5kIGFzc2V0cywgdGhlIGZpcm0gaXMgYXZhaWxhYmxlIHRvIGFzc2lzdCB5b3Uu", "1");
INSERT INTO `wp_icl_translate` VALUES("92", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("93", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("94", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_focuskw", "base64", "1", "dHJhbnNhY3Rpb25z", "dHJhbnNhY3Rpb24=", "1");
INSERT INTO `wp_icl_translate` VALUES("95", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("96", "9", "0", "2014-10-30 10:23:41", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("174", "20", "0", "2014-11-04 14:19:52", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("97", "10", "0", "2014-10-30 10:31:51", "title", "base64", "1", "SW5mb3JtYXRpb25zIGzDqWdhbGVz", "TGVnYWwgSW5mb3JtYXRpb24=", "1");
INSERT INTO `wp_icl_translate` VALUES("98", "10", "0", "2014-10-30 10:31:51", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("99", "10", "0", "2014-10-30 10:31:51", "original_id", "", "0", "12117", "", "1");
INSERT INTO `wp_icl_translate` VALUES("100", "11", "0", "2014-10-30 10:50:21", "title", "base64", "1", "QWN0dWFsaXTDqXM=", "UmVjZW50IE5ld3M=", "1");
INSERT INTO `wp_icl_translate` VALUES("101", "11", "0", "2014-10-30 10:50:21", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("102", "11", "0", "2014-10-30 10:50:21", "original_id", "", "0", "12154", "", "1");
INSERT INTO `wp_icl_translate` VALUES("103", "11", "0", "2014-10-30 10:50:21", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBlc3Qgb3V2ZXJ0IMOgIGwnw6l2b2x1dGlvbiBkdSBtb25kZSBkZXMgYWZmYWlyZXMgdGFudCBlbiBtYXRpw6hyZSBkJ8OpY2hhbmdlIGludGVybmF0aW9uYXV4IGV0IGQnaW5ub3ZhdGlvbiBkZXMgbW9kZXMgZGUgZMOpdmVsb3BwZW1lbnQgZHUgY29tbWVyY2Uu", "T3VyIGZpcm0ga2VlcHMgYSBjbG9zZSBleWUgb24gY2hhbmdlcyBpbiB0aGUgYnVzaW5lc3Mgd29ybGQgYm90aCBhcyBjb25jZXJucyBpbnRlcm5hdGlvbmFsIHRyYWRlIGFuZCBpbm5vdmF0aW9ucyBpbiB0aGUgZGV2ZWxvcG1lbnQgb2YgdHJhZGUu", "1");
INSERT INTO `wp_icl_translate` VALUES("104", "11", "0", "2014-10-30 10:50:21", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("105", "11", "0", "2014-10-30 10:50:21", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("106", "11", "0", "2014-10-30 10:50:21", "field-_yoast_wpseo_focuskw", "base64", "1", "YXZvY2F0", "TmV3cw==", "1");
INSERT INTO `wp_icl_translate` VALUES("107", "11", "0", "2014-10-30 10:50:21", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("108", "11", "0", "2014-10-30 10:50:21", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("109", "12", "0", "2014-10-30 10:56:55", "title", "base64", "1", "Q29udGFjdA==", "Q29udGFjdA==", "1");
INSERT INTO `wp_icl_translate` VALUES("110", "12", "0", "2014-10-30 10:56:55", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209InllcyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIyLzMiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQo8aDE+Tm91cyDDqWNyaXJlPC9oMT4NCltjb250YWN0LWZvcm0tNyBpZD0iNyIgdGl0bGU9IkZvcm11bGFpcmUgZGUgY29udGFjdCAxIl0NCg0KWy9zcGJfdGV4dF9ibG9ja10gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMyIgZWxfcG9zaXRpb249Imxhc3QiXQ0KPGgzIGNsYXNzPSJtdDAiPltpY29uIGltYWdlPSJmYS1tYXAtbWFya2VyIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdQWRyZXNzZSA6PC9oMz4NCjU1LCBhdmVudWUgTG91aXMgQnJlZ3VldA0KQsOidCBIZXJtw6hzIC0gNGUgw4l0YWdlDQozMTQwMCBUT1VMT1VTRQ0KPGgzPltpY29uIGltYWdlPSJzcy1jaGF0IiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdRMOpdGFpbHMgOjwvaDM+DQpUw6lsLiA6ICszMyAoMCk1LjYxLjMyLjY2LjkyDQpGYXggOiArMzMgKDApNS42MS41Mi4zNC43MA0KRW1haWwgOiBjb250YWN0QGdhbm5lLWF2b2NhdHMuY29tDQo8aDM+W2ljb24gaW1hZ2U9InNzLWNsb2NrIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdSG9yYWlyZXMgZCdvdXZlcnR1cmVzIDo8L2gzPg0KPHAgYWxpZ249ImxlZnQiPmR1IGx1bmRpIGF1IHZlbmRyZWRpIGRlIDloMDAgw6AgMTJoMzANCmV0IGRlIDE0aDAwIMOgIDE4aDMwPC9wPg0KWy9zcGJfdGV4dF9ibG9ja10gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjIwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW2RpdmlkZXIgdHlwZT0iZ29fdG9fdG9wX2ljb24xIiB0ZXh0PSJHbyB0byB0b3AiIGZ1bGxfd2lkdGg9Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJd", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209InllcyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIyLzMiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQo8aDE+V3JpdGUgdG8gdXM8L2gxPg0KW2NvbnRhY3QtZm9ybS03IGlkPSIxMzcxMSIgdGl0bGU9IkZvcm11bGFpcmUgZGUgY29udGFjdCBFTiJdDQoNClsvc3BiX3RleHRfYmxvY2tdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzMiIGVsX3Bvc2l0aW9uPSJsYXN0Il0NCjxoMyBjbGFzcz0ibXQwIj5baWNvbiBpbWFnZT0iZmEtbWFwLW1hcmtlciIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXUFkZHJlc3M6PC9oMz4NCjU1LCBhdmVudWUgTG91aXMgQnJlZ3VldA0KQsOidCBIZXJtw6hzIC0gNGUgw4l0YWdlDQozMTQwMCBUT1VMT1VTRQ0KRnJhbmNlDQo8aDM+W2ljb24gaW1hZ2U9InNzLWNoYXQiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il1Db250YWN0IGRldGFpbHM6PC9oMz4NClTDqWwuIDogKzMzICgwKTUuNjEuMzIuNjYuOTINCkZheCA6ICszMyAoMCk1LjYxLjUyLjM0LjcwDQpFbWFpbCA6IGNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb20NCjxoMz5baWNvbiBpbWFnZT0ic3MtY2xvY2siIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il1CdXNpbmVzcyBob3VyczwvaDM+DQo8cCBhbGlnbj0ibGVmdCI+TW9uZGF5IHRvIEZyaWRheSBmcm9tIDlBTSB0byAxMjozMA0KYW5kIDJQTSB0byA2OjYwUE08L3A+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbYmxhbmtfc3BhY2VyIGhlaWdodD0iMjBweCIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=", "1");
INSERT INTO `wp_icl_translate` VALUES("111", "12", "0", "2014-10-30 10:56:55", "original_id", "", "0", "6796", "", "1");
INSERT INTO `wp_icl_translate` VALUES("112", "12", "0", "2014-10-30 10:56:55", "field-_yoast_wpseo_metadesc", "base64", "1", "UsOpcG9uZCDDoCB0b3V0ZXMgdm9zIGludGVycm9nYXRpb25zIGVuIGRyb2l0IGRlcyBhZmZhaXJlcywgY29udGVudGlldXgsIGZpc2NhbGl0w6ksIHBhdHJpbW9pbmUgZXQgZ2VzdGlvbiBkZXMgZGlmZmljdWx0w6lzIGQnZW50cmVwcmlzZSDDoCBUb3Vsb3VzZS4=", "KzMzICgwKTUuNjEuMzIuNjYuOTIgb3IgY29udGFjdEBnYW5uZS1hdm9jYXRzLmNvbQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("113", "12", "0", "2014-10-30 10:56:55", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("114", "12", "0", "2014-10-30 10:56:55", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("115", "12", "0", "2014-10-30 10:56:55", "field-_yoast_wpseo_focuskw", "base64", "1", "YXZvY2F0", "", "1");
INSERT INTO `wp_icl_translate` VALUES("116", "12", "0", "2014-10-30 10:56:55", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("117", "12", "0", "2014-10-30 10:56:55", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("118", "13", "0", "2014-10-30 11:46:41", "title", "base64", "1", "QWNxdcOpcmV1cg==", "QnV5ZXI=", "1");
INSERT INTO `wp_icl_translate` VALUES("119", "13", "0", "2014-10-30 11:46:41", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5Qb3VyIG1pZXV4IHLDqXBvbmRyZSDDoCB2b3RyZSBiZXNvaW4sIG5vdXMgdm91cyBwcm9wb3NvbnMgZGUgY29tcGzDqXRlciBsZSBmb3JtdWxhaXJlIGNpLWRlc3NvdXMuPC9oMz4NCltjb250YWN0LWZvcm0tNyBpZD0iMTIxMDAiIHRpdGxlPSJWb3VzIMOqdGVzIGFjcXXDqXJldXIiXQ0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS80IiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDE+W2ljb24gaW1hZ2U9InNzLWJ1c2luZXNzdXNlciIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXVZvdXMgw6p0ZXMgVmVuZGV1cjwvaDE+DQo8aDQ+U2kgdm91cyBzb3VoYWl0ZXogdmVuZHJlIHVuIGZvbmRzIGRlIGNvbW1lcmNlIG91IGxlcyB0aXRyZXMgZOKAmXVuZSBTb2Npw6l0w6kgOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9mb3JtdWxhaXJlLXZlbmRldXIiIHRhcmdldD0iX3NlbGYiIGljb249InNzLWN1cnNvciIgZHJvcHNoYWRvdz0ieWVzIiBleHRyYWNsYXNzPSIiXUNsaXF1ZXotaWNpWy9zZl9idXR0b25dPC9wPg0KW2hyXQ0KDQo8aW1nIGNsYXNzPSJhbGlnbm5vbmUiIGFsdD0iU2FuZHJpbmUgRElBWiIgc3JjPSIuLi8uLi93cC1jb250ZW50L3VwbG9hZHMvMjAxMy8xMC9TX0RpYXpfQy0xNTB4MTUwLmpwZyIgd2lkdGg9IjE1MCIgaGVpZ2h0PSIxNTAiIC8+DQoNClBvdXIgdG91dCByZW5zZWlnbmVtZW50IGNvbXBsw6ltZW50YWlyZSwgTWFkYW1lIFNhbmRyaW5lIERJQVogZXN0IMOgIHZvdHJlIGRpc3Bvc2l0aW9uLg0KDQpbaWNvbiBpbWFnZT0ic3MtcGhvbmUiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il3CoCArMzMgKDApNS42MS4zMi42Ni45Mg0KDQpbaWNvbiBpbWFnZT0ic3MtbWFpbCIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXSA8YSB0aXRsZT0ibm90cmUgYXNzaXN0YW50ZSBqdXJpZGlxdWUgZXN0IMOgIHZvdHJlIMOpY291dGUiIGhyZWY9Im1haWx0bzpjb250YWN0QGdhbm5lLWF2b2NhdHMuY29tIj5jb250YWN0QGdhbm5lLWF2b2NhdHMuY29tPC9hPg0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5UbyBoZWxwIHVzIGJldHRlciByZXNwb25kIHRvIHlvdXIgbmVlZHMsIHBsZWFzZSBjb21wbGV0ZSB0aGUgZm9ybSBiZWxvdy48L2gzPg0KW2NvbnRhY3QtZm9ybS03IGlkPSIxMzcxMyIgdGl0bGU9IlZvdXMgw6p0ZXMgYWNxdcOpcmV1ciBFTiJdDQoNClsvc3BiX3RleHRfYmxvY2tdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzQiIGVsX3Bvc2l0aW9uPSJsYXN0Il0NCjxoMj5baWNvbiBpbWFnZT0ic3MtYnVzaW5lc3N1c2VyIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdWW91IGFyZSBhIFNlbGxlcjwvaDI+DQo8aDQ+SWYgeW91IHdhbnQgdG8gc2VsbCBhIGJ1c2luZXNzIG9yIGEgY29tcGFueeKAmXMgc2hhcmVzOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9zZWxsZXIvIiB0YXJnZXQ9Il9zZWxmIiBpY29uPSJzcy1jdXJzb3IiIGRyb3BzaGFkb3c9InllcyIgZXh0cmFjbGFzcz0iIl1DbGljayBoZXJlWy9zZl9idXR0b25dPC9wPg0KW2hyXQ0KDQo8aW1nIGNsYXNzPSJhbGlnbm5vbmUiIHNyYz0iLi4vLi4vLi4vd3AtY29udGVudC91cGxvYWRzLzIwMTMvMTAvU19EaWF6X0MtMTUweDE1MC5qcGciIGFsdD0iU2FuZHJpbmUgRElBWiIgd2lkdGg9IjE1MCIgaGVpZ2h0PSIxNTAiIC8+DQoNCkZvciBtb3JlIGluZm9ybWF0aW9uLCBwbGVhc2UgY29udGFjdCBTYW5kcmluZSBEaWF6Og0KDQpbaWNvbiBpbWFnZT0ic3MtcGhvbmUiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il3CoCArMzMgKDApNS42MS4zMi42Ni45Mg0KDQpbaWNvbiBpbWFnZT0ic3MtbWFpbCIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXSA8YSB0aXRsZT0iT3VyIGxlZ2FsIGFzc2lzdGFudCIgaHJlZj0ibWFpbHRvOmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb20iPmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb208L2E+DQoNClsvc3BiX3RleHRfYmxvY2tdIFtkaXZpZGVyIHR5cGU9ImdvX3RvX3RvcF9pY29uMSIgdGV4dD0iR28gdG8gdG9wIiBmdWxsX3dpZHRoPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("120", "13", "0", "2014-10-30 11:46:41", "original_id", "", "0", "12102", "", "1");
INSERT INTO `wp_icl_translate` VALUES("121", "14", "0", "2014-10-30 12:02:18", "title", "base64", "1", "VmVuZGV1cg==", "U2VsbGVy", "1");
INSERT INTO `wp_icl_translate` VALUES("122", "14", "0", "2014-10-30 12:02:18", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5Qb3VyIG1pZXV4IHLDqXBvbmRyZSDDoCB2b3RyZSBiZXNvaW4sIG5vdXMgdm91cyBwcm9wb3NvbnMgZGUgY29tcGzDqXRlciBsZSBmb3JtdWxhaXJlIGNpLWRlc3NvdXMuPC9oMz4NCltjb250YWN0LWZvcm0tNyBpZD0iMTIwMjQiIHRpdGxlPSJWb3VzIMOqdGVzIHZlbmRldXIiXQ0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS80IiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDE+W2ljb24gaW1hZ2U9InNzLWJ1c2luZXNzdXNlciIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXVZvdXMgw6p0ZXMgQWNxdcOpcmV1cjwvaDE+DQo8aDQ+U2kgdm91cyBzb3VoYWl0ZXogYWNxdcOpcmlyIHVuIGZvbmRzIGRlIGNvbW1lcmNlIG91IGxlcyB0aXRyZXMgZOKAmXVuZSBTb2Npw6l0w6kgOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9mb3JtdWxhaXJlLWFjcXVlcmV1ciIgdGFyZ2V0PSJfc2VsZiIgaWNvbj0ic3MtY3Vyc29yIiBkcm9wc2hhZG93PSJ5ZXMiIGV4dHJhY2xhc3M9IiJdQ2xpcXVlei1pY2lbL3NmX2J1dHRvbl08L3A+DQpbaHJdDQoNCjxpbWcgYWx0PSJTYW5kcmluZSBESUFaIiBzcmM9Ii4uLy4uL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDEzLzEwL1NfRGlhel9DLTE1MHgxNTAuanBnIiB3aWR0aD0iMTUwIiBoZWlnaHQ9IjE1MCIgLz4NCg0KUG91ciB0b3V0IHJlbnNlaWduZW1lbnQgY29tcGzDqW1lbnRhaXJlLCBub3RyZSBBc3Npc3RhbmNlIEp1cmlkaXF1ZSBNYWRhbWUgU2FuZHJpbmUgRElBWiBlc3Qgw6Agdm90cmUgZGlzcG9zaXRpb24uDQoNCltpY29uIGltYWdlPSJzcy1waG9uZSIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXcKgICszMyAoMCk1LjYxLjMyLjY2LjkyDQoNCltpY29uIGltYWdlPSJzcy1tYWlsIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdIDxhIHRpdGxlPSJub3RyZSBhc3Npc3RhbnRlIGp1cmlkaXF1ZSBlc3Qgw6Agdm90cmUgw6ljb3V0ZSIgaHJlZj0ibWFpbHRvOmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb20iPmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb208L2E+DQoNCiZuYnNwOw0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5UbyBoZWxwIHVzIGJldHRlciByZXNwb25kIHRvIHlvdXIgbmVlZHMsIHBsZWFzZSBjb21wbGV0ZSB0aGUgZm9ybSBiZWxvdy48L2gzPg0KW2NvbnRhY3QtZm9ybS03IGlkPSIxMzcxOSIgdGl0bGU9IlZvdXMgw6p0ZXMgdmVuZGV1ciBFTiJdDQoNClsvc3BiX3RleHRfYmxvY2tdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzQiIGVsX3Bvc2l0aW9uPSJsYXN0Il0NCjxoMj5baWNvbiBpbWFnZT0ic3MtYnVzaW5lc3N1c2VyIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdWW91IGFyZSBhIEJ1eWVyPC9oMj4NCjxoND5JZiB5b3Ugd2FudCB0byBwdXJjaGFzZSBhIGJ1c2luZXNzIG9yIGEgY29tcGFueeKAmXMgc2hhcmVzOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9idXllciIgdGFyZ2V0PSJfc2VsZiIgaWNvbj0ic3MtY3Vyc29yIiBkcm9wc2hhZG93PSJ5ZXMiIGV4dHJhY2xhc3M9IiJdQ2xpY2sgaGVyZVsvc2ZfYnV0dG9uXTwvcD4NCltocl0NCg0KPGltZyBhbHQ9IlNhbmRyaW5lIERJQVoiIHNyYz0iLi4vLi4vLi4vd3AtY29udGVudC91cGxvYWRzLzIwMTMvMTAvU19EaWF6X0MtMTUweDE1MC5qcGciIHdpZHRoPSIxNTAiIGhlaWdodD0iMTUwIiAvPg0KRm9yIG1vcmUgaW5mb3JtYXRpb24sIHBsZWFzZSBjb250YWN0IFNhbmRyaW5lIERpYXo6DQoNCltpY29uIGltYWdlPSJzcy1waG9uZSIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXcKgICszMyAoMCk1LjYxLjMyLjY2LjkyDQoNCltpY29uIGltYWdlPSJzcy1tYWlsIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdIDxhIHRpdGxlPSJPdXIgbGVnYWwgYXNzaXN0YW50IiBocmVmPSJtYWlsdG86Y29udGFjdEBnYW5uZS1hdm9jYXRzLmNvbSI+Y29udGFjdEBnYW5uZS1hdm9jYXRzLmNvbTwvYT4NCg0KWy9zcGJfdGV4dF9ibG9ja10gW2RpdmlkZXIgdHlwZT0iZ29fdG9fdG9wX2ljb24xIiB0ZXh0PSJHbyB0byB0b3AiIGZ1bGxfd2lkdGg9Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJd", "1");
INSERT INTO `wp_icl_translate` VALUES("123", "14", "0", "2014-10-30 12:02:18", "original_id", "", "0", "12048", "", "1");
INSERT INTO `wp_icl_translate` VALUES("124", "15", "0", "2014-10-30 12:17:05", "title", "base64", "1", "VkFMRVVSUw==", "", "0");
INSERT INTO `wp_icl_translate` VALUES("125", "15", "0", "2014-10-30 12:17:05", "body", "base64", "1", "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", "", "0");
INSERT INTO `wp_icl_translate` VALUES("126", "15", "0", "2014-10-30 12:17:05", "original_id", "", "0", "12297", "", "0");
INSERT INTO `wp_icl_translate` VALUES("127", "16", "0", "2014-10-30 12:24:23", "title", "base64", "1", "THVjaWxlIENBTE1FVFRF", "THVjaWxlIENBTE1FVFRF", "1");
INSERT INTO `wp_icl_translate` VALUES("128", "16", "0", "2014-10-30 12:24:23", "body", "base64", "1", "PGEgdGl0bGU9IkRFUEFSVEVNRU5UIFJFU1RSVUNUVVJJTkcg4oCTIEVOVFJFUFJJU0VTIEVOIERJRkZJQ1VMVMOJIiBocmVmPSIvZXhwZXJ0aXNlL3Jlc3RydWN0dXJpbmctZW50cmVwcmlzZXNfZGlmZmljdWx0ZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgUkVTVFJVQ1RVUklORyDigJMgRU5UUkVQUklTRVMgRU4gRElGRklDVUxUw4k8L2E+DQoNCkFwcsOocyBhdm9pciBpbnTDqWdyw6kgbGUgc2VydmljZSBqdXJpZGlxdWUgZGVzIGxhYm9yYXRvaXJlcyBQaWVycmUgRmFicmUsIEx1Y2lsZSBhIHJlam9pbnQgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIGVuIG1hdGnDqHJlIGRlIHJlc3RydWN0dXJhdGlvbiBkJ2VudHJlcHJpc2UuDQpMdWNpbGUgYsOpbsOpZmljaWUgZCd1biBkb3VibGUgY3Vyc3VzIDogZHJvaXQgZXQgZ2VzdGlvbiBkZXMgZW50cmVwcmlzZXMgLyBjb21wdGFiaWxpdMOpLg0KQXVqb3VyZCdodWksIEx1Y2lsZSBlc3QgcGFydGljdWxpw6hyZW1lbnQgaW52ZXN0aWUgZGFucyBsYSBtaXNlIGVuIHBsYWNlIGVuIEZyYW5jZSBkZSBwcm9qZXRzIGRlIENyb3dkZnVuZGluZyAvIEZpbmFuY2VtZW50IHBhcnRpY2lwYXRpZi4=", "PGEgdGl0bGU9IlJFU1RSVUNUVVJJTkcg4oCTIElOU09MVkVOQ1kgRGVwYXJ0bWVudCIgaHJlZj0iL2V4cGVydGlzZS9yZXN0cnVjdHVyaW5nLWVudHJlcHJpc2VzX2RpZmZpY3VsdGUvIj48aSBjbGFzcz0iZmEtYW5nbGUtcmlnaHQiPjwvaT4gTWFuYWdlciBvZiB0aGUgUkVTVFJVQ1RVUklORyDigJMgSU5TT0xWRU5DWSBEZXBhcnRtZW50PC9hPg0KDQpMdWNpbGUgd29ya2VkIGluIHRoZSBsZWdhbCBkZXBhcnRtZW50IG9mIExhYm9yYXRvaXJlcyBQaWVycmUgRmFicmUgcHJpb3IgdG8gam9pbmluZyBDYWJpbmV0IEdBTk5FICYgQVZPQ0FUUyBpbiBjb3Jwb3JhdGUgcmVzdHJ1Y3R1cmluZy4NCkx1Y2lsZSBoYXMgcmVjZWl2ZWQgc3BlY2lhbGlzdCB0cmFpbmluZyBpbiB0d28gYXJlYXM6IGxhdywgYW5kIGNvcnBvcmF0ZSBtYW5hZ2VtZW50IGFuZCBhY2NvdW50aW5nLg0KVG9kYXksIEx1Y2lsZSBpcyBpbnZvbHZlZCBwYXJ0aWN1bGFybHkgaW4gZXN0YWJsaXNoaW5nIENyb3dkZnVuZGluZyBwcm9qZWN0cyBpbiBGcmFuY2Uu", "1");
INSERT INTO `wp_icl_translate` VALUES("129", "16", "0", "2014-10-30 12:24:23", "original_id", "", "0", "11981", "", "1");
INSERT INTO `wp_icl_translate` VALUES("130", "16", "0", "2014-10-30 12:24:23", "field-_yoast_wpseo_metadesc", "base64", "1", "QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCByZXN0cnVjdHVyYXRpb24gZGVzIGVudHJlcHJpc2VzIGVuIGRpZmZpY3VsdMOpcw==", "", "1");
INSERT INTO `wp_icl_translate` VALUES("131", "16", "0", "2014-10-30 12:24:23", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("132", "16", "0", "2014-10-30 12:24:23", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("133", "16", "0", "2014-10-30 12:24:23", "field-_yoast_wpseo_focuskw", "base64", "1", "YXZvY2F0LCByZXN0cnVjdHVyaW5nLCByZXN0cnVjdHVyYXRpb24sIGRyb2l0LCBlbnRyZXByaXNlLCBjb21wdGFiaWxpdMOpLCBmaW5hbmNlbWVudCwgcGFydGljaXBhdGlmLCBjcm93Zm91bmRpbmcsIHRvdWxvdXNl", "", "1");
INSERT INTO `wp_icl_translate` VALUES("134", "16", "0", "2014-10-30 12:24:23", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("135", "16", "0", "2014-10-30 12:24:23", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("136", "16", "0", "2014-10-30 12:24:23", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"cmVzdHJ1Y3R1cmluZw==\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("137", "16", "0", "2014-10-30 12:24:23", "tag_ids", "", "0", "195,194,197,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("138", "16", "0", "2014-10-30 12:24:23", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIFJFU1RSVUNUVVJBVElPTg==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("139", "16", "0", "2014-10-30 12:24:23", "team-category_ids", "", "0", "186", "", "1");
INSERT INTO `wp_icl_translate` VALUES("140", "17", "0", "2014-10-30 12:29:07", "title", "base64", "1", "U29waGllIENPR05BVUxU", "U29waGllIENPR05BVUxU", "1");
INSERT INTO `wp_icl_translate` VALUES("141", "17", "0", "2014-10-30 12:29:07", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgQ09OVEVOVElFVVgg4oCTIERST0lUIElOVEVSTkFUSU9OQUwiIGhyZWY9Ii9leHBlcnRpc2UvY29udGVudGlldXgtZHJvaXRfaW50ZXJuYXRpb25hbC8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09OVEVOVElFVVgg4oCTIElOVEVSTkFUSU9OQUw8L2E+DQoNCkF2b2NhdCBhdSBCYXJyZWF1IGRlIFBhcmlzIHBlbmRhbnQgcGx1cyA1IGFucyBub3RhbW1lbnQgYXUgc2VpbiBkdSBjYWJpbmV0IGQnYWZmYWlyZXMgcGFyaXNpZW4gTEFNWSBMRVhFTCwgU29waGllIGEgcmVqb2ludCBsZSBDYWJpbmV0IEdBTk5FICZhbXA7IEFWT0NBVFMuDQoNCkRlIGZvcm1hdGlvbiBkZSBEcm9pdCBDb21tdW5hdXRhaXJlLCBTb3BoaWUgYSB0cmF2YWlsbMOpIGF2YW50IGQnZXhlcmNlciBlbiBxdWFsaXTDqSBkJ2F2b2NhdCDDoCBFdXJvIEluZm8gQ2VudHJlIGTDqXBlbmRhbnQgZGUgbGEgQ29tbWlzc2lvbiBFdXJvcMOpZW5uZS4NCg0KQmlsaW5ndWUgZW4gQW5nbGFpcywgU29waGllIGEgcGFydGljaXDDqSDDoCBwbHVzaWV1cnMgY29udGVudGlldXggdHJhbnNmcm9udGFsaWVycy4NCg0KWy9zcGJfdGV4dF9ibG9ja10=", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iTElUSUdBVElPTuKAkyBJTlRFUk5BVElPTkFMIERlcGFydG1lbnQiIGhyZWY9Ii9leHBlcnRpc2UvY29udGVudGlldXgtZHJvaXRfaW50ZXJuYXRpb25hbC8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPk1hbmFnZXIgb2YgdGhlIExJVElHQVRJT07igJMgSU5URVJOQVRJT05BTCBEZXBhcnRtZW50PC9hPg0KU29waGllIGpvaW5lZCBDYWJpbmV0IEdBTk5FICYgQVZPQ0FUUyBhZnRlciB3b3JraW5nIGFzIGEgbGF3eWVyIGF0IHRoZSBQYXJpcyBiYXIgZm9yIGZpdmUgeWVhcnMgZm9yIFBhcmlzaWFuIGJ1c2luZXNzIGxhdyBmaXJtIExBTVkgTEVYRUwuDQpXaXRoIGEgYmFja2dyb3VuZCBpbiBDb21tdW5pdHkgbGF3LCBTb3BoaWUgd29ya2VkIGF0IEV1cm8gSW5mbyBDZW50cmUsIHVuZGVyIHRoZSBFdXJvcGVhbiBDb21taXNzaW9uIHByaW9yIHRvIGJlY29taW5nIGEgbGF3eWVyLg0KU29waGllIGlzIGJpbGluZ3VhbCBpbiBGcmVuY2ggYW5kIEVuZ2xpc2gsIGFuZCBoYXMgcGFydGljaXBhdGVkIGluIGEgbnVtYmVyIG9mIGludGVybmF0aW9uYWwgbGl0aWdhdGlvbnMuDQoNClsvc3BiX3RleHRfYmxvY2td", "1");
INSERT INTO `wp_icl_translate` VALUES("142", "17", "0", "2014-10-30 12:29:07", "original_id", "", "0", "12446", "", "1");
INSERT INTO `wp_icl_translate` VALUES("143", "17", "0", "2014-10-30 12:29:07", "field-_yoast_wpseo_metadesc", "base64", "1", "QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBjb250ZW50aWV1eCBldCBpbnRlcm5hdGlvbmFsIGRhbnMgbGUgY2FiaW5ldCBHQU5ORSAmIEFWT0NBVFM=", "", "1");
INSERT INTO `wp_icl_translate` VALUES("144", "17", "0", "2014-10-30 12:29:07", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("145", "17", "0", "2014-10-30 12:29:07", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("146", "17", "0", "2014-10-30 12:29:07", "field-_yoast_wpseo_focuskw", "base64", "1", "Q29udGVudGlldXg=", "", "1");
INSERT INTO `wp_icl_translate` VALUES("147", "17", "0", "2014-10-30 12:29:07", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("148", "17", "0", "2014-10-30 12:29:07", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("149", "17", "0", "2014-10-30 12:29:07", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29udGVudGlldXg=\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("150", "17", "0", "2014-10-30 12:29:07", "tag_ids", "", "0", "195,194,201,198,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("151", "17", "0", "2014-10-30 12:29:07", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIENPTlRFTlRJRVVY\"", "\"RMOJUEFSVEVNRU5UIENPTlRFTlRJRVVY\"", "1");
INSERT INTO `wp_icl_translate` VALUES("152", "17", "0", "2014-10-30 12:29:07", "team-category_ids", "", "0", "187", "", "1");
INSERT INTO `wp_icl_translate` VALUES("153", "18", "0", "2014-10-30 12:37:33", "title", "base64", "1", "QXVyw6lsaWUgTUlDSEFVRA==", "QXVyw6lsaWUgTUlDSEFVRA==", "1");
INSERT INTO `wp_icl_translate` VALUES("154", "18", "0", "2014-10-30 12:37:33", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkUiIGhyZWY9Ii9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkU8L2E+DQoNCkLDqW7DqWZpY2lhbnQgZCd1bmUgZXhww6lyaWVuY2UgZGUgcGx1cyBkZSA5IGFubsOpZXMgZW4gbWF0acOocmUgZGUgY29uc2VpbCBldCBkw6l2ZWxvcHBlbWVudCBkZXMgZW50cmVwcmlzZXMsIEF1csOpbGllIGEgcGFydGljaXDDqSDDoCBkZXMgb3DDqXJhdGlvbnMgZGUgY2Vzc2lvbnMgZCdlbnZlcmd1cmUuDQpBdXLDqWxpZSBlc3QgdGl0dWxhaXJlIGQndW4gREVTUyBkZSBEcm9pdCBGaXNjYWwgZHUgUHJvZmVzc2V1ciBCZXJuYXJkIFBMQUdORVQgZXQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuDQoNClsvc3BiX3RleHRfYmxvY2td", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iVEFYIExBVyDigJMgV0VBTFRIIE1BTkFHRU1FTlQgRGVwYXJ0bWVudCIgaHJlZj0iL2V4cGVydGlzZS9kcm9pdF9maXNjYWwtZ2VzdGlvbl9wYXRyaW1vaW5lLyI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IE1hbmFnZXIgb2YgdGhlICBUQVggTEFXIOKAkyBXRUFMVEggTUFOQUdFTUVOVCBEZXBhcnRtZW50PC9hPg0KDQpXaXRoIG92ZXIgbmluZSB5ZWFyc+KAmSBleHBlcmllbmNlIGluIGNvbnN1bHRpbmcgYW5kIGNvcnBvcmF0ZSBkZXZlbG9wbWVudCwgQXVyw6lsaWUgaGFzIHBhcnRpY2lwYXRlZCBpbiBsYXJnZS1zY2FsZSBkaXNwb3NhbCBvcGVyYXRpb25zLg0KQXVyw6lsaWUgaG9sZHMgYSBERVNTIGdyYWR1YXRlIGRlZ3JlZSBpbiBUYXggTGF3IHVuZGVyIFByb2Zlc3NvciBCZXJuYXJkIFBsYWduZXQgYW5kIGlzIGEgbGF1cmVhdGUgb2YgdGhlIENvbmbDqXJlbmNlIGRlcyBBdm9jYXRzLg0KWy9zcGJfdGV4dF9ibG9ja10=", "1");
INSERT INTO `wp_icl_translate` VALUES("155", "18", "0", "2014-10-30 12:37:33", "original_id", "", "0", "11976", "", "1");
INSERT INTO `wp_icl_translate` VALUES("156", "18", "0", "2014-10-30 12:37:33", "field-_yoast_wpseo_metadesc", "base64", "1", "QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBkcm9pdCBmaXNjYWwgZXQgZ2VzdGlvbiBkdSBwYXRyaW1vaW5l", "", "1");
INSERT INTO `wp_icl_translate` VALUES("157", "18", "0", "2014-10-30 12:37:33", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("158", "18", "0", "2014-10-30 12:37:33", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("159", "18", "0", "2014-10-30 12:37:33", "field-_yoast_wpseo_focuskw", "base64", "1", "YXZvY2F0LCBnZXN0aW9uLCBwYXRyaW1vaW5lLCBmaXNjYWwsIGZpc2NhbGl0w6ksIGZpbmFuY2VtZW50LCB0b3Vsb3VzZSwgcGFyaXM=", "", "1");
INSERT INTO `wp_icl_translate` VALUES("160", "18", "0", "2014-10-30 12:37:33", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("161", "18", "0", "2014-10-30 12:37:33", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("162", "18", "0", "2014-10-30 12:37:33", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"ZHJvaXQ=\",\"ZmlzY2Fs\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("163", "18", "0", "2014-10-30 12:37:33", "tag_ids", "", "0", "195,194,198,199,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("164", "18", "0", "2014-10-30 12:37:33", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIERST0lUIEZJU0NBTA==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("165", "18", "0", "2014-10-30 12:37:33", "team-category_ids", "", "0", "185", "", "1");
INSERT INTO `wp_icl_translate` VALUES("166", "19", "0", "2014-10-30 12:38:08", "title", "base64", "1", "T2xpdmllciBHQU5ORQ==", "T2xpdmllciBHQU5ORQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("167", "19", "0", "2014-10-30 12:38:08", "body", "base64", "1", "PGEgdGl0bGU9IkRFUEFSVEVNRU5UIENPUlBPUkFURSDigJMgRklOQU5DRSIgaHJlZj0iL2V4cGVydGlzZS9jb3Jwb3JhdGUtZmluYW5jZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09SUE9SQVRFIC0gRklOQU5DRTwvYT4NCjxkaXYgaWQ9Im1haW5faW50ZXJfZnVsbCI+QXZvY2F0IGRlcHVpcyAyMDAzLCBPbGl2aWVyIGVzdCBwYXNzw6kgcGFyIGRpZmbDqXJlbnRzIGNhYmluZXRzIGFuZ2xvLXNheG9ucyDDoCBQYXJpcyBldCBlbiBOb3V2ZWxsZSBaw6lsYW5kZSBhdmFudCBkZSBmb25kZXIgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIMOgIFRvdWxvdXNlLjwvZGl2Pg0KPGRpdj5PbGl2aWVyIGEgbm90YW1tZW50IHNvdXRlbnUgbGEgbWlzZSBlbiBwbGFjZSBkZSBww7RsZXMgZGUgY29tcMOpdGl0aXZpdMOpIGRhbnMgbGVzIGRvbWFpbmVzIGRlIGxhIFNhbnTDqSBldCBkZSBsJ0HDqXJvbmF1dGlxdWUuPC9kaXY+DQo8ZGl2PkFuY2llbiBQcsOpc2lkZW50IGRlcyBKLiBBdm9jYXRzIENvbnNlaWwgZW4gRW50cmVwcmlzZSBkZSBNaWRpLVB5csOpbsOpZXMsIE9saXZpZXIgZXN0IMOpZ2FsZW1lbnQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuPC9kaXY+", "PGEgdGl0bGU9IkNPUlBPUkFURSDigJMgRklOQU5DRSBERVBBUlRNRU5UIiBocmVmPSIvZXhwZXJ0aXNlLWJ1c2luZXNzLWxhdy9jb3Jwb3JhdGUtZmluYW5jZS1kZXBhcnRtZW50LyI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IE1hbmFnZXIgb2YgdGhlICBDT1JQT1JBVEUg4oCTIEZJTkFOQ0UgRGVwYXJ0bWVudDwvYT4NCkEgbGF3eWVyIHNpbmNlIDIwMDMsIE9saXZpZXIgd29ya2VkIGZvciBhIG51bWJlciBvZiBFbmdsaXNoLWxhbmd1YWdlIGZpcm1zIGluIFBhcmlzIGFuZCBOZXcgWmVhbGFuZCBiZWZvcmUgZm91bmRpbmcgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIGluIFRvdWxvdXNlLg0KT2xpdmllciBzdXBwb3J0ZWQgdGhlIGVzdGFibGlzaG1lbnQgb2YgY29tcGV0aXRpdmVuZXNzIGNsdXN0ZXJzIGluIHRoZSBhcmVhcyBvZiBIZWFsdGggYW5kIEFlcm9uYXV0aWNzLg0KRm9ybWVyIFByZXNpZGVudCBvZiBKLiBBdm9jYXRzIENvbnNlaWwgZW4gRW50cmVwcmlzZSBmb3IgdGhlIE1pZGktUHlyw6luw6llcyByZWdpb24sIE9saXZpZXIgaXMgYWxzbyBhIGxhdXJlYXRlIG9mIHRoZSBDb25mw6lyZW5jZSBkZXMgQXZvY2F0cy4=", "1");
INSERT INTO `wp_icl_translate` VALUES("168", "19", "0", "2014-10-30 12:38:08", "original_id", "", "0", "11038", "", "1");
INSERT INTO `wp_icl_translate` VALUES("169", "19", "0", "2014-10-30 12:38:08", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29ycG9yYXRl\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("170", "19", "0", "2014-10-30 12:38:08", "tag_ids", "", "0", "195,194,200,198,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("171", "19", "0", "2014-10-30 12:38:08", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIENPUlBPUkFURQ==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("172", "19", "0", "2014-10-30 12:38:08", "team-category_ids", "", "0", "184", "", "1");
INSERT INTO `wp_icl_translate` VALUES("173", "20", "0", "2014-11-04 14:19:52", "title", "base64", "1", "SW5mb3JtYXRpb25zIGzDqWdhbGVz", "QWNjb21wYWduZW1lbnQ=", "1");
INSERT INTO `wp_icl_translate` VALUES("175", "20", "0", "2014-11-04 14:19:52", "original_id", "", "0", "12117", "", "1");
INSERT INTO `wp_icl_translate` VALUES("206", "24", "0", "2015-01-04 22:24:25", "title", "base64", "1", "SW5mb3JtYXRpb25zIGzDqWdhbGVz", "MDlfTUVOVElPTlMtTEVHQUxFUyDms5Xlvovlo7DmmI4=", "1");
INSERT INTO `wp_icl_translate` VALUES("207", "24", "0", "2015-01-04 22:24:25", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("176", "21", "0", "2014-11-05 09:09:55", "title", "base64", "1", "QWNjb21wYWduZW1lbnQ=", "QXNzaXN0YW5jZQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("177", "21", "0", "2014-11-05 09:09:55", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("178", "21", "0", "2014-11-05 09:09:55", "original_id", "", "0", "13188", "", "1");
INSERT INTO `wp_icl_translate` VALUES("179", "21", "0", "2014-11-05 09:09:55", "field-_yoast_wpseo_metadesc", "base64", "1", "TCdhY2NvbXBhZ25lbWVudCBkZXMgZW50cmVwcmVuZXVycyBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgZXN0IGxlIGZvbmRlbWVudCBwcmluY2lwYWwgZGUgbCdhY3Rpdml0w6kgZHUgQ2FiaW5ldCAtIG5vcyBkb21haW5lcyBkZSBjb21ww6l0ZW5jZXMgOiBmaXNjYWxpdMOpLCBkcm9pdCBkZXMgc29jacOpdMOpcywgZHJvaXQgY29tbWVyY2lhbCwgdHJhbnNtaXNzaW9uIGQnZW50cmVwcmlzZXMu", "QXNzaXN0aW5nIGVudHJlcHJlbmV1cnMgaW4gYnVzaW5lc3MgbGF3IGlzIG91ciBmaXJt4oCZcyB2ZXJ5IGVzc2VuY2UgLSB0YXhhdGlvbiwgYnVzaW5lc3MgbGF3LCBjb21tZXJjaWFsIGxhdywgZXRjLg==", "1");
INSERT INTO `wp_icl_translate` VALUES("180", "21", "0", "2014-11-05 09:09:55", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("181", "21", "0", "2014-11-05 09:09:55", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("182", "21", "0", "2014-11-05 09:09:55", "field-_yoast_wpseo_focuskw", "base64", "1", "YWNjb21wYWduZW1lbnQ=", "QXNzaXN0YW5jZQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("183", "21", "0", "2014-11-05 09:09:55", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("184", "21", "0", "2014-11-05 09:09:55", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("185", "22", "0", "2014-11-05 10:03:09", "title", "base64", "1", "RXhwZXJ0aXNlcw==", "RXhwZXJ0aXNlIGluIGJ1c2luZXNzIGxhdw==", "1");
INSERT INTO `wp_icl_translate` VALUES("186", "22", "0", "2014-11-05 10:03:09", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMiIgZWxfcG9zaXRpb249ImZpcnN0Il0NCg0KW3NmX2ljb25ib3ggaW1hZ2U9IiIgY2hhcmFjdGVyPSIxIiB0eXBlPSJsZWZ0LWljb24tYWx0IiB0aXRsZT0iRMOJUEFSVEVNRU5UIENPUlBPUkFURSAtIEZJTkFOQ0UiIGFuaW1hdGlvbj0iZmFkZS1mcm9tLWxlZnQiIGFuaW1hdGlvbl9kZWxheT0iMjAwIl0NCjxwIHN0eWxlPSJ0ZXh0LWFsaWduOiBqdXN0aWZ5OyI+TGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIGludGVydmllbnQgc3VyIGRlcyBvcMOpcmF0aW9ucyBkZSBmaW5hbmNlbWVudCwgZGUgY29ycG9yYXRlIGZpbmFuY2UsIExCTywgcHJpdmF0ZSBlcXVpdHksIGZ1c2lvbi1hY3F1aXNpdGlvbi4gTGUgQ2FiaW5ldCBhc3Npc3RlIGRlcyBncm91cGVzIGZyYW7Dp2FpcyBldCDDqXRyYW5nZXJzLCBkZXMgZGlyaWdlYW50cyBk4oCZZW50cmVwcmlzZSwgZGVzIGZvbmRzIGTigJlpbnZlc3Rpc3NlbWVudCBldCBkZXMgw6l0YWJsaXNzZW1lbnRzIGRlIGNyw6lkaXQuDQo8YSB0aXRsZT0iQWNjw6lkZXIgw6AgbGEgcGFnZSBERVBBUlRFTUVOVCBDT1JQT1JBVEUg4oCTIEZJTkFOQ0UiIGhyZWY9Ii4uL2V4cGVydGlzZS9jb3Jwb3JhdGUtZmluYW5jZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBFbiBzYXZvaXIgcGx1czwvYT48L3A+DQpbb25lX3RoaXJkXQ0KDQo8YSB0aXRsZT0iVm9pciBsYSBmaWNoZSBkJ09saXZpZXIgR0FOTkUiIGhyZWY9Ii4uLz90ZWFtPW9saXZpZXItZ2FubmUiPjxpbWcgc3JjPSIuLi93cC1jb250ZW50L3VwbG9hZHMvMjAxNC8wMS9DYWJpbmV0X0dhbm5lLUF2b2NhdHNfT2xpdmllci1HYW5uZV9jYXJyZS1jb3VsZXVyLTE1MHgxNTAuanBnIiBhbHQ9IkNhYmluZXRfR2FubmUtQXZvY2F0c19PbGl2aWVyLUdhbm5lX2NhcnJlLWNvdWxldXIiIHdpZHRoPSIxNTAiIGhlaWdodD0iMTUwIiAvPjwvYT4NCg0KWy9vbmVfdGhpcmRdDQpbdHdvX3RoaXJkX2xhc3RdDQo8aDQ+TWHDrnRyZSBPbGl2aWVyIEdBTk5FPC9oND4NClJlc3BvbnNhYmxlIGR1IETDqXBhcnRlbWVudCBDb3Jwb3JhdGUgLSBGaW5hbmNlDQo8YSB0aXRsZT0iUmV0cm91dmV6IGxhIGZpY2hlIGQnT2xpdmllciBHYW5uZSIgaHJlZj0iLi4vP3RlYW09b2xpdmllci1nYW5uZSI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IFZvaXIgbGUgcHJvZmlsIGVuIGTDqXRhaWw8L2E+DQoNClsvdHdvX3RoaXJkX2xhc3RdDQoNClsvc2ZfaWNvbmJveF0NCg0KWy9zcGJfdGV4dF9ibG9ja10gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMiIgZWxfcG9zaXRpb249Imxhc3QiXQ0KDQpbc2ZfaWNvbmJveCBpbWFnZT0iIiBjaGFyYWN0ZXI9IjIiIHR5cGU9ImxlZnQtaWNvbi1hbHQiIHRpdGxlPSJEw4lQQVJURU1FTlQgRFJPSVQgRklTQ0FMIC0gR0VTVElPTiBERSBQQVRSSU1PSU5FIiBhbmltYXRpb249ImZhZGUtZnJvbS1sZWZ0IiBhbmltYXRpb25fZGVsYXk9IjYwMCJdDQo8cCBzdHlsZT0idGV4dC1hbGlnbjoganVzdGlmeTsiPkxlIENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUUyBmb3Vybml0IGRlcyBjb25zZWlscyBhZGFwdMOpcyDDoCB2b3MgYmVzb2lucyBldCBtZXQgZW4gxZN1dnJlIGRlcyBzb2x1dGlvbnMgY29uY3LDqHRlcyBldCBpbm5vdmFudGVzLiBJbCB2b3VzIGFzc2lzdGUgZGFucyBsZSBjYWRyZSBkZSB0cmFuc2FjdGlvbnM8aT4gY29ycG9yYXRlPC9pPiwgaW1tb2JpbGnDqHJlcyBldCBmaW5hbmNpw6hyZXMuIFNlcyBjbGllbnRzIGLDqW7DqWZpY2llbnQgw6lnYWxlbWVudCBk4oCZdW5lIGFzc2lzdGFuY2UgcsOpZ3VsacOocmUgbGV1ciBwZXJtZXR0YW50IGTigJlvcHRpbWlzZXIgbGVzIGNvbnPDqXF1ZW5jZXMgZmlzY2FsZXMgZGUgbGV1cnMgb3DDqXJhdGlvbnMgZGUgZ2VzdGlvbiBjb3VyYW50ZS4NCjxhIHRpdGxlPSJBY2PDqWRlciDDoCBsYSBwYWdlIERFUEFSVEVNRU5UIERST0lUIEZJU0NBTCDigJMgR0VTVElPTiBERSBQQVRSSU1PSU5FIiBocmVmPSIuLi9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBFbiBzYXZvaXIgcGx1czwvYT48L3A+DQpbb25lX3RoaXJkXQ0KDQo8YSB0aXRsZT0iVm9pciBsYSBmaWNoZSBkJ0F1csOpbGllIE1JQ0hBVVgiIGhyZWY9Ii4uLz90ZWFtPWF1cmVsaWUtbWljaGF1eCI+PGltZyBjbGFzcz0iYWxpZ25ub25lICB3cC1pbWFnZS0xMjc4OCIgc3JjPSIuLi93cC1jb250ZW50L3VwbG9hZHMvMjAxMy8xMC9BX01pY2hhdXhfQy0xNTB4MTUwLmpwZyIgYWx0PSJBX01pY2hhdXhfQyIgLz48L2E+DQpbL29uZV90aGlyZF0NClt0d29fdGhpcmRfbGFzdF0NCjxoND5NYcOudHJlIEF1csOpbGllIE1JQ0hBVUQ8L2g0Pg0KUmVzcG9uc2FibGUgZHUgRMOpcGFydGVtZW50IERyb2l0IEZpc2NhbCAtIEdlc3Rpb24gZHUgUGF0cmltb2luZQ0KPGEgdGl0bGU9IlJldHJvdXZleiBsYSBmaWNoZSBkJ0F1csOpbGllIE1pY2hhdWQiIGhyZWY9Ii4uLz90ZWFtPWF1cmVsaWUtbWljaGF1ZCI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IFZvaXIgbGUgcHJvZmlsIGVuIGTDqXRhaWw8L2E+DQoNClsvdHdvX3RoaXJkX2xhc3RdDQoNClsvc2ZfaWNvbmJveF0NCg0KWy9zcGJfdGV4dF9ibG9ja10gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjMwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW2RpdmlkZXIgdHlwZT0iZG90dGVkIiB0ZXh0PSJHbyB0byB0b3AiIGZ1bGxfd2lkdGg9Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzIiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQoNCltzZl9pY29uYm94IGltYWdlPSIiIGNoYXJhY3Rlcj0iMyIgdHlwZT0ibGVmdC1pY29uLWFsdCIgdGl0bGU9IkTDiVBBUlRFTUVOVCBSRVNUUlVDVFVSSU5HIC0gRU5UUkVQUklTRVMgRU4gRElGRklDVUxUw4kgIiBhbmltYXRpb249ImZhZGUtZnJvbS1yaWdodCIgYW5pbWF0aW9uX2RlbGF5PSIzMDAiXQ0KPHAgc3R5bGU9InRleHQtYWxpZ246IGp1c3RpZnk7Ij5EYW5zIGxlIGNhZHJlIGRlcyBkaWZmaWN1bHTDqXMgZmluYW5jacOocmVzIGRlcyBlbnRyZXByaXNlcywgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIGNvdXZyZSBs4oCZZW5zZW1ibGUgZGVzIG1pc3Npb25zIGTigJlhc3Npc3RhbmNlIGV0IGRlIGNvbnNlaWwgbGnDqWVzIGF1IHJlc3RydWN0dXJpbmcsIMOgIGxhIHByw6l2ZW50aW9uIGV0IGF1IHRyYWl0ZW1lbnQgZGVzIGRpZmZpY3VsdMOpcyBkZXMgZW50cmVwcmlzZXMuDQo8YSB0aXRsZT0iQWNjw6lkZXIgw6AgbGEgcGFnZSBERVBBUlRFTUVOVCBSRVNUUlVDVFVSSU5HIOKAkyBFTlRSRVBSSVNFUyBFTiBESUZGSUNVTFTDiSIgaHJlZj0iLi4vZXhwZXJ0aXNlL3Jlc3RydWN0dXJpbmctZW50cmVwcmlzZXNfZGlmZmljdWx0ZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBFbiBzYXZvaXIgcGx1czwvYT48L3A+DQpbb25lX3RoaXJkXQ0KDQo8YSB0aXRsZT0iVm9pciBsYSBmaWNoZSBkZSBMdWNpbGUgQ0FMTUVUVEUiIGhyZWY9Ii4uLz90ZWFtPWx1Y2lsZS1jYWxtZXR0ZSI+PGltZyBzcmM9Ii4uL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDE0LzAxL0NhYmluZXRfR2FubmUtQXZvY2F0c19MdWNpZS1DYWxtZXR0ZV9jYXJyZS1jb3VsZXVyLTE1MHgxNTAuanBnIiBhbHQ9IkNhYmluZXQgR2FubmUgJmFtcDsgQXZvY2F0cyBMdWNpZSBDYWxtZXR0ZSIgLz48L2E+DQoNClsvb25lX3RoaXJkXQ0KW3R3b190aGlyZF9sYXN0XQ0KPGg0Pk1hw650cmUgTHVjaWxlIENBTE1FVFRFPC9oND4NClJlc3BvbnNhYmxlIGR1IETDqXBhcnRlbWVudCBSZXN0cnVjdHVyaW5nIC0gRW50cmVwcmlzZXMgZW4gZGlmZmljdWx0w6kNCjxhIHRpdGxlPSJSZXRyb3V2ZXogbGEgZmljaGUgZGUgTHVjaWxlIENhbG1ldHRlIiBocmVmPSIuLi8/dGVhbT1sdWNpbGUtY2FsbWV0dGUiPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBWb2lyIGxlIHByb2ZpbCBlbiBkw6l0YWlsPC9hPg0KDQpbL3R3b190aGlyZF9sYXN0XQ0KDQpbL3NmX2ljb25ib3hdDQoNCiZuYnNwOw0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8yIiBlbF9wb3NpdGlvbj0ibGFzdCJdDQoNCltzZl9pY29uYm94IGltYWdlPSIiIGNoYXJhY3Rlcj0iNCIgdHlwZT0ibGVmdC1pY29uLWFsdCIgdGl0bGU9IkTDiVBBUlRFTUVOVCBDT05URU5USUVVWCAtIElOVEVSTkFUSU9OQUwiIGFuaW1hdGlvbj0iZmFkZS1mcm9tLXJpZ2h0IiBhbmltYXRpb25fZGVsYXk9IjkwMCJdDQo8cCBzdHlsZT0idGV4dC1hbGlnbjoganVzdGlmeTsiPkxlIENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUUyByZXByw6lzZW50ZSBzZXMgY2xpZW50cywgZW4gZGVtYW5kZSBldCBlbiBkw6lmZW5zZSwgZGV2YW50IGxlcyBqdXJpZGljdGlvbnMgY2l2aWxlcywgcMOpbmFsZXMgZXQgY29tbWVyY2lhbGVzIG5hdGlvbmFsZXMgZXQgZXVyb3DDqWVubmVzLg0KPGEgdGl0bGU9IkFjY8OpZGVyIMOgIGxhIHBhZ2UgREVQQVJURU1FTlQgQ09OVEVOVElFVVgg4oCTIERST0lUIElOVEVSTkFUSU9OQUwiIGhyZWY9Ii4uL2V4cGVydGlzZS9jb250ZW50aWV1eC1kcm9pdF9pbnRlcm5hdGlvbmFsLyI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IEVuIHNhdm9pciBwbHVzPC9hPjwvcD4NCltvbmVfdGhpcmRdDQoNCjxhIHRpdGxlPSJWb2lyIGxhIGZpY2hlIGRlIFNvcGhpZSBDT0dOQVVMVCIgaHJlZj0iLi4vP3RlYW09c2FuZHJpbmUtZGlheiI+PGltZyBzcmM9Ii4uL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDE0LzAxL0NhYmluZXRfR2FubmUtQXZvY2F0c19Tb3BoaWUtQ29nbmF1bHRfY2FycmUtY291bGV1ci0xNTB4MTUwLmpwZyIgYWx0PSJDYWJpbmV0IEdhbm5lICZhbXA7IEF2b2NhdHMgU29waGllIENvZ25hdWx0IiB3aWR0aD0iMTUwIiBoZWlnaHQ9IjE1MCIgLz48L2E+DQoNClsvb25lX3RoaXJkXQ0KW3R3b190aGlyZF9sYXN0XQ0KPGg0Pk1hw650cmUgU29waGllIENPR05BVUxUPC9oND4NClJlc3BvbnNhYmxlIGR1IETDqXBhcnRlbWVudCBDb250ZW50aWV1eCAtIEludGVybmF0aW9uYWwNCjxhIHRpdGxlPSJWb2lyIGxhIGZpY2hlIGRlIFNvcGhpZSBDT0dOQVVMVCIgaHJlZj0iLi4vP3RlYW09c29waGllLWNvZ25hdWx0Ij4gVm9pciBsZSBwcm9maWwgZW4gZMOpdGFpbDwvYT4NClsvdHdvX3RoaXJkX2xhc3RdDQoNClsvc2ZfaWNvbmJveF0NCg0KWy9zcGJfdGV4dF9ibG9ja10=", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("303", "45", "0", "2017-03-13 18:34:07", "title", "base64", "1", "RXhwZXJ0aXNlcw==", "RXhwZXJ0aXNlIGluIGJ1c2luZXNzIGxhdw==", "1");
INSERT INTO `wp_icl_translate` VALUES("304", "45", "0", "2017-03-13 18:34:07", "body", "base64", "1", "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", "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", "0");
INSERT INTO `wp_icl_translate` VALUES("187", "22", "0", "2014-11-05 10:03:09", "original_id", "", "0", "1195", "", "1");
INSERT INTO `wp_icl_translate` VALUES("188", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_title", "base64", "1", "R0FOTkUgJiBBdm9jYXRzIGF2ZWMgdW5lIGdyYW5kZSBleHBlcnRpc2VzIGVuIGRyb2l0IGRlcyBhZmZhaXJlcw==", "TGF3IGZpcm0gaW4gVG91bG91c2Ugc3BlY2lhbGl6aW5nIGluIGJ1c2luZXNzIGxhdyDigJMgRXhwZXJ0aXNlIGluIGJ1c2luZXNzIGxhdyAtIEdBTk5FICYgQVZPQ0FUUw==", "1");
INSERT INTO `wp_icl_translate` VALUES("189", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("190", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("191", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBHQU5ORSAmIEF2b2NhdHMgw6AgVG91bG91c2UgaW50ZXJ2aWVudCBhdmVjIHVuZSBleHBlcnRpc2VhdXByw6hzIGRlIHNhIGNsaWVudMOobGUgcHJvLg==", "VGhlIGxhdyBmaXJtIC0gR0FOTkUgJiBBVk9DQVRTIGFzc2lzdHMgaXRzIGNsaWVudHMgaW4gZmluYW5jaW5nLCBjb3Jwb3JhdGUgZmluYW5jZSwgTEJPLCBwcml2YXRlIGVxdWl0eSBhbmQgbWVyZ2VycyBhbmQgYWNxdWlzaXRpb25zIG9wZXJhdGlvbnMu", "1");
INSERT INTO `wp_icl_translate` VALUES("197", "23", "0", "2014-11-05 10:28:08", "title", "base64", "1", "QWN0dWFsaXTDqXM=", "UmVjZW50IE5ld3M=", "1");
INSERT INTO `wp_icl_translate` VALUES("192", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("193", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("194", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_focuskw", "base64", "1", "ZXhwZXJ0aXNl", "TGF3IGZpcm0=", "1");
INSERT INTO `wp_icl_translate` VALUES("195", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("196", "22", "0", "2014-11-05 10:03:09", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("198", "23", "0", "2014-11-05 10:28:08", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("199", "23", "0", "2014-11-05 10:28:08", "original_id", "", "0", "12154", "", "1");
INSERT INTO `wp_icl_translate` VALUES("200", "23", "0", "2014-11-05 10:28:08", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBlc3Qgb3V2ZXJ0IMOgIGwnw6l2b2x1dGlvbiBkdSBtb25kZSBkZXMgYWZmYWlyZXMgdGFudCBlbiBtYXRpw6hyZSBkJ8OpY2hhbmdlIGludGVybmF0aW9uYXV4IGV0IGQnaW5ub3ZhdGlvbiBkZXMgbW9kZXMgZGUgZMOpdmVsb3BwZW1lbnQgZHUgY29tbWVyY2Uu", "TmV3cyAtIE91ciBmaXJtIGtlZXBzIGEgY2xvc2UgZXllIG9uIGNoYW5nZXMgaW4gdGhlIGJ1c2luZXNzIHdvcmxkIGJvdGggYXMgY29uY2VybnMgaW50ZXJuYXRpb25hbCB0cmFkZSBhbmQgaW5ub3ZhdGlvbnMgaW4gdGhlIGRldmVsb3BtZW50IG9mIHRyYWRlLg==", "1");
INSERT INTO `wp_icl_translate` VALUES("201", "23", "0", "2014-11-05 10:28:08", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("202", "23", "0", "2014-11-05 10:28:08", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("203", "23", "0", "2014-11-05 10:28:08", "field-_yoast_wpseo_focuskw", "base64", "1", "YXZvY2F0", "TmV3cw==", "1");
INSERT INTO `wp_icl_translate` VALUES("204", "23", "0", "2014-11-05 10:28:08", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("205", "23", "0", "2014-11-05 10:28:08", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("208", "24", "0", "2015-01-04 22:24:25", "original_id", "", "0", "12117", "", "1");
INSERT INTO `wp_icl_translate` VALUES("209", "25", "0", "2015-01-05 11:19:52", "title", "base64", "1", "RMOpcGFydGVtZW50IGNvbnRlbnRpZXV4IGV0IGRyb2l0IGludGVybmF0aW9uYWw=", "MDNfRVhQRVJUSVNFUy0wNC1DT05URU5USUVVWCDnuqDnurfigJPlm73pmYXms5Xpg6g=", "1");
INSERT INTO `wp_icl_translate` VALUES("210", "25", "0", "2015-01-05 11:19:52", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("211", "25", "0", "2015-01-05 11:19:52", "original_id", "", "0", "12199", "", "1");
INSERT INTO `wp_icl_translate` VALUES("227", "31", "0", "2015-01-06 12:52:06", "title", "base64", "1", "UmVzdHJ1Y3R1cmluZyBldCBlbnRyZXByaXNlIGVuIGRpZmZpY3VsdMOp", "MDNfRVhQRVJUSVNFUy0wMy1SRVNUUlVDVFVSSU5HIOmHjee7hC3lm7DlooPkvIHkuJrpg6g=", "1");
INSERT INTO `wp_icl_translate` VALUES("228", "31", "0", "2015-01-06 12:52:06", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("223", "29", "0", "2015-01-06 12:05:26", "original_id", "", "0", "12207", "", "1");
INSERT INTO `wp_icl_translate` VALUES("217", "27", "0", "2015-01-06 11:26:33", "original_id", "", "0", "6575", "", "1");
INSERT INTO `wp_icl_translate` VALUES("230", "32", "0", "2015-01-06 14:01:42", "title", "base64", "1", "VHJhbnNhY3Rpb25z", "MDRfVFJBTlNBQ1RJT05TLVBBR0Ug5Lqk5piT", "1");
INSERT INTO `wp_icl_translate` VALUES("231", "32", "0", "2015-01-06 14:01:42", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("229", "31", "0", "2015-01-06 12:52:06", "original_id", "", "0", "12202", "", "1");
INSERT INTO `wp_icl_translate` VALUES("226", "30", "0", "2015-01-06 12:26:21", "original_id", "", "0", "12205", "", "1");
INSERT INTO `wp_icl_translate` VALUES("220", "28", "0", "2015-01-06 11:42:51", "original_id", "", "0", "13188", "", "1");
INSERT INTO `wp_icl_translate` VALUES("221", "29", "0", "2015-01-06 12:05:26", "title", "base64", "1", "RMOpcGFydGVtZW50IENvcnBvcmF0ZSAtIEZpbmFuY2U=", "MDNfRVhQRVJUSVNFUy0wMS1GSU5BTkNFUyDlhazlj7gt6LSi5Yqh6YOo", "1");
INSERT INTO `wp_icl_translate` VALUES("222", "29", "0", "2015-01-06 12:05:26", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("215", "27", "0", "2015-01-06 11:26:33", "title", "base64", "1", "Q2FiaW5ldCBkJ2F2b2NhdHMgZW4gZHJvaXQgZGVzIGFmZmFpcmVzIMOgIFRvdWxvdXNl", "MDFfSE9NRS1QQUdFIOWbvuWNouWFueWVhuazleW+i+W4iOS6i+WKoeaJgA==", "1");
INSERT INTO `wp_icl_translate` VALUES("216", "27", "0", "2015-01-06 11:26:33", "body", "base64", "1", "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", "W2JsYW5rX3NwYWNlciBoZWlnaHQ9IjMwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9jb2x1bW4gd2lkdGg9IjEvMyIgZWxfcG9zaXRpb249ImZpcnN0Il0gW2JveGVkX2NvbnRlbnQgdHlwZT0iY29sb3VyZWQiIGN1c3RvbV9iZ19jb2xvdXI9IiNmMmY3ZmEiIHBiX21hcmdpbl9ib3R0b209InllcyIgZWxfY2xhc3M9InB0MCBwYjAiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjxoMj7kuLvopoHku47kuovkuI7llYbms5Xnm7jlhbPnmoTmnI3liqEsPC9oMj4NCjxoND5HQU5ORSAmYW1wOyBBVk9DQVRT5LqL5Yqh5omA5Zyo5ZKo6K+i5Y+K57qg57q35pa56Z2i5ZCR5Y+R5Zu96ZmF5YW25LuW5Zu95a6255qE5a6i5oi35o+Q5L6b5pyN5Yqh44CCPC9oND4NClsvYm94ZWRfY29udGVudF0gWy9zcGJfY29sdW1uXSBbc3BiX2NvbHVtbiB3aWR0aD0iMi8zIiBlbF9wb3NpdGlvbj0ibGFzdCJdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjxoMT7miJHku6zkuLrmgqjmj5DkvpvnmoTkuJPkuJrmnI3liqE8L2gxPg0KWy9zcGJfdGV4dF9ibG9ja10gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMiIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz7lhazlj7jkuI7otKLliqE8L2gzPg0KR0FOTkUgJmFtcDsgQVZPQ0FUU+S6i+WKoeaJgOWcqOiejei1hOihjOWKqO+8jOWFrOWPuOi0ouWKoe+8jOadoOadhuaUtui0re+8jOengeWLn+iCoeadg+iejei1hO+8jOWQiOW5tuaUtui0reetiemihuWfn+S7juS6i+S4muWKoeOAguacrOS6i+WKoeaJgOWvueazleWbveWPiuWFtuS7luWbveWutuS8geS4mumbhuWbou+8jOWFrOWPuOS4u+euoe+8jOaKlei1hOWfuumHkeWPiuS/oei0t+acuuaehOe7meS6iOWNj+WKqeOAgg0KDQo8YSB0aXRsZT0i6K+m57uG5YaF5a65IiBocmVmPSJleHBlcnRpc2VzL2NvcnBvcmF0ZS1maW5hbmNlLyI+6K+m57uG5YaF5a65PC9hPg0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8yIiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDM+56iO5rOV5Y+K6LWE5Lqn566h55CGPC9oMz4NCkdBTk5FICZhbXA7IEFWT0NBVFPkuovliqHmiYDkuLrmgqjnmoTpnIDopoHmj5Dkvpvnm7jlupTlu7rorq7vvIzlubbnu5nlh7rlhbfkvZPlj4rmnInliJvmhI/nmoTop6PlhrPmlrnmoYjjgILmiJHku6zkvJrlnKjlhazlj7jvvIzkuI3liqjkuqflj4rotKLliqHkuqTmmJPmlrnpnaLluK7liqnmgqjjgILmiJHku6zov5jkvJrljY/liqnlrqLmiLfkvb/kuYvog73lpJ/kvJjljJblhbbml6XluLjmk43kvZznrqHnkIbnmoTnqI7liqHlvbHlk43jgIINCg0KPGEgdGl0bGU9IueojuazleWPiui1hOS6p+euoeeQhiIgaHJlZj0iZXhwZXJ0aXNlcy9kcm9pdC1maXNjYWwvIj7or6bnu4blhoXlrrk8L2E+DQoNClsvc3BiX3RleHRfYmxvY2tdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzIiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQo8aDM+6YeN57uE5Y+K5Zuw5aKD5LyB5LiaPC9oMz4NCuWcqOW6lOWvueS8geS4mui0ouWKoeWbsOmavuaWuemdou+8jEdBTk5FICZhbXA7IEFWT0NBVFPkuovliqHmiYDopobnm5bmiYDmnInnmoTljY/liqnku7vliqHlj4rkuI7ph43nu4TvvIzpooTpmLLlkozkvIHkuJrlm7Dpmr7lupTlr7nmlrnpnaLnmoTlkqjor6LmnI3liqHjgIINCg0KPGEgdGl0bGU9IumHjee7hOWPiuWbsOWig+S8geS4miIgaHJlZj0iZXhwZXJ0aXNlcy9yZXN0cnVjdHVyaW5nLyI+6K+m57uG5YaF5a65PC9hPg0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8yIiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDM+57qg57q35Y+K5Zu96ZmF5LqL5YqhPC9oMz4NCkdBTk5FICZhbXA7IEFWT0NBVFPkuovliqHmiYDku6PooajlhbblrqLmiLflnKjlm73lhoXvvIzmrKfmtLLnmoTmsJHkuovvvIzliJHkuovlj4rllYbkuJrms5Xluq3otbfor4nlj4rlupTor4njgIINCg0KPGEgdGl0bGU9Iue6oOe6t+WPiuWbvemZheS6i+WKoSIgaHJlZj0iZXhwZXJ0aXNlcy9jb250ZW50aWV1eC1kcm9pdC1pbnRlcm5hdGlvbmFsLyI+6K+m57uG5YaF5a65PC9hPg0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJ0aGluIiB0ZXh0PSJHbyB0byB0b3AiIGZ1bGxfd2lkdGg9Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjxoMj7miJHku6zlnKjmipXotYTln7rph5HmlrnpnaLnmoTlkqjor6I8L2gyPg0KWy9zcGJfdGV4dF9ibG9ja10gW2JveGVkX2NvbnRlbnQgdHlwZT0iY29sb3VyZWQiIGN1c3RvbV9iZ19jb2xvdXI9IiNmMmYyZjIiIHBiX21hcmdpbl9ib3R0b209InllcyIgZWxfY2xhc3M9InBiMCIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPHAgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPjxhIGhyZWY9IiNtb2RhbC0xIiBkYXRhLXRvZ2dsZT0ibW9kYWwiPjxpbWcgY2xhc3M9ImFsaWduY2VudGVyIHNpemUtZnVsbCB3cC1pbWFnZS0xMzQ2OCIgc3JjPSJodHRwOi8vd3d3Lmdhbm5lLWF2b2NhdHMuY29tL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDEzLzAzL2dhbm5lLWF2b2NhdHNfY2FwdHVyZS12aWRlb19pbnRlcnZpZXctY29uc2VpbC1mb25kLWludmVzdGlzc2VtZW50LmpwZyIgYWx0PSJDYXB0dXJlIGRlIGxhIHZpZMOpbyIgd2lkdGg9IjIwNiIgaGVpZ2h0PSIxNTAiIC8+PC9hPjwvcD4NCg0KPGg0IHN0eWxlPSJ0ZXh0LWFsaWduOiBjZW50ZXI7Ij5PbGl2aWVyIEdBTk5F5b6L5biI5ZyoSVTDqWzDqeeUteinhuWPsOeahOiuv+iwiDwvaDQ+DQo8aDUgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPuWVhuS4muW+i+W4iOWcqOaKlei1hOWfuumHkeaWuemdoueahOWSqOivojwvaDU+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX21vZGFsIGhlYWRlcj0iT2xpdmllciBHQU5OReW+i+W4iOWcqElUw6lsw6nnlLXop4blj7DnmoTorr/osIgiIGJ0bl9jb2xvdXI9ImFjY2VudCIgYnRuX3R5cGU9InN0YW5kYXJkIiBidG5fc2l6ZT0ic3RhbmRhcmQiIGJ0bl90ZXh0PSLop4LnnIvop4bpopEiXTwvcD4NCg0KPGRpdiBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W2V2cF9lbWJlZF92aWRlbyB1cmw9Ii4uL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDEzLzEwL2ludGVydmlld19vbGl2aWVyLWdhbm5lLm1wNCIgd2lkdGg9IjQwMCIgSGVpZ2h0PSIzMDAiIGF1dG9wbGF5PSJ0cnVlIl08L2Rpdj4NCjxwIHN0eWxlPSJ0ZXh0LWFsaWduOiBjZW50ZXI7Ij5bL3NmX21vZGFsXTwvcD4NClsvYm94ZWRfY29udGVudF0gWy9zcGJfY29sdW1uXQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("218", "28", "0", "2015-01-06 11:42:51", "title", "base64", "1", "QWNjb21wYWduZW1lbnQ=", "MDJfQUNDT01QQUdORU1FTlQtUEFHRSDmiJHku6znmoTljY/liqnpobnnm64=", "1");
INSERT INTO `wp_icl_translate` VALUES("219", "28", "0", "2015-01-06 11:42:51", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("224", "30", "0", "2015-01-06 12:26:21", "title", "base64", "1", "RHJvaXQgZmlzY2FsICYgR2VzdGlvbiBkZSBQYXRyaW1vaW5l", "MDNfRVhQRVJUSVNFUy0wMi1HRVNUSU9OUEFUIOeojuazlS3otYTkuqfnrqHnkIbpg6g=", "1");
INSERT INTO `wp_icl_translate` VALUES("225", "30", "0", "2015-01-06 12:26:21", "body", "base64", "1", "W2JveGVkX2NvbnRlbnQgdHlwZT0id2hpdGVzdHJva2UiIGN1c3RvbV9iZ19jb2xvdXI9IiNmZmZmZmYiIHBiX21hcmdpbl9ib3R0b209Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdDQoNCltvbmVfdGhpcmRdDQoNCjxhIHRpdGxlPSJWb2lyIGxhIGZpY2hlIGQnQXVyw6lsaWUgTUlDSEFVRCIgaHJlZj0iLi4vLi4vP3RlYW09YXVyZWxpZS1taWNoYXVkIj48aW1nIHNyYz0iLi4vLi4vd3AtY29udGVudC91cGxvYWRzLzIwMTMvMTAvQV9NaWNoYXV4X0MtMTUweDE1MC5qcGciIGFsdD0iQ2FiaW5ldCBHYW5uZSAmYW1wOyBBdm9jYXRzIC0gQXVyZWxpZSBNaWNoYXVkIiAvPjwvYT4NClsvb25lX3RoaXJkXQ0KW3R3b190aGlyZF9sYXN0XQ0KPGg0PlJlc3BvbnNhYmxlIGR1IETDqXBhcnRlbWVudCBEcm9pdCBGaXNjYWwgLSBHZXN0aW9uIGR1IFBhdHJpbW9pbmU8L2g0Pg0KTWHDrnRyZSBBdXLDqWxpZSBNSUNIQVVEDQoNCjxhIHRpdGxlPSJSZXRyb3V2ZXogbGEgZmljaGUgZCdBdXLDqWxpZSBNaWNoYXVkIiBocmVmPSIuLi8uLi8/dGVhbT1hdXJlbGllLW1pY2hhdWQiPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBWb2lyIGVuIGTDqXRhaWw8L2E+DQoNClsvdHdvX3RoaXJkX2xhc3RdDQoNClsvYm94ZWRfY29udGVudF0gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjMwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW2JveGVkX2NvbnRlbnQgdHlwZT0iY29sb3VyZWQiIGN1c3RvbV9iZ19jb2xvdXI9IiNmMmYyZjIiIGN1c3RvbV90ZXh0X2NvbG91cj0iIzMzMyIgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjxoNCBzdHlsZT0idGV4dC1hbGlnbjogbGVmdDsiPkxlIENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUU8Kgdm91cyBhc3Npc3RlIGRhbnMgbGUgY2FkcmUgZGUgdHJhbnNhY3Rpb25zPGk+IGNvcnBvcmF0ZTwvaT4sIGltbW9iaWxpw6hyZXMgZXQgZmluYW5jacOocmVzLiBTZXMgY2xpZW50cyBiw6luw6lmaWNpZW50IMOpZ2FsZW1lbnQgZOKAmXVuZSBhc3Npc3RhbmNlIHLDqWd1bGnDqHJlIGxldXIgcGVybWV0dGFudCBk4oCZb3B0aW1pc2VyIGxlcyBjb25zw6lxdWVuY2VzIGZpc2NhbGVzIGRlIGxldXJzIG9ww6lyYXRpb25zIGRlIGdlc3Rpb24gY291cmFudGUuPC9oND4NClsvYm94ZWRfY29udGVudF0gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjMwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9hY2NvcmRpb24gYWN0aXZlX3NlY3Rpb249IjAiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJGaXNjYWxpdMOpIGfDqW7DqXJhbGUgZGVzIGVudHJlcHJpc2VzIl0gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPHVsPg0KCTxsaT5Bc3Npc3RhbmNlIGRhbnMgbGEgZ2VzdGlvbiBmaXNjYWxlIGRlcyBncm91cGVzIG5hdGlvbmF1eCBldCBpbnRlcm5hdGlvbmF1eDwvbGk+DQoJPGxpPkF1ZGl0IGRlcyByaXNxdWVzwqA7IG9wdGltaXNhdGlvbsKgOyByZXN0cnVjdHVyYXRpb25zPC9saT4NCgk8bGk+UsOpbXVuw6lyYXRpb24gZGVzIHNhbGFyacOpcyBldCBkZXMgbWFuZGF0YWlyZXMgc29jaWF1eDwvbGk+DQoJPGxpPlByb2Jsw6ltYXRpcXVlcyBsacOpZXMgw6AgbOKAmWV4cGF0cmlhdGlvbiBldCDDoCBs4oCZaW1wYXRyaWF0aW9uPC9saT4NCgk8bGk+U3RvY2sgb3B0aW9ucywgQlNBLCBQRUUgZXQgYXV0cmVzIG3DqWNhbmlzbWVzIGTigJlpbnTDqXJlc3NlbWVudDwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJGaXNjYWxpdMOpIGRlcyBvcMOpcmF0aW9ucyBk4oCZYWNxdWlzaXRpb24sIGRlIGNlc3Npb24gZXQgZGUgcmVzdHJ1Y3R1cmF0aW9uIl0gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPHVsPg0KCTxsaT5EdWUgZGlsaWdlbmNlPC9saT4NCgk8bGk+U3RydWN0dXJhdGlvbiAoY29uY2VwdGlvbiBldCBtaXNlIGVuIMWTdXZyZSBkZSBtb250YWdlcyBhdmVjIG91IHNhbnMgZWZmZXQgZGUgbGV2aWVycyk8L2xpPg0KCTxsaT5PcHRpbWlzYXRpb24gZGVzIGZsdXggZmluYW5jaWVycyAoaW50w6lncmF0aW9uIGZpc2NhbGUsIFRWQSwgZHJvaXRzIGRlIG11dGF0aW9uLCBmaXNjYWxpdMOpIGludGVybmF0aW9uYWxlIGV0IGNvbnZlbnRpb25uZWxsZSk8L2xpPg0KCTxsaT5Bc3Npc3RhbmNlIGRhbnMgbGUgY2FkcmUgZGUgbGEgbsOpZ29jaWF0aW9uIGRlIGxhIGRvY3VtZW50YXRpb24gY29udHJhY3R1ZWxsZTwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJGaXNjYWxpdMOpIHBhdHJpbW9uaWFsZSBldCBpbW1vYmlsacOocmUiXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdDQo8dWw+DQoJPGxpPkluZ8OpbmllcmllIHBhdHJpbW9uaWFsZTwvbGk+DQoJPGxpPlRyYW5zbWlzc2lvbiBk4oCZZW50cmVwcmlzZXMgb3UgZGUgcGF0cmltb2luZXMgcHJpdsOpczwvbGk+DQoJPGxpPkZpc2NhbGl0w6kgZGVzIHJldmVudXMgZXQgSVNGKTwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJQcm9jw6lkdXJlcyBmaXNjYWxlcyJdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjx1bD4NCgk8bGk+QXNzaXN0YW5jZSBkYW5zIGxlIGNhZHJlIGRlIGNvbnRyw7RsZXMgZmlzY2F1eCBldCBkZSBjb250ZW50aWV1eCBhZG1pbmlzdHJhdGlmcyBldCBqdWRpY2lhaXJlczwvbGk+DQoJPGxpPk7DqWdvY2lhdGlvbiBwb3VyIGxlIGNvbXB0ZSBkZXMgY2xpZW50cyBkZSBzb2x1dGlvbnMgZ2xvYmFsZXMgYXZlYyBs4oCZQWRtaW5pc3RyYXRpb24gZmlzY2FsZTwvbGk+DQoJPGxpPkFzc2lzdGFuY2UgZGFucyBsZSBjYWRyZSBkZSBs4oCZb2J0ZW50aW9uIGTigJlhZ3LDqW1lbnRzPC9saT4NCjwvdWw+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbL3NwYl9hY2NvcmRpb25d", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("232", "32", "0", "2015-01-06 14:01:42", "original_id", "", "0", "2", "", "1");
INSERT INTO `wp_icl_translate` VALUES("233", "33", "0", "2015-01-06 15:52:04", "title", "base64", "1", "U29waGllIENPR05BVUxU", "U29waGllIENPR05BVUxU", "1");
INSERT INTO `wp_icl_translate` VALUES("234", "33", "0", "2015-01-06 15:52:04", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgQ09OVEVOVElFVVgg4oCTIERST0lUIElOVEVSTkFUSU9OQUwiIGhyZWY9Ii9leHBlcnRpc2UvY29udGVudGlldXgtZHJvaXRfaW50ZXJuYXRpb25hbC8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09OVEVOVElFVVgg4oCTIElOVEVSTkFUSU9OQUw8L2E+DQoNCkF2b2NhdCBhdSBCYXJyZWF1IGRlIFBhcmlzIHBlbmRhbnQgcGx1cyA1IGFucyBub3RhbW1lbnQgYXUgc2VpbiBkdSBjYWJpbmV0IGQnYWZmYWlyZXMgcGFyaXNpZW4gTEFNWSBMRVhFTCwgU29waGllIGEgcmVqb2ludCBsZSBDYWJpbmV0IEdBTk5FICZhbXA7IEFWT0NBVFMuDQoNCkRlIGZvcm1hdGlvbiBkZSBEcm9pdCBDb21tdW5hdXRhaXJlLCBTb3BoaWUgYSB0cmF2YWlsbMOpIGF2YW50IGQnZXhlcmNlciBlbiBxdWFsaXTDqSBkJ2F2b2NhdCDDoCBFdXJvIEluZm8gQ2VudHJlIGTDqXBlbmRhbnQgZGUgbGEgQ29tbWlzc2lvbiBFdXJvcMOpZW5uZS4NCg0KQmlsaW5ndWUgZW4gQW5nbGFpcywgU29waGllIGEgcGFydGljaXDDqSDDoCBwbHVzaWV1cnMgY29udGVudGlldXggdHJhbnNmcm9udGFsaWVycy4NCg0KWy9zcGJfdGV4dF9ibG9ja10=", "PGEgdGl0bGU9Iue6oOe6tyAtIOWbvemZhemDqOe7j+eQhiIgaHJlZj0iL3poLWhhbnMvZXhwZXJ0aXNlL2NvbnRlbnRpZXV4LWRyb2l0LWludGVybmF0aW9uYWwvIj48aSBjbGFzcz0iZmEtYW5nbGUtcmlnaHQiPjwvaT4g57qg57q3IC0g5Zu96ZmF6YOo57uP55CGPC9hPg0KDQrlt7Tpu47lvovluIhTb3BoaWUg5Zyo5Yqg5YWlR0FOTkUgJmFtcDsgQVZPQ0FUU+S6i+WKoeaJgOS5i+WJje+8jOabvue7j+WcqOW3tOm7jkxBTVkgTEVYRUzkuovliqHmiYDlt6XkvZzkuobkupTlubQNCg0KU29waGll5a2m5Lmg56S+5Yy65rOV5Ye66Lqr77yM5Zyo5LuO5LqL5b6L5biI5bel5L2c5LmL5YmN77yM5pu+57uP5Zyo5qyn55uf5aeU5ZGY5Lya55qE5qyn5rSy5L+h5oGv5Lit5b+D77yIRXVybyBJbmZvIENlbnRyZe+8ieW3peS9nOOAgg0KDQpTb3BoaWXnsr7pgJroi7Hor63vvIzmm77nu4/lj4LkuI7kuoblpJrmrKHot6jlooPnuqDnurfmoYjkvovjgII=", "1");
INSERT INTO `wp_icl_translate` VALUES("235", "33", "0", "2015-01-06 15:52:04", "original_id", "", "0", "12446", "", "1");
INSERT INTO `wp_icl_translate` VALUES("236", "33", "0", "2015-01-06 15:52:04", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29udGVudGlldXg=\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("237", "33", "0", "2015-01-06 15:52:04", "tag_ids", "", "0", "195,194,201,198,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("238", "33", "0", "2015-01-06 15:52:04", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIENPTlRFTlRJRVVY\"", "\"dG91bG91c2U=\"", "1");
INSERT INTO `wp_icl_translate` VALUES("239", "33", "0", "2015-01-06 15:52:04", "team-category_ids", "", "0", "187", "", "1");
INSERT INTO `wp_icl_translate` VALUES("247", "35", "0", "2015-01-06 16:12:27", "title", "base64", "1", "QXVyw6lsaWUgTUlDSEFVRA==", "QXVyw6lsaWUgTUlDSEFVRA==", "1");
INSERT INTO `wp_icl_translate` VALUES("248", "35", "0", "2015-01-06 16:12:27", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkUiIGhyZWY9Ii9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkU8L2E+DQoNCkLDqW7DqWZpY2lhbnQgZCd1bmUgZXhww6lyaWVuY2UgZGUgcGx1cyBkZSA5IGFubsOpZXMgZW4gbWF0acOocmUgZGUgY29uc2VpbCBldCBkw6l2ZWxvcHBlbWVudCBkZXMgZW50cmVwcmlzZXMsIEF1csOpbGllIGEgcGFydGljaXDDqSDDoCBkZXMgb3DDqXJhdGlvbnMgZGUgY2Vzc2lvbnMgZCdlbnZlcmd1cmUuDQpBdXLDqWxpZSBlc3QgdGl0dWxhaXJlIGQndW4gREVTUyBkZSBEcm9pdCBGaXNjYWwgZHUgUHJvZmVzc2V1ciBCZXJuYXJkIFBMQUdORVQgZXQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuDQoNClsvc3BiX3RleHRfYmxvY2td", "PGEgdGl0bGU9IueojuazlS3otYTkuqfnrqHnkIbpg6jnu4/nkIYiIGhyZWY9Ii96aC1oYW5zL2V4cGVydGlzZXMvZHJvaXQtZmlzY2FsLyI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IOeojuazlS3otYTkuqfnrqHnkIbpg6jnu4/nkIY8L2E+DQoNCkF1csOpbGll5pu+57uP5Zyo5LyB5Lia5Y+R5bGV5ZKo6K+i5pa56Z2i5pyJ5Lmd5bm055qE5bel5L2c57uP6aqM77yM5aW55pu+5Y+C5LiO5aSn5Z6L5Ye66K6p6KGM5Yqo44CCDQoNCkF1csOpbGll5oul5pyJQmVybmFyZCBQTEFHTkVU5pWZ5o6I55qE56iO5rOV56GV5aOr5paH5Yet77yM5bm25LiU5piv5b6L5biI6IGU5ZCI5Lya55qE6I635aWW6ICF44CCDQo=", "1");
INSERT INTO `wp_icl_translate` VALUES("240", "34", "0", "2015-01-06 16:00:52", "title", "base64", "1", "THVjaWxlIENBTE1FVFRF", "THVjaWxlIENBTE1FVFRF", "1");
INSERT INTO `wp_icl_translate` VALUES("241", "34", "0", "2015-01-06 16:00:52", "body", "base64", "1", "PGEgdGl0bGU9IkRFUEFSVEVNRU5UIFJFU1RSVUNUVVJJTkcg4oCTIEVOVFJFUFJJU0VTIEVOIERJRkZJQ1VMVMOJIiBocmVmPSIvZXhwZXJ0aXNlL3Jlc3RydWN0dXJpbmctZW50cmVwcmlzZXNfZGlmZmljdWx0ZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgUkVTVFJVQ1RVUklORyDigJMgRU5UUkVQUklTRVMgRU4gRElGRklDVUxUw4k8L2E+DQoNCkFwcsOocyBhdm9pciBpbnTDqWdyw6kgbGUgc2VydmljZSBqdXJpZGlxdWUgZGVzIGxhYm9yYXRvaXJlcyBQaWVycmUgRmFicmUsIEx1Y2lsZSBhIHJlam9pbnQgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIGVuIG1hdGnDqHJlIGRlIHJlc3RydWN0dXJhdGlvbiBkJ2VudHJlcHJpc2UuDQpMdWNpbGUgYsOpbsOpZmljaWUgZCd1biBkb3VibGUgY3Vyc3VzIDogZHJvaXQgZXQgZ2VzdGlvbiBkZXMgZW50cmVwcmlzZXMgLyBjb21wdGFiaWxpdMOpLg0KQXVqb3VyZCdodWksIEx1Y2lsZSBlc3QgcGFydGljdWxpw6hyZW1lbnQgaW52ZXN0aWUgZGFucyBsYSBtaXNlIGVuIHBsYWNlIGVuIEZyYW5jZSBkZSBwcm9qZXRzIGRlIENyb3dkZnVuZGluZyAvIEZpbmFuY2VtZW50IHBhcnRpY2lwYXRpZi4=", "PGEgdGl0bGU9IumHjee7hC3lm7DlooPkvIHkuJrpg6jnu4/nkIYiIGhyZWY9Ii96aC1oYW5zL2V4cGVydGlzZS9yZXN0cnVjdHVyaW5nLyI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IOmHjee7hC3lm7DlooPkvIHkuJrpg6jnu4/nkIY8L2E+DQoNCuWcqOWKoOWFpUdBTk5FICZhbXA7IEFWT0NBVFPkuovliqHmiYDov5vooYzkvIHkuJrph43nu4Tlt6XkvZzkuYvliY3vvIxMdWNpbGXmm77nu4/mmK9QaWVycmUgRmFicmXlrp7pqozlrqTnmoTlj7jms5XmnI3liqHpg6jpl6jkuIDlkZgNCg0KTHVjaWxl5pyJ6L+H5Y+M6YeN57uP5Y6G77ya5LyB5Lia566h55CG5rOVIC8g5Lya6K6h44CCDQoNCuS7iuWkqe+8jEx1Y2lsZeS4u+imgeS7juS6i+WcqOazleWbveW7uueri+S8l+etuSAvIOWPguS4juaAp+iejei1hOeahOiuoeWIkuOAgg==", "1");
INSERT INTO `wp_icl_translate` VALUES("242", "34", "0", "2015-01-06 16:00:52", "original_id", "", "0", "11981", "", "1");
INSERT INTO `wp_icl_translate` VALUES("243", "34", "0", "2015-01-06 16:00:52", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"cmVzdHJ1Y3R1cmluZw==\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("244", "34", "0", "2015-01-06 16:00:52", "tag_ids", "", "0", "195,194,197,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("245", "34", "0", "2015-01-06 16:00:52", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIFJFU1RSVUNUVVJBVElPTg==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("246", "34", "0", "2015-01-06 16:00:52", "team-category_ids", "", "0", "186", "", "1");
INSERT INTO `wp_icl_translate` VALUES("249", "35", "0", "2015-01-06 16:12:27", "original_id", "", "0", "11976", "", "1");
INSERT INTO `wp_icl_translate` VALUES("250", "35", "0", "2015-01-06 16:12:27", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"ZHJvaXQ=\",\"ZmlzY2Fs\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("251", "35", "0", "2015-01-06 16:12:27", "tag_ids", "", "0", "195,194,198,199,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("252", "35", "0", "2015-01-06 16:12:27", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIERST0lUIEZJU0NBTA==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("253", "35", "0", "2015-01-06 16:12:27", "team-category_ids", "", "0", "185", "", "1");
INSERT INTO `wp_icl_translate` VALUES("254", "36", "0", "2015-01-06 16:12:43", "title", "base64", "1", "T2xpdmllciBHQU5ORQ==", "T2xpdmllciBHQU5ORQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("255", "36", "0", "2015-01-06 16:12:43", "body", "base64", "1", "PGEgdGl0bGU9IkRFUEFSVEVNRU5UIENPUlBPUkFURSDigJMgRklOQU5DRSIgaHJlZj0iL2V4cGVydGlzZS9jb3Jwb3JhdGUtZmluYW5jZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09SUE9SQVRFIC0gRklOQU5DRTwvYT4NCjxkaXYgaWQ9Im1haW5faW50ZXJfZnVsbCI+QXZvY2F0IGRlcHVpcyAyMDAzLCBPbGl2aWVyIGVzdCBwYXNzw6kgcGFyIGRpZmbDqXJlbnRzIGNhYmluZXRzIGFuZ2xvLXNheG9ucyDDoCBQYXJpcyBldCBlbiBOb3V2ZWxsZSBaw6lsYW5kZSBhdmFudCBkZSBmb25kZXIgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIMOgIFRvdWxvdXNlLjwvZGl2Pg0KPGRpdj5PbGl2aWVyIGEgbm90YW1tZW50IHNvdXRlbnUgbGEgbWlzZSBlbiBwbGFjZSBkZSBww7RsZXMgZGUgY29tcMOpdGl0aXZpdMOpIGRhbnMgbGVzIGRvbWFpbmVzIGRlIGxhIFNhbnTDqSBldCBkZSBsJ0HDqXJvbmF1dGlxdWUuPC9kaXY+DQo8ZGl2PkFuY2llbiBQcsOpc2lkZW50IGRlcyBKLiBBdm9jYXRzIENvbnNlaWwgZW4gRW50cmVwcmlzZSBkZSBNaWRpLVB5csOpbsOpZXMsIE9saXZpZXIgZXN0IMOpZ2FsZW1lbnQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuPC9kaXY+", "PGEgdGl0bGU9IuWFrOWPuC3otKLliqHpg6jnu4/nkIYiIGhyZWY9Ii96aC1oYW5zL2V4cGVydGlzZXMvY29ycG9yYXRlLWZpbmFuY2UvIj48aSBjbGFzcz0iZmEtYW5nbGUtcmlnaHQiPjwvaT4g5YWs5Y+4Lei0ouWKoemDqOe7j+eQhjwvYT4NCg0K6IeqMjAwM+W5tOaIkOS4uuW+i+W4iOS7peadpe+8jE9saXZpZXLlnKjlm77ljaLlhbnliJvnq4tHQU5ORSAmIEFWT0NBVFPkuovliqHmiYDkuYvliY3vvIzmm77nu4/lnKjlt7Tpu47lkozmlrDopb/lhbDnmoTkuI3lkIznmoToi7Hor63kuovliqHmiYDlt6XkvZzjgIIgDQoNCk9saXZpZXLlnKjlu7rnq4vlgaXlurflkozoiKrnqbrpoobln5/nmoTnq57kuonlipvpm4bnvqTkuK3lgZrlh7rkuobotKHnjK7jgIINCg0KT2xpdmllcuaYr+WNl+avlOWIqeeJm+aWr++8iE1pZGktUHlyw6luw6llc++8ieS8geS4muW+i+W4iOeQhuS6i+S8muWJjeS4u+W4rSwg5Lmf5ZCM5pe25piv5b6L5biI6IGU5ZCI5Lya55qE6I635aWW6ICF44CCDQo=", "1");
INSERT INTO `wp_icl_translate` VALUES("256", "36", "0", "2015-01-06 16:12:43", "original_id", "", "0", "11038", "", "1");
INSERT INTO `wp_icl_translate` VALUES("257", "36", "0", "2015-01-06 16:12:43", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29ycG9yYXRl\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("258", "36", "0", "2015-01-06 16:12:43", "tag_ids", "", "0", "195,194,200,198,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("259", "36", "0", "2015-01-06 16:12:43", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIENPUlBPUkFURQ==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("260", "36", "0", "2015-01-06 16:12:43", "team-category_ids", "", "0", "184", "", "1");
INSERT INTO `wp_icl_translate` VALUES("261", "37", "0", "2015-01-06 16:19:48", "title", "base64", "1", "QWN0dWFsaXTDqXM=", "MDdfQUNUVUFMSVRFUy1QQUdFIOacgOaWsOaWsOmXuw==", "1");
INSERT INTO `wp_icl_translate` VALUES("262", "37", "0", "2015-01-06 16:19:48", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("263", "37", "0", "2015-01-06 16:19:48", "original_id", "", "0", "12154", "", "1");
INSERT INTO `wp_icl_translate` VALUES("264", "38", "0", "2015-01-06 16:42:20", "title", "base64", "1", "UmVjcnV0ZW1lbnQgZW4gZHJvaXQgZGVzIGFmZmFpcmVz", "MDVfUkVDUlVURU1FTlQtUEFHRSDllYbms5XkuJPkuJrmi5vogZg=", "1");
INSERT INTO `wp_icl_translate` VALUES("265", "38", "0", "2015-01-06 16:42:20", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("266", "38", "0", "2015-01-06 16:42:20", "original_id", "", "0", "11634", "", "1");
INSERT INTO `wp_icl_translate` VALUES("267", "39", "0", "2015-01-06 18:20:13", "title", "base64", "1", "QWNxdcOpcmV1cg==", "MDRfVFJBTlNBQ1RJT05TLTAxLUFDUVVFUkVVUiDmlLbotK3ogIU=", "1");
INSERT INTO `wp_icl_translate` VALUES("268", "39", "0", "2015-01-06 18:20:13", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5Qb3VyIG1pZXV4IHLDqXBvbmRyZSDDoCB2b3RyZSBiZXNvaW4sIG5vdXMgdm91cyBwcm9wb3NvbnMgZGUgY29tcGzDqXRlciBsZSBmb3JtdWxhaXJlIGNpLWRlc3NvdXMuPC9oMz4NCltjb250YWN0LWZvcm0tNyBpZD0iMTIxMDAiIHRpdGxlPSJWb3VzIMOqdGVzIGFjcXXDqXJldXIiXQ0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS80IiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDE+W2ljb24gaW1hZ2U9InNzLWJ1c2luZXNzdXNlciIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXVZvdXMgw6p0ZXMgVmVuZGV1cjwvaDE+DQo8aDQ+U2kgdm91cyBzb3VoYWl0ZXogdmVuZHJlIHVuIGZvbmRzIGRlIGNvbW1lcmNlIG91IGxlcyB0aXRyZXMgZOKAmXVuZSBTb2Npw6l0w6kgOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9mb3JtdWxhaXJlLXZlbmRldXIiIHRhcmdldD0iX3NlbGYiIGljb249InNzLWN1cnNvciIgZHJvcHNoYWRvdz0ieWVzIiBleHRyYWNsYXNzPSIiXUNsaXF1ZXotaWNpWy9zZl9idXR0b25dPC9wPg0KW2hyXQ0KDQo8aW1nIGNsYXNzPSJhbGlnbm5vbmUiIGFsdD0iU2FuZHJpbmUgRElBWiIgc3JjPSIuLi8uLi93cC1jb250ZW50L3VwbG9hZHMvMjAxMy8xMC9TX0RpYXpfQy0xNTB4MTUwLmpwZyIgd2lkdGg9IjE1MCIgaGVpZ2h0PSIxNTAiIC8+DQoNClBvdXIgdG91dCByZW5zZWlnbmVtZW50IGNvbXBsw6ltZW50YWlyZSwgTWFkYW1lIFNhbmRyaW5lIERJQVogZXN0IMOgIHZvdHJlIGRpc3Bvc2l0aW9uLg0KDQpbaWNvbiBpbWFnZT0ic3MtcGhvbmUiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il3CoCArMzMgKDApNS42MS4zMi42Ni45Mg0KDQpbaWNvbiBpbWFnZT0ic3MtbWFpbCIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXSA8YSB0aXRsZT0ibm90cmUgYXNzaXN0YW50ZSBqdXJpZGlxdWUgZXN0IMOgIHZvdHJlIMOpY291dGUiIGhyZWY9Im1haWx0bzpjb250YWN0QGdhbm5lLWF2b2NhdHMuY29tIj5jb250YWN0QGdhbm5lLWF2b2NhdHMuY29tPC9hPg0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjIvMyIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMj7kuLrkuobog73mm7Tlpb3lnLDlm57nrZTmgqjnmoTpnIDmsYLvvIzor7floavkuIvooajjgII8L2gyPg0KW2NvbnRhY3QtZm9ybS03IGlkPSIxMzk1MyIgdGl0bGU9IlZvdXMgw6p0ZXMgYWNxdcOpcmV1ciBaSCJdDQoNCiZuYnNwOw0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8zIiBlbF9wb3NpdGlvbj0ibGFzdCJdDQoNCiZuYnNwOw0KPGgyPltpY29uIGltYWdlPSJzcy1idXNpbmVzc3VzZXIiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il3mgqjmmK/lh7rllK7ogIU8L2gyPg0KPGg0PuWmguaenOaCqOW4jOacm+WHuuWUruW6l+mdouaIluWFrOWPuOivgeWIuO+8jOivt+eCuei/memHjO+8mjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi92ZW5kZXVyIiB0YXJnZXQ9Il9zZWxmIiBpY29uPSJzcy1jdXJzb3IiIGRyb3BzaGFkb3c9InllcyIgZXh0cmFjbGFzcz0iIl3ngrnlh7sgWy9zZl9idXR0b25dPC9wPg0KW2hyXQ0KDQo8aW1nIGNsYXNzPSJhbGlnbm5vbmUiIHNyYz0iLi4vLi4vd3AtY29udGVudC91cGxvYWRzLzIwMTMvMTAvU19EaWF6X0MtMTUweDE1MC5qcGciIGFsdD0iU2FuZHJpbmUgRElBWiIgd2lkdGg9IjE1MCIgaGVpZ2h0PSIxNTAiIC8+DQoNCuassuiOt+WPluWFtuS7luS/oeaBr++8jOivt+iBlOezu1NhbmRyaW5lIERJQVrlpbPlo6vjgIINCg0KW2ljb24gaW1hZ2U9InNzLXBob25lIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdwqAgKzMzICgwKTUuNjEuMzIuNjYuOTINCg0KW2ljb24gaW1hZ2U9InNzLW1haWwiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il0gPGEgaHJlZj0ibWFpbHRvOmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb20iPmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb208L2E+DQoNCiZuYnNwOw0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=", "1");
INSERT INTO `wp_icl_translate` VALUES("269", "39", "0", "2015-01-06 18:20:13", "original_id", "", "0", "12102", "", "1");
INSERT INTO `wp_icl_translate` VALUES("270", "40", "0", "2015-01-06 18:27:47", "title", "base64", "1", "VmVuZGV1cg==", "MDRfVFJBTlNBQ1RJT04tMDItVkVORCDlh7rllK7ogIXooajmoLw=", "1");
INSERT INTO `wp_icl_translate` VALUES("271", "40", "0", "2015-01-06 18:27:47", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5Qb3VyIG1pZXV4IHLDqXBvbmRyZSDDoCB2b3RyZSBiZXNvaW4sIG5vdXMgdm91cyBwcm9wb3NvbnMgZGUgY29tcGzDqXRlciBsZSBmb3JtdWxhaXJlIGNpLWRlc3NvdXMuPC9oMz4NCltjb250YWN0LWZvcm0tNyBpZD0iMTIwMjQiIHRpdGxlPSJWb3VzIMOqdGVzIHZlbmRldXIiXQ0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS80IiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDE+W2ljb24gaW1hZ2U9InNzLWJ1c2luZXNzdXNlciIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXVZvdXMgw6p0ZXMgQWNxdcOpcmV1cjwvaDE+DQo8aDQ+U2kgdm91cyBzb3VoYWl0ZXogYWNxdcOpcmlyIHVuIGZvbmRzIGRlIGNvbW1lcmNlIG91IGxlcyB0aXRyZXMgZOKAmXVuZSBTb2Npw6l0w6kgOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9mb3JtdWxhaXJlLWFjcXVlcmV1ciIgdGFyZ2V0PSJfc2VsZiIgaWNvbj0ic3MtY3Vyc29yIiBkcm9wc2hhZG93PSJ5ZXMiIGV4dHJhY2xhc3M9IiJdQ2xpcXVlei1pY2lbL3NmX2J1dHRvbl08L3A+DQpbaHJdDQoNCjxpbWcgYWx0PSJTYW5kcmluZSBESUFaIiBzcmM9Ii4uLy4uL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDEzLzEwL1NfRGlhel9DLTE1MHgxNTAuanBnIiB3aWR0aD0iMTUwIiBoZWlnaHQ9IjE1MCIgLz4NCg0KUG91ciB0b3V0IHJlbnNlaWduZW1lbnQgY29tcGzDqW1lbnRhaXJlLCBub3RyZSBBc3Npc3RhbmNlIEp1cmlkaXF1ZSBNYWRhbWUgU2FuZHJpbmUgRElBWiBlc3Qgw6Agdm90cmUgZGlzcG9zaXRpb24uDQoNCltpY29uIGltYWdlPSJzcy1waG9uZSIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXcKgICszMyAoMCk1LjYxLjMyLjY2LjkyDQoNCltpY29uIGltYWdlPSJzcy1tYWlsIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdIDxhIHRpdGxlPSJub3RyZSBhc3Npc3RhbnRlIGp1cmlkaXF1ZSBlc3Qgw6Agdm90cmUgw6ljb3V0ZSIgaHJlZj0ibWFpbHRvOmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb20iPmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb208L2E+DQoNCiZuYnNwOw0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjIvMyIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz7kuLrkuobog73mm7Tlpb3lnLDlm57nrZTmgqjnmoTpnIDmsYLvvIzor7floavkuIvooajjgII8L2gzPg0KW2NvbnRhY3QtZm9ybS03IGlkPSIxMzk1NCIgdGl0bGU9IlZvdXMgw6l0ZXMgdmVuZGV1ciBaSCJdDQoNClsvc3BiX3RleHRfYmxvY2tdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzMiIGVsX3Bvc2l0aW9uPSJsYXN0Il0NCjxoMT5baWNvbiBpbWFnZT0ic3MtYnVzaW5lc3N1c2VyIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJd5oKo5piv5pS26LSt6ICFPC9oMT4NCuWmguaenOaCqOW4jOacm+aUtui0reW6l+mdouaIluWFrOWPuOivgeWIuA0KPHAgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPltzZl9idXR0b24gY29sb3VyPSJhY2NlbnQiIHR5cGU9InN0YW5kYXJkIiBzaXplPSJzdGFuZGFyZCIgbGluaz0iLi4vYWNxdWVyZXVyIiB0YXJnZXQ9Il9zZWxmIiBpY29uPSJzcy1jdXJzb3IiIGRyb3BzaGFkb3c9InllcyIgZXh0cmFjbGFzcz0iIl3or7fngrnov5nph4xbL3NmX2J1dHRvbl08L3A+DQpbaHJdDQoNCuassuiOt+WPluWFtuS7luS/oeaBr++8jOivt+iBlOezu1NhbmRyaW5lIERJQVrlpbPlo6vjgIINCg0KW2ljb24gaW1hZ2U9InNzLXBob25lIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdwqAgKzMzICgwKTUuNjEuMzIuNjYuOTINCg0KW2ljb24gaW1hZ2U9InNzLW1haWwiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il0gPGEgdGl0bGU9Im5vdHJlIGFzc2lzdGFudGUganVyaWRpcXVlIGVzdCDDoCB2b3RyZSDDqWNvdXRlIiBocmVmPSJtYWlsdG86Y29udGFjdEBnYW5uZS1hdm9jYXRzLmNvbSI+Y29udGFjdEBnYW5uZS1hdm9jYXRzLmNvbTwvYT4NCg0KJm5ic3A7DQoNClsvc3BiX3RleHRfYmxvY2tdIFtkaXZpZGVyIHR5cGU9ImdvX3RvX3RvcF9pY29uMSIgdGV4dD0iR28gdG8gdG9wIiBmdWxsX3dpZHRoPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("272", "40", "0", "2015-01-06 18:27:47", "original_id", "", "0", "12048", "", "1");
INSERT INTO `wp_icl_translate` VALUES("273", "41", "0", "2015-01-06 18:52:21", "title", "base64", "1", "RXhwZXJ0aXNlcw==", "MDNfRVhQRVJUSVNFUy1QQUdFIOaIkeS7rOeahOS4k+S4muacjeWKoemhueebrg==", "1");
INSERT INTO `wp_icl_translate` VALUES("274", "41", "0", "2015-01-06 18:52:21", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("275", "41", "0", "2015-01-06 18:52:21", "original_id", "", "0", "1195", "", "1");
INSERT INTO `wp_icl_translate` VALUES("276", "42", "0", "2015-01-09 14:05:43", "title", "base64", "1", "Q29udGFjdA==", "MDZfQ29udGFjdCDogZTns7s=", "1");
INSERT INTO `wp_icl_translate` VALUES("277", "42", "0", "2015-01-09 14:05:43", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209InllcyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIyLzMiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQo8aDE+Tm91cyDDqWNyaXJlPC9oMT4NCltjb250YWN0LWZvcm0tNyBpZD0iNyIgdGl0bGU9IkZvcm11bGFpcmUgZGUgY29udGFjdCAxIl0NCg0KWy9zcGJfdGV4dF9ibG9ja10gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMyIgZWxfcG9zaXRpb249Imxhc3QiXQ0KPGgzIGNsYXNzPSJtdDAiPltpY29uIGltYWdlPSJmYS1tYXAtbWFya2VyIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdQWRyZXNzZSA6PC9oMz4NCjU1LCBhdmVudWUgTG91aXMgQnJlZ3VldA0KQsOidCBIZXJtw6hzIC0gNGUgw4l0YWdlDQozMTQwMCBUT1VMT1VTRQ0KPGgzPltpY29uIGltYWdlPSJzcy1jaGF0IiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdRMOpdGFpbHMgOjwvaDM+DQpUw6lsLiA6ICszMyAoMCk1LjYxLjMyLjY2LjkyDQpGYXggOiArMzMgKDApNS42MS41Mi4zNC43MA0KRW1haWwgOiBjb250YWN0QGdhbm5lLWF2b2NhdHMuY29tDQo8aDM+W2ljb24gaW1hZ2U9InNzLWNsb2NrIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdSG9yYWlyZXMgZCdvdXZlcnR1cmVzIDo8L2gzPg0KPHAgYWxpZ249ImxlZnQiPmR1IGx1bmRpIGF1IHZlbmRyZWRpIGRlIDloMDAgw6AgMTJoMzANCmV0IGRlIDE0aDAwIMOgIDE4aDMwPC9wPg0KWy9zcGJfdGV4dF9ibG9ja10gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjIwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW2RpdmlkZXIgdHlwZT0iZ29fdG9fdG9wX2ljb24xIiB0ZXh0PSJHbyB0byB0b3AiIGZ1bGxfd2lkdGg9Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJd", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209InllcyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIyLzMiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQo8aDE+5YaZ57uZ5oiR5LusPC9oMT4NCltjb250YWN0LWZvcm0tNyBpZD0iMTM5NTIiIHRpdGxlPSJGb3JtdWxhaXJlIGRlIGNvbnRhY3QgWkgiXQ0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8zIiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDMgY2xhc3M9Im10MCI+W2ljb24gaW1hZ2U9ImZhLW1hcC1tYXJrZXIiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il3lnLDlnYA6PC9oMz4NCjU1LCBhdmVudWUgTG91aXMgQnJlZ3VldA0KDQpCw6J0IEhlcm3DqHMgLSA0ZSDDiXRhZ2UNCg0KMzE0MDAgVE9VTE9VU0UNCjxoMz5baWNvbiBpbWFnZT0ic3MtY2hhdCIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXeivpue7huS/oeaBrzo8L2gzPg0K55S16K+d77yaKzMzICgwKTUuNjEuMzIuNjYuOTINCg0K5Lyg55yf77yaKzMzICgwKTUuNjEuNTIuMzQuNzANCg0K55S15a2Q5L+h566x77yaY29udGFjdEBnYW5uZS1hdm9jYXRzLmNvbQ0KPGgzPltpY29uIGltYWdlPSJzcy1jbG9jayIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXeW3peS9nOaXtumXtDo8L2gzPg0KPHAgYWxpZ249ImxlZnQiPjk6MDAgLSAxMjozMA0KMTQ6MDAgw6AgMTg6MzA8L3A+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbYmxhbmtfc3BhY2VyIGhlaWdodD0iMjBweCIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=", "1");
INSERT INTO `wp_icl_translate` VALUES("278", "42", "0", "2015-01-09 14:05:43", "original_id", "", "0", "6796", "", "1");
INSERT INTO `wp_icl_translate` VALUES("279", "43", "0", "2017-03-13 18:29:31", "title", "base64", "1", "RHJvaXQgZmlzY2FsICYgR2VzdGlvbiBkZSBQYXRyaW1vaW5l", "VGF4IExhdyAtIFdlYWx0aCBNYW5hZ2VtZW50IERlcGFydG1lbnQ=", "1");
INSERT INTO `wp_icl_translate` VALUES("280", "43", "0", "2017-03-13 18:29:31", "body", "base64", "1", "W2JveGVkX2NvbnRlbnQgdHlwZT0iY29sb3VyZWQiIGN1c3RvbV9iZ19jb2xvdXI9IiNmMmYyZjIiIGN1c3RvbV90ZXh0X2NvbG91cj0iIzMzMyIgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjxoNCBzdHlsZT0idGV4dC1hbGlnbjogbGVmdDsiPkxlIENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUU8Kgdm91cyBhc3Npc3RlIGRhbnMgbGUgY2FkcmUgZGUgdHJhbnNhY3Rpb25zPGk+IGNvcnBvcmF0ZTwvaT4sIGltbW9iaWxpw6hyZXMgZXQgZmluYW5jacOocmVzLiBTZXMgY2xpZW50cyBiw6luw6lmaWNpZW50IMOpZ2FsZW1lbnQgZOKAmXVuZSBhc3Npc3RhbmNlIHLDqWd1bGnDqHJlIGxldXIgcGVybWV0dGFudCBk4oCZb3B0aW1pc2VyIGxlcyBjb25zw6lxdWVuY2VzIGZpc2NhbGVzIGRlIGxldXJzIG9ww6lyYXRpb25zIGRlIGdlc3Rpb24gY291cmFudGUuPC9oND4NClsvYm94ZWRfY29udGVudF0gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjMwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9hY2NvcmRpb24gYWN0aXZlX3NlY3Rpb249IjAiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJGaXNjYWxpdMOpIGfDqW7DqXJhbGUgZGVzIGVudHJlcHJpc2VzIl0gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPHVsPg0KIAk8bGk+QXNzaXN0YW5jZSBkYW5zIGxhIGdlc3Rpb24gZmlzY2FsZSBkZXMgZ3JvdXBlcyBuYXRpb25hdXggZXQgaW50ZXJuYXRpb25hdXg8L2xpPg0KIAk8bGk+QXVkaXQgZGVzIHJpc3F1ZXPCoDsgb3B0aW1pc2F0aW9uwqA7IHJlc3RydWN0dXJhdGlvbnM8L2xpPg0KIAk8bGk+UsOpbXVuw6lyYXRpb24gZGVzIHNhbGFyacOpcyBldCBkZXMgbWFuZGF0YWlyZXMgc29jaWF1eDwvbGk+DQogCTxsaT5Qcm9ibMOpbWF0aXF1ZXMgbGnDqWVzIMOgIGzigJlleHBhdHJpYXRpb24gZXQgw6AgbOKAmWltcGF0cmlhdGlvbjwvbGk+DQogCTxsaT5TdG9jayBvcHRpb25zLCBCU0EsIFBFRSBldCBhdXRyZXMgbcOpY2FuaXNtZXMgZOKAmWludMOpcmVzc2VtZW50PC9saT4NCjwvdWw+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbc3BiX2FjY29yZGlvbl90YWIgdGl0bGU9IkZpc2NhbGl0w6kgZGVzIG9ww6lyYXRpb25zIGTigJlhY3F1aXNpdGlvbiwgZGUgY2Vzc2lvbiBldCBkZSByZXN0cnVjdHVyYXRpb24iXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdDQo8dWw+DQogCTxsaT5EdWUgZGlsaWdlbmNlPC9saT4NCiAJPGxpPlN0cnVjdHVyYXRpb24gKGNvbmNlcHRpb24gZXQgbWlzZSBlbiDFk3V2cmUgZGUgbW9udGFnZXMgYXZlYyBvdSBzYW5zIGVmZmV0IGRlIGxldmllcnMpPC9saT4NCiAJPGxpPk9wdGltaXNhdGlvbiBkZXMgZmx1eCBmaW5hbmNpZXJzIChpbnTDqWdyYXRpb24gZmlzY2FsZSwgVFZBLCBkcm9pdHMgZGUgbXV0YXRpb24sIGZpc2NhbGl0w6kgaW50ZXJuYXRpb25hbGUgZXQgY29udmVudGlvbm5lbGxlKTwvbGk+DQogCTxsaT5Bc3Npc3RhbmNlIGRhbnMgbGUgY2FkcmUgZGUgbGEgbsOpZ29jaWF0aW9uIGRlIGxhIGRvY3VtZW50YXRpb24gY29udHJhY3R1ZWxsZTwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJGaXNjYWxpdMOpIHBhdHJpbW9uaWFsZSBldCBpbW1vYmlsacOocmUiXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdDQo8dWw+DQogCTxsaT5JbmfDqW5pZXJpZSBwYXRyaW1vbmlhbGU8L2xpPg0KIAk8bGk+VHJhbnNtaXNzaW9uIGTigJllbnRyZXByaXNlcyBvdSBkZSBwYXRyaW1vaW5lcyBwcml2w6lzPC9saT4NCiAJPGxpPkZpc2NhbGl0w6kgZGVzIHJldmVudXMgZXQgSVNGKTwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJQcm9jw6lkdXJlcyBmaXNjYWxlcyJdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjx1bD4NCiAJPGxpPkFzc2lzdGFuY2UgZGFucyBsZSBjYWRyZSBkZSBjb250csO0bGVzIGZpc2NhdXggZXQgZGUgY29udGVudGlldXggYWRtaW5pc3RyYXRpZnMgZXQganVkaWNpYWlyZXM8L2xpPg0KIAk8bGk+TsOpZ29jaWF0aW9uIHBvdXIgbGUgY29tcHRlIGRlcyBjbGllbnRzIGRlIHNvbHV0aW9ucyBnbG9iYWxlcyBhdmVjIGzigJlBZG1pbmlzdHJhdGlvbiBmaXNjYWxlPC9saT4NCiAJPGxpPkFzc2lzdGFuY2UgZGFucyBsZSBjYWRyZSBkZSBs4oCZb2J0ZW50aW9uIGTigJlhZ3LDqW1lbnRzPC9saT4NCjwvdWw+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbL3NwYl9hY2NvcmRpb25d", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("281", "43", "0", "2017-03-13 18:29:31", "original_id", "", "0", "12205", "", "1");
INSERT INTO `wp_icl_translate` VALUES("282", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_title", "base64", "1", "QXZvY2F0IMOgIFRvdWxvdXNlIC0gRHJvaXQgZmlzY2FsIC0gR0FOTkUgJiBBVk9DQVRT", "TGVnYWwgZmlybSBzcGVjaWFsaXppbmcgaW4gYnVzaW5lc3MgbGF3IGluIFRvdWxvdXNlIC0gVGF4IGxhdyAtIEdBTk5FICYgQVZPQ0FUUw==", "1");
INSERT INTO `wp_icl_translate` VALUES("283", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("284", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("285", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBhc3Npc3RlIGxlcyBlbnRyZXByaXNlcyBlbiBkcm9pdCBmaXNjYWwgbG9ycyBkZSB0cmFuc2FjdGlvbnMgY29ycG9yYXRlLCBpbW1vYmlsacOocmVzIGV0IGZpbmFuY2nDqHJlcy4=", "VGhlIGZpcm0gb2ZmZXJzIGNvbXBhbmllcyB0YXggbGF3IGFzc2lzdGFuY2UgZm9yIGNvcnBvcmF0ZSwgcHJvcGVydHkgYW5kIGZpbmFuY2lhbCB0cmFuc2FjdGlvbnMu", "1");
INSERT INTO `wp_icl_translate` VALUES("286", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("287", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("288", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_focuskw", "base64", "1", "ZHJvaXQgZmlzY2Fs", "VGF4IGxhdw==", "1");
INSERT INTO `wp_icl_translate` VALUES("289", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("290", "43", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("291", "44", "0", "2017-03-13 18:29:31", "title", "base64", "1", "RHJvaXQgZmlzY2FsICYgR2VzdGlvbiBkZSBQYXRyaW1vaW5l", "RHJvaXQgZmlzY2FsICYgR2VzdGlvbiBkZSBQYXRyaW1vaW5l", "1");
INSERT INTO `wp_icl_translate` VALUES("292", "44", "0", "2017-03-13 18:29:31", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("293", "44", "0", "2017-03-13 18:29:31", "original_id", "", "0", "12205", "", "1");
INSERT INTO `wp_icl_translate` VALUES("294", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_title", "base64", "1", "QXZvY2F0IMOgIFRvdWxvdXNlIC0gRHJvaXQgZmlzY2FsIC0gR0FOTkUgJiBBVk9DQVRT", "5Zu+5Y2i5YW55b6L5biIIOKAk+eojuazlSAtIEdBTk5FICYgQVZPQ0FUUw==", "1");
INSERT INTO `wp_icl_translate` VALUES("295", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("296", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("297", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBhc3Npc3RlIGxlcyBlbnRyZXByaXNlcyBlbiBkcm9pdCBmaXNjYWwgbG9ycyBkZSB0cmFuc2FjdGlvbnMgY29ycG9yYXRlLCBpbW1vYmlsacOocmVzIGV0IGZpbmFuY2nDqHJlcy4=", "5LqL5Yqh5omA5Zyo56iO5rOV6aKG5Z+f5biu5Yqp5LyB5Lia6L+b6KGM5YWs5Y+477yM5LiN5Yqo5Lqn5Y+K6YeR6J6N5Lqk5piT44CC", "1");
INSERT INTO `wp_icl_translate` VALUES("298", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("299", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("300", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_focuskw", "base64", "1", "ZHJvaXQgZmlzY2Fs", "ZHJvaXQgZmlzY2Fs", "1");
INSERT INTO `wp_icl_translate` VALUES("301", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("302", "44", "0", "2017-03-13 18:29:31", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("305", "45", "0", "2017-03-13 18:34:07", "original_id", "", "0", "1195", "", "0");
INSERT INTO `wp_icl_translate` VALUES("306", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_title", "base64", "1", "R0FOTkUgJiBBdm9jYXRzIC0gKzMzICgwKTUuNjEuMzIuNjYuOTIgLSBsZSBjYWJpbmV0IGQnYXZvY2F0IGV4cGVydCBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgw6AgVG91bG91c2U=", "TGF3IGZpcm0gaW4gVG91bG91c2Ugc3BlY2lhbGl6aW5nIGluIGJ1c2luZXNzIGxhdyDigJMgRXhwZXJ0aXNlIGluIGJ1c2luZXNzIGxhdyAtIEdBTk5FICYgQVZPQ0FUUw==", "0");
INSERT INTO `wp_icl_translate` VALUES("307", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "0");
INSERT INTO `wp_icl_translate` VALUES("308", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "0");
INSERT INTO `wp_icl_translate` VALUES("309", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBHQU5ORSAmIEF2b2NhdHMgw6AgVG91bG91c2UgaW50ZXJ2aWVudCBhdmVjIHVuZSBleHBlcnRpc2UgYXVwcsOocyBkZSBzYSBjbGllbnTDqGxlIGRlIHByb2Zlc3Npb25lbHMgLSBURUxFUEhPTkUgOiArMzMgKDApNS42MS4zMi42Ni45Mg==", "VGhlIGxhdyBmaXJtIC0gR0FOTkUgJiBBVk9DQVRTIGFzc2lzdHMgaXRzIGNsaWVudHMgaW4gZmluYW5jaW5nLCBjb3Jwb3JhdGUgZmluYW5jZSwgTEJPLCBwcml2YXRlIGVxdWl0eSBhbmQgbWVyZ2VycyBhbmQgYWNxdWlzaXRpb25zIG9wZXJhdGlvbnMu", "0");
INSERT INTO `wp_icl_translate` VALUES("310", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "0");
INSERT INTO `wp_icl_translate` VALUES("311", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "0");
INSERT INTO `wp_icl_translate` VALUES("312", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_focuskw", "base64", "1", "ZXhwZXJ0aXNl", "TGF3IGZpcm0=", "1");
INSERT INTO `wp_icl_translate` VALUES("313", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "0");
INSERT INTO `wp_icl_translate` VALUES("314", "45", "0", "2017-03-13 18:34:07", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "0");
INSERT INTO `wp_icl_translate` VALUES("315", "46", "0", "2017-03-13 18:34:08", "title", "base64", "1", "RXhwZXJ0aXNlcw==", "RXhwZXJ0aXNlcw==", "1");
INSERT INTO `wp_icl_translate` VALUES("316", "46", "0", "2017-03-13 18:34:08", "body", "base64", "1", "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", "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", "1");
INSERT INTO `wp_icl_translate` VALUES("317", "46", "0", "2017-03-13 18:34:08", "original_id", "", "0", "1195", "", "1");
INSERT INTO `wp_icl_translate` VALUES("318", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_title", "base64", "1", "R0FOTkUgJiBBdm9jYXRzIC0gKzMzICgwKTUuNjEuMzIuNjYuOTIgLSBsZSBjYWJpbmV0IGQnYXZvY2F0IGV4cGVydCBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgw6AgVG91bG91c2U=", "5Zu+5Y2i5YW55b6L5biILeWVhuazleS4k+S4muacjeWKoQ==", "1");
INSERT INTO `wp_icl_translate` VALUES("319", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_title-name", "", "0", "_yoast_wpseo_title", "", "1");
INSERT INTO `wp_icl_translate` VALUES("320", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_title-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("321", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_metadesc", "base64", "1", "TGUgY2FiaW5ldCBHQU5ORSAmIEF2b2NhdHMgw6AgVG91bG91c2UgaW50ZXJ2aWVudCBhdmVjIHVuZSBleHBlcnRpc2UgYXVwcsOocyBkZSBzYSBjbGllbnTDqGxlIGRlIHByb2Zlc3Npb25lbHMgLSBURUxFUEhPTkUgOiArMzMgKDApNS42MS4zMi42Ni45Mg==", "6YCa6L+H5LiN5ZCM6YOo6Zeo77yM5Zu+5Y2i5YW55b6L5biI5LqL5Yqh5omA5Li65YW25LiT5Lia5a6i5oi35Zyo5ZKo6K+i5ZKM57qg57q35pa56Z2i5o+Q5L6b5pyN5Yqh44CC", "1");
INSERT INTO `wp_icl_translate` VALUES("322", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("323", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("324", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_focuskw", "base64", "1", "ZXhwZXJ0aXNl", "5oiR5Lus55qE5LiT5Lia5pyN5Yqh6aG555uu", "1");
INSERT INTO `wp_icl_translate` VALUES("325", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("326", "46", "0", "2017-03-13 18:34:08", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("327", "47", "0", "2017-03-13 18:39:05", "title", "base64", "1", "QXVyw6lsaWUgTUlDSEFVRA==", "QXVyw6lsaWUgTUlDSEFVRA==", "1");
INSERT INTO `wp_icl_translate` VALUES("328", "47", "0", "2017-03-13 18:39:05", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkUiIGhyZWY9Ii9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkU8L2E+DQoNCkLDqW7DqWZpY2lhbnQgZCd1bmUgZXhww6lyaWVuY2UgZGUgcGx1cyBkZSA5IGFubsOpZXMgZW4gbWF0acOocmUgZGUgY29uc2VpbCBldCBkw6l2ZWxvcHBlbWVudCBkZXMgZW50cmVwcmlzZXMsIEF1csOpbGllIGEgcGFydGljaXDDqSDDoCBkZXMgb3DDqXJhdGlvbnMgZGUgY2Vzc2lvbnMgZCdlbnZlcmd1cmUuDQpBdXLDqWxpZSBlc3QgdGl0dWxhaXJlIGQndW4gREVTUyBkZSBEcm9pdCBGaXNjYWwgZHUgUHJvZmVzc2V1ciBCZXJuYXJkIFBMQUdORVQgZXQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuDQoNClsvc3BiX3RleHRfYmxvY2td", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iVEFYIExBVyDigJMgV0VBTFRIIE1BTkFHRU1FTlQgRGVwYXJ0bWVudCIgaHJlZj0iL2V4cGVydGlzZS9kcm9pdF9maXNjYWwtZ2VzdGlvbl9wYXRyaW1vaW5lLyI+PGkgY2xhc3M9ImZhLWFuZ2xlLXJpZ2h0Ij48L2k+IE1hbmFnZXIgb2YgdGhlICBUQVggTEFXIOKAkyBXRUFMVEggTUFOQUdFTUVOVCBEZXBhcnRtZW50PC9hPg0KDQpXaXRoIG92ZXIgbmluZSB5ZWFyc+KAmSBleHBlcmllbmNlIGluIGNvbnN1bHRpbmcgYW5kIGNvcnBvcmF0ZSBkZXZlbG9wbWVudCwgQXVyw6lsaWUgaGFzIHBhcnRpY2lwYXRlZCBpbiBsYXJnZS1zY2FsZSBkaXNwb3NhbCBvcGVyYXRpb25zLg0KQXVyw6lsaWUgaG9sZHMgYSBERVNTIGdyYWR1YXRlIGRlZ3JlZSBpbiBUYXggTGF3IHVuZGVyIFByb2Zlc3NvciBCZXJuYXJkIFBsYWduZXQgYW5kIGlzIGEgbGF1cmVhdGUgb2YgdGhlIENvbmbDqXJlbmNlIGRlcyBBdm9jYXRzLg0KWy9zcGJfdGV4dF9ibG9ja10=", "1");
INSERT INTO `wp_icl_translate` VALUES("329", "47", "0", "2017-03-13 18:39:05", "original_id", "", "0", "11976", "", "0");
INSERT INTO `wp_icl_translate` VALUES("330", "47", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_metadesc", "base64", "1", "QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBkcm9pdCBmaXNjYWwgZXQgZ2VzdGlvbiBkdSBwYXRyaW1vaW5l", "", "1");
INSERT INTO `wp_icl_translate` VALUES("331", "47", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "0");
INSERT INTO `wp_icl_translate` VALUES("332", "47", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "0");
INSERT INTO `wp_icl_translate` VALUES("333", "47", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_focuskw", "base64", "1", "YXZvY2F0LCBnZXN0aW9uLCBwYXRyaW1vaW5lLCBmaXNjYWwsIGZpc2NhbGl0w6ksIGZpbmFuY2VtZW50LCB0b3Vsb3VzZSwgcGFyaXM=", "", "1");
INSERT INTO `wp_icl_translate` VALUES("334", "47", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "0");
INSERT INTO `wp_icl_translate` VALUES("335", "47", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "0");
INSERT INTO `wp_icl_translate` VALUES("336", "47", "0", "2017-03-13 18:39:05", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"ZHJvaXQ=\",\"ZmlzY2Fs\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("337", "47", "0", "2017-03-13 18:39:05", "tag_ids", "", "0", "195,194,198,199,196", "", "0");
INSERT INTO `wp_icl_translate` VALUES("338", "47", "0", "2017-03-13 18:39:05", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIERST0lUIEZJU0NBTA==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("339", "47", "0", "2017-03-13 18:39:05", "team-category_ids", "", "0", "185", "", "0");
INSERT INTO `wp_icl_translate` VALUES("340", "48", "0", "2017-03-13 18:39:05", "title", "base64", "1", "QXVyw6lsaWUgTUlDSEFVRA==", "QXVyw6lsaWUgTUlDSEFVRA==", "1");
INSERT INTO `wp_icl_translate` VALUES("341", "48", "0", "2017-03-13 18:39:05", "body", "base64", "1", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkUiIGhyZWY9Ii9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkU8L2E+DQoNCkLDqW7DqWZpY2lhbnQgZCd1bmUgZXhww6lyaWVuY2UgZGUgcGx1cyBkZSA5IGFubsOpZXMgZW4gbWF0acOocmUgZGUgY29uc2VpbCBldCBkw6l2ZWxvcHBlbWVudCBkZXMgZW50cmVwcmlzZXMsIEF1csOpbGllIGEgcGFydGljaXDDqSDDoCBkZXMgb3DDqXJhdGlvbnMgZGUgY2Vzc2lvbnMgZCdlbnZlcmd1cmUuDQpBdXLDqWxpZSBlc3QgdGl0dWxhaXJlIGQndW4gREVTUyBkZSBEcm9pdCBGaXNjYWwgZHUgUHJvZmVzc2V1ciBCZXJuYXJkIFBMQUdORVQgZXQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuDQoNClsvc3BiX3RleHRfYmxvY2td", "W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkUiIGhyZWY9Ii9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkU8L2E+DQoNCkLDqW7DqWZpY2lhbnQgZCd1bmUgZXhww6lyaWVuY2UgZGUgcGx1cyBkZSA5IGFubsOpZXMgZW4gbWF0acOocmUgZGUgY29uc2VpbCBldCBkw6l2ZWxvcHBlbWVudCBkZXMgZW50cmVwcmlzZXMsIEF1csOpbGllIGEgcGFydGljaXDDqSDDoCBkZXMgb3DDqXJhdGlvbnMgZGUgY2Vzc2lvbnMgZCdlbnZlcmd1cmUuDQpBdXLDqWxpZSBlc3QgdGl0dWxhaXJlIGQndW4gREVTUyBkZSBEcm9pdCBGaXNjYWwgZHUgUHJvZmVzc2V1ciBCZXJuYXJkIFBMQUdORVQgZXQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuDQoNClsvc3BiX3RleHRfYmxvY2td", "1");
INSERT INTO `wp_icl_translate` VALUES("342", "48", "0", "2017-03-13 18:39:05", "original_id", "", "0", "11976", "", "1");
INSERT INTO `wp_icl_translate` VALUES("343", "48", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_metadesc", "base64", "1", "QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBkcm9pdCBmaXNjYWwgZXQgZ2VzdGlvbiBkdSBwYXRyaW1vaW5l", "", "1");
INSERT INTO `wp_icl_translate` VALUES("344", "48", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_metadesc-name", "", "0", "_yoast_wpseo_metadesc", "", "1");
INSERT INTO `wp_icl_translate` VALUES("345", "48", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_metadesc-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("346", "48", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_focuskw", "base64", "1", "YXZvY2F0LCBnZXN0aW9uLCBwYXRyaW1vaW5lLCBmaXNjYWwsIGZpc2NhbGl0w6ksIGZpbmFuY2VtZW50LCB0b3Vsb3VzZSwgcGFyaXM=", "", "1");
INSERT INTO `wp_icl_translate` VALUES("347", "48", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_focuskw-name", "", "0", "_yoast_wpseo_focuskw", "", "1");
INSERT INTO `wp_icl_translate` VALUES("348", "48", "0", "2017-03-13 18:39:05", "field-_yoast_wpseo_focuskw-type", "", "0", "custom_field", "", "1");
INSERT INTO `wp_icl_translate` VALUES("349", "48", "0", "2017-03-13 18:39:05", "tags", "csv_base64", "1", "\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"ZHJvaXQ=\",\"ZmlzY2Fs\",\"dG91bG91c2U=\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("350", "48", "0", "2017-03-13 18:39:05", "tag_ids", "", "0", "195,194,198,199,196", "", "1");
INSERT INTO `wp_icl_translate` VALUES("351", "48", "0", "2017-03-13 18:39:05", "team-category", "csv_base64", "1", "\"RMOJUEFSVEVNRU5UIERST0lUIEZJU0NBTA==\"", "", "1");
INSERT INTO `wp_icl_translate` VALUES("352", "48", "0", "2017-03-13 18:39:05", "team-category_ids", "", "0", "185", "", "1");

/* INSERT TABLE DATA: wp_icl_translate_job */
INSERT INTO `wp_icl_translate_job` VALUES("1", "1", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("2", "2", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("3", "3", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("4", "4", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("5", "5", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("6", "6", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("7", "7", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("8", "8", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("9", "9", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("10", "10", "0", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("11", "11", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("12", "12", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("13", "13", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("14", "14", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("15", "15", "0", "0", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("16", "16", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("17", "17", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("18", "18", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("19", "19", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("20", "10", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("21", "2", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("22", "3", "1", "1", "1", "2");
INSERT INTO `wp_icl_translate_job` VALUES("23", "11", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("24", "20", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("25", "21", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("27", "23", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("28", "24", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("29", "25", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("30", "26", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("31", "27", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("32", "28", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("33", "29", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("34", "30", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("35", "31", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("36", "32", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("37", "33", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("38", "34", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("39", "35", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("40", "36", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("41", "37", "1", "1", "1", "1");
INSERT INTO `wp_icl_translate_job` VALUES("42", "38", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("43", "6", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("44", "26", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("45", "3", "1", "0", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("46", "37", "1", "1", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("47", "18", "1", "0", "1", NULL);
INSERT INTO `wp_icl_translate_job` VALUES("48", "31", "1", "1", "1", NULL);

/* INSERT TABLE DATA: wp_icl_translation_status */
INSERT INTO `wp_icl_translation_status` VALUES("1", "1165", "10", "1", "0", "4d0455f432ee2240fb42b929824123f7", "local", "a:2:{s:3:\"url\";s:41:\"http://www.ganne-avocats.com?page_id=6575\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:68:\"Q2FiaW5ldCBkJ2F2b2NhdHMgZW4gZHJvaXQgZGVzIGFmZmFpcmVzIMOgIFRvdWxvdXNl\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:5976:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:6575;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:68:\"Q2FiaW5ldCBkJ2F2b2NhdHMgZW4gZHJvaXQgZGVzIGFmZmFpcmVzIMOgIFRvdWxvdXNl\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:212:\"U3DDqWNpYWxpc8OpIGVuIGRyb2l0IGRlcyBhZmZhaXJlcywgbGUgY2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgaW50ZXJ2aWVudCB0YW50IGVuIG1hdGnDqHJlIGRlIGNvbnNlaWwgcXVlIGRlIGNvbnRlbnRpZXV4IGF1cHLDqHMgZGVzIGVudHJlcHJpc2VzIMOgIFRvdWxvdXNlLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:24:\"ZHJvaXQgZGVzIGFmZmFpcmVz\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-29 14:57:28", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("2", "1192", "10", "1", "0", "3191cbd355b20fc300e3b305463c7b90", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=13188\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"QWNjb21wYWduZW1lbnQ=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:4652:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:13188;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:296:\"TCdhY2NvbXBhZ25lbWVudCBkZXMgZW50cmVwcmVuZXVycyBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgZXN0IGxlIGZvbmRlbWVudCBwcmluY2lwYWwgZGUgbCdhY3Rpdml0w6kgZHUgQ2FiaW5ldCAtIG5vcyBkb21haW5lcyBkZSBjb21ww6l0ZW5jZXMgOiBmaXNjYWxpdMOpLCBkcm9pdCBkZXMgc29jacOpdMOpcywgZHJvaXQgY29tbWVyY2lhbCwgdHJhbnNtaXNzaW9uIGQnZW50cmVwcmlzZXMu\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"YWNjb21wYWduZW1lbnQ=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-29 16:36:48", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("3", "1193", "10", "1", "1", "5f35ceb9b632f9469747e868a9b2ccd8", "local", "a:2:{s:3:\"url\";s:41:\"http://www.ganne-avocats.com?page_id=1195\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"RXhwZXJ0aXNlcw==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:6600:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:1195;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:136:\"R0FOTkUgJiBBdm9jYXRzIC0gKzMzICgwKTUuNjEuMzIuNjYuOTIgLSBsZSBjYWJpbmV0IGQnYXZvY2F0IGV4cGVydCBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgw6AgVG91bG91c2U=\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:196:\"TGUgY2FiaW5ldCBHQU5ORSAmIEF2b2NhdHMgw6AgVG91bG91c2UgaW50ZXJ2aWVudCBhdmVjIHVuZSBleHBlcnRpc2UgYXVwcsOocyBkZSBzYSBjbGllbnTDqGxlIGRlIHByb2Zlc3Npb25lbHMgLSBURUxFUEhPTkUgOiArMzMgKDApNS42MS4zMi42Ni45Mg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:12:\"ZXhwZXJ0aXNl\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-29 17:02:48", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("4", "1195", "10", "1", "0", "c4424e2213e89e1f9d4614058ae93a79", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12199\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:64:\"RMOpcGFydGVtZW50IGNvbnRlbnRpZXV4IGV0IGRyb2l0IGludGVybmF0aW9uYWw=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:2464:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12199;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:212:\"TGUgQ2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgcmVwcsOpc2VudGUgc2VzIGNsaWVudHMgcG91ciB0b3V0IGNvbnRlbnRpZXV4IGRldmFudCBsZXMganVyaWRpY3Rpb25zIGNpdmlsZXMsIHDDqW5hbGVzIGV0IGNvbW1lcmNpYWxlcyBuYXRpb25hbGVzIGV0IGV1cm9ww6llbm5lcy4=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"Y29udGVudGlldXg=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-29 19:32:24", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("5", "1196", "10", "1", "0", "5f2a14b02c402395373270b5307b295d", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12207\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:44:\"RMOpcGFydGVtZW50IENvcnBvcmF0ZSAtIEZpbmFuY2U=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:5820:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12207;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:184:\"TGUgQ2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgaW50ZXJ2aWVudCBzdXIgZGVzIG9ww6lyYXRpb25zIGRlIGZpbmFuY2VtZW50LCBkZSBjb3Jwb3JhdGUgZmluYW5jZSwgTEJPLCBwcml2YXRlIGVxdWl0eSwgZnVzaW9uLWFjcXVpc2l0aW9uLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:12:\"Y29ycG9yYXRl\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-30 09:38:22", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("6", "1197", "10", "1", "0", "0044a13c3556e9fd74b2e7e9ac54049b", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12205\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:48:\"RHJvaXQgZmlzY2FsICYgR2VzdGlvbiBkZSBQYXRyaW1vaW5l\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:3592:\"W2JveGVkX2NvbnRlbnQgdHlwZT0iY29sb3VyZWQiIGN1c3RvbV9iZ19jb2xvdXI9IiNmMmYyZjIiIGN1c3RvbV90ZXh0X2NvbG91cj0iIzMzMyIgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjxoNCBzdHlsZT0idGV4dC1hbGlnbjogbGVmdDsiPkxlIENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUU8Kgdm91cyBhc3Npc3RlIGRhbnMgbGUgY2FkcmUgZGUgdHJhbnNhY3Rpb25zPGk+IGNvcnBvcmF0ZTwvaT4sIGltbW9iaWxpw6hyZXMgZXQgZmluYW5jacOocmVzLiBTZXMgY2xpZW50cyBiw6luw6lmaWNpZW50IMOpZ2FsZW1lbnQgZOKAmXVuZSBhc3Npc3RhbmNlIHLDqWd1bGnDqHJlIGxldXIgcGVybWV0dGFudCBk4oCZb3B0aW1pc2VyIGxlcyBjb25zw6lxdWVuY2VzIGZpc2NhbGVzIGRlIGxldXJzIG9ww6lyYXRpb25zIGRlIGdlc3Rpb24gY291cmFudGUuPC9oND4NClsvYm94ZWRfY29udGVudF0gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjMwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9hY2NvcmRpb24gYWN0aXZlX3NlY3Rpb249IjAiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJGaXNjYWxpdMOpIGfDqW7DqXJhbGUgZGVzIGVudHJlcHJpc2VzIl0gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KPHVsPg0KIAk8bGk+QXNzaXN0YW5jZSBkYW5zIGxhIGdlc3Rpb24gZmlzY2FsZSBkZXMgZ3JvdXBlcyBuYXRpb25hdXggZXQgaW50ZXJuYXRpb25hdXg8L2xpPg0KIAk8bGk+QXVkaXQgZGVzIHJpc3F1ZXPCoDsgb3B0aW1pc2F0aW9uwqA7IHJlc3RydWN0dXJhdGlvbnM8L2xpPg0KIAk8bGk+UsOpbXVuw6lyYXRpb24gZGVzIHNhbGFyacOpcyBldCBkZXMgbWFuZGF0YWlyZXMgc29jaWF1eDwvbGk+DQogCTxsaT5Qcm9ibMOpbWF0aXF1ZXMgbGnDqWVzIMOgIGzigJlleHBhdHJpYXRpb24gZXQgw6AgbOKAmWltcGF0cmlhdGlvbjwvbGk+DQogCTxsaT5TdG9jayBvcHRpb25zLCBCU0EsIFBFRSBldCBhdXRyZXMgbcOpY2FuaXNtZXMgZOKAmWludMOpcmVzc2VtZW50PC9saT4NCjwvdWw+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbc3BiX2FjY29yZGlvbl90YWIgdGl0bGU9IkZpc2NhbGl0w6kgZGVzIG9ww6lyYXRpb25zIGTigJlhY3F1aXNpdGlvbiwgZGUgY2Vzc2lvbiBldCBkZSByZXN0cnVjdHVyYXRpb24iXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdDQo8dWw+DQogCTxsaT5EdWUgZGlsaWdlbmNlPC9saT4NCiAJPGxpPlN0cnVjdHVyYXRpb24gKGNvbmNlcHRpb24gZXQgbWlzZSBlbiDFk3V2cmUgZGUgbW9udGFnZXMgYXZlYyBvdSBzYW5zIGVmZmV0IGRlIGxldmllcnMpPC9saT4NCiAJPGxpPk9wdGltaXNhdGlvbiBkZXMgZmx1eCBmaW5hbmNpZXJzIChpbnTDqWdyYXRpb24gZmlzY2FsZSwgVFZBLCBkcm9pdHMgZGUgbXV0YXRpb24sIGZpc2NhbGl0w6kgaW50ZXJuYXRpb25hbGUgZXQgY29udmVudGlvbm5lbGxlKTwvbGk+DQogCTxsaT5Bc3Npc3RhbmNlIGRhbnMgbGUgY2FkcmUgZGUgbGEgbsOpZ29jaWF0aW9uIGRlIGxhIGRvY3VtZW50YXRpb24gY29udHJhY3R1ZWxsZTwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJGaXNjYWxpdMOpIHBhdHJpbW9uaWFsZSBldCBpbW1vYmlsacOocmUiXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdDQo8dWw+DQogCTxsaT5JbmfDqW5pZXJpZSBwYXRyaW1vbmlhbGU8L2xpPg0KIAk8bGk+VHJhbnNtaXNzaW9uIGTigJllbnRyZXByaXNlcyBvdSBkZSBwYXRyaW1vaW5lcyBwcml2w6lzPC9saT4NCiAJPGxpPkZpc2NhbGl0w6kgZGVzIHJldmVudXMgZXQgSVNGKTwvbGk+DQo8L3VsPg0KWy9zcGJfdGV4dF9ibG9ja10gWy9zcGJfYWNjb3JkaW9uX3RhYl0gW3NwYl9hY2NvcmRpb25fdGFiIHRpdGxlPSJQcm9jw6lkdXJlcyBmaXNjYWxlcyJdIFtzcGJfdGV4dF9ibG9jayBwYl9tYXJnaW5fYm90dG9tPSJubyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0NCjx1bD4NCiAJPGxpPkFzc2lzdGFuY2UgZGFucyBsZSBjYWRyZSBkZSBjb250csO0bGVzIGZpc2NhdXggZXQgZGUgY29udGVudGlldXggYWRtaW5pc3RyYXRpZnMgZXQganVkaWNpYWlyZXM8L2xpPg0KIAk8bGk+TsOpZ29jaWF0aW9uIHBvdXIgbGUgY29tcHRlIGRlcyBjbGllbnRzIGRlIHNvbHV0aW9ucyBnbG9iYWxlcyBhdmVjIGzigJlBZG1pbmlzdHJhdGlvbiBmaXNjYWxlPC9saT4NCiAJPGxpPkFzc2lzdGFuY2UgZGFucyBsZSBjYWRyZSBkZSBs4oCZb2J0ZW50aW9uIGTigJlhZ3LDqW1lbnRzPC9saT4NCjwvdWw+DQpbL3NwYl90ZXh0X2Jsb2NrXSBbL3NwYl9hY2NvcmRpb25fdGFiXSBbL3NwYl9hY2NvcmRpb25d\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12205;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:68:\"QXZvY2F0IMOgIFRvdWxvdXNlIC0gRHJvaXQgZmlzY2FsIC0gR0FOTkUgJiBBVk9DQVRT\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:152:\"TGUgY2FiaW5ldCBhc3Npc3RlIGxlcyBlbnRyZXByaXNlcyBlbiBkcm9pdCBmaXNjYWwgbG9ycyBkZSB0cmFuc2FjdGlvbnMgY29ycG9yYXRlLCBpbW1vYmlsacOocmVzIGV0IGZpbmFuY2nDqHJlcy4=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"ZHJvaXQgZmlzY2Fs\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-30 09:53:16", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("7", "1198", "10", "1", "0", "9e81f705b105f3b4ea6ddf46012e1b0d", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12202\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:56:\"UmVzdHJ1Y3R1cmluZyBldCBlbnRyZXByaXNlIGVuIGRpZmZpY3VsdMOp\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:4384:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12202;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:100:\"QXZvY2F0cyDDoCBUb3Vsb3VzZSBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgLSBSZXN0cnVjdHVyaW5nIC0gR2FubmUgJiBBdm9jYXRz\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:184:\"TWlzc2lvbnMgZOKAmWFzc2lzdGFuY2UgZXQgZGUgY29uc2VpbCBkYW5zIGxlIGNhZHJlIGRlIGxhIHByw6l2ZW50aW9uIGV0IGR1IHRyYWl0ZW1lbnQgZGVzIGRpZmZpY3VsdMOpcyBkZXMgZW50cmVwcmlzZXMgOiByZXN0cnVjdHVyaW5nLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"cmVzdHJ1Y3R1cmluZw==\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-30 10:04:05", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("8", "1199", "10", "1", "0", "55dc0450878ec3dca647cebedb0ba600", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=11634\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:44:\"UmVjcnV0ZW1lbnQgZW4gZHJvaXQgZGVzIGFmZmFpcmVz\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:4784:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:11634;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:204:\"TGUgY2FiaW5ldCBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgb2ZmcmUgZGVzIHBvc3NpYmlsaXTDqXMgZGUgY2FycmnDqHJlIGV0IGTigJnDqXZvbHV0aW9uIGZvbmTDqWVzIHN1ciBsZSBtw6lyaXRlLCBsYSByZXNwb25zYWJpbGl0w6kgZXQgbGEgcGVyc29ubmFsaXTDqS4=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:24:\"ZHJvaXQgZGVzIGFmZmFpcmVz\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-30 10:05:26", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("9", "1200", "10", "1", "0", "e1d12eb72e88619bd00a2fc40b2fcb36", "local", "a:2:{s:3:\"url\";s:38:\"http://www.ganne-avocats.com?page_id=2\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"VHJhbnNhY3Rpb25z\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:3868:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:2;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:72:\"QXZvY2F0cyDDoCBUb3Vsb3VzZSAtIFRyYW5zYWN0aW9ucyAtIEdhbm5lICYgQXZvY2F0cw==\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:216:\"U3DDqWNpYWxpc8OpIGVuIG1hdGnDqHJlIGRlIHRyYW5zYWN0aW9ucyBldCBkZSB0cmFuc21pc3Npb25zIGTigJllbnRyZXByaXNlcyBldCBkZSBmb25kcyBkZSBjb21tZXJjZSwgbGUgY2FiaW5ldCBlc3Qgw6Agdm90cmUgZGlzcG9zaXRpb24gcG91ciB2b3VzIGFjY29tcGFnbmVyLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"dHJhbnNhY3Rpb25z\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-30 10:23:41", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("10", "1201", "10", "1", "0", "b43409a2a481141239d6407b23d17446", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12117\";s:8:\"contents\";a:3:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:28:\"SW5mb3JtYXRpb25zIGzDqWdhbGVz\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16880:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12117;}}}", "2014-10-30 10:31:51", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("11", "1202", "10", "1", "0", "fb0a17a1bdfd5b1acb5d5f5f1ef96169", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12154\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"QWN0dWFsaXTDqXM=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:5584:\"W3NwYl9yb3cgcGFyYWxsYXhfdmlkZW9faGVpZ2h0PSJ2aWRlby1oZWlnaHQiIHBhcmFsbGF4X2ltYWdlX2hlaWdodD0iY29udGVudC1oZWlnaHQiIHBhcmFsbGF4X2ltYWdlX21vdmVtZW50PSJmaXhlZCIgcGFyYWxsYXhfaW1hZ2Vfc3BlZWQ9IjAuNSIgcm93X292ZXJsYXlfb3BhY2l0eT0iMCIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXSBbYm94ZWRfY29udGVudCB0aXRsZT0iREVSTklFUkUgQUNUVUFMSVRFIiB0eXBlPSJ3aGl0ZXN0cm9rZSIgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzQiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQoNCk1hw650cmUgT2xpdmllciBHQU5ORSwgYXZvY2F0IGVuIGRyb2l0IGZpbmFuY2llciwgZXN0IGNvbnN1bHTDqSBkYW5zIGwnYXJ0aWNsZSBzdXIgbGUgc2l0ZSBpbnRlcm5ldCBkZSBMYSBEw6lww6pjaGUgZHUgTWlkaSBpbnRpdHVsw6kgPGVtPkFybmFxdWUgw6AgbGEgY3JldmV0dGUgYnLDqXNpbGllbm5lIDogZW5xdcOqdGUgc3VyIGRlcyBjb250cmF0cyBsaXRpZ2lldXg8L2VtPiBvw7kgaWwgcHLDqXNlbnRlIGxlcyBkaWZmw6lyZW50ZXMgc2FuY3Rpb25zIGVuY291cnVlcyBkYW5zIGxlIGNhZHJlIGRlIGNldHRlIGFmZmFpcmUuDQo8YSB0aXRsZT0iT2xpdmllciBHQU5ORSwgZXhwZXJ0IGVuIGRyb2l0IGZpbmFuY2llciDDoCBUb3Vsb3VzZSIgaHJlZj0iaHR0cDovL3d3dy5sYWRlcGVjaGUuZnIvYXJ0aWNsZS8yMDE0LzA5LzE2LzE5NTI1NzYtYXJuYXF1ZS1hLWxhLWNyZXZldHRlLWJyZXNpbGllbm5lLWVucXVldGUtc3VyLWRlcy1jb250cmF0cy1saXRpZ2lldXguaHRtbCIgdGFyZ2V0PSJfYmxhbmsiPkxpZW4gdmVycyBsJ2FydGljbGU8L2E+DQoNClsvYm94ZWRfY29udGVudF0gW2JveGVkX2NvbnRlbnQgdGl0bGU9IlNVSVNTRSIgdHlwZT0id2hpdGVzdHJva2UiIHBiX21hcmdpbl9ib3R0b209Im5vIiB3aWR0aD0iMS80Il0NCg0KQWNjb21wYWduZW1lbnQgZOKAmXVuZSBzb2Npw6l0w6kgaW5ub3ZhbnRlIGxvcnMgZGUgbGEgcHLDqXNlbnRhdGlvbiBkZSBzYSB0ZWNobm9sb2dpZSBkYW5zIGxlIGNhZHJlIGR1IGNvbmNvdXJzIGTigJlpbm5vdmF0aW9uIGRlcyB0ZWNobm9sb2dpZXMgbcOpZGljYWxlcyBkZXZhbnQgNDAgZm9uZHMgZOKAmWludmVzdGlzc2VtZW50cyBTdWlzc2UgZXQgw6l0cmFuZ2Vycy4NCg0KUGFydGljaXBhdGlvbiBkdSBDYWJpbmV0IEdBTk5FICZhbXA7IEFWT0NBVFMgYXUgc2Fsb24gZGUgbOKAmWlubm92YXRpb24gbcOpZGljYWxlIDogIkFscGluZSBWZW50dXJlIEZvcnVtIiDDoCBMYXVzYW5uZS4NCg0KWy9ib3hlZF9jb250ZW50XSBbYm94ZWRfY29udGVudCB0aXRsZT0iRlJBTkNFIiB0eXBlPSJ3aGl0ZXN0cm9rZSIgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzQiXQ0KDQo8aW1nIHNyYz0iLi4vd3AtY29udGVudC91cGxvYWRzLzIwMTMvMTAvb2xpdmllcl9nYW5uZV9lbHlzc2UtMzAweDIwNi5qcGciIGFsdD0iT2xpdmllciBHYW5uZSByZcOndSDDoCBsJ0VseXPDqWUiIC8+DQoNCk1lIE9saXZpZXIgR0FOTkUsIGFuY2llbiBQcsOpc2lkZW50IGRlcyBKLiBBdm9jYXRzIENvbnNlaWwgZOKAmUVudHJlcHJpc2VzLCByZcOndSDDoCBs4oCZw4lseXPDqWUuDQoNClsvYm94ZWRfY29udGVudF0gW2JveGVkX2NvbnRlbnQgdGl0bGU9IkZSQU5DRSIgdHlwZT0id2hpdGVzdHJva2UiIHBiX21hcmdpbl9ib3R0b209Im5vIiB3aWR0aD0iMS80IiBlbF9wb3NpdGlvbj0ibGFzdCJdDQoNCkNvbmbDqXJlbmNlIGR1IENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUUyBlbiBwYXJ0ZW5hcmlhdCBhdmVjIGxhIGNoYW1icmUgZnJhbmNvLWFtw6lyaWNhaW5lIHBvdXIgbOKAmWltcGxhbnRhdGlvbiBkZXMgZW50cmVwcmlzZXMgYW3DqXJpY2FpbmVzIGVuIE1pZGktUHlyw6luw6llcy4NCg0KPGEgdGl0bGU9IlBERiBERSBMQSBQUkVTRU5UQVRJT04iIGhyZWY9Ii4uL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDEzLzEwL0dBTk5FQVZPQ0FUUy1QUkVTRU5UQVRJT04tSU5WRVNUSVNUTUVOVC1PUFBPUlRVTklUSUVTLUZPUi1BTUVSSUNBTi1DT01QQU5JRVMtTUlESS1QWVJFTk5FUy1SRUdJT04ucGRmIj5Uw6lsw6ljaGFyZ2VyIGxhIFByw6lzZW50YXRpb248L2E+DQoNCjxhIHRpdGxlPSJPTElWSUVSIEdBTk5FIiBocmVmPSIuLi8/dGVhbT1vbGl2aWVyLWdhbm5lIj5NZSBPbGl2aWVyIEdBTk5FPC9hPiwgYW5jaWVuIFByw6lzaWRlbnQgZGVzIEpldW5lcyBBdm9jYXRzIENvbnNlaWwgZOKAmUVudHJlcHJpc2VzLCByZcOndSDDoCBs4oCZw4lseXPDqWUuDQoNClsvYm94ZWRfY29udGVudF0gWy9zcGJfcm93XSBbc3BiX3JvdyBwYXJhbGxheF92aWRlb19oZWlnaHQ9InZpZGVvLWhlaWdodCIgcGFyYWxsYXhfaW1hZ2VfaGVpZ2h0PSJjb250ZW50LWhlaWdodCIgcGFyYWxsYXhfaW1hZ2VfbW92ZW1lbnQ9ImZpeGVkIiBwYXJhbGxheF9pbWFnZV9zcGVlZD0iMC41IiByb3dfb3ZlcmxheV9vcGFjaXR5PSIwIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJdIFtib3hlZF9jb250ZW50IHRpdGxlPSJORVctWU9SSyIgdHlwZT0id2hpdGVzdHJva2UiIHBiX21hcmdpbl9ib3R0b209Im5vIiB3aWR0aD0iMS8zIiBlbF9wb3NpdGlvbj0iZmlyc3QiXQ0KDQpSZW5jb250cmVzIGRlIDxhIHRpdGxlPSJMdWNpbGUgQ0FMTUVUVEUiIGhyZWY9Ii4uLz90ZWFtPWx1Y2lsZS1jYWxtZXR0ZSI+TWUgTHVjaWxlIENBTE1FVFRFPC9hPiBhdmVjIGludmVzdGlzc2V1cnMgc3VyIGxhIHRow6ltYXRpcXVlIGR1IENyb3dkZnVkaW5nLg0KDQpbL2JveGVkX2NvbnRlbnRdIFtib3hlZF9jb250ZW50IHRpdGxlPSJIT05HIEtPTkciIHR5cGU9IndoaXRlc3Ryb2tlIiBwYl9tYXJnaW5fYm90dG9tPSJubyIgd2lkdGg9IjEvMyJdDQoNCkNvbmbDqXJlbmNlIGR1IENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUUyBzdXIgbGVzIGNvbnRyYXRzIGRlIGTDqXZlbG9wcGVtZW50IGRlIG1hc3RlciBmcmFuY2hpc2UgYXVwcsOocyBkZXMgZnJhbsOnYWlzIGV4cGF0cmnDqXMgZW4gQXNpZS4NCg0KWy9ib3hlZF9jb250ZW50XSBbYm94ZWRfY29udGVudCB0aXRsZT0iQ0hJTkUiIHR5cGU9IndoaXRlc3Ryb2tlIiBwYl9tYXJnaW5fYm90dG9tPSJubyIgd2lkdGg9IjEvMyIgZWxfcG9zaXRpb249Imxhc3QiXQ0KDQpQYXJ0aWNpcGF0aW9uIGR1IENhYmluZXQgR0FOTkUgJmFtcDsgQVZPQ0FUUyDDoCBsYSAiQ2hpbmEgSW1wb3J0IGFuZCBFeHBvcnQgRmFpciIgw6AgR3Vhbmd6aG91Lg0KDQpbL2JveGVkX2NvbnRlbnRdIFsvc3BiX3Jvd10gW3NwYl9yb3cgcGFyYWxsYXhfdmlkZW9faGVpZ2h0PSJ2aWRlby1oZWlnaHQiIHBhcmFsbGF4X2ltYWdlX2hlaWdodD0iY29udGVudC1oZWlnaHQiIHBhcmFsbGF4X2ltYWdlX21vdmVtZW50PSJmaXhlZCIgcGFyYWxsYXhfaW1hZ2Vfc3BlZWQ9IjAuNSIgcm93X292ZXJsYXlfb3BhY2l0eT0iMCIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXSBbYm94ZWRfY29udGVudCB0aXRsZT0iSVRBTElFIiB0eXBlPSJ3aGl0ZXN0cm9rZSIgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHdpZHRoPSIxLzMiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQoNClJlbmNvbnRyZSBjb25mcsOocmVzIGl0YWxpZW5zIGRhbnMgbGUgY2FkcmUgZGUgbWlzZSBlbiBwbGFjZSBkZSBqb2ludC12ZW50dXJlIGVuIG1hdGnDqHJlIGF1dG9tb2JpbGUuDQoNClsvYm94ZWRfY29udGVudF0gW2JveGVkX2NvbnRlbnQgdGl0bGU9IlNwb25zb3JpbmcgQUZSSVFVRSIgdHlwZT0id2hpdGVzdHJva2UiIHBiX21hcmdpbl9ib3R0b209Im5vIiB3aWR0aD0iMS8zIl0NCg0KU291dGllbiBkdSA0TCBUcm9waGkgZGFucyBsZSBjYWRyZSBkZSBs4oCZYXBwb3J0IGTigJlhaWRlcyBodW1hbml0YWlyZXMgZW4gQWZyaXF1ZS4NCg0KWy9ib3hlZF9jb250ZW50XSBbYm94ZWRfY29udGVudCB0aXRsZT0iU3BvbnNvcmluZyBBUkdFTlRJTkUiIHR5cGU9IndoaXRlc3Ryb2tlIiBwYl9tYXJnaW5fYm90dG9tPSJubyIgd2lkdGg9IjEvMyIgZWxfcG9zaXRpb249Imxhc3QiXQ0KDQpSZW5jb250cmVzIHJ1Z2J5c3RpcXVlcyA6DQrDiXF1aXBlIGRlIHJ1Z2J5IGR1IFBhbGFpcyBkZSBUb3Vsb3VzZSBjb250cmUgbOKAmcOpcXVpcGUgZGUgQnVlbm9zIEFpcmVzDQoNClsvYm94ZWRfY29udGVudF0gWy9zcGJfcm93XQ==\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12154;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:212:\"TGUgY2FiaW5ldCBlc3Qgb3V2ZXJ0IMOgIGwnw6l2b2x1dGlvbiBkdSBtb25kZSBkZXMgYWZmYWlyZXMgdGFudCBlbiBtYXRpw6hyZSBkJ8OpY2hhbmdlIGludGVybmF0aW9uYXV4IGV0IGQnaW5ub3ZhdGlvbiBkZXMgbW9kZXMgZGUgZMOpdmVsb3BwZW1lbnQgZHUgY29tbWVyY2Uu\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:8:\"YXZvY2F0\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-30 10:50:21", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("12", "1203", "10", "1", "0", "37f1259f914b373c0a41459afd5fad03", "local", "a:2:{s:3:\"url\";s:41:\"http://www.ganne-avocats.com?page_id=6796\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:12:\"Q29udGFjdA==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:1364:\"W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209InllcyIgcGJfYm9yZGVyX2JvdHRvbT0ibm8iIHdpZHRoPSIyLzMiIGVsX3Bvc2l0aW9uPSJmaXJzdCJdDQo8aDE+Tm91cyDDqWNyaXJlPC9oMT4NCltjb250YWN0LWZvcm0tNyBpZD0iNyIgdGl0bGU9IkZvcm11bGFpcmUgZGUgY29udGFjdCAxIl0NCg0KWy9zcGJfdGV4dF9ibG9ja10gW3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMyIgZWxfcG9zaXRpb249Imxhc3QiXQ0KPGgzIGNsYXNzPSJtdDAiPltpY29uIGltYWdlPSJmYS1tYXAtbWFya2VyIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdQWRyZXNzZSA6PC9oMz4NCjU1LCBhdmVudWUgTG91aXMgQnJlZ3VldA0KQsOidCBIZXJtw6hzIC0gNGUgw4l0YWdlDQozMTQwMCBUT1VMT1VTRQ0KPGgzPltpY29uIGltYWdlPSJzcy1jaGF0IiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdRMOpdGFpbHMgOjwvaDM+DQpUw6lsLiA6ICszMyAoMCk1LjYxLjMyLjY2LjkyDQpGYXggOiArMzMgKDApNS42MS41Mi4zNC43MA0KRW1haWwgOiBjb250YWN0QGdhbm5lLWF2b2NhdHMuY29tDQo8aDM+W2ljb24gaW1hZ2U9InNzLWNsb2NrIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdSG9yYWlyZXMgZCdvdXZlcnR1cmVzIDo8L2gzPg0KPHAgYWxpZ249ImxlZnQiPmR1IGx1bmRpIGF1IHZlbmRyZWRpIGRlIDloMDAgw6AgMTJoMzANCmV0IGRlIDE0aDAwIMOgIDE4aDMwPC9wPg0KWy9zcGJfdGV4dF9ibG9ja10gW2JsYW5rX3NwYWNlciBoZWlnaHQ9IjIwcHgiIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0gW2RpdmlkZXIgdHlwZT0iZ29fdG9fdG9wX2ljb24xIiB0ZXh0PSJHbyB0byB0b3AiIGZ1bGxfd2lkdGg9Im5vIiB3aWR0aD0iMS8xIiBlbF9wb3NpdGlvbj0iZmlyc3QgbGFzdCJd\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:6796;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:200:\"UsOpcG9uZCDDoCB0b3V0ZXMgdm9zIGludGVycm9nYXRpb25zIGVuIGRyb2l0IGRlcyBhZmZhaXJlcywgY29udGVudGlldXgsIGZpc2NhbGl0w6ksIHBhdHJpbW9pbmUgZXQgZ2VzdGlvbiBkZXMgZGlmZmljdWx0w6lzIGQnZW50cmVwcmlzZSDDoCBUb3Vsb3VzZS4=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:8:\"YXZvY2F0\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2014-10-30 10:56:55", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("13", "1204", "10", "1", "0", "09adc1281046e1ea07f3f65b7b71e22a", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12102\";s:8:\"contents\";a:3:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"QWNxdcOpcmV1cg==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:1920:\"W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5Qb3VyIG1pZXV4IHLDqXBvbmRyZSDDoCB2b3RyZSBiZXNvaW4sIG5vdXMgdm91cyBwcm9wb3NvbnMgZGUgY29tcGzDqXRlciBsZSBmb3JtdWxhaXJlIGNpLWRlc3NvdXMuPC9oMz4NCltjb250YWN0LWZvcm0tNyBpZD0iMTIxMDAiIHRpdGxlPSJWb3VzIMOqdGVzIGFjcXXDqXJldXIiXQ0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS80IiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDE+W2ljb24gaW1hZ2U9InNzLWJ1c2luZXNzdXNlciIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXVZvdXMgw6p0ZXMgVmVuZGV1cjwvaDE+DQo8aDQ+U2kgdm91cyBzb3VoYWl0ZXogdmVuZHJlIHVuIGZvbmRzIGRlIGNvbW1lcmNlIG91IGxlcyB0aXRyZXMgZOKAmXVuZSBTb2Npw6l0w6kgOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9mb3JtdWxhaXJlLXZlbmRldXIiIHRhcmdldD0iX3NlbGYiIGljb249InNzLWN1cnNvciIgZHJvcHNoYWRvdz0ieWVzIiBleHRyYWNsYXNzPSIiXUNsaXF1ZXotaWNpWy9zZl9idXR0b25dPC9wPg0KW2hyXQ0KDQo8aW1nIGNsYXNzPSJhbGlnbm5vbmUiIGFsdD0iU2FuZHJpbmUgRElBWiIgc3JjPSIuLi8uLi93cC1jb250ZW50L3VwbG9hZHMvMjAxMy8xMC9TX0RpYXpfQy0xNTB4MTUwLmpwZyIgd2lkdGg9IjE1MCIgaGVpZ2h0PSIxNTAiIC8+DQoNClBvdXIgdG91dCByZW5zZWlnbmVtZW50IGNvbXBsw6ltZW50YWlyZSwgTWFkYW1lIFNhbmRyaW5lIERJQVogZXN0IMOgIHZvdHJlIGRpc3Bvc2l0aW9uLg0KDQpbaWNvbiBpbWFnZT0ic3MtcGhvbmUiIGNoYXJhY3Rlcj0iIiBzaXplPSJzbWFsbCIgY29udD0ibm8iIGZsb2F0PSJsZWZ0Il3CoCArMzMgKDApNS42MS4zMi42Ni45Mg0KDQpbaWNvbiBpbWFnZT0ic3MtbWFpbCIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXSA8YSB0aXRsZT0ibm90cmUgYXNzaXN0YW50ZSBqdXJpZGlxdWUgZXN0IMOgIHZvdHJlIMOpY291dGUiIGhyZWY9Im1haWx0bzpjb250YWN0QGdhbm5lLWF2b2NhdHMuY29tIj5jb250YWN0QGdhbm5lLWF2b2NhdHMuY29tPC9hPg0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12102;}}}", "2014-10-30 11:46:41", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("14", "1205", "10", "1", "0", "f34b2c0f3c9f6632aacf27be7de5927b", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12048\";s:8:\"contents\";a:3:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:12:\"VmVuZGV1cg==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:1952:\"W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjMvNCIgZWxfcG9zaXRpb249ImZpcnN0Il0NCjxoMz5Qb3VyIG1pZXV4IHLDqXBvbmRyZSDDoCB2b3RyZSBiZXNvaW4sIG5vdXMgdm91cyBwcm9wb3NvbnMgZGUgY29tcGzDqXRlciBsZSBmb3JtdWxhaXJlIGNpLWRlc3NvdXMuPC9oMz4NCltjb250YWN0LWZvcm0tNyBpZD0iMTIwMjQiIHRpdGxlPSJWb3VzIMOqdGVzIHZlbmRldXIiXQ0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbc3BiX3RleHRfYmxvY2sgcGJfbWFyZ2luX2JvdHRvbT0ibm8iIHBiX2JvcmRlcl9ib3R0b209Im5vIiB3aWR0aD0iMS80IiBlbF9wb3NpdGlvbj0ibGFzdCJdDQo8aDE+W2ljb24gaW1hZ2U9InNzLWJ1c2luZXNzdXNlciIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXVZvdXMgw6p0ZXMgQWNxdcOpcmV1cjwvaDE+DQo8aDQ+U2kgdm91cyBzb3VoYWl0ZXogYWNxdcOpcmlyIHVuIGZvbmRzIGRlIGNvbW1lcmNlIG91IGxlcyB0aXRyZXMgZOKAmXVuZSBTb2Npw6l0w6kgOjwvaDQ+DQo8cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+W3NmX2J1dHRvbiBjb2xvdXI9ImFjY2VudCIgdHlwZT0ic3RhbmRhcmQiIHNpemU9InN0YW5kYXJkIiBsaW5rPSIuLi9mb3JtdWxhaXJlLWFjcXVlcmV1ciIgdGFyZ2V0PSJfc2VsZiIgaWNvbj0ic3MtY3Vyc29yIiBkcm9wc2hhZG93PSJ5ZXMiIGV4dHJhY2xhc3M9IiJdQ2xpcXVlei1pY2lbL3NmX2J1dHRvbl08L3A+DQpbaHJdDQoNCjxpbWcgYWx0PSJTYW5kcmluZSBESUFaIiBzcmM9Ii4uLy4uL3dwLWNvbnRlbnQvdXBsb2Fkcy8yMDEzLzEwL1NfRGlhel9DLTE1MHgxNTAuanBnIiB3aWR0aD0iMTUwIiBoZWlnaHQ9IjE1MCIgLz4NCg0KUG91ciB0b3V0IHJlbnNlaWduZW1lbnQgY29tcGzDqW1lbnRhaXJlLCBub3RyZSBBc3Npc3RhbmNlIEp1cmlkaXF1ZSBNYWRhbWUgU2FuZHJpbmUgRElBWiBlc3Qgw6Agdm90cmUgZGlzcG9zaXRpb24uDQoNCltpY29uIGltYWdlPSJzcy1waG9uZSIgY2hhcmFjdGVyPSIiIHNpemU9InNtYWxsIiBjb250PSJubyIgZmxvYXQ9ImxlZnQiXcKgICszMyAoMCk1LjYxLjMyLjY2LjkyDQoNCltpY29uIGltYWdlPSJzcy1tYWlsIiBjaGFyYWN0ZXI9IiIgc2l6ZT0ic21hbGwiIGNvbnQ9Im5vIiBmbG9hdD0ibGVmdCJdIDxhIHRpdGxlPSJub3RyZSBhc3Npc3RhbnRlIGp1cmlkaXF1ZSBlc3Qgw6Agdm90cmUgw6ljb3V0ZSIgaHJlZj0ibWFpbHRvOmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb20iPmNvbnRhY3RAZ2FubmUtYXZvY2F0cy5jb208L2E+DQoNCiZuYnNwOw0KDQpbL3NwYl90ZXh0X2Jsb2NrXSBbZGl2aWRlciB0eXBlPSJnb190b190b3BfaWNvbjEiIHRleHQ9IkdvIHRvIHRvcCIgZnVsbF93aWR0aD0ibm8iIHdpZHRoPSIxLzEiIGVsX3Bvc2l0aW9uPSJmaXJzdCBsYXN0Il0=\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12048;}}}", "2014-10-30 12:02:18", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("15", "1206", "0", "0", "1", "ee81ff7320266a7d589b3648b7931821", "", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12297\";s:8:\"contents\";a:3:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:12:\"VkFMRVVSUw==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:2384:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12297;}}}", "2014-10-30 12:17:05", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("16", "1207", "10", "1", "0", "b8ada5ee74c5240a8f88855b438f4a6e", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=11981\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"THVjaWxlIENBTE1FVFRF\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:844:\"PGEgdGl0bGU9IkRFUEFSVEVNRU5UIFJFU1RSVUNUVVJJTkcg4oCTIEVOVFJFUFJJU0VTIEVOIERJRkZJQ1VMVMOJIiBocmVmPSIvZXhwZXJ0aXNlL3Jlc3RydWN0dXJpbmctZW50cmVwcmlzZXNfZGlmZmljdWx0ZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgUkVTVFJVQ1RVUklORyDigJMgRU5UUkVQUklTRVMgRU4gRElGRklDVUxUw4k8L2E+DQoNCkFwcsOocyBhdm9pciBpbnTDqWdyw6kgbGUgc2VydmljZSBqdXJpZGlxdWUgZGVzIGxhYm9yYXRvaXJlcyBQaWVycmUgRmFicmUsIEx1Y2lsZSBhIHJlam9pbnQgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIGVuIG1hdGnDqHJlIGRlIHJlc3RydWN0dXJhdGlvbiBkJ2VudHJlcHJpc2UuDQpMdWNpbGUgYsOpbsOpZmljaWUgZCd1biBkb3VibGUgY3Vyc3VzIDogZHJvaXQgZXQgZ2VzdGlvbiBkZXMgZW50cmVwcmlzZXMgLyBjb21wdGFiaWxpdMOpLg0KQXVqb3VyZCdodWksIEx1Y2lsZSBlc3QgcGFydGljdWxpw6hyZW1lbnQgaW52ZXN0aWUgZGFucyBsYSBtaXNlIGVuIHBsYWNlIGVuIEZyYW5jZSBkZSBwcm9qZXRzIGRlIENyb3dkZnVuZGluZyAvIEZpbmFuY2VtZW50IHBhcnRpY2lwYXRpZi4=\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:11981;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:116:\"QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCByZXN0cnVjdHVyYXRpb24gZGVzIGVudHJlcHJpc2VzIGVuIGRpZmZpY3VsdMOpcw==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:164:\"YXZvY2F0LCByZXN0cnVjdHVyaW5nLCByZXN0cnVjdHVyYXRpb24sIGRyb2l0LCBlbnRyZXByaXNlLCBjb21wdGFiaWxpdMOpLCBmaW5hbmNlbWVudCwgcGFydGljaXBhdGlmLCBjcm93Zm91bmRpbmcsIHRvdWxvdXNl\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:63:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"cmVzdHJ1Y3R1cmluZw==\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:15:\"195,194,197,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:42:\"\"RMOJUEFSVEVNRU5UIFJFU1RSVUNUVVJBVElPTg==\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"186\";}}}", "2014-10-30 12:24:23", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("17", "1208", "10", "1", "0", "5e536718d0cad47a7862790d24112cf9", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=12446\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"U29waGllIENPR05BVUxU\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:972:\"W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgQ09OVEVOVElFVVgg4oCTIERST0lUIElOVEVSTkFUSU9OQUwiIGhyZWY9Ii9leHBlcnRpc2UvY29udGVudGlldXgtZHJvaXRfaW50ZXJuYXRpb25hbC8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09OVEVOVElFVVgg4oCTIElOVEVSTkFUSU9OQUw8L2E+DQoNCkF2b2NhdCBhdSBCYXJyZWF1IGRlIFBhcmlzIHBlbmRhbnQgcGx1cyA1IGFucyBub3RhbW1lbnQgYXUgc2VpbiBkdSBjYWJpbmV0IGQnYWZmYWlyZXMgcGFyaXNpZW4gTEFNWSBMRVhFTCwgU29waGllIGEgcmVqb2ludCBsZSBDYWJpbmV0IEdBTk5FICZhbXA7IEFWT0NBVFMuDQoNCkRlIGZvcm1hdGlvbiBkZSBEcm9pdCBDb21tdW5hdXRhaXJlLCBTb3BoaWUgYSB0cmF2YWlsbMOpIGF2YW50IGQnZXhlcmNlciBlbiBxdWFsaXTDqSBkJ2F2b2NhdCDDoCBFdXJvIEluZm8gQ2VudHJlIGTDqXBlbmRhbnQgZGUgbGEgQ29tbWlzc2lvbiBFdXJvcMOpZW5uZS4NCg0KQmlsaW5ndWUgZW4gQW5nbGFpcywgU29waGllIGEgcGFydGljaXDDqSDDoCBwbHVzaWV1cnMgY29udGVudGlldXggdHJhbnNmcm9udGFsaWVycy4NCg0KWy9zcGJfdGV4dF9ibG9ja10=\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12446;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:132:\"QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBjb250ZW50aWV1eCBldCBpbnRlcm5hdGlvbmFsIGRhbnMgbGUgY2FiaW5ldCBHQU5ORSAmIEFWT0NBVFM=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"Q29udGVudGlldXg=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:70:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29udGVudGlldXg=\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:19:\"195,194,201,198,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:34:\"\"RMOJUEFSVEVNRU5UIENPTlRFTlRJRVVY\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"187\";}}}", "2014-10-30 12:29:07", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("18", "1213", "10", "1", "1", "8cd107414118b41dae7807869d18b2c1", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=11976\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:24:\"QXVyw6lsaWUgTUlDSEFVRA==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:852:\"W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkUiIGhyZWY9Ii9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkU8L2E+DQoNCkLDqW7DqWZpY2lhbnQgZCd1bmUgZXhww6lyaWVuY2UgZGUgcGx1cyBkZSA5IGFubsOpZXMgZW4gbWF0acOocmUgZGUgY29uc2VpbCBldCBkw6l2ZWxvcHBlbWVudCBkZXMgZW50cmVwcmlzZXMsIEF1csOpbGllIGEgcGFydGljaXDDqSDDoCBkZXMgb3DDqXJhdGlvbnMgZGUgY2Vzc2lvbnMgZCdlbnZlcmd1cmUuDQpBdXLDqWxpZSBlc3QgdGl0dWxhaXJlIGQndW4gREVTUyBkZSBEcm9pdCBGaXNjYWwgZHUgUHJvZmVzc2V1ciBCZXJuYXJkIFBMQUdORVQgZXQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuDQoNClsvc3BiX3RleHRfYmxvY2td\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:11976;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:100:\"QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBkcm9pdCBmaXNjYWwgZXQgZ2VzdGlvbiBkdSBwYXRyaW1vaW5l\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:104:\"YXZvY2F0LCBnZXN0aW9uLCBwYXRyaW1vaW5lLCBmaXNjYWwsIGZpc2NhbGl0w6ksIGZpbmFuY2VtZW50LCB0b3Vsb3VzZSwgcGFyaXM=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:62:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"ZHJvaXQ=\",\"ZmlzY2Fs\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:19:\"195,194,198,199,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:38:\"\"RMOJUEFSVEVNRU5UIERST0lUIEZJU0NBTA==\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"185\";}}}", "2014-10-30 12:37:33", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("19", "1214", "10", "1", "0", "b6fbf1dc7a8a823d4da38e229ddafcca", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=11038\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"T2xpdmllciBHQU5ORQ==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:876:\"PGEgdGl0bGU9IkRFUEFSVEVNRU5UIENPUlBPUkFURSDigJMgRklOQU5DRSIgaHJlZj0iL2V4cGVydGlzZS9jb3Jwb3JhdGUtZmluYW5jZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09SUE9SQVRFIC0gRklOQU5DRTwvYT4NCjxkaXYgaWQ9Im1haW5faW50ZXJfZnVsbCI+QXZvY2F0IGRlcHVpcyAyMDAzLCBPbGl2aWVyIGVzdCBwYXNzw6kgcGFyIGRpZmbDqXJlbnRzIGNhYmluZXRzIGFuZ2xvLXNheG9ucyDDoCBQYXJpcyBldCBlbiBOb3V2ZWxsZSBaw6lsYW5kZSBhdmFudCBkZSBmb25kZXIgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIMOgIFRvdWxvdXNlLjwvZGl2Pg0KPGRpdj5PbGl2aWVyIGEgbm90YW1tZW50IHNvdXRlbnUgbGEgbWlzZSBlbiBwbGFjZSBkZSBww7RsZXMgZGUgY29tcMOpdGl0aXZpdMOpIGRhbnMgbGVzIGRvbWFpbmVzIGRlIGxhIFNhbnTDqSBldCBkZSBsJ0HDqXJvbmF1dGlxdWUuPC9kaXY+DQo8ZGl2PkFuY2llbiBQcsOpc2lkZW50IGRlcyBKLiBBdm9jYXRzIENvbnNlaWwgZW4gRW50cmVwcmlzZSBkZSBNaWRpLVB5csOpbsOpZXMsIE9saXZpZXIgZXN0IMOpZ2FsZW1lbnQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuPC9kaXY+\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:11038;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:272:\"QXZvY2F0IGQnYWZmYWlyZXMgw6AgVG91bG91c2UgLSBBdm9jYXQgQXNzb2Npw6kgLSBNYW5hZ2luZyBQYXJ0bmVyIC0gRMOpcGFydGVtZW50IENPUlBPUkFURSAtIE5vcyBkb21haW5lcyBkZSBjb21ww6l0ZW5jZXMgOiBmaXNjYWxpdMOpLCBkcm9pdCBkZXMgc29jacOpdMOpcywgZHJvaXQgY29tbWVyY2lhbCwgdHJhbnNtaXNzaW9uIGQnZW50cmVwcmlzZXM=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:8:\"QXZvY2F0\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:66:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29ycG9yYXRl\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:19:\"195,194,200,198,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:34:\"\"RMOJUEFSVEVNRU5UIENPUlBPUkFURQ==\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"184\";}}}", "2014-10-30 12:38:08", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("20", "1520", "10", "1", "0", "b43409a2a481141239d6407b23d17446", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12117\";s:8:\"contents\";a:3:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:28:\"SW5mb3JtYXRpb25zIGzDqWdhbGVz\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16880:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12117;}}}", "2015-01-04 22:24:25", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("21", "1526", "10", "1", "0", "c4424e2213e89e1f9d4614058ae93a79", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12199\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:64:\"RMOpcGFydGVtZW50IGNvbnRlbnRpZXV4IGV0IGRyb2l0IGludGVybmF0aW9uYWw=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:2464:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12199;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:212:\"TGUgQ2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgcmVwcsOpc2VudGUgc2VzIGNsaWVudHMgcG91ciB0b3V0IGNvbnRlbnRpZXV4IGRldmFudCBsZXMganVyaWRpY3Rpb25zIGNpdmlsZXMsIHDDqW5hbGVzIGV0IGNvbW1lcmNpYWxlcyBuYXRpb25hbGVzIGV0IGV1cm9ww6llbm5lcy4=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"Y29udGVudGlldXg=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-05 11:19:52", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("23", "1545", "10", "1", "0", "4d0455f432ee2240fb42b929824123f7", "local", "a:2:{s:3:\"url\";s:41:\"http://www.ganne-avocats.com?page_id=6575\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:68:\"Q2FiaW5ldCBkJ2F2b2NhdHMgZW4gZHJvaXQgZGVzIGFmZmFpcmVzIMOgIFRvdWxvdXNl\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:5976:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:6575;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:68:\"Q2FiaW5ldCBkJ2F2b2NhdHMgZW4gZHJvaXQgZGVzIGFmZmFpcmVzIMOgIFRvdWxvdXNl\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:212:\"U3DDqWNpYWxpc8OpIGVuIGRyb2l0IGRlcyBhZmZhaXJlcywgbGUgY2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgaW50ZXJ2aWVudCB0YW50IGVuIG1hdGnDqHJlIGRlIGNvbnNlaWwgcXVlIGRlIGNvbnRlbnRpZXV4IGF1cHLDqHMgZGVzIGVudHJlcHJpc2VzIMOgIFRvdWxvdXNlLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:24:\"ZHJvaXQgZGVzIGFmZmFpcmVz\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-06 11:26:33", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("24", "1546", "10", "1", "0", "b61c2b0a089a035a08cdb2f48630852a", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=13188\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"QWNjb21wYWduZW1lbnQ=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:4652:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:13188;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:296:\"TCdhY2NvbXBhZ25lbWVudCBkZXMgZW50cmVwcmVuZXVycyBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgZXN0IGxlIGZvbmRlbWVudCBwcmluY2lwYWwgZGUgbCdhY3Rpdml0w6kgZHUgQ2FiaW5ldCAtIG5vcyBkb21haW5lcyBkZSBjb21ww6l0ZW5jZXMgOiBmaXNjYWxpdMOpLCBkcm9pdCBkZXMgc29jacOpdMOpcywgZHJvaXQgY29tbWVyY2lhbCwgdHJhbnNtaXNzaW9uIGQnZW50cmVwcmlzZXMu\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"YWNjb21wYWduZW1lbnQ=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-06 11:42:51", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("25", "1547", "10", "1", "0", "5f2a14b02c402395373270b5307b295d", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12207\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:44:\"RMOpcGFydGVtZW50IENvcnBvcmF0ZSAtIEZpbmFuY2U=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:5820:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12207;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:184:\"TGUgQ2FiaW5ldCBHQU5ORSAmIEFWT0NBVFMgaW50ZXJ2aWVudCBzdXIgZGVzIG9ww6lyYXRpb25zIGRlIGZpbmFuY2VtZW50LCBkZSBjb3Jwb3JhdGUgZmluYW5jZSwgTEJPLCBwcml2YXRlIGVxdWl0eSwgZnVzaW9uLWFjcXVpc2l0aW9uLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:12:\"Y29ycG9yYXRl\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-06 12:05:26", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("26", "1548", "9", "1", "0", "0044a13c3556e9fd74b2e7e9ac54049b", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12205\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:48:\"RHJvaXQgZmlzY2FsICYgR2VzdGlvbiBkZSBQYXRyaW1vaW5l\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:3592:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12205;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:68:\"QXZvY2F0IMOgIFRvdWxvdXNlIC0gRHJvaXQgZmlzY2FsIC0gR0FOTkUgJiBBVk9DQVRT\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:152:\"TGUgY2FiaW5ldCBhc3Npc3RlIGxlcyBlbnRyZXByaXNlcyBlbiBkcm9pdCBmaXNjYWwgbG9ycyBkZSB0cmFuc2FjdGlvbnMgY29ycG9yYXRlLCBpbW1vYmlsacOocmVzIGV0IGZpbmFuY2nDqHJlcy4=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"ZHJvaXQgZmlzY2Fs\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-06 12:26:21", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("27", "1549", "10", "1", "0", "9e81f705b105f3b4ea6ddf46012e1b0d", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12202\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:56:\"UmVzdHJ1Y3R1cmluZyBldCBlbnRyZXByaXNlIGVuIGRpZmZpY3VsdMOp\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:4384:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12202;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:100:\"QXZvY2F0cyDDoCBUb3Vsb3VzZSBlbiBkcm9pdCBkZXMgYWZmYWlyZXMgLSBSZXN0cnVjdHVyaW5nIC0gR2FubmUgJiBBdm9jYXRz\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:184:\"TWlzc2lvbnMgZOKAmWFzc2lzdGFuY2UgZXQgZGUgY29uc2VpbCBkYW5zIGxlIGNhZHJlIGRlIGxhIHByw6l2ZW50aW9uIGV0IGR1IHRyYWl0ZW1lbnQgZGVzIGRpZmZpY3VsdMOpcyBkZXMgZW50cmVwcmlzZXMgOiByZXN0cnVjdHVyaW5nLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"cmVzdHJ1Y3R1cmluZw==\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-06 12:52:06", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("28", "1550", "10", "1", "0", "e1d12eb72e88619bd00a2fc40b2fcb36", "local", "a:2:{s:3:\"url\";s:38:\"http://www.ganne-avocats.com?page_id=2\";s:8:\"contents\";a:12:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"VHJhbnNhY3Rpb25z\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:3868:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:2;}s:24:\"field-_yoast_wpseo_title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:72:\"QXZvY2F0cyDDoCBUb3Vsb3VzZSAtIFRyYW5zYWN0aW9ucyAtIEdhbm5lICYgQXZvY2F0cw==\";s:6:\"format\";s:6:\"base64\";}s:29:\"field-_yoast_wpseo_title-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:18:\"_yoast_wpseo_title\";}s:29:\"field-_yoast_wpseo_title-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:216:\"U3DDqWNpYWxpc8OpIGVuIG1hdGnDqHJlIGRlIHRyYW5zYWN0aW9ucyBldCBkZSB0cmFuc21pc3Npb25zIGTigJllbnRyZXByaXNlcyBldCBkZSBmb25kcyBkZSBjb21tZXJjZSwgbGUgY2FiaW5ldCBlc3Qgw6Agdm90cmUgZGlzcG9zaXRpb24gcG91ciB2b3VzIGFjY29tcGFnbmVyLg==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"dHJhbnNhY3Rpb25z\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-06 14:01:42", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("29", "1552", "10", "1", "0", "5e536718d0cad47a7862790d24112cf9", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=12446\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"U29waGllIENPR05BVUxU\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:972:\"W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgQ09OVEVOVElFVVgg4oCTIERST0lUIElOVEVSTkFUSU9OQUwiIGhyZWY9Ii9leHBlcnRpc2UvY29udGVudGlldXgtZHJvaXRfaW50ZXJuYXRpb25hbC8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09OVEVOVElFVVgg4oCTIElOVEVSTkFUSU9OQUw8L2E+DQoNCkF2b2NhdCBhdSBCYXJyZWF1IGRlIFBhcmlzIHBlbmRhbnQgcGx1cyA1IGFucyBub3RhbW1lbnQgYXUgc2VpbiBkdSBjYWJpbmV0IGQnYWZmYWlyZXMgcGFyaXNpZW4gTEFNWSBMRVhFTCwgU29waGllIGEgcmVqb2ludCBsZSBDYWJpbmV0IEdBTk5FICZhbXA7IEFWT0NBVFMuDQoNCkRlIGZvcm1hdGlvbiBkZSBEcm9pdCBDb21tdW5hdXRhaXJlLCBTb3BoaWUgYSB0cmF2YWlsbMOpIGF2YW50IGQnZXhlcmNlciBlbiBxdWFsaXTDqSBkJ2F2b2NhdCDDoCBFdXJvIEluZm8gQ2VudHJlIGTDqXBlbmRhbnQgZGUgbGEgQ29tbWlzc2lvbiBFdXJvcMOpZW5uZS4NCg0KQmlsaW5ndWUgZW4gQW5nbGFpcywgU29waGllIGEgcGFydGljaXDDqSDDoCBwbHVzaWV1cnMgY29udGVudGlldXggdHJhbnNmcm9udGFsaWVycy4NCg0KWy9zcGJfdGV4dF9ibG9ja10=\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12446;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:132:\"QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBjb250ZW50aWV1eCBldCBpbnRlcm5hdGlvbmFsIGRhbnMgbGUgY2FiaW5ldCBHQU5ORSAmIEFWT0NBVFM=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"Q29udGVudGlldXg=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:70:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29udGVudGlldXg=\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:19:\"195,194,201,198,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:34:\"\"RMOJUEFSVEVNRU5UIENPTlRFTlRJRVVY\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"187\";}}}", "2015-01-06 15:52:04", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("30", "1560", "10", "1", "0", "b8ada5ee74c5240a8f88855b438f4a6e", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=11981\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"THVjaWxlIENBTE1FVFRF\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:844:\"PGEgdGl0bGU9IkRFUEFSVEVNRU5UIFJFU1RSVUNUVVJJTkcg4oCTIEVOVFJFUFJJU0VTIEVOIERJRkZJQ1VMVMOJIiBocmVmPSIvZXhwZXJ0aXNlL3Jlc3RydWN0dXJpbmctZW50cmVwcmlzZXNfZGlmZmljdWx0ZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgUkVTVFJVQ1RVUklORyDigJMgRU5UUkVQUklTRVMgRU4gRElGRklDVUxUw4k8L2E+DQoNCkFwcsOocyBhdm9pciBpbnTDqWdyw6kgbGUgc2VydmljZSBqdXJpZGlxdWUgZGVzIGxhYm9yYXRvaXJlcyBQaWVycmUgRmFicmUsIEx1Y2lsZSBhIHJlam9pbnQgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIGVuIG1hdGnDqHJlIGRlIHJlc3RydWN0dXJhdGlvbiBkJ2VudHJlcHJpc2UuDQpMdWNpbGUgYsOpbsOpZmljaWUgZCd1biBkb3VibGUgY3Vyc3VzIDogZHJvaXQgZXQgZ2VzdGlvbiBkZXMgZW50cmVwcmlzZXMgLyBjb21wdGFiaWxpdMOpLg0KQXVqb3VyZCdodWksIEx1Y2lsZSBlc3QgcGFydGljdWxpw6hyZW1lbnQgaW52ZXN0aWUgZGFucyBsYSBtaXNlIGVuIHBsYWNlIGVuIEZyYW5jZSBkZSBwcm9qZXRzIGRlIENyb3dkZnVuZGluZyAvIEZpbmFuY2VtZW50IHBhcnRpY2lwYXRpZi4=\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:11981;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:116:\"QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCByZXN0cnVjdHVyYXRpb24gZGVzIGVudHJlcHJpc2VzIGVuIGRpZmZpY3VsdMOpcw==\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:164:\"YXZvY2F0LCByZXN0cnVjdHVyaW5nLCByZXN0cnVjdHVyYXRpb24sIGRyb2l0LCBlbnRyZXByaXNlLCBjb21wdGFiaWxpdMOpLCBmaW5hbmNlbWVudCwgcGFydGljaXBhdGlmLCBjcm93Zm91bmRpbmcsIHRvdWxvdXNl\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:63:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"cmVzdHJ1Y3R1cmluZw==\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:15:\"195,194,197,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:42:\"\"RMOJUEFSVEVNRU5UIFJFU1RSVUNUVVJBVElPTg==\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"186\";}}}", "2015-01-06 16:00:52", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("31", "1567", "9", "1", "0", "8cd107414118b41dae7807869d18b2c1", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=11976\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:24:\"QXVyw6lsaWUgTUlDSEFVRA==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:852:\"W3NwYl90ZXh0X2Jsb2NrIHBiX21hcmdpbl9ib3R0b209Im5vIiBwYl9ib3JkZXJfYm90dG9tPSJubyIgd2lkdGg9IjEvMSIgZWxfcG9zaXRpb249ImZpcnN0IGxhc3QiXQ0KDQo8YSB0aXRsZT0iREVQQVJURU1FTlQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkUiIGhyZWY9Ii9leHBlcnRpc2UvZHJvaXRfZmlzY2FsLWdlc3Rpb25fcGF0cmltb2luZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgRFJPSVQgRklTQ0FMIOKAkyBHRVNUSU9OIERFIFBBVFJJTU9JTkU8L2E+DQoNCkLDqW7DqWZpY2lhbnQgZCd1bmUgZXhww6lyaWVuY2UgZGUgcGx1cyBkZSA5IGFubsOpZXMgZW4gbWF0acOocmUgZGUgY29uc2VpbCBldCBkw6l2ZWxvcHBlbWVudCBkZXMgZW50cmVwcmlzZXMsIEF1csOpbGllIGEgcGFydGljaXDDqSDDoCBkZXMgb3DDqXJhdGlvbnMgZGUgY2Vzc2lvbnMgZCdlbnZlcmd1cmUuDQpBdXLDqWxpZSBlc3QgdGl0dWxhaXJlIGQndW4gREVTUyBkZSBEcm9pdCBGaXNjYWwgZHUgUHJvZmVzc2V1ciBCZXJuYXJkIFBMQUdORVQgZXQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuDQoNClsvc3BiX3RleHRfYmxvY2td\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:11976;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:100:\"QXZvY2F0IGV0IHJlc3BvbnNhYmxlIGR1IGTDqXBhcnRlbWVudCBkcm9pdCBmaXNjYWwgZXQgZ2VzdGlvbiBkdSBwYXRyaW1vaW5l\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:104:\"YXZvY2F0LCBnZXN0aW9uLCBwYXRyaW1vaW5lLCBmaXNjYWwsIGZpc2NhbGl0w6ksIGZpbmFuY2VtZW50LCB0b3Vsb3VzZSwgcGFyaXM=\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:62:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"ZHJvaXQ=\",\"ZmlzY2Fs\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:19:\"195,194,198,199,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:38:\"\"RMOJUEFSVEVNRU5UIERST0lUIEZJU0NBTA==\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"185\";}}}", "2015-01-06 16:12:27", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("32", "1571", "10", "1", "0", "b6fbf1dc7a8a823d4da38e229ddafcca", "local", "a:2:{s:3:\"url\";s:36:\"http://www.ganne-avocats.com?p=11038\";s:8:\"contents\";a:13:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:20:\"T2xpdmllciBHQU5ORQ==\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:876:\"PGEgdGl0bGU9IkRFUEFSVEVNRU5UIENPUlBPUkFURSDigJMgRklOQU5DRSIgaHJlZj0iL2V4cGVydGlzZS9jb3Jwb3JhdGUtZmluYW5jZS8iPjxpIGNsYXNzPSJmYS1hbmdsZS1yaWdodCI+PC9pPiBSZXNwb25zYWJsZSBkdSBEw6lwYXJ0ZW1lbnQgQ09SUE9SQVRFIC0gRklOQU5DRTwvYT4NCjxkaXYgaWQ9Im1haW5faW50ZXJfZnVsbCI+QXZvY2F0IGRlcHVpcyAyMDAzLCBPbGl2aWVyIGVzdCBwYXNzw6kgcGFyIGRpZmbDqXJlbnRzIGNhYmluZXRzIGFuZ2xvLXNheG9ucyDDoCBQYXJpcyBldCBlbiBOb3V2ZWxsZSBaw6lsYW5kZSBhdmFudCBkZSBmb25kZXIgbGUgQ2FiaW5ldCBHQU5ORSAmYW1wOyBBVk9DQVRTIMOgIFRvdWxvdXNlLjwvZGl2Pg0KPGRpdj5PbGl2aWVyIGEgbm90YW1tZW50IHNvdXRlbnUgbGEgbWlzZSBlbiBwbGFjZSBkZSBww7RsZXMgZGUgY29tcMOpdGl0aXZpdMOpIGRhbnMgbGVzIGRvbWFpbmVzIGRlIGxhIFNhbnTDqSBldCBkZSBsJ0HDqXJvbmF1dGlxdWUuPC9kaXY+DQo8ZGl2PkFuY2llbiBQcsOpc2lkZW50IGRlcyBKLiBBdm9jYXRzIENvbnNlaWwgZW4gRW50cmVwcmlzZSBkZSBNaWRpLVB5csOpbsOpZXMsIE9saXZpZXIgZXN0IMOpZ2FsZW1lbnQgbGF1csOpYXQgZGUgbGEgQ29uZsOpcmVuY2UgZGVzIEF2b2NhdHMuPC9kaXY+\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:11038;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:272:\"QXZvY2F0IGQnYWZmYWlyZXMgw6AgVG91bG91c2UgLSBBdm9jYXQgQXNzb2Npw6kgLSBNYW5hZ2luZyBQYXJ0bmVyIC0gRMOpcGFydGVtZW50IENPUlBPUkFURSAtIE5vcyBkb21haW5lcyBkZSBjb21ww6l0ZW5jZXMgOiBmaXNjYWxpdMOpLCBkcm9pdCBkZXMgc29jacOpdMOpcywgZHJvaXQgY29tbWVyY2lhbCwgdHJhbnNtaXNzaW9uIGQnZW50cmVwcmlzZXM=\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:8:\"QXZvY2F0\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:4:\"tags\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:66:\"\"YWZmYWlyZXM=\",\"YXZvY2F0\",\"Y29ycG9yYXRl\",\"ZHJvaXQ=\",\"dG91bG91c2U=\"\";s:6:\"format\";s:10:\"csv_base64\";}s:7:\"tag_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:19:\"195,194,200,198,196\";}s:13:\"team-category\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:34:\"\"RMOJUEFSVEVNRU5UIENPUlBPUkFURQ==\"\";s:6:\"format\";s:10:\"csv_base64\";}s:17:\"team-category_ids\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:3:\"184\";}}}", "2015-01-06 16:12:43", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("33", "1574", "10", "1", "0", "fb0a17a1bdfd5b1acb5d5f5f1ef96169", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=12154\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:16:\"QWN0dWFsaXTDqXM=\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:5584:\"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\";s:6:\"format\";s:6:\"base64\";}s:11:\"original_id\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";i:12154;}s:27:\"field-_yoast_wpseo_metadesc\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:212:\"TGUgY2FiaW5ldCBlc3Qgb3V2ZXJ0IMOgIGwnw6l2b2x1dGlvbiBkdSBtb25kZSBkZXMgYWZmYWlyZXMgdGFudCBlbiBtYXRpw6hyZSBkJ8OpY2hhbmdlIGludGVybmF0aW9uYXV4IGV0IGQnaW5ub3ZhdGlvbiBkZXMgbW9kZXMgZGUgZMOpdmVsb3BwZW1lbnQgZHUgY29tbWVyY2Uu\";s:6:\"format\";s:6:\"base64\";}s:32:\"field-_yoast_wpseo_metadesc-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:21:\"_yoast_wpseo_metadesc\";}s:32:\"field-_yoast_wpseo_metadesc-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}s:26:\"field-_yoast_wpseo_focuskw\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:8:\"YXZvY2F0\";s:6:\"format\";s:6:\"base64\";}s:31:\"field-_yoast_wpseo_focuskw-name\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:20:\"_yoast_wpseo_focuskw\";}s:31:\"field-_yoast_wpseo_focuskw-type\";a:2:{s:9:\"translate\";i:0;s:4:\"data\";s:12:\"custom_field\";}}}", "2015-01-06 16:19:48", "0", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("34", "1576", "10", "1", "0", "55dc0450878ec3dca647cebedb0ba600", "local", "a:2:{s:3:\"url\";s:42:\"http://www.ganne-avocats.com?page_id=11634\";s:8:\"contents\";a:9:{s:5:\"title\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:44:\"UmVjcnV0ZW1lbnQgZW4gZHJvaXQgZGVzIGFmZmFpcmVz\";s:6:\"format\";s:6:\"base64\";}s:4:\"body\";a:3:{s:9:\"translate\";i:1;s:4:\"data\";s:4784:\"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